/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.basic.chat.api.dto.response.ThirdPartyMemberResDTO;
import com.beiming.basic.chat.api.dto.response.ThirdPartyRoomMemberResDTO;
import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.ShortUrlUtils;
import com.beiming.odr.document.api.DocRecordMicroApi;
import com.beiming.odr.document.api.DocumentApi;
import com.beiming.odr.document.dto.requestdto.DocRecordGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocRecordSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.document.dto.responsedto.DocRecordGetResDTO;
import com.beiming.odr.document.dto.responsedto.DocWholeConfirmResDTO;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import com.beiming.odr.peace.common.constants.MeetingUserTypeConst;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.PeaceRedisKeyEnums;
import com.beiming.odr.peace.common.utils.DocXmlUtil;
import com.beiming.odr.peace.domain.dto.requestdto.AddMeetingIntranetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordGetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordSaveRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DownloadRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.IntranetCommonRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.IntranetPersonInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.IntranetSendClerkRecordRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordSaveResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntranetGetLitigantInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntranetSignPicResponseDTO;
import com.beiming.odr.peace.im.api.IntranetPeaceImApi;
import com.beiming.odr.peace.service.BackstageUserService;
import com.beiming.odr.peace.service.IntranetService;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.MediationRoomService;
import com.beiming.odr.peace.service.PeaceSmsService;
import com.beiming.odr.peace.service.PersonalService;
import com.beiming.odr.peace.service.backend.document.DocRecordDubboService;
import com.beiming.odr.peace.service.backend.document.SignatureDubboService;
import com.beiming.odr.peace.service.backend.storage.StorageDubboService;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.backend.user.UserBackendService;
import com.beiming.odr.peace.service.convert.DTOCheckFieldConvert;
import com.beiming.odr.peace.service.convert.DocPersonalConvert;
import com.beiming.odr.peace.service.convert.DocRecordConvert;
import com.beiming.odr.peace.service.convert.IntranetMediationMeetingConvert;
import com.beiming.odr.peace.service.convert.MediationMeetingConvert;
import com.beiming.odr.peace.service.util.Base64Utils;
import com.beiming.odr.referee.api.IntranetApi;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.GetRoomIdRequestDTO;
import com.beiming.odr.referee.dto.requestdto.GetUserIdRequestDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddMediationMeetingResDTO;
import com.beiming.odr.referee.dto.responsedto.IntranetMeetingInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MediationMeetingTypeEnum;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beust.jcommander.internal.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntranetServiceImpl
implements IntranetService {
    private static final Logger log = LoggerFactory.getLogger(IntranetServiceImpl.class);
    @Resource
    private IntranetApi intranetApi;
    @Resource
    private DocRecordMicroApi docRecordMicroApi;
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private DocRecordDubboService docRecordDubboService;
    @Resource
    private StorageDubboService storageDubboService;
    @Resource
    DocumentApi documentApi;
    @Resource
    private RedisService redisService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private IntranetPeaceImApi intranetPeaceImApi;
    @Resource
    private SignatureDubboService signatureDubboService;
    @Value(value="${peace.meetingNum}")
    private Long meetingNum;
    @Resource
    private UserBackendService userService;
    @Resource
    private UserServiceSecondApi userServiceSecondApi;
    @Resource
    private BackstageUserService backstageUserService;
    @Resource
    private MediationRoomService mediationRoomService;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private PeaceSmsService peaceSmsService;
    @Value(value="${peace.qrCodeUrlPrefix}")
    private String qrCodeUrlPrefix;
    @Value(value="${peace.accessSignUrlPrefix}")
    private String accessSignUrlPrefix;
    @Value(value="${peace.accessSignUrlSuffix}")
    private String accessSignUrlSuffix;
    @Value(value="${yanchengtencent.rtmpurl}")
    private String rtmpurl;
    @Value(value="${tencent.webRTC.sdkAppId}")
    private String sdkAppId;
    @Resource
    private PersonalService personalService;

    @Override
    public ClerkRecordGetResponseDTO getClerkRecord(IntranetCommonRequestDTO dto) {
        DubboResult<ArrayList<IntranetMeetingInfoResDTO>> dubboResult = this.getIntranetMeetingInfo(dto);
        IntranetMeetingInfoResDTO intranetMeetingInfo = (IntranetMeetingInfoResDTO)((ArrayList)dubboResult.getData()).get(0);
        Long bizId = intranetMeetingInfo.getId();
        DubboResult docIds = this.docRecordMicroApi.getDocId(bizId);
        Long docId = (Long)docIds.getData();
        ClerkRecordGetRequestDTO requestDTO = new ClerkRecordGetRequestDTO();
        requestDTO.setBizId(bizId);
        requestDTO.setMeetId(bizId);
        requestDTO.setDocId(docId);
        DocRecordGetReqDTO reqDTO = this.buildDocRecordGetReqDTO(requestDTO);
        if (reqDTO == null) {
            return null;
        }
        DocRecordGetResDTO resDTO = this.docRecordDubboService.viewClerkRecordForMediator(reqDTO);
        resDTO.setOrgId(intranetMeetingInfo.getOrgId());
        resDTO.setOrgName(intranetMeetingInfo.getOrgName());
        resDTO.setDisputeType(intranetMeetingInfo.getCauseName());
        resDTO.setBizNo(intranetMeetingInfo.getName());
        return DocRecordConvert.convertClerkRecordGetResponseDTO(resDTO);
    }

    @Override
    public ClerkRecordSaveResponseDTO sendClerkRecord(IntranetSendClerkRecordRequestDTO dto) {
        dto.setContent(DocXmlUtil.checkUnicodeString((String)dto.getContent()));
        AssertUtils.assertTrue((!CollectionUtils.isEmpty((Collection)dto.getSelectPersonIds()) ? 1 : 0) != 0, (ResultCode)ErrorCode.SELECT_PERSON_NULL, (String)ErrorCode.SELECT_PERSON_NULL.desc());
        GetRoomIdRequestDTO req = new GetRoomIdRequestDTO();
        req.setCaseNumberCode(dto.getCaseNumberCode());
        req.setCourtCode(dto.getCourtCode());
        req.setCaseOrder(dto.getCaseOrder());
        req.setMeetingType(MediationMeetingTypeEnum.MEDIATION_MEETING);
        DubboResult dubboResult = this.intranetApi.getIntranetMeetingInfo(req);
        AssertUtils.assertTrue((!CollectionUtils.isEmpty((Collection)((Collection)((Object)dubboResult.getData()))) ? 1 : 0) != 0, (ResultCode)ErrorCode.MEETING_ROOM_IS_NULL, (String)ErrorCode.MEETING_ROOM_IS_NULL.desc());
        log.info("\u67e5\u8be2\u7684\u5ead\u5ba1\u6570\uff1a{}", (Object)((ArrayList)dubboResult.getData()).size());
        AssertUtils.assertTrue((((ArrayList)dubboResult.getData()).size() == 1 ? 1 : 0) != 0, (ResultCode)ErrorCode.MEETING_ROOM_HAVE_MANY, (String)ErrorCode.MEETING_ROOM_HAVE_MANY.desc());
        IntranetMeetingInfoResDTO intranetMeetingInfo = (IntranetMeetingInfoResDTO)((ArrayList)dubboResult.getData()).get(0);
        IntranetCommonRequestDTO getClerkRecordDTO = new IntranetCommonRequestDTO();
        getClerkRecordDTO.setCaseNumberCode(dto.getCaseNumberCode());
        getClerkRecordDTO.setCourtCode(dto.getCourtCode());
        getClerkRecordDTO.setCaseOrder(dto.getCaseOrder());
        ClerkRecordGetResponseDTO clerkRecord = this.getClerkRecord(getClerkRecordDTO);
        log.info("\u67e5\u8be2\u5230\u7684\u7b14\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)clerkRecord));
        Long bizId = clerkRecord.getBizId();
        ArrayList<Long> selectPersonIds = new ArrayList<Long>();
        for (IntranetPersonInfoRequestDTO one : dto.getSelectPersonIds()) {
            GetUserIdRequestDTO getUserIdRequestDTO = new GetUserIdRequestDTO();
            getUserIdRequestDTO.setBizRoomId(bizId);
            getUserIdRequestDTO.setUserName(one.getUserName());
            getUserIdRequestDTO.setMobilePhone(one.getMobilePhone());
            DubboResult userIdResult = this.intranetApi.getUserTableId(getUserIdRequestDTO);
            if (userIdResult == null || userIdResult.getData() == null || "".equals(userIdResult.getData())) continue;
            selectPersonIds.add(Long.valueOf((String)((Object)userIdResult.getData())));
        }
        AssertUtils.assertTrue((!CollectionUtils.isEmpty(selectPersonIds) ? 1 : 0) != 0, (ResultCode)ErrorCode.SELECT_PERSON_NULL, (String)ErrorCode.SELECT_PERSON_NULL.desc());
        ClerkRecordSaveRequestDTO saveRequestDTO = this.buildClerkRecordSaveRequestDTO(clerkRecord);
        saveRequestDTO.setContent(dto.getContent());
        saveRequestDTO.setSelectPersonIds(selectPersonIds);
        saveRequestDTO.setMediatorName(intranetMeetingInfo.getCreatorUser());
        saveRequestDTO.setUserInfo(this.buildUserInfo(bizId, selectPersonIds));
        log.info("\u53d1\u9001\u7b14\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)saveRequestDTO));
        DocRecordSaveReqDTO reqDTO = this.buildDocRecordSaveReqDTO(saveRequestDTO);
        DocIdResDTO resDTO = this.docRecordDubboService.sendClerkRecordMicro(reqDTO);
        ClerkRecordSaveResponseDTO responseDTO = DocRecordConvert.convertClerkRecordSaveResponseDTO(resDTO);
        responseDTO.setLaunchSign(this.buildLaunchSign(resDTO.getDocId(), intranetMeetingInfo.getCreatorId()));
        return responseDTO;
    }

    private ClerkRecordSaveRequestDTO buildClerkRecordSaveRequestDTO(ClerkRecordGetResponseDTO dto) {
        if (dto == null) {
            return null;
        }
        ClerkRecordSaveRequestDTO result = new ClerkRecordSaveRequestDTO();
        result.setBizId(dto.getBizId());
        result.setBizNo(dto.getBizNo());
        result.setDisputeType(dto.getDisputeType());
        result.setDocId(dto.getDocId());
        result.setLocation(dto.getLocation());
        result.setMeetId(dto.getBizId());
        result.setOrgId(dto.getOrgId());
        result.setOrgName(dto.getOrgName());
        result.setRemark(dto.getRemark());
        result.setTime(dto.getTime());
        result.setUserInfo(dto.getUserInfo());
        return result;
    }

    @Override
    public String download(DownloadRequestDTO downloadRequestDTO) {
        GetRoomIdRequestDTO getRoomIdRequestDTO = new GetRoomIdRequestDTO();
        BeanUtils.copyProperties((Object)downloadRequestDTO, (Object)getRoomIdRequestDTO);
        getRoomIdRequestDTO.setMeetingType(MediationMeetingTypeEnum.MEDIATION_MEETING);
        DubboResult roomDto = this.intranetApi.getIntranetMeetingInfo(getRoomIdRequestDTO);
        AssertUtils.assertTrue((((ArrayList)roomDto.getData()).size() > 0 ? 1 : 0) != 0, (ResultCode)ErrorCode.MEETING_ROOM_HAVE_MANY, (String)"\u6848\u53f7\u5b58\u5728\u591a\u4e2a\u5ead\u5ba1");
        IntranetMeetingInfoResDTO intranetMeetingInfoResDTO = (IntranetMeetingInfoResDTO)((ArrayList)roomDto.getData()).get(0);
        DubboResult dto = this.documentApi.queryFileId(intranetMeetingInfoResDTO.getId().toString());
        log.info("fileID\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        FileInfoResponseDTO data = this.storageDubboService.getFileInfo((String)((Object)dto.getData()));
        log.info("\u4e0b\u8f7d\u7b14\u5f55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)data));
        if (null == data) {
            return null;
        }
        return Base64Utils.encodeBase64String(data.getFileByte());
    }

    private DocRecordGetReqDTO buildDocRecordGetReqDTO(ClerkRecordGetRequestDTO requestDTO) {
        String meetingVideoId;
        DocRecordGetReqDTO reqDTO = DocRecordConvert.convertDocRecordGetReqDTO(requestDTO);
        Long bizId = requestDTO.getBizId();
        MediationMeetingRoomUserInfoResDTO roomUserInfo = this.mediationMeetingService.getMediationRoomUserInfoList(new CommonIdRequestDTO(bizId));
        if (roomUserInfo == null) {
            return null;
        }
        String bizType = roomUserInfo.getMediationMeetingType();
        String meetingOrderType = roomUserInfo.getMediationMeetingType();
        List userInfoLst = roomUserInfo.getList();
        String meetingOrderAddress = null;
        String disputeType = null;
        String roomId = roomUserInfo.getRoomId();
        String string = meetingVideoId = StringUtils.isNotBlank((CharSequence)roomId) ? roomId.split(",")[0] : roomId;
        if (requestDTO.getRoomId() != null) {
            reqDTO.setRoomId(requestDTO.getRoomId());
            DubboResult pirvateMemberDubbo = this.roomMediationApi.getRoomMembers(requestDTO.getRoomId());
            if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)pirvateMemberDubbo.getData())))) {
                ArrayList pirvateMembers = (ArrayList)pirvateMemberDubbo.getData();
                List userIds = pirvateMembers.stream().map(MemberResDTO::getMemberId).collect(Collectors.toList());
                List docPersonalLst = userInfoLst.stream().map(DocPersonalConvert::convertDocPersonalReqDTO).filter(s -> s.getUserId() != null && userIds.contains(s.getUserId().toString())).collect(Collectors.toList());
                reqDTO.setMeetingJoinUserIds(String.join((CharSequence)",", userIds));
                reqDTO.setDocPersonalLst(docPersonalLst);
            }
        } else {
            List userIds = userInfoLst.stream().map(MediationRoomUserInfoResDTO::getUserId).map(s -> String.valueOf(s)).collect(Collectors.toList());
            List docPersonalLst = userInfoLst.stream().map(DocPersonalConvert::convertDocPersonalReqDTO).collect(Collectors.toList());
            reqDTO.setMeetingJoinUserIds(String.join((CharSequence)",", userIds));
            reqDTO.setDocPersonalLst(docPersonalLst);
        }
        bizType = ObjectTypeEnum.MEDIATION.name();
        reqDTO.setBizType(bizType);
        reqDTO.setMeetingOrderType(meetingOrderType);
        reqDTO.setMeetingOrderAddress(meetingOrderAddress);
        reqDTO.setDisputeType(disputeType);
        reqDTO.setMeetingVideoId(meetingVideoId);
        return reqDTO;
    }

    private DocRecordSaveReqDTO buildDocRecordSaveReqDTO(ClerkRecordSaveRequestDTO requestDTO) {
        DocRecordSaveReqDTO reqDTO = DocRecordConvert.convertDocRecordSaveIntranetReqDTO(requestDTO);
        Long bizId = requestDTO.getBizId();
        MediationMeetingRoomUserInfoResDTO roomUserInfo = this.mediationMeetingService.getMediationRoomUserInfoList(new CommonIdRequestDTO(bizId));
        List userInfoLst = roomUserInfo.getList();
        String meetingOrderType = roomUserInfo.getMediationMeetingType();
        List userIds = userInfoLst.stream().map(MediationRoomUserInfoResDTO::getUserId).map(s -> String.valueOf(s)).collect(Collectors.toList());
        List docPersonalLst = userInfoLst.stream().map(DocPersonalConvert::convertDocPersonalReqDTO).collect(Collectors.toList());
        String bizType = roomUserInfo.getMediationMeetingType();
        bizType = ObjectTypeEnum.MEDIATION.name();
        reqDTO.setBizType(bizType);
        if (requestDTO.getMeetId() != null) {
            reqDTO.setMeetingId(requestDTO.getMeetId());
        } else {
            reqDTO.setMeetingId(bizId);
        }
        reqDTO.setMeetingOrderType(meetingOrderType);
        reqDTO.setMeetingJoinUserIds(String.join((CharSequence)",", userIds));
        reqDTO.setMeetingOrder(Integer.valueOf(0));
        reqDTO.setDocPersonalLst(docPersonalLst);
        reqDTO.setRoomId(requestDTO.getRoomId());
        return reqDTO;
    }

    private String buildLaunchSign(Long docId, Long userId) {
        String apiUrl = this.dictionaryService.getDictionaryValue("PEACE_API_URL");
        String shortQrCodeUrl = ShortUrlUtils.encode((long)docId) + ShortUrlUtils.encode((long)userId);
        String shortUrl = apiUrl + this.qrCodeUrlPrefix.concat(shortQrCodeUrl);
        String appName = AppNameContextHolder.getAppName();
        log.info("buildLaunchSign appName is {}", (Object)appName);
        String longUrl = apiUrl.concat(this.accessSignUrlPrefix).concat(appName).concat("/").concat(this.accessSignUrlSuffix).concat(docId.toString()) + "&userId=" + userId;
        this.redisService.hSet((RedisKey)PeaceRedisKeyEnums.SHORT_URL, shortQrCodeUrl, (Object)longUrl);
        return shortUrl;
    }

    private String buildUserInfo(Long bizRoomId, List<Long> userIds) {
        DubboResult userDobbu = this.mediationRoomApi.getMediationRoomAllUserInfoList(bizRoomId);
        if (userDobbu == null || CollectionUtils.isEmpty((Collection)((Collection)((Object)userDobbu.getData())))) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (MediationRoomUserInfoResDTO one : (ArrayList)userDobbu.getData()) {
            if (!userIds.contains(one.getPersonId())) continue;
            String userIdentity = MeetingUserTypeConst.getUserIdentity((String)one.getMeetingUserType());
            result.append(userIdentity == null ? "" : userIdentity);
            result.append(":");
            result.append(one.getUserName() == null ? "" : one.getUserName());
            result.append(",");
            result.append("\u516c\u6c11\u8eab\u4efd\u8bc1:");
            result.append(one.getIdCard() == null ? "" : one.getIdCard());
            result.append("\n");
        }
        return result.toString();
    }

    private DubboResult<ArrayList<IntranetMeetingInfoResDTO>> getIntranetMeetingInfo(IntranetCommonRequestDTO dto) {
        GetRoomIdRequestDTO req = new GetRoomIdRequestDTO();
        req.setCaseNumberCode(dto.getCaseNumberCode());
        req.setCourtCode(dto.getCourtCode());
        req.setCaseOrder(dto.getCaseOrder());
        req.setMeetingType(MediationMeetingTypeEnum.MEDIATION_MEETING);
        DubboResult dubboResult = this.intranetApi.getIntranetMeetingInfo(req);
        AssertUtils.assertTrue((!CollectionUtils.isEmpty((Collection)((Collection)((Object)dubboResult.getData()))) ? 1 : 0) != 0, (ResultCode)ErrorCode.MEETING_ROOM_IS_NULL, (String)ErrorCode.MEETING_ROOM_IS_NULL.desc());
        log.info("\u67e5\u8be2\u7684\u5ead\u5ba1\u6570\uff1a{}", (Object)((ArrayList)dubboResult.getData()).size());
        AssertUtils.assertTrue((((ArrayList)dubboResult.getData()).size() == 1 ? 1 : 0) != 0, (ResultCode)ErrorCode.MEETING_ROOM_HAVE_MANY, (String)ErrorCode.MEETING_ROOM_HAVE_MANY.desc());
        return dubboResult;
    }

    private Map<Long, MediationRoomUserInfoResDTO> buildUserInfoMap(Long bizRoomId) {
        HashMap<Long, MediationRoomUserInfoResDTO> map = new HashMap<Long, MediationRoomUserInfoResDTO>();
        DubboResult userDobbu = this.mediationRoomApi.getMediationRoomAllUserInfoList(bizRoomId);
        if (userDobbu == null || CollectionUtils.isEmpty((Collection)((Collection)((Object)userDobbu.getData())))) {
            return null;
        }
        for (MediationRoomUserInfoResDTO one : (ArrayList)userDobbu.getData()) {
            map.put(one.getUserId(), one);
        }
        return map;
    }

    @Override
    public List<IntranetGetLitigantInfoResponseDTO> getLitigantInfo(IntranetCommonRequestDTO dto) {
        ArrayList<IntranetGetLitigantInfoResponseDTO> resultList = new ArrayList<IntranetGetLitigantInfoResponseDTO>();
        DubboResult<ArrayList<IntranetMeetingInfoResDTO>> dubboResult = this.getIntranetMeetingInfo(dto);
        IntranetMeetingInfoResDTO intranetMeetingInfo = (IntranetMeetingInfoResDTO)((ArrayList)dubboResult.getData()).get(0);
        Map<Long, MediationRoomUserInfoResDTO> userMap = this.buildUserInfoMap(intranetMeetingInfo.getId());
        DubboResult realRoomIdDubbo = this.roomMediationApi.getRealRoomId(intranetMeetingInfo.getRoomId());
        AssertUtils.assertNotNull((Object)realRoomIdDubbo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        String realRoomId = (String)((Object)realRoomIdDubbo.getData());
        log.info("realRoomId:{}" + realRoomId);
        DubboResult memebersDubbo = this.roomMediationApi.thirdPartyGetRoomInfo(realRoomId);
        AssertUtils.assertFalse((memebersDubbo.getData() == null || CollectionUtils.isEmpty((Collection)((ThirdPartyRoomMemberResDTO)memebersDubbo.getData()).getMembers()) ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        IntranetGetLitigantInfoResponseDTO resultDto = null;
        for (ThirdPartyMemberResDTO one : ((ThirdPartyRoomMemberResDTO)memebersDubbo.getData()).getMembers()) {
            MediationRoomUserInfoResDTO userInfo;
            resultDto = new IntranetGetLitigantInfoResponseDTO();
            resultDto.setStatus(one.getMemberStatus());
            if (one.getMemberId() == null || (userInfo = userMap.get(Long.valueOf(one.getMemberId()))) == null) continue;
            resultDto.setUserName(userInfo.getUserName());
            resultDto.setMobilePhone(userInfo.getMobilePhone());
            if ("ONLINE".equals(one.getMemberStatus())) {
                resultDto.setRtmp(this.rtmpurl + one.getStreamId());
            }
            resultDto.setRole(this.getMeetingUserType(one.getMemberType()));
            resultList.add(resultDto);
        }
        return resultList;
    }

    public String getMeetingUserType(String meetingUserType) {
        if ("APPLICANT".equals(meetingUserType) || "APPLICANT_AGENT".equals(meetingUserType)) {
            return "2";
        }
        if ("RESPONDENT".equals(meetingUserType) || "RESPONDENT_AGENT".equals(meetingUserType)) {
            return "3";
        }
        if ("MEDIATOR".equals(meetingUserType)) {
            return "1";
        }
        return "4";
    }

    @Override
    public List<IntranetSignPicResponseDTO> signPic(IntranetCommonRequestDTO dto) {
        ArrayList<IntranetSignPicResponseDTO> returnList = new ArrayList<IntranetSignPicResponseDTO>();
        DubboResult<ArrayList<IntranetMeetingInfoResDTO>> dubboResult = this.getIntranetMeetingInfo(dto);
        IntranetMeetingInfoResDTO intranetMeetingInfo = (IntranetMeetingInfoResDTO)((ArrayList)dubboResult.getData()).get(0);
        Map<Long, MediationRoomUserInfoResDTO> userMap = this.buildUserInfoMap(intranetMeetingInfo.getId());
        DubboResult docIds = this.docRecordMicroApi.getDocId(intranetMeetingInfo.getId());
        Long docId = (Long)docIds.getData();
        if (docId == null) {
            return returnList;
        }
        List<DocWholeConfirmResDTO> list = this.signatureDubboService.queryBilu(intranetMeetingInfo.getId(), 0L, docId);
        if (CollectionUtils.isEmpty(list)) {
            return returnList;
        }
        IntranetSignPicResponseDTO returnDto = null;
        for (DocWholeConfirmResDTO one : list) {
            returnDto = new IntranetSignPicResponseDTO();
            MediationRoomUserInfoResDTO userInfo = userMap.get(one.getConfirmUserId());
            if (userInfo == null) continue;
            returnDto.setUserName(userInfo.getUserName());
            returnDto.setMobilePhone(userInfo.getMobilePhone());
            if (one.getSignatureUrl() == null) {
                returnList.add(returnDto);
                continue;
            }
            FileInfoResponseDTO fileData = this.storageDubboService.getFileInfo(one.getSignatureUrl());
            log.info("\u4e0b\u8f7d\u7b14\u5f55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fileData));
            if (fileData != null) {
                returnDto.setSignPic(Base64Utils.encodeBase64String(fileData.getFileByte()));
            }
            returnList.add(returnDto);
        }
        return returnList;
    }

    @Override
    public void createMediationMeeting(AddMeetingIntranetRequestDTO dto) {
        DTOCheckFieldConvert.checkIntranetAddMeetingDTO(dto);
        DTOCheckFieldConvert.buildIntranetTempId(dto);
        log.info("\u521b\u5efa\u5728\u7ebf\u5ead\u5ba1\u5f00\u59cb");
        Date orderTime = dto.getOrderTime();
        if (orderTime == null) {
            dto.setOrderTime(new Date());
        }
        List<LitigantInfoRequestDTO> litigantList = dto.getLitigantList();
        List mediatorList = Lists.newArrayList();
        List agentList = dto.getAgentList();
        DubboResult userInfoDubbo = this.userServiceSecondApi.getStaffUserId(dto.getMobilePhone());
        AssertUtils.assertTrue((userInfoDubbo != null && userInfoDubbo.getData() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7f51\u5173\u6807\u8bc6\u4e3a\u7a7a");
        UserInfoDTO userInfo = (UserInfoDTO)userInfoDubbo.getData();
        LitigantInfoRequestDTO mediator = IntranetMediationMeetingConvert.buildLitigantInfo(userInfo);
        mediatorList.add(mediator);
        dto.setMediatorList(mediatorList);
        APIResult apiResult = MediationMeetingConvert.getAllPersontListCountIgnorePhoneNoIs1111(litigantList, mediatorList, agentList);
        AssertUtils.assertTrue((apiResult.getCode() == 1000 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)apiResult.getMessage());
        int personCount = (Integer)apiResult.getData();
        AssertUtils.assertFalse((personCount < 2 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u81f3\u5c11\u9700\u89812\u4eba\u624d\u53ef\u4ee5\u53d1\u8d77\u5728\u7ebf\u5ead\u5ba1");
        AssertUtils.assertFalse(((long)personCount > this.meetingNum - 1L ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6dfb\u52a0\u53c2\u4f1a\u4eba\u5458\u8d85\u8fc7\u4e0a\u9650");
        List newList = Lists.newArrayList();
        List agentList1 = Lists.newArrayList();
        if (litigantList != null) {
            newList.addAll(litigantList);
        }
        newList.addAll(mediatorList);
        if (agentList != null) {
            agentList1.addAll(agentList);
        }
        litigantList = this.userService.registerLitigant(litigantList);
        this.userService.registerAgentLitigant(agentList);
        AddMediationMeetingRoomMicroReqDTO reqDTO = IntranetMediationMeetingConvert.getAddMediationMeetingRoomMicroReqDTO(dto);
        reqDTO.setCreatorId(userInfo.getUserId());
        reqDTO.setCreateUser(userInfo.getUserName());
        reqDTO.setUpdateUser(userInfo.getUserName());
        UserRoleInfoDTO roleInfo = this.backstageUserService.searchBackstageUserOrgId(userInfo.getUserId().toString());
        reqDTO.setOrgId(Long.valueOf(dto.getCourtCode()));
        reqDTO.setOrgName(roleInfo.getOrganizationName());
        DubboResult result = this.mediationMeetingRoomApi.addMediationMeetingMicro(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AddMediationMeetingResDTO resDTO = (AddMediationMeetingResDTO)result.getData();
        List<String> phoneList = this.getSendUserPhoneForCreateOnlineMeeting(reqDTO);
        this.peaceSmsService.sendMediationMeetingSmsByPhoneList(phoneList, resDTO.getMediationRoomId(), dto.getCaseNumberCode(), resDTO.getRoomId(), dto.getStaffName(), resDTO.getOrderTime(), 1);
    }

    private List<String> getSendUserPhoneForCreateOnlineMeeting(AddMediationMeetingRoomMicroReqDTO reqDTO) {
        List litigantList;
        List allUser = Lists.newArrayList();
        List agentList = reqDTO.getAgentList();
        if (agentList != null) {
            allUser.addAll(agentList);
        }
        if ((litigantList = reqDTO.getLitigantList()) != null) {
            for (MediationMeetingUserInfoReqDTO litigant : litigantList) {
                if (StringUtils.isEmpty((CharSequence)litigant.getMobilePhone())) continue;
                allUser.add(litigant);
            }
        }
        Set phoneSet = allUser.stream().map(MediationMeetingUserInfoReqDTO::getMobilePhone).collect(Collectors.toSet());
        phoneSet.remove("1111");
        return new ArrayList<String>(phoneSet);
    }
}

