/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.responsedto.JiangBeiGetLitigantInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.JiangBeiGetRoomAndUserIdsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.RoomAndUserIdsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.RoomMemberListResponseDTO;
import com.beiming.odr.peace.service.JiangBeiIntranetService;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JiangbeiIntranetServiceImpl
implements JiangBeiIntranetService {
    private static final Logger log = LoggerFactory.getLogger(JiangbeiIntranetServiceImpl.class);
    @Value(value="${jiangbei.getUsers}")
    private String getUsersUrl;
    @Value(value="${jiangbei.getLitigantInfo}")
    private String getLitigantInfoUrl;

    @Override
    public JiangBeiGetLitigantInfoResponseDTO getLitigantInfo(String roomId) {
        JiangBeiGetLitigantInfoResponseDTO responseDTO = new JiangBeiGetLitigantInfoResponseDTO();
        try {
            log.info("begin getLitigantInfo, request param is {}", (Object)roomId);
            String getUrl = this.getLitigantInfoUrl + roomId;
            log.info("begin getLitigantInfo, request url is {}", (Object)getUrl);
            String result = MyHttpClientUtils.sendHttpGet((String)getUrl);
            log.info("getLitigantInfo result is {}", (Object)result);
            if (result != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String code = null;
                if (jsonObject.get((Object)"code") != null) {
                    code = jsonObject.get((Object)"code").toString();
                }
                AssertUtils.assertTrue((boolean)"1000".equals(code), (ResultCode)ErrorCode.UNABLE_GET_LITIGANT_INFO, (String)ErrorCode.UNABLE_GET_LITIGANT_INFO.desc());
                if (jsonObject.get((Object)"data") == null) {
                    return null;
                }
                JSONObject data = (JSONObject)jsonObject.get((Object)"data");
                if (data.get((Object)"roomId") != null) {
                    responseDTO.setRoomId(data.get((Object)"roomId").toString());
                }
                List roomMemberList = null;
                if (data.get((Object)"roomMemberList") != null) {
                    roomMemberList = JSONObject.parseArray((String)data.get((Object)"roomMemberList").toString(), RoomMemberListResponseDTO.class);
                }
                responseDTO.setList(roomMemberList);
            }
        }
        catch (IOException e) {
            log.error("sendHttpPost error ", (Throwable)e);
        }
        return responseDTO;
    }

    @Override
    public JiangBeiGetRoomAndUserIdsResponseDTO getCourtRoomIdsAndUserIds(String caseNumber) {
        JiangBeiGetRoomAndUserIdsResponseDTO responseDTO = new JiangBeiGetRoomAndUserIdsResponseDTO();
        try {
            String getUrl = this.getUsersUrl + caseNumber;
            log.info("begin getRoomAndUser, request url is {}", (Object)getUrl);
            String result = MyHttpClientUtils.sendHttpGet((String)getUrl);
            log.info("getRoomAndUser result is {}", (Object)result);
            if (result != null) {
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String code = null;
                if (jsonObject.get((Object)"code") != null) {
                    code = jsonObject.get((Object)"code").toString();
                }
                if (!"1000".equals(code)) {
                    return null;
                }
                if (jsonObject.get((Object)"data") == null) {
                    return null;
                }
                String data = jsonObject.get((Object)"data").toString();
                List list = JSONObject.parseArray((String)data, RoomAndUserIdsResponseDTO.class);
                responseDTO.setList(list);
            }
        }
        catch (IOException e) {
            log.error("sendHttpPost error ", (Throwable)e);
        }
        return responseDTO;
    }
}

