/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import com.beiming.framework.util.Java8DateUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String getFormatDate(String dateFormat, Date date) {
        return Java8DateUtils.formatter((Date)date, (String)dateFormat);
    }

    public static String getMinusDate(String dateFormat, Date date, long minusDays) {
        String nowDate = Java8DateUtils.formatter((Date)date, (String)dateFormat);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(dateFormat);
        LocalDate localDate = LocalDate.parse(nowDate, dateFormatter);
        LocalDate minusLocalDate = localDate.minusDays(minusDays);
        return dateFormatter.format(minusLocalDate);
    }

    public static String getPlusDateByStr(String dateFormat, String dateStr, long plusDays) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(dateFormat);
        LocalDate localDate = LocalDate.parse(dateStr, dateFormatter);
        if (plusDays != 0L) {
            localDate = localDate.plusDays(plusDays);
        }
        DateTimeFormatter returnFormatter = DateTimeFormatter.ofPattern("MM\u6708dd\u65e5");
        return returnFormatter.format(localDate);
    }

    public static Date getDateStartTime() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getDateEndTime() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static long getMinuteDiff(Date startDate, Date endDate) {
        long diff = endDate.getTime() - startDate.getTime();
        long min = diff / 1000L / 60L;
        return min;
    }
}

