/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.RoomApi;
import com.beiming.basic.chat.api.dto.response.RoomResDTO;
import com.beiming.basic.message.api.MessageServiceApi;
import com.beiming.basic.message.dto.request.SendSmsRequestDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.MobilePhoneTypeEnums;
import com.beiming.odr.peace.common.enums.SMSTypeEnums;
import com.beiming.odr.peace.domain.dto.requestdto.CheckValidCodeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonUserResetPasswordRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.GetMobilePhoneByCodeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RealNameAuthenticationRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SMSCodeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SendMessageRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdatePwdReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginByMicroCourtRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginBySxMicroCourtRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserLoginNotPasswordRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.CommonUserInfoResponseDTO;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.Base64Utils;
import com.beiming.odr.peace.service.util.PasswordHandleUtil;
import com.beiming.odr.peace.service.util.RSAUtil;
import com.beiming.odr.peace.service.util.SMSUtil;
import com.beiming.odr.peace.service.util.WechatBindingUtil;
import com.beiming.odr.referee.api.MediationMeetingApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.user.api.DataStatisticsCourtApi;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.OrganizationServiceApi;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.common.enums.PasswordFormatTypeEnum;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserDubboErrorCode;
import com.beiming.odr.user.api.common.enums.UserLoginNotPasswordEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.PeaceRealNameAuthenticationTopicDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserResetPasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdatePasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginByMicroCourtReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginBySxMicroCourtReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginNotPasswordReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beiming.pigeons.api.producer.rocketmq.RocketMessageDto;
import com.beiming.pigeons.api.producer.rocketmq.RocketProducerClient;
import com.google.common.collect.Lists;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.mortbay.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private SMSUtil smsUtil;
    @Resource
    private MessageServiceApi messageServiceApi;
    @Resource
    private PasswordHandleUtil passwordHandleUtil;
    @Resource
    private RocketProducerClient rocketProducerClient;
    @Resource
    private RedisService redisService;
    @Resource
    private WechatBindingUtil wechatBindingUtil;
    @Resource
    private UserServiceSecondApi userServiceSecondApi;
    @Resource
    DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private OrganizationServiceApi organizationServiceApi;
    @Resource
    private DataStatisticsCourtApi dataStatisticsCourtApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private RoomApi roomApi;
    @Resource
    private MediationMeetingApi mediationMeetingApi;

    @Override
    public LoginInfoResDTO userLogin(String mobile, String loginName, String password, UserLoginTypeEnum loginType, String publicKey, String deviceId) {
        loginType = loginType == null ? UserLoginTypeEnum.COMMON_USER_LOGIN_TYPE : loginType;
        password = this.passwordHandleUtil.decryptPassword(PasswordFormatTypeEnum.USER_LOGIN, publicKey, password, "\u5bc6\u7801\u683c\u5f0f\u9519\u8bef");
        DubboResult result = this.userServiceApi.userLogin(mobile, password, loginName, loginType);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public LoginInfoResDTO userLoginByCert(String mobile, String certSn, String password, UserLoginTypeEnum loginType, String publicKey, String deviceId) {
        DubboResult result = this.userServiceApi.userLogin(mobile, password, certSn, loginType);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public boolean isShowInnerCase(Long orgId, Long userId) {
        String type = this.dictionaryServiceApi.getUserRole(userId);
        if ("JUROR".equals(type)) {
            return false;
        }
        DictionaryReqDTO req = new DictionaryReqDTO();
        req.setParentCode("TDH_WEBSERVICE_URL");
        DubboResult dictionaryInfo = this.dictionaryServiceApi.searchDictionaryInfo(req);
        if (Objects.isNull(dictionaryInfo)) {
            return false;
        }
        List list = ((DictionaryResDTO)dictionaryInfo.getData()).getData();
        Optional<DictionaryInfoDTO> dictionary = list.stream().filter(dic -> StringUtils.isNotBlank((CharSequence)dic.getImgUrl()) && dic.getImgUrl().contains(String.format(",%s,", orgId))).findFirst();
        return dictionary.isPresent();
    }

    @Override
    public void checkAppNameAndProvinceCode(Long orgId) {
        if (orgId == null) {
            return;
        }
        DubboResult organizationDubbo = this.organizationServiceApi.getOrganizationDetail(orgId);
        AssertUtils.assertNotNull((Object)organizationDubbo.getData(), (ResultCode)ErrorCode.ORGANIZATION_NOT_EXISTS, (String)ErrorCode.ORGANIZATION_NOT_EXISTS.desc());
        String provinceCode = ((OrganizationResDTO)organizationDubbo.getData()).getProvinceCode();
        String appName = AppNameContextHolder.getAppName();
        boolean sign = false;
        if (!StringUtil.isNullOrEmpty((String)provinceCode)) {
            if ("weitingshensx".equals(appName)) {
                sign = !"6100000000".equals(provinceCode);
            } else if ("weitingshenfj".equals(appName)) {
                sign = !"3500000000".equals(provinceCode);
            } else if ("weitingshencq".equals(appName)) {
                sign = !"5000000000".equals(provinceCode);
            } else if ("weitingshenhubei".equals(appName)) {
                sign = !"4200000000".equals(provinceCode);
            } else if ("weitingshenhubeizz".equals(appName)) {
                sign = !"4200000000".equals(provinceCode);
            }
        }
        AssertUtils.assertFalse((boolean)sign, (ResultCode)ErrorCode.USER_NOT_EXISTS, (String)ErrorCode.USER_NOT_EXISTS.desc());
    }

    @Override
    public void resetUserPassword(CommonUserResetPasswordRequestDTO req) {
        AssertUtils.assertTrue((boolean)this.smsUtil.checkMobilePhoneCode(req.getMobilePhone(), req.getValidateCode(), SMSTypeEnums.SMS_RESET_PASSWORD_CODE, false, req.getPersonType()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef");
        log.info("\u5bc6\u7801\uff1a{}", (Object)req.getPassword());
        String password = this.passwordHandleUtil.decryptPassword(PasswordFormatTypeEnum.USER_REGISTER, req.getPublicKey(), req.getPassword(), "\u5bc6\u7801\u683c\u5f0f\u9519\u8bef");
        log.info("\u5bc6\u7801\uff1a{}", (Object)password);
        CommonUserResetPasswordReqDTO param = new CommonUserResetPasswordReqDTO();
        param.setMobilePhone(req.getMobilePhone());
        param.setPassword(password);
        param.setPersonTypeEnum(req.getPersonType());
        DubboResult result = this.userServiceApi.resetUserPassword(param);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        this.smsUtil.checkMobilePhoneCode(req.getMobilePhone(), req.getValidateCode(), SMSTypeEnums.SMS_RESET_PASSWORD_CODE, true, req.getPersonType());
    }

    @Override
    public DubboResult updatePassword(UpdatePwdReqDTO dto) {
        CommonUserUpdatePasswordReqDTO commonUserUpdatePasswordReqDTO = new CommonUserUpdatePasswordReqDTO();
        commonUserUpdatePasswordReqDTO.setUserId(dto.getUserId());
        byte[] oldDecode = Base64.getDecoder().decode(Base64.getDecoder().decode(dto.getOldPwd()));
        String oldPwd = new String(oldDecode);
        commonUserUpdatePasswordReqDTO.setOldPassword(oldPwd);
        byte[] newDecode = Base64.getDecoder().decode(Base64.getDecoder().decode(dto.getNewPwd()));
        String newPwd = new String(newDecode);
        commonUserUpdatePasswordReqDTO.setNewPassword(newPwd);
        DubboResult dubboResult = this.userServiceApi.updatePassword(commonUserUpdatePasswordReqDTO);
        return dubboResult;
    }

    @Override
    public void setFacialVerify(Long userId) {
        AssertUtils.assertNotNull((Object)userId, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u672a\u767b\u5f55");
        DubboResult result = this.userServiceApi.setFacialVerify(userId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    @Override
    public void setRealNameAuthentication(Long userId, RealNameAuthenticationRequestDTO req) {
        AssertUtils.assertNotNull((Object)userId, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u672a\u767b\u5f55");
        RealNameAuthenticationReqDTO requestDTO = new RealNameAuthenticationReqDTO();
        requestDTO.setIdCard(req.getIdCard());
        requestDTO.setUserName(req.getUserName());
        DubboResult result = this.userServiceApi.setRealNameAuthentication(userId, requestDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    @Override
    public CommonUserInfoResponseDTO searchCommonUser(Long userId) {
        CommonIdReqDTO commonIdReqDTO = new CommonIdReqDTO();
        commonIdReqDTO.setId(userId);
        DubboResult result = this.userServiceApi.searchCommonUser(commonIdReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        CommonUserSearchResDTO resDTO = (CommonUserSearchResDTO)result.getData();
        CommonUserInfoResponseDTO responseDTO = new CommonUserInfoResponseDTO(resDTO.getUserId(), resDTO.getIdCard(), resDTO.getUserName(), resDTO.getSex(), resDTO.getBirthday(), resDTO.getCurrentAddress(), resDTO.getPermanentAddress(), resDTO.getPortraitUrl(), resDTO.getIsRealName(), resDTO.getIsFacialVerify(), resDTO.getMobilePhone(), resDTO.getEmail(), resDTO.getBusinessPeopleType());
        return responseDTO;
    }

    @Override
    public String getSMSCode(SMSCodeRequestDTO smsCodeRequestDTO) {
        if (SMSTypeEnums.SMS_RESET_PASSWORD_CODE.equals((Object)smsCodeRequestDTO.getSmsType())) {
            Boolean bol = this.checkUserByMobileMethod(smsCodeRequestDTO.getMobilePhone(), smsCodeRequestDTO.getPersonType());
            AssertUtils.assertTrue((boolean)bol, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return this.smsUtil.sendSms(smsCodeRequestDTO.getMobilePhone(), smsCodeRequestDTO.getSmsType(), smsCodeRequestDTO.getPersonType());
    }

    @Override
    public void checkValidCode(CheckValidCodeRequestDTO req) {
        AssertUtils.assertTrue((boolean)this.smsUtil.checkMobilePhoneCode(req.getMobilePhone(), req.getValidateCode(), req.getSmsType(), false, req.getPersonType()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25");
    }

    public Boolean checkUserByMobileMethod(String mobile, PersonTypeEnum type) {
        DubboResult result = this.userServiceApi.checkUserByMobile(mobile, type);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Boolean)result.getData();
    }

    @Override
    public LoginInfoResDTO userLoginNotPassword(UserLoginNotPasswordRequestDTO req, UserLoginNotPasswordEnum loginType) {
        String appName = AppNameContextHolder.getAppName();
        AssertUtils.assertTrue((loginType != null ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u767b\u5f55\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        String openId = "";
        if (!UserLoginNotPasswordEnum.LOGIN_BY_CODE.equals((Object)loginType)) {
            if (UserLoginNotPasswordEnum.LOGIN_BY_WECHAT_NOT_FIRST.equals((Object)loginType)) {
                openId = this.wechatBindingUtil.getOpenIdByCode(req.getCode(), appName);
            } else {
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)req.getMobilePhone()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.assertTrue((req.getMobilePhoneType() != null ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u624b\u673a\u53f7\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                if (MobilePhoneTypeEnums.OTHER.equals((Object)req.getMobilePhoneType())) {
                    AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)req.getValidateCode()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9009\u62e9\u5176\u4ed6\u624b\u673a\u53f7\u7801\u65f6\uff0c\u9a8c\u8bc1\u7801\u5fc5\u586b");
                    AssertUtils.assertTrue((boolean)this.smsUtil.checkMobilePhoneCode(req.getMobilePhone(), req.getValidateCode(), req.getSmsType(), false, req.getPersonType()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25");
                }
                openId = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_OPEN_ID, req.getCode());
                AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)openId), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"openId\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        UserLoginNotPasswordReqDTO res = new UserLoginNotPasswordReqDTO();
        res.setLoginType(loginType);
        res.setMobilePhone(req.getMobilePhone());
        res.setPersonType(req.getPersonType());
        res.setOpenId(openId);
        res.setHeadImgUrl(req.getHeadPortraitUrl());
        DubboResult result = this.userServiceApi.userLoginNotPassword(res);
        if (UserDubboErrorCode.USER_NOT_BINDING_OPEN_ID.getValue() == result.getCode()) {
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)UserDubboErrorCode.USER_NOT_BINDING_OPEN_ID, (String)UserDubboErrorCode.USER_NOT_BINDING_OPEN_ID.desc());
        }
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        if (UserLoginNotPasswordEnum.LOGIN_BY_WECHAT_FIRST.equals((Object)loginType)) {
            this.smsUtil.checkMobilePhoneCode(req.getMobilePhone(), req.getValidateCode(), req.getSmsType(), true, req.getPersonType());
            this.redisService.delete((RedisKey)RedisKeyEnums.USER_OPEN_ID, req.getCode());
        }
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public String getMobilePhoneByCode(GetMobilePhoneByCodeRequestDTO requestDTO) {
        return this.wechatBindingUtil.getOpenIdByCode(requestDTO);
    }

    @Override
    public void setRealNameAndFacialVerify(Long userId, RealNameAuthenticationRequestDTO req) {
        AssertUtils.assertNotNull((Object)userId, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u672a\u767b\u5f55");
        RealNameAuthenticationReqDTO requestDTO = new RealNameAuthenticationReqDTO();
        requestDTO.setIdCard(req.getIdCard());
        requestDTO.setUserName(req.getUserName());
        DubboResult result = this.userServiceSecondApi.setRealNameAndFacialVerify(userId, requestDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        PeaceRealNameAuthenticationTopicDTO obj = new PeaceRealNameAuthenticationTopicDTO(userId, req.getUserName(), req.getIdCard());
        RocketMessageDto rocketMessageDto = new RocketMessageDto("peaceRealNameAuthenticationTopic", userId + "", (Object)obj);
        this.rocketProducerClient.sendMessage(rocketMessageDto);
    }

    @Override
    public LoginInfoResDTO userLoginByMicroCourt(UserLoginByMicroCourtRequestDTO requestDTO) {
        UserLoginByMicroCourtReqDTO req = new UserLoginByMicroCourtReqDTO();
        req.setMobilePhone(requestDTO.getMobilePhone());
        req.setUserName(requestDTO.getUserName());
        req.setIdCard(requestDTO.getIdCard());
        req.setOpenId(this.wechatBindingUtil.getOpenIdByCode(requestDTO.getJsCode(), null));
        DubboResult result = this.userServiceSecondApi.userLoginByMicroCourt(req);
        if (result.getCode() == UserDubboErrorCode.OPEN_ID_BINDING_OTHER_MOBILE_PHONE.getValue()) {
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)UserDubboErrorCode.OPEN_ID_BINDING_OTHER_MOBILE_PHONE, (String)result.getMessage());
        } else {
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        }
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public LoginInfoResDTO userLoginBySxMicroCourt(UserLoginBySxMicroCourtRequestDTO requestDTO) {
        JSONObject json = this.decodeParam(requestDTO);
        UserLoginBySxMicroCourtReqDTO req = new UserLoginBySxMicroCourtReqDTO();
        req.setMobilePhone(json.getString("phone"));
        req.setUserName(json.getString("name"));
        String idCard = json.getString("idCard");
        if (StringUtils.isBlank((CharSequence)idCard)) {
            idCard = json.getString("iDCard");
        }
        req.setIdCard(idCard);
        req.setPersonType("1".equals(json.getString("type")) ? PersonTypeEnum.STAFF : PersonTypeEnum.COMMON);
        DubboResult result = this.userServiceSecondApi.userLoginBySxMicroCourt(req);
        log.info("userLoginBySxMicroCourt result: " + result);
        if (result.getCode() == UserDubboErrorCode.OPEN_ID_BINDING_OTHER_MOBILE_PHONE.getValue()) {
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)UserDubboErrorCode.OPEN_ID_BINDING_OTHER_MOBILE_PHONE, (String)result.getMessage());
        } else {
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        }
        return (LoginInfoResDTO)result.getData();
    }

    private JSONObject decodeParam(UserLoginBySxMicroCourtRequestDTO req) {
        try {
            String jsonStr = Base64Utils.decodeBase64String(req.getInfo());
            log.info("--\u89e3\u5bc6\u540e\u7684jsonStr--\uff1a" + jsonStr);
            JSONObject json = (JSONObject)JSONObject.parse((String)jsonStr);
            String cKeyStr = json.get((Object)"cKey").toString();
            String cStr = json.get((Object)"cStr").toString();
            String cKey = RSAUtil.decrypt(cKeyStr);
            log.info("--\u89e3\u5bc6\u540e\u7684cKey--\uff1a" + cKey);
            String base64Param = RSAUtil.aesDncode(cKey, cStr);
            String param = Base64Utils.decodeBase64String(base64Param);
            log.info("--\u89e3\u5bc6\u540e\u7684\u5165\u53c2\u5b57\u7b26\u4e32--\uff1a" + param);
            return (JSONObject)JSONObject.parse((String)param);
        }
        catch (Exception e) {
            AssertUtils.assertFalse((boolean)true, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u89e3\u5bc6\u5931\u8d25,\u53c2\u6570\u6709\u8bef");
            return null;
        }
    }

    @Override
    public void sendMsg(SendMessageRequestDTO dto) {
        String templateId = dto.getTemplateId();
        JSONObject params = JSONObject.parseObject((String)dto.getParam());
        List<DictionaryInfoDTO> loginCodeAndPhoneNo = this.getLoginCodeAndPhoneNo();
        for (DictionaryInfoDTO dic : loginCodeAndPhoneNo) {
            String value = dic.getValue();
            String[] phones = value.replace("\uff0c", ",").split(",");
            for (int i = 0; i < phones.length; ++i) {
                SendSmsRequestDTO arg0 = new SendSmsRequestDTO();
                arg0.setTemplateId(templateId);
                arg0.setPhone(phones[i]);
                if ("SMS_MEDIATION_MEETING_TEST2".equals(templateId)) {
                    params.put("loginCode", (Object)dic.getContent());
                }
                if ("SMS_MEDIATION_MEETING_TEST3".equals(templateId)) {
                    params.put("loginCode", (Object)dic.getCode());
                }
                arg0.setParams(params);
                this.messageServiceApi.sendSMS(arg0);
            }
        }
    }

    private List<DictionaryInfoDTO> getLoginCodeAndPhoneNo() {
        ArrayList parentCodes = Lists.newArrayList();
        parentCodes.add("LOGIN_CODE");
        DubboResult result = this.dictionaryServiceApi.getDictionaryByParentCode((List)parentCodes);
        Log.info((String)"getLoginCodeAndPhoneNo:{}", (Object)result);
        List data = ((DictionaryResDTO)result.getData()).getData();
        return data;
    }

    @Override
    public LoginInfoResDTO userLoginInfo(Long userId) {
        DubboResult result = this.dataStatisticsCourtApi.userLoginInfo(userId.toString());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public void setRegisterOrigin(Long userId) {
        this.userServiceApi.setRegisterOrigin(userId);
    }

    @Override
    public LoginInfoResDTO userLoginTwo(String mobile) {
        DubboResult result = this.userServiceApi.userLoginTwo(mobile);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public LoginInfoResDTO userLoginByMobileAndType(String mobile, UserLoginTypeEnum loginType) {
        DubboResult result = this.userServiceApi.userLoginByMobileAndType(mobile, loginType);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public LoginInfoResDTO userLoginByMobileAndTypes(String mobile, PersonTypeEnum loginType) {
        log.info("================" + mobile);
        DubboResult result = this.userServiceApi.userLoginByMobileAndTypes(mobile, loginType);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public List<String> userIdCard(String idCard) {
        DubboResult result = this.userServiceSecondApi.userIdCard(idCard);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (List)((Object)result.getData());
    }

    @Override
    public void authentication(Long mediationMeetingId) {
        String userIdStr = JWTContextUtil.getCurrentUserId();
        log.info("\u9274\u6743\u7684\u7528\u6237id{}||\u7a7a\u95f4\u6216\u5ead\u5ba1id{}", (Object)userIdStr, (Object)mediationMeetingId);
        DubboResult result = this.mediationRoomApi.getMediationRoomUserInfoAllList(mediationMeetingId);
        AssertUtils.assertFalse((result == null || CollectionUtils.isEmpty((Collection)((Collection)((Object)result.getData()))) ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u4f1a\u8bae\u53c2\u4e0e\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)userIdStr), (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u83b7\u53d6\u7528\u6237id\u4e3a\u7a7a\uff0c\u9274\u6743\u5931\u8d25");
        Long userId = Long.valueOf(userIdStr);
        HashSet<Long> memberIds = new HashSet<Long>();
        for (MediationRoomUserInfoResDTO userInfo : (ArrayList)result.getData()) {
            if (userInfo == null || userInfo.getUserId() == null) continue;
            memberIds.add(userInfo.getUserId());
        }
        AssertUtils.assertTrue((boolean)memberIds.contains(userId), (ResultCode)ErrorCode.ACCESS_DENIED, (String)"\u6ca1\u6709\u8bbf\u95ee\u6570\u636e\u7684\u6743\u9650");
    }

    @Override
    public void authenticationByRoomId(String roomId) {
        DubboResult roomInfoRes = this.roomApi.getRoom(roomId);
        AssertUtils.assertFalse((roomInfoRes == null || roomInfoRes.getData() == null ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u623f\u95f4id\u6709\u8bef");
        String subjectIdStr = ((RoomResDTO)roomInfoRes.getData()).getSubjectId();
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)subjectIdStr), (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u623f\u95f4id\u6709\u8bef");
        Long subjectId = Long.valueOf(subjectIdStr);
        this.authentication(subjectId);
    }

    @Override
    public String screenLayout(Long orgId) {
        String appName = AppNameContextHolder.getAppName();
        if (!("weitingshenhubei".equals(appName) || "weitingshenhainan".equals(appName) || "weitingshenhubeizz".equals(appName))) {
            return "";
        }
        String screenLayout = "MIDDLE";
        try {
            OrganizationResDTO organizationResDTO;
            DubboResult dubboResult = this.organizationServiceApi.getOrganizationDetail(orgId);
            if (dubboResult != null && (organizationResDTO = (OrganizationResDTO)dubboResult.getData()) != null && StringUtils.isNotBlank((CharSequence)organizationResDTO.getMediateCode())) {
                screenLayout = organizationResDTO.getMediateCode();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return screenLayout;
    }

    @Override
    public String getMeetingUserType(Long meetingId, Long userId) {
        DubboResult result = this.mediationMeetingApi.getMeetingUserType(meetingId, userId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (String)((Object)result.getData());
    }
}

