/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestMicroDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationRoomMeetingUserRequstDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CloseMediationMeetingRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MediationMeetingListRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.AddMediationRoomMeetingResponseDTO;
import com.beiming.odr.peace.im.api.dto.request.InvitationVideoSendTextRequestDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomUserMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomMeetingReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomMeetingUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.CloseMediationRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingRoomListReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.VisitSystemUserReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class MediationMeetingConvert {
    private static final Logger log = LoggerFactory.getLogger(MediationMeetingConvert.class);

    public static AddMediationMeetingRoomReqDTO getAddMediationMeetingRoomReqDTO(AddMediationMeetingRequestDTO dto) {
        AddMediationMeetingRoomReqDTO addDto = new AddMediationMeetingRoomReqDTO();
        addDto.setAuthFlag(dto.getAuthFlag());
        addDto.setCallFlag(dto.getCallFlag());
        addDto.setMediationMeetingRoomName(dto.getMediationMeetingName());
        addDto.setOrderTime(dto.getOrderTime());
        addDto.setParentId(null);
        addDto.setCreatorId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        addDto.setCreateUser(JWTContextUtil.getCurrentUserName());
        addDto.setUpdateUser(JWTContextUtil.getCurrentUserName());
        ArrayList litigantList = Lists.newArrayList();
        List list = dto.getList();
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationMeetingConvert.getMediationMeetingUserInfoReqDTO(userDto);
            litigantList.add(userInfoReqDTO);
        }
        addDto.setLitigantList((List)litigantList);
        return addDto;
    }

    public static AddMediationMeetingRoomMicroReqDTO getAddMediationMeetingRoomMicroReqDTO(AddMediationMeetingMicroRequestDTO dto, String expandAttribute, MediationMeetingRoomInfoResDTO parentRoomInfo) {
        JSONObject json;
        AddMediationMeetingRoomMicroReqDTO addDto = new AddMediationMeetingRoomMicroReqDTO();
        addDto.setAuthFlag(dto.getAuthFlag());
        addDto.setCallFlag(dto.getCallFlag());
        addDto.setMediationMeetingRoomName(dto.getMediationRoomName());
        addDto.setOrderTime(dto.getOrderTime());
        addDto.setParentId(dto.getMediationRoomId());
        addDto.setCauseName(dto.getCauseName());
        addDto.setCauseCode(dto.getCauseCode());
        addDto.setCourtRoomCode(dto.getCourtRoomCode());
        addDto.setCourtRoomName(dto.getCourtRoomName());
        addDto.setLeadTime(dto.getLeadTime());
        if (parentRoomInfo == null) {
            addDto.setCreatorId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
            addDto.setCreateUser(JWTContextUtil.getCurrentUserName());
            addDto.setUpdateUser(JWTContextUtil.getCurrentUserName());
        } else {
            addDto.setCreatorId(parentRoomInfo.getCreatorId());
            addDto.setCreateUser(parentRoomInfo.getCreateUser());
            addDto.setUpdateUser(parentRoomInfo.getCreateUser());
        }
        addDto.setThirdCaseId(dto.getThirdCaseId());
        JSONObject jSONObject = json = StringUtils.isNotBlank((CharSequence)expandAttribute) ? JSONObject.parseObject((String)expandAttribute) : new JSONObject();
        if (dto.getOrderEndTime() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String orderTime = sdf.format(dto.getOrderTime());
            addDto.setOrderEndTime(orderTime.substring(0, 11) + " " + dto.getOrderEndTime() + ":00");
            json.put(ColumnEnums.ORDER_END_TIME.desc(), (Object)dto.getOrderEndTime());
        } else {
            json.put(ColumnEnums.ORDER_END_TIME.desc(), (Object)DateUtil.offsetMinute((Date)dto.getOrderTime(), (int)30));
        }
        addDto.setExpandAttribute(json.toJSONString());
        ArrayList litigantList = Lists.newArrayList();
        ArrayList mediationList = Lists.newArrayList();
        List list = dto.getLitigantList();
        list = list == null ? Lists.newArrayList() : list;
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(userDto);
            userInfoReqDTO.setExpandAttribute(MediationMeetingConvert.buildLitigantJsonInfo(userDto));
            litigantList.add(userInfoReqDTO);
        }
        List agentList = dto.getAgentList();
        agentList = agentList == null ? Lists.newArrayList() : agentList;
        ArrayList agentListAdd = Lists.newArrayList();
        for (LitigantAgentInfoMicroRequestDTO agentInfoMicroReq : agentList) {
            String agentParentUserUserTempIdStr = agentInfoMicroReq.getAgentParentUserTempIdList();
            List<Object> agentParentUserTempIdList = Lists.newArrayList();
            if (!StringUtils.isBlank((CharSequence)agentParentUserUserTempIdStr)) {
                String[] split = agentParentUserUserTempIdStr.split(",");
                agentParentUserTempIdList = Arrays.asList(split);
            }
            List<MediationMeetingUserInfoReqDTO> agentListTemp = MediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(agentInfoMicroReq, agentParentUserTempIdList);
            agentListAdd.addAll(agentListTemp);
        }
        addDto.setAgentList((List)agentListAdd);
        addDto.setLitigantList((List)litigantList);
        List mediatorList = dto.getMediatorList();
        for (LitigantInfoRequestDTO litigantInfoRequestDTO : mediatorList) {
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(litigantInfoRequestDTO);
            userInfoReqDTO.setExpandAttribute(MediationMeetingConvert.buildMediatorJsonInfo(litigantInfoRequestDTO));
            mediationList.add(userInfoReqDTO);
        }
        addDto.setMediatorList((List)mediationList);
        return addDto;
    }

    public static MediationMeetingUserInfoReqDTO getMediationMeetingUserInfoReqDTO(LitigantInfoRequestDTO dto) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(MeetingUserTypeEnum.LITIGANT.name());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        return reqDTO;
    }

    public static MediationMeetingUserInfoReqDTO getMediationMeetingUserInfoMicroReqDTO(LitigantInfoRequestDTO dto) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType().name());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setRemark(dto.getUserTempId());
        reqDTO.setExpandAttribute(MediationMeetingConvert.buildLitigantJsonInfo(dto));
        return reqDTO;
    }

    public static List<MediationMeetingUserInfoReqDTO> getMediationMeetingUserInfoMicroReq(LitigantAgentInfoMicroRequestDTO dto) {
        ArrayList list = Lists.newArrayList();
        MediationMeetingUserInfoReqDTO reqDTO = MediationMeetingConvert.createAgentReqObjectNew(dto);
        list.add(reqDTO);
        return list;
    }

    public static List<MediationMeetingUserInfoReqDTO> getMediationMeetingUserInfoMicroReqDTO(LitigantAgentInfoMicroRequestDTO dto, List<String> agentParentUserTempIdList) {
        ArrayList list = Lists.newArrayList();
        for (String userTempId : agentParentUserTempIdList) {
            MediationMeetingUserInfoReqDTO reqDTO = MediationMeetingConvert.createAgentReqObject(dto, userTempId);
            list.add(reqDTO);
        }
        if (list.size() == 0) {
            MediationMeetingUserInfoReqDTO reqDTO = MediationMeetingConvert.createAgentReqObject(dto, null);
            list.add(reqDTO);
        }
        return list;
    }

    private static MediationMeetingUserInfoReqDTO createAgentReqObject(LitigantAgentInfoMicroRequestDTO dto, String userTempId) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType().name());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setAgentUserTempId(userTempId);
        reqDTO.setAgentType(dto.getAgentType() == null ? "" : dto.getAgentType().name());
        reqDTO.setUserOrder(dto.getUserOrder());
        reqDTO.setRemark(dto.getUserTempId());
        return reqDTO;
    }

    public static AddMediationRoomUserReqDTO gerAddMediationRoomUserReqDTO(AddMediationMeetingUserRequestDTO addMediationMeetingUserRequestDTO) {
        AddMediationRoomUserReqDTO addMediationRoomUserReqDTO = new AddMediationRoomUserReqDTO();
        addMediationRoomUserReqDTO.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        addMediationRoomUserReqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        addMediationRoomUserReqDTO.setMediationRoomId(addMediationMeetingUserRequestDTO.getMediationRoomId());
        ArrayList litigantList = Lists.newArrayList();
        List list = addMediationMeetingUserRequestDTO.getList();
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationMeetingConvert.getMediationMeetingUserInfoReqDTO(userDto);
            litigantList.add(userInfoReqDTO);
        }
        addMediationRoomUserReqDTO.setList((List)litigantList);
        return addMediationRoomUserReqDTO;
    }

    public static AddMediationMeetingRoomUserMicroReqDTO gerAddMediationMeetingRoomUserMicroReqDTO(AddMediationMeetingUserRequestMicroDTO webReqDto) {
        AddMediationMeetingRoomUserMicroReqDTO req = new AddMediationMeetingRoomUserMicroReqDTO();
        req.setCurrentUserId(JWTContextUtil.getCurrentUserId());
        req.setCreateUser(JWTContextUtil.getCurrentUserName());
        req.setMediationRoomId(webReqDto.getMediationRoomId());
        ArrayList litigantList = Lists.newArrayList();
        List list = webReqDto.getLitigantList();
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(userDto);
            if (userDto.getPersonId() != null) continue;
            litigantList.add(userInfoReqDTO);
        }
        req.setList((List)litigantList);
        return req;
    }

    public static MediationMeetingUserInfoReqDTO getMediationMeetingAgent(LitigantAgentInfoRequestDTO dto, String userTempId) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType().name());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setAgentUserTempId(userTempId);
        reqDTO.setAgentType(dto.getAgentType() == null ? "" : dto.getAgentType().name());
        reqDTO.setUserOrder(dto.getUserOrder());
        reqDTO.setRemark(dto.getUserTempId());
        return reqDTO;
    }

    public static CloseMediationRoomReqDTO getCloseMediationRoomReqDTO(CloseMediationMeetingRequestDTO closeMediationMeetingReqDTO) {
        CloseMediationRoomReqDTO closeMediationRoomReqDTO = new CloseMediationRoomReqDTO();
        closeMediationRoomReqDTO.setMediationRoomId(closeMediationMeetingReqDTO.getMediationRoomId());
        closeMediationRoomReqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        closeMediationRoomReqDTO.setUserName(JWTContextUtil.getCurrentUserName());
        return closeMediationRoomReqDTO;
    }

    public static CloseMediationRoomReqDTO getCloseMediationRoomReqDTOTwo(CloseMediationMeetingRequestDTO closeMediationMeetingReqDTO) {
        CloseMediationRoomReqDTO closeMediationRoomReqDTO = new CloseMediationRoomReqDTO();
        closeMediationRoomReqDTO.setMediationRoomId(closeMediationMeetingReqDTO.getMediationRoomId());
        closeMediationRoomReqDTO.setUserName("\u5b9a\u65f6\u4efb\u52a1");
        return closeMediationRoomReqDTO;
    }

    public static AddMediationRoomMeetingReqDTO getAddMediationRoomMeetingReqDTO(AddMediationRoomMeetingRequestDTO dto) {
        AddMediationRoomMeetingReqDTO addMediationRoomMeetingReqDTO = new AddMediationRoomMeetingReqDTO();
        addMediationRoomMeetingReqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        addMediationRoomMeetingReqDTO.setCreatorId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        addMediationRoomMeetingReqDTO.setMediationMeetingRoomName(dto.getMediationMeetingRoomName());
        addMediationRoomMeetingReqDTO.setMediationRoomId(dto.getMediationRoomId());
        addMediationRoomMeetingReqDTO.setUserIds(dto.getUserIds());
        return addMediationRoomMeetingReqDTO;
    }

    public static MediationMeetingRoomListReqDTO getMediationMeetingRoomListReqDTO(MediationMeetingListRequestDTO dto) {
        MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO = new MediationMeetingRoomListReqDTO();
        mediationMeetingRoomListReqDTO.setMediationStatus(dto.getMediationStatus());
        mediationMeetingRoomListReqDTO.setName(dto.getName());
        mediationMeetingRoomListReqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        return mediationMeetingRoomListReqDTO;
    }

    public static String handleData(String roleName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MeetingUserTypeEnum.MEDIATOR.name(), "\u5ba1");
        map.put(MeetingUserTypeEnum.ASSISTANT_JUDGE.name(), "\u52a9");
        map.put(MeetingUserTypeEnum.CLERK.name(), "\u4e66");
        map.put(MeetingUserTypeEnum.JUROR.name(), "\u966a");
        map.put(MeetingUserTypeEnum.APPLICANT.name(), "\u539f");
        map.put(MeetingUserTypeEnum.APPLICANT_AGENT.name(), "\u4ee3");
        map.put(MeetingUserTypeEnum.RESPONDENT.name(), "\u88ab");
        map.put(MeetingUserTypeEnum.RESPONDENT_AGENT.name(), "\u4ee3");
        map.put(MeetingUserTypeEnum.LITIGANT_THIRD.name(), "\u4e09");
        map.put(MeetingUserTypeEnum.LITIGANT_THIRD_AGENT.name(), "\u4ee3");
        map.put(MeetingUserTypeEnum.LITIGANT_WITNESS.name(), "\u8bc1");
        map.put(MeetingUserTypeEnum.LITIGANT_SURVEYOR.name(), "\u9274");
        map.put(MeetingUserTypeEnum.LITIGANT_TRANSLATOR.name(), "\u7ffb");
        map.put(MeetingUserTypeEnum.OTHER.name(), "\u4e34");
        return MapUtil.getStr(map, (Object)roleName);
    }

    public static MediationMeetingRoomUserInfoResDTO getMediationMeetingRoomUserExtInfo(MediationMeetingRoomUserInfoResDTO userInfoRes) {
        List list = userInfoRes.getList();
        log.info("list\uff1a{}", (Object)JSON.toJSONString((Object)list));
        if (list.size() > 0) {
            for (MediationRoomUserInfoResDTO res : list) {
                String meetingUserTypeDesc = MediationMeetingConvert.handleData(res.getMeetingUserType());
                System.out.println(meetingUserTypeDesc);
                log.info("meetingUserTypeDesc\uff1a{}", (Object)meetingUserTypeDesc);
                res.setMeetingUserTypeDesc(meetingUserTypeDesc);
            }
        }
        if (userInfoRes.getExpandAttribute() != null) {
            JSONObject json = JSONObject.parseObject((String)userInfoRes.getExpandAttribute());
            if (json.get((Object)ColumnEnums.LITIGATION_STATUS.desc()) != null) {
                userInfoRes.setLitigationStatus(json.getInteger(ColumnEnums.LITIGATION_STATUS.desc()));
            }
            if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null) {
                userInfoRes.setOriginalLitigationStatus(json.getInteger(ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()));
            }
            if (json.get((Object)ColumnEnums.LITIGANT_TYPE.desc()) != null) {
                userInfoRes.setLitigantType(json.getInteger(ColumnEnums.LITIGANT_TYPE.desc()));
            }
            if (json.get((Object)ColumnEnums.UNIT_NAME.desc()) != null) {
                userInfoRes.setUnitName(json.getString(ColumnEnums.UNIT_NAME.desc()));
            }
            if (json.get((Object)ColumnEnums.CREDIT_CODE.desc()) != null) {
                userInfoRes.setCreditCode(json.getString(ColumnEnums.CREDIT_CODE.desc()));
            }
            if (json.get((Object)ColumnEnums.IS_UNDERTAKER.desc()) != null) {
                userInfoRes.setIsUndertaker(json.getInteger(ColumnEnums.IS_UNDERTAKER.desc()));
            }
        }
        return userInfoRes;
    }

    public static AddMediationRoomMeetingUserReqDTO getAddMediationRoomMeetingUserReqDTO(AddMediationRoomMeetingUserRequstDTO dto) {
        AddMediationRoomMeetingUserReqDTO addMediationRoomMeetingUserReqDTO = new AddMediationRoomMeetingUserReqDTO();
        addMediationRoomMeetingUserReqDTO.setCreateUser(JWTContextUtil.getCurrentUserName());
        addMediationRoomMeetingUserReqDTO.setCreatorId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        addMediationRoomMeetingUserReqDTO.setMediationRoomId(dto.getMediationRoomId());
        addMediationRoomMeetingUserReqDTO.setMeetingId(dto.getMeetingId());
        ArrayList litigantList = Lists.newArrayList();
        List list = dto.getList();
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationMeetingConvert.getMediationMeetingUserInfoReqDTO(userDto);
            litigantList.add(userInfoReqDTO);
        }
        addMediationRoomMeetingUserReqDTO.setList((List)litigantList);
        return addMediationRoomMeetingUserReqDTO;
    }

    public static List<LitigantInfoRequestDTO> getLitigantInfoRequestDTOList(List<MediationMeetingUserInfoReqDTO> infoList) {
        List<LitigantInfoRequestDTO> litigantList = infoList.stream().map(litigantInfoRequestDTO -> {
            LitigantInfoRequestDTO mediationMeetingUserInfoReqDTO = new LitigantInfoRequestDTO();
            if (!litigantInfoRequestDTO.getMeetingUserType().equals(MeetingUserTypeEnum.MEDIATOR.toString())) {
                BeanUtils.copyProperties((Object)litigantInfoRequestDTO, (Object)mediationMeetingUserInfoReqDTO);
            }
            return mediationMeetingUserInfoReqDTO;
        }).collect(Collectors.toList());
        return litigantList;
    }

    public static APIResult getAllPersontListCountIgnorePhoneNoIs1111(List<LitigantInfoRequestDTO> litigantList, List<LitigantInfoRequestDTO> mediatorList, List<LitigantAgentInfoMicroRequestDTO> agentList) {
        String mobilePhone;
        String phoneNo1111 = "1111";
        HashSet<String> phoneSet = new HashSet<String>();
        ArrayList phoneList = Lists.newArrayList();
        if (litigantList != null) {
            for (LitigantInfoRequestDTO litigantInfoRequestDTO : litigantList) {
                mobilePhone = litigantInfoRequestDTO.getMobilePhone();
                if (MeetingUserTypeEnum.APPLICANT.equals((Object)litigantInfoRequestDTO.getMeetingUserType())) {
                    AssertUtils.assertTrue((!StringUtils.isEmpty((CharSequence)mobilePhone) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u539f\u544a\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isEmpty((CharSequence)mobilePhone) && phoneNo1111.equals(mobilePhone)) continue;
                phoneList.add(mobilePhone);
                phoneSet.add(mobilePhone);
            }
        }
        if (agentList != null) {
            for (LitigantAgentInfoMicroRequestDTO litigantAgentInfoMicroRequestDTO : agentList) {
                mobilePhone = litigantAgentInfoMicroRequestDTO.getMobilePhone();
                AssertUtils.assertTrue((!phoneNo1111.equals(mobilePhone) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)("\u4ee3\u7406\u4eba\u5458\u3010" + litigantAgentInfoMicroRequestDTO.getUserName() + "\u3011\u624b\u673a\u53f7\u9519\u8bef"));
                phoneList.add(mobilePhone);
                phoneSet.add(mobilePhone);
            }
        }
        if (mediatorList != null) {
            for (LitigantInfoRequestDTO litigantInfoRequestDTO : mediatorList) {
                mobilePhone = litigantInfoRequestDTO.getMobilePhone();
                AssertUtils.assertTrue((!phoneNo1111.equals(mobilePhone) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)("\u5de5\u4f5c\u4eba\u5458\u3010" + litigantInfoRequestDTO.getUserName() + "\u3011\u624b\u673a\u53f7\u9519\u8bef"));
                phoneList.add(mobilePhone);
                phoneSet.add(mobilePhone);
            }
        }
        return phoneSet.size() == phoneList.size() ? APIResult.success((Object)phoneSet.size()) : APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u53c2\u4e0e\u4eba\u5458\u624b\u673a\u53f7\u91cd\u590d");
    }

    public static APIResult getAllPersontListCountIgnorePhoneNoIs1111(List<VisitSystemUserReqDTO> list) {
        String phoneNo1111 = "1111";
        HashSet<String> phoneSet = new HashSet<String>();
        ArrayList phoneList = Lists.newArrayList();
        if (list != null && list.size() > 0) {
            for (VisitSystemUserReqDTO liti : list) {
                String mobilePhone = liti.getUserMobilePhone();
                AssertUtils.assertTrue((!StringUtils.isEmpty((CharSequence)mobilePhone) && !phoneNo1111.equals(mobilePhone) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                phoneList.add(mobilePhone);
                phoneSet.add(mobilePhone);
            }
        }
        return phoneSet.size() == phoneList.size() ? APIResult.success((Object)phoneSet.size()) : APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u53c2\u4e0e\u4eba\u5458\u624b\u673a\u53f7\u91cd\u590d");
    }

    public static String buildLitigantJsonInfo(LitigantInfoRequestDTO dto) {
        if (dto.getLitigantType() == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc(), (Object)dto.getOriginalLitigationStatus());
        json.put(ColumnEnums.LITIGANT_TYPE.desc(), (Object)dto.getLitigantType());
        if (dto.getLitigantType() != 1) {
            json.put(ColumnEnums.UNIT_NAME.desc(), (Object)dto.getUnitName());
            json.put(ColumnEnums.CREDIT_CODE.desc(), (Object)dto.getCreditCode());
        }
        return json.toJSONString();
    }

    public static String buildMediatorJsonInfo(LitigantInfoRequestDTO dto) {
        if (dto.getIsUndertaker() == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(ColumnEnums.IS_UNDERTAKER.desc(), (Object)dto.getIsUndertaker());
        return json.toJSONString();
    }

    public static List<LitigantAgentInfoMicroRequestDTO> getAgentList(AddMediationMeetingUserRequestMicroDTO webReqDto) {
        ArrayList<LitigantAgentInfoMicroRequestDTO> agentList = new ArrayList<LitigantAgentInfoMicroRequestDTO>();
        List list = webReqDto.getLitigantList();
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            if (userDto.getUserAgentList() == null || userDto.getUserAgentList().size() <= 0) continue;
            List agentUserList = userDto.getUserAgentList();
            for (int j = 0; j < agentUserList.size(); ++j) {
                LitigantAgentInfoMicroRequestDTO agent = MediationMeetingConvert.getLitigantAgentInfo((LitigantAgentInfoRequestDTO)agentUserList.get(j), userDto.getUserTempId());
                agentList.add(agent);
            }
        }
        return agentList;
    }

    public static LitigantAgentInfoMicroRequestDTO getLitigantAgentInfo(LitigantAgentInfoRequestDTO dto, String userTempId) {
        LitigantAgentInfoMicroRequestDTO reqDTO = new LitigantAgentInfoMicroRequestDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setUserTempId(dto.getUserTempId());
        reqDTO.setAgentType(dto.getAgentType());
        reqDTO.setUserOrder(dto.getUserOrder());
        reqDTO.setAgentParentUserTempIdList(userTempId);
        return reqDTO;
    }

    private static MediationMeetingUserInfoReqDTO createAgentReqObjectNew(LitigantAgentInfoMicroRequestDTO dto) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType().name());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setAgentUserTempId(dto.getAgentParentUserTempIdList());
        reqDTO.setAgentType(dto.getAgentType() == null ? "" : dto.getAgentType().name());
        reqDTO.setUserOrder(dto.getUserOrder());
        reqDTO.setRemark(dto.getUserTempId());
        return reqDTO;
    }

    public static AddMediationMeetingRoomUserMicroReqDTO intranetAddMediationMeetingUserReqDTO(AddMediationMeetingUserRequestMicroDTO reqDto) {
        AddMediationMeetingRoomUserMicroReqDTO req = new AddMediationMeetingRoomUserMicroReqDTO();
        req.setMediationRoomId(reqDto.getMediationRoomId());
        req.setCurrentUserId("0");
        ArrayList litigantList = Lists.newArrayList();
        List list = reqDto.getLitigantList();
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = MediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(userDto);
            if (userDto.getPersonId() != null) continue;
            litigantList.add(userInfoReqDTO);
        }
        req.setList((List)litigantList);
        return req;
    }

    public static List<MediationMeetingUserInfoReqDTO> getUserList(List<MediationMeetingUserInfoReqDTO> litigantList, List<MediationMeetingUserInfoReqDTO> agentList) {
        ArrayList<MediationMeetingUserInfoReqDTO> allUserList = new ArrayList<MediationMeetingUserInfoReqDTO>();
        if (!CollectionUtils.isEmpty(litigantList)) {
            allUserList.addAll(litigantList);
        }
        if (!CollectionUtils.isEmpty(agentList)) {
            allUserList.addAll(agentList);
        }
        return allUserList;
    }

    public static void checkMeetingUserNum(int meetingUserNum) {
        String appName = AppNameContextHolder.getAppName();
        int maxUserNum = 0;
        maxUserNum = "weitingshenhubei".equals(appName) || "weitingshenhubeizz".equals(appName) || "weitingshensx".equals(appName) ? 10 : 8;
        AssertUtils.assertFalse((meetingUserNum > maxUserNum ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6dfb\u52a0\u53c2\u4f1a\u4eba\u5458\u8d85\u8fc7\u4e0a\u9650");
    }

    public static InvitationVideoSendTextRequestDTO getInvitationVideoSendText(Long mediationMeetingId, AddMediationRoomMeetingResponseDTO dto, MediationMeetingRoomInfoResDTO mediation, AddMediationMeetingRoomMicroReqDTO reqDTO) {
        JSONObject personJson;
        InvitationVideoSendTextRequestDTO tnvitationVideoSendText = new InvitationVideoSendTextRequestDTO();
        tnvitationVideoSendText.setBizRoomId(mediationMeetingId.toString());
        JSONObject json = new JSONObject();
        json.put("roomId", (Object)dto.getRoomId());
        json.put("meetingId", (Object)dto.getMediationRoomId());
        json.put("bizRoomId", (Object)mediationMeetingId.toString());
        ArrayList<JSONObject> personJsonList = new ArrayList<JSONObject>();
        List litigantList = reqDTO.getLitigantList();
        List agentList = reqDTO.getAgentList();
        for (MediationMeetingUserInfoReqDTO litigant : litigantList) {
            personJson = new JSONObject();
            personJson.put("userName", (Object)litigant.getUserName());
            personJson.put("userId", (Object)litigant.getUserId());
            personJsonList.add(personJson);
        }
        for (MediationMeetingUserInfoReqDTO agent : agentList) {
            personJson = new JSONObject();
            personJson.put("userName", (Object)agent.getUserName());
            personJson.put("userId", (Object)agent.getUserId());
            personJsonList.add(personJson);
        }
        json.put("person", personJsonList);
        JSONObject mediatorJson = new JSONObject();
        MediationMeetingUserInfoReqDTO userMediator = (MediationMeetingUserInfoReqDTO)reqDTO.getMediatorList().get(0);
        mediatorJson.put("userName", (Object)userMediator.getUserName());
        mediatorJson.put("userId", (Object)userMediator.getUserId());
        json.put("mediator", (Object)mediatorJson);
        tnvitationVideoSendText.setContent(json.toJSONString());
        tnvitationVideoSendText.setMemberId(JWTContextUtil.getCurrentUserId());
        tnvitationVideoSendText.setReceiverId(null);
        tnvitationVideoSendText.setRoomId(Arrays.asList(mediation.getRoomId().split(",")).get(0));
        return tnvitationVideoSendText;
    }

    public static InvitationVideoSendTextRequestDTO getInvitationVideoSendTextByTdh(Long mediationMeetingId, AddMediationRoomMeetingResponseDTO dto, MediationMeetingRoomInfoResDTO mediation, AddMediationMeetingRoomMicroReqDTO reqDTO, Long uId) {
        JSONObject personJson;
        InvitationVideoSendTextRequestDTO tnvitationVideoSendText = new InvitationVideoSendTextRequestDTO();
        tnvitationVideoSendText.setBizRoomId(mediationMeetingId.toString());
        JSONObject json = new JSONObject();
        json.put("roomId", (Object)dto.getRoomId());
        json.put("meetingId", (Object)dto.getMediationRoomId());
        json.put("bizRoomId", (Object)mediationMeetingId.toString());
        ArrayList<JSONObject> personJsonList = new ArrayList<JSONObject>();
        List litigantList = reqDTO.getLitigantList();
        List agentList = reqDTO.getAgentList();
        for (MediationMeetingUserInfoReqDTO litigant : litigantList) {
            personJson = new JSONObject();
            personJson.put("userName", (Object)litigant.getUserName());
            personJson.put("userId", (Object)litigant.getUserId());
            personJsonList.add(personJson);
        }
        for (MediationMeetingUserInfoReqDTO agent : agentList) {
            personJson = new JSONObject();
            personJson.put("userName", (Object)agent.getUserName());
            personJson.put("userId", (Object)agent.getUserId());
            personJsonList.add(personJson);
        }
        json.put("person", personJsonList);
        JSONObject mediatorJson = new JSONObject();
        MediationMeetingUserInfoReqDTO userMediator = (MediationMeetingUserInfoReqDTO)reqDTO.getMediatorList().get(0);
        mediatorJson.put("userName", (Object)userMediator.getUserName());
        mediatorJson.put("userId", (Object)userMediator.getUserId());
        json.put("mediator", (Object)mediatorJson);
        tnvitationVideoSendText.setContent(json.toJSONString());
        tnvitationVideoSendText.setMemberId(String.valueOf(uId));
        tnvitationVideoSendText.setReceiverId(null);
        tnvitationVideoSendText.setRoomId(Arrays.asList(mediation.getRoomId().split(",")).get(0));
        return tnvitationVideoSendText;
    }
}

