/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.domain.dto.requestdto.MyMediationRoomPageListRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyMediationRoomPageListResponseDTO;
import com.beiming.odr.peace.im.api.UnreadMessageApi;
import com.beiming.odr.peace.im.api.dto.response.SubjectUnreadCountResponseDTO;
import com.beiming.odr.peace.service.PersonalServiceDemo;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.api.StatisticsApi;
import com.beiming.odr.referee.dto.requestdto.CaseListRoomReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingRoomListReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.LastMeetingByParentIdResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MediationMeetingRoomStatusEnum;
import com.beiming.odr.referee.enums.MediationMeetingTypeEnum;
import com.beiming.odr.referee.enums.RoomStatusEnums;
import com.beiming.odr.trial.api.TrialApi;
import com.beiming.odr.trial.api.dto.response.CaseInfoResponseDTO;
import com.beiming.odr.trial.api.dto.response.CaseOrderResponseDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PersonalServiceDemoImpl
implements PersonalServiceDemo {
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private UnreadMessageApi unreadMessageApi;
    @Resource
    private StatisticsApi statisticsApi;
    @Resource
    private TrialApi infoApi;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    private static final String MEMBER_ROLE_TYPE_MASTER = "MASTER";
    private static final String MEMBER_ROLE_TYPE_NORMAL = "NORMAL";

    @Override
    public List<MyMediationRoomPageListResponseDTO> getMyMediationRoomPageList(MyMediationRoomPageListRequestDTO listRequestDTO, String userId, String roleType) {
        ArrayList<MyMediationRoomPageListResponseDTO> responseDTOs = new ArrayList<MyMediationRoomPageListResponseDTO>();
        CaseListRoomReqDTO reqDTO = new CaseListRoomReqDTO();
        reqDTO.setMemberId(userId);
        reqDTO.setMemberName(listRequestDTO.getMemberName());
        reqDTO.setCreatorType(listRequestDTO.getCreatorType());
        reqDTO.setBusinessRoomType(MediationMeetingTypeEnum.MEDIATION_ROOM.name());
        if (listRequestDTO.getRoomStatus().equals(RoomStatusEnums.RUNNING.name())) {
            reqDTO.setRoomStatus(MediationMeetingRoomStatusEnum.START.name());
        } else if (listRequestDTO.getRoomStatus().equals(RoomStatusEnums.END.name())) {
            reqDTO.setRoomStatus(MediationMeetingRoomStatusEnum.CLOSE.name());
        } else {
            reqDTO.setRoomStatus(listRequestDTO.getRoomStatus());
        }
        DubboResult result = this.mediationMeetingRoomApi.listRoom(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)result.getMessage());
        List roomInfos = result.getData() == null ? new ArrayList() : (List)((Object)result.getData());
        MediationMeetingRoomListReqDTO mediationMeetingRoomListReqDTO = new MediationMeetingRoomListReqDTO();
        mediationMeetingRoomListReqDTO.setMediationStatus("RUNNING");
        mediationMeetingRoomListReqDTO.setUserId(Long.valueOf(userId));
        HashMap roomUserInfoResDTOMap = new HashMap();
        DubboResult roomResult = this.mediationMeetingRoomApi.getMediationMeetingRoomList(mediationMeetingRoomListReqDTO);
        AssertUtils.assertTrue((boolean)roomResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)roomResult.getMessage());
        for (MediationMeetingRoomUserInfoResDTO roomUserInfoResDTO : (ArrayList)roomResult.getData()) {
            ArrayList list = (ArrayList)roomUserInfoResDTOMap.get(roomUserInfoResDTO.getParentId());
            if (list != null) {
                list.add(roomUserInfoResDTO);
                continue;
            }
            ArrayList<MediationMeetingRoomUserInfoResDTO> list1 = new ArrayList<MediationMeetingRoomUserInfoResDTO>();
            list1.add(roomUserInfoResDTO);
            roomUserInfoResDTOMap.put(roomUserInfoResDTO.getParentId(), list1);
        }
        for (CaseRoomInfoResDTO roomInfo : roomInfos) {
            ArrayList list;
            DubboResult caseInfo;
            MyMediationRoomPageListResponseDTO response = new MyMediationRoomPageListResponseDTO(roomInfo);
            if ("TDH_CASE".equals(roomInfo.getCreatorType())) {
                response.setCreatorType("\u5185\u7f51\u6848\u4ef6");
            } else if ("SYS_PLATFORM".equals(roomInfo.getCreatorType())) {
                response.setCreatorType("\u5e73\u53f0\u65b0\u5efa");
            }
            if (!StringUtils.isBlank((String)roomInfo.getThirdCaseId()) && (caseInfo = this.infoApi.selectCaseInfoByCaseId(roomInfo.getThirdCaseId())).getData() != null && !CollectionUtils.isEmpty((Collection)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder())) {
                CaseOrderResponseDTO caseOrder = (CaseOrderResponseDTO)((CaseInfoResponseDTO)caseInfo.getData()).getCaseOrder().get(0);
                response.setHoldCourt(caseOrder.getDd());
            }
            if (!"END".equals(roomInfo.getRoomStatus())) {
                this.buildCaseRoomInfoResDTO(roomInfo.getBizRoomId(), response);
            }
            if ((list = (ArrayList)roomUserInfoResDTOMap.get(Long.valueOf(roomInfo.getBizRoomId()))) != null) {
                response.setCanItEnd((Object)false);
                MediationMeetingRoomUserInfoResDTO mediationMeetingRoomUserInfoRes = (MediationMeetingRoomUserInfoResDTO)list.get(0);
                response.setStartTime(mediationMeetingRoomUserInfoRes.getStartTime());
                response.setEndTime(mediationMeetingRoomUserInfoRes.getEndTime());
            } else {
                response.setCanItEnd((Object)true);
            }
            if (roomInfo.getCreatorId() != null && roomInfo.getCreatorId().toString().equals(userId)) {
                if (list != null) {
                    response.setIsMine((Object)false);
                } else {
                    response.setIsMine((Object)true);
                }
            } else {
                response.setIsMine((Object)false);
            }
            responseDTOs.add(response);
        }
        DubboResult unreadCountResult = this.unreadMessageApi.getUnreadCountByUserId(userId);
        AssertUtils.assertTrue((boolean)unreadCountResult.isSuccess(), (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)unreadCountResult.getMessage());
        ArrayList unreadCounts = (ArrayList)unreadCountResult.getData();
        for (MyMediationRoomPageListResponseDTO response : responseDTOs) {
            for (SubjectUnreadCountResponseDTO unreadCount : unreadCounts) {
                if (!response.getBizRoomId().equals(unreadCount.getSubjectId())) continue;
                response.setUnreadMessageCount(Integer.valueOf(unreadCount.getUnreadCount()));
            }
            if (response.getUnreadMessageCount() != null) continue;
            response.setUnreadMessageCount(Integer.valueOf(0));
        }
        return responseDTOs;
    }

    public void buildCaseRoomInfoResDTO(String bizRoomId, MyMediationRoomPageListResponseDTO responseDTO) {
        if (bizRoomId == null) {
            return;
        }
        DubboResult dubboResult = this.caseRoomMicroApi.getLastMeetingByParentId(Long.valueOf(bizRoomId));
        if (dubboResult == null || dubboResult.getData() == null) {
            return;
        }
        SimpleDateFormat startFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        LastMeetingByParentIdResDTO lastMeetingByParentIdResDTO = (LastMeetingByParentIdResDTO)dubboResult.getData();
        responseDTO.setHoldCourtNum(lastMeetingByParentIdResDTO.getScheduleId());
        String orderTime = "";
        if (lastMeetingByParentIdResDTO.getOrderTime() != null) {
            orderTime = startFormat.format(lastMeetingByParentIdResDTO.getOrderTime());
        }
        responseDTO.setHoldCourtTime(orderTime);
    }
}

