/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.DocUndisputedFactApi;
import com.beiming.odr.document.dto.requestdto.DocPersonReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveUndisputedFactReqDTO;
import com.beiming.odr.document.dto.responsedto.UndisputedFactResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.peace.service.backend.document.DocUndisputedFactDubboService;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.convert.DocumentConvert;
import com.beiming.odr.referee.dto.responsedto.MediationRoomPersonResDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DocUndisputedFactDubboServiceImpl
implements DocUndisputedFactDubboService {
    @Resource
    private DocUndisputedFactApi docUndisputedFactApi;
    @Resource
    private MediationRoomDubboService mediationRoomDubboService;

    @Override
    public ProtocolBookResponseDTO getUndisputedFactByMediator(Long objId) {
        DubboResult result = this.docUndisputedFactApi.getUndisputedFactByMediator(objId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        UndisputedFactResDTO resDTO = (UndisputedFactResDTO)result.getData();
        ProtocolBookResponseDTO undisputedFact = DocumentConvert.convertUndisputedFactResDTO(resDTO);
        return undisputedFact;
    }

    @Override
    public ProtocolBookResponseDTO getUndisputedFactByUser(Long objId) {
        DubboResult result = this.docUndisputedFactApi.getUndisputedFactByUser(objId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        UndisputedFactResDTO resDTO = (UndisputedFactResDTO)result.getData();
        ProtocolBookResponseDTO undisputedFact = DocumentConvert.convertUndisputedFactResDTO(resDTO);
        return undisputedFact;
    }

    @Override
    public Long saveUndisputedFact(SaveProtocolBookRequestDTO dto) {
        SaveUndisputedFactReqDTO reqDTO = DocumentConvert.convertSaveUndisputedFactReqDTO(dto);
        MediationRoomPersonResDTO mediator = this.mediationRoomDubboService.getMediationRoomMediator(dto.getMediationRoomId());
        DocPersonReqDTO proPerson = DocumentConvert.getDocPersonReqDTO(mediator);
        reqDTO.getUndisputedFactPersonList().add(proPerson);
        DubboResult result = this.docUndisputedFactApi.saveUndisputedFact(reqDTO);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Long)result.getData();
    }
}

