/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.OfflineApi;
import com.beiming.odr.document.api.RefuseApi;
import com.beiming.odr.document.dto.requestdto.UserInfoReqDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.OfflineDocumentRequestDTO;
import com.beiming.odr.peace.service.backend.document.RefuseDubboService;
import com.beiming.odr.peace.service.backend.user.UserDubboService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RefuseDubboServiceImpl
implements RefuseDubboService {
    @Resource
    private RefuseApi refuseApi;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private OfflineApi offlineApi;

    @Override
    public void refuseDocument(Long docId) {
        UserInfoReqDTO userInfo = new UserInfoReqDTO();
        userInfo.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        userInfo.setUserName(this.userDubboService.getUserNameByJWT());
        DubboResult result = this.refuseApi.refuseDocument(docId, userInfo);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.UNEXCEPTED, (String)ErrorCode.UNEXCEPTED.desc());
    }

    @Override
    public void offlineDocument(OfflineDocumentRequestDTO dto) {
        UserInfoReqDTO userInfo = new UserInfoReqDTO();
        userInfo.setUserId(dto.getUserId());
        userInfo.setUserName(dto.getUserName());
        DubboResult result = this.offlineApi.offlineDocument(dto.getId(), userInfo);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.CLERK_SIGNATURE_FAIL, (String)result.getMessage());
    }
}

