/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.SignatureApi;
import com.beiming.odr.document.dto.requestdto.SignatureInfoReqDTO;
import com.beiming.odr.document.dto.responsedto.DocWholeConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.SignatureInfoResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.SuspectReportRequestDTO;
import com.beiming.odr.peace.service.backend.document.SignatureDubboService;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignatureDubboServiceImpl
implements SignatureDubboService {
    private static final Logger log = LoggerFactory.getLogger(SignatureDubboServiceImpl.class);
    @Resource
    private SignatureApi signatureApi;
    @Resource
    private ClerkRecordService clerkRecordService;

    @Override
    public SignatureInfoResDTO confirmSignature(SignatureInfoReqDTO reqDTO) {
        DubboResult dubboRes = this.signatureApi.confirmSignature(reqDTO);
        SignatureInfoResDTO resDTO = (SignatureInfoResDTO)dubboRes.getData();
        log.info("confirmSignature \u65b9\u6cd5\u8fd4\u56de\u7684\u503c\u4e3a{}, message\u503c\u4e3a{}", (Object)resDTO, (Object)dubboRes.getMessage());
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        log.info("confirmSignature \u65b9\u6cd5\u65ad\u8a00\u540e\u8fd4\u56de\u7684\u503c\u662f{}, message\u503c\u4e3a{}", (Object)resDTO, (Object)dubboRes.getMessage());
        return resDTO;
    }

    @Override
    public SignatureInfoResDTO signElectronicDoc(SignatureInfoReqDTO reqDTO) {
        DubboResult dubboRes = this.signatureApi.signElectronicDoc(reqDTO);
        SignatureInfoResDTO resDTO = (SignatureInfoResDTO)dubboRes.getData();
        SuspectReportRequestDTO requestDTO = new SuspectReportRequestDTO();
        requestDTO.setMeetId(resDTO.getMeetingId());
        requestDTO.setBizId(resDTO.getMeetingId());
        this.clerkRecordService.createElectronicReport(requestDTO);
        log.info("confirmSignature \u65b9\u6cd5\u8fd4\u56de\u7684\u503c\u4e3a{}, message\u503c\u4e3a{}", (Object)resDTO, (Object)dubboRes.getMessage());
        AssertUtils.assertTrue((boolean)dubboRes.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        log.info("confirmSignature \u65b9\u6cd5\u65ad\u8a00\u540e\u8fd4\u56de\u7684\u503c\u662f{}, message\u503c\u4e3a{}", (Object)resDTO, (Object)dubboRes.getMessage());
        return resDTO;
    }

    @Override
    public List<DocWholeConfirmResDTO> queryBilu(Long meetId, Long userId, Long docId) {
        DubboResult dubboRes = this.signatureApi.queryBilu(meetId, userId, docId);
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        return (List)((Object)dubboRes.getData());
    }

    @Override
    public SignatureInfoResDTO confirmSignatures(SignatureInfoReqDTO reqDTOs) {
        DubboResult dubboRes = this.signatureApi.confirmSignatures(reqDTOs);
        SignatureInfoResDTO resDTO = (SignatureInfoResDTO)dubboRes.getData();
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        return resDTO;
    }

    @Override
    public void updateConfirm(DocWholeConfirmResDTO ss) {
        DubboResult dubboResult = this.signatureApi.updateConfirm(ss);
    }

    @Override
    public DocWholeConfirmResDTO queryR(DocWholeConfirmResDTO ss) {
        DubboResult dubboResult = this.signatureApi.queryR(ss);
        DocWholeConfirmResDTO resDTO = (DocWholeConfirmResDTO)dubboResult.getData();
        AssertUtils.assertTrue((dubboResult != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        return resDTO;
    }

    @Override
    public DocWholeConfirmResDTO queryState(Long docId) {
        DubboResult dubboResult = this.signatureApi.queryState(docId);
        DocWholeConfirmResDTO resDTO = (DocWholeConfirmResDTO)dubboResult.getData();
        AssertUtils.assertTrue((dubboResult != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        return resDTO;
    }
}

