/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.referee.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.DocDossierApi;
import com.beiming.odr.document.dto.requestdto.DeliveryRequestDTO;
import com.beiming.odr.document.dto.responsedto.ElectronicConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.ElectronicDeliveryResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.responsedto.ElectronicDeliveryGetResponseDTO;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomPersonResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MediationRoomDubboServiceImpl
implements MediationRoomDubboService {
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private ClerkRecordService clerkRecordService;
    @Resource
    private DocDossierApi docDossierApi;

    @Override
    public Boolean checkIsMediator(Long id) {
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        DubboResult result = this.mediationRoomApi.checkIsMediator(id, userId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Boolean)result.getData();
    }

    @Override
    public Boolean checkIsWorker(Long id) {
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        DubboResult result = this.mediationRoomApi.checkIsWorker(id, userId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Boolean)result.getData();
    }

    @Override
    public ArrayList<MediationRoomUserInfoResDTO> getMediationRoomUserInfoList(Long mediationRoomId) {
        ArrayList result = null;
        DubboResult dubboResult = this.mediationRoomApi.getMediationRoomUserInfoList(mediationRoomId);
        if (dubboResult.isSuccess()) {
            result = (ArrayList)dubboResult.getData();
        }
        AssertUtils.assertNotNull((Object)result, (ResultCode)DubboResultCodeEnums.SOURCE_NOT_FOUND, (String)"\u8c03\u89e3\u5ba4\u7528\u6237\u672a\u627e\u5230");
        return result;
    }

    @Override
    public MediationRoomPersonResDTO getMediationRoomMediator(Long mediationRoomId) {
        MediationRoomPersonResDTO result = null;
        DubboResult dubboResult = this.mediationRoomApi.getMediationRoomMediator(mediationRoomId);
        if (dubboResult.isSuccess()) {
            result = (MediationRoomPersonResDTO)dubboResult.getData();
        }
        AssertUtils.assertNotNull((Object)result, (ResultCode)DubboResultCodeEnums.SOURCE_NOT_FOUND, (String)"\u8c03\u89e3\u5ba4\u7528\u6237\u672a\u627e\u5230");
        return result;
    }

    @Override
    public MediationMeetingRoomInfoResDTO getMediationMeetingRoomInfo(Long mediationRoomId) {
        CommonIdReqDTO dto = new CommonIdReqDTO();
        dto.setId(mediationRoomId);
        MediationMeetingRoomInfoResDTO result = null;
        DubboResult dubboResult = this.mediationRoomApi.getMediationMeetingRoomInfo(dto);
        if (dubboResult.isSuccess()) {
            result = (MediationMeetingRoomInfoResDTO)dubboResult.getData();
        }
        AssertUtils.assertTrue((result != null && dubboResult.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        return result;
    }

    @Override
    public ArrayList<ElectronicDeliveryGetResponseDTO> signatureStatus(DeliveryRequestDTO dto) {
        ArrayList res = this.docDossierApi.signatureStatus(dto);
        ArrayList<ElectronicDeliveryGetResponseDTO> result = new ArrayList<ElectronicDeliveryGetResponseDTO>();
        for (ElectronicDeliveryResDTO re : res) {
            if (re.getStatus() != 0) continue;
            ElectronicDeliveryGetResponseDTO temp = new ElectronicDeliveryGetResponseDTO();
            temp.setMeetingId(re.getMeetingId());
            temp.setUserName(re.getUserName());
            temp.setUserType(MediationRoomDubboServiceImpl.getUserIdentity(re.getConfirmUserType()));
            temp.setUserId(re.getUserId());
            temp.setConfirm(re.getConfirm());
            result.add(temp);
        }
        return result;
    }

    @Override
    public ElectronicDeliveryResDTO electronicDocInfo(DeliveryRequestDTO dto) {
        DubboResult result = this.docDossierApi.electronicDocInfo(dto);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.UNEXCEPTED, (String)result.getMessage());
        ElectronicDeliveryResDTO resDTO = (ElectronicDeliveryResDTO)result.getData();
        this.clerkRecordService.electronicLaunchSign(resDTO);
        return resDTO;
    }

    @Override
    public ElectronicConfirmResDTO confirmDocInfo(ElectronicDeliveryResDTO dto) {
        DubboResult result = this.docDossierApi.confirmDocInfo(dto);
        return (ElectronicConfirmResDTO)result.getData();
    }

    @Override
    public Map<String, Object> signatureConfirmInfo(ElectronicDeliveryResDTO dto) {
        return this.docDossierApi.signatureConfirmInfo(dto);
    }

    public static String getUserIdentity(String value) {
        switch (value) {
            case "CLERK": {
                return "\u4e66\u8bb0\u5458";
            }
            case "JUROR": {
                return "\u966a\u5ba1\u5458";
            }
            case "MEDIATOR": {
                return "\u5ba1\u5224\u5458";
            }
            case "MEDIATOR_HELP_TEMPORARY": {
                return "\u534f\u52a9\u6cd5\u5b98";
            }
            case "MEDIATOR_HELP": {
                return "\u534f\u52a9\u6cd5\u5b98";
            }
            case "ASSISTANT_JUDGE": {
                return "\u6cd5\u5b98\u52a9\u7406";
            }
            case "APPLICANT": {
                return "\u539f\u544a";
            }
            case "RESPONDENT": {
                return "\u88ab\u544a";
            }
            case "LITIGANT_THIRD": {
                return "\u7b2c\u4e09\u4eba";
            }
            case "APPLICANT_AGENT": {
                return "\u539f\u544a\u4ee3\u7406\u4eba";
            }
            case "RESPONDENT_AGENT": {
                return "\u88ab\u544a\u4ee3\u7406\u4eba";
            }
            case "PETITION_AGENT": {
                return "\u4fe1\u8bbf\u4ee3\u7406\u4eba";
            }
            case "LITIGANT": {
                return "\u5f53\u4e8b\u4eba";
            }
            case "LITIGANT_WITNESS": {
                return "\u8bc1\u4eba";
            }
            case "SECOND_APPLICANT": {
                return "\u4e0a\u8bc9\u4eba";
            }
            case "SECOND_RESPONDENT": {
                return "\u88ab\u4e0a\u8bc9\u4eba";
            }
            case "LITIGANT_SURVEYOR": {
                return "\u9274\u5b9a\u4eba";
            }
            case "LITIGANT_TRANSLATOR": {
                return "\u7ffb\u8bd1\u5458";
            }
            case "LITIGANT_THIRD_AGENT": {
                return "\u7b2c\u4e09\u4eba\u4ee3\u7406\u4eba";
            }
            case "OTHER": {
                return "\u4e34\u65f6\u5165\u4f1a\u4eba\u5458";
            }
        }
        return "";
    }
}

