/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.user.impl;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.CTypeEnums;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.LoginMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.service.backend.user.VerificationCodeService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomInfoResDTO;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class VerificationCodeServiceImpl
implements VerificationCodeService {
    private static final Logger log = LoggerFactory.getLogger(VerificationCodeServiceImpl.class);
    @Resource
    private RedisService redisService;
    @Resource
    private MediationRoomApi mediationRoomApi;
    private RedisTemplate redisTemplate;

    @Override
    public LoginMediationRoomInfoDTO getMediationRoomInfoByCode(String verCode, String cType) {
        String appName;
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        RedisMediationRoomInfoDTO dto = (RedisMediationRoomInfoDTO)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verCode));
        if (CTypeEnums.PC.name().equalsIgnoreCase(cType)) {
            AssertUtils.assertNotNull((Object)dto, (ResultCode)ErrorCode.ERROR_CODE, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        } else {
            AssertUtils.assertNotNull((Object)dto, (ResultCode)ErrorCode.ERROR_CODE, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u8fc7\u671f\uff0c\u8bf7\u7528\u5fae\u4fe1\u53f7\u767b\u5f55");
        }
        CommonIdReqDTO reqDto = new CommonIdReqDTO();
        reqDto.setId(dto.getMediationRoomId());
        DubboResult result = this.mediationRoomApi.getMediationMeetingRoomInfo(reqDto);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)result.getMessage());
        AssertUtils.assertNotNull((Object)result.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)("\u4f1a\u8bae\u4e0d\u5b58\u5728\uff0c\u4f1a\u8baeid=" + dto.getMediationRoomId()));
        DubboResult leadTimeResult = this.mediationRoomApi.getMediationMeetingRoomMoreInfo(reqDto);
        log.info("-----------------leadTimeResult:--------------{}", (Object)leadTimeResult.getData());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)result.getMessage());
        String leadTime = (String)((Object)leadTimeResult.getData());
        if (StringUtils.isNotBlank((CharSequence)leadTime)) {
            AssertUtils.assertTrue((new Date().getTime() >= ((MediationMeetingRoomInfoResDTO)result.getData()).getOrderTime().getTime() - (long)(60000 * Integer.valueOf(leadTime)) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u524d\u5728\u7ebf\u5ead\u5ba1\u672a\u5f00\u59cb\uff0c\u65e0\u6cd5\u8fdb\u5165");
        } else if (appName.contains("weitingshenhubei") || appName.contains("weitingshenhainan")) {
            AssertUtils.assertTrue((new Date().getTime() >= ((MediationMeetingRoomInfoResDTO)result.getData()).getOrderTime().getTime() - 1800000L ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u524d\u5728\u7ebf\u5ead\u5ba1\u672a\u5f00\u59cb\uff0c\u65e0\u6cd5\u8fdb\u5165");
        } else {
            AssertUtils.assertTrue((new Date().getTime() >= ((MediationMeetingRoomInfoResDTO)result.getData()).getOrderTime().getTime() - 600000L ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u5f53\u524d\u5728\u7ebf\u5ead\u5ba1\u672a\u5f00\u59cb\uff0c\u65e0\u6cd5\u8fdb\u5165");
        }
        LoginMediationRoomInfoDTO loginMediationRoomInfoDTO = new LoginMediationRoomInfoDTO();
        MediationMeetingRoomInfoResDTO meetingRoomInfoRes = (MediationMeetingRoomInfoResDTO)result.getData();
        loginMediationRoomInfoDTO.setRedisMediationRoomInfo(dto);
        loginMediationRoomInfoDTO.setName(meetingRoomInfoRes.getName());
        String status = meetingRoomInfoRes.getMediationStatus();
        if ("START".equals(status)) {
            loginMediationRoomInfoDTO.setMediationStatus("RUNNING");
        } else if ("CLOSE".equals(status)) {
            loginMediationRoomInfoDTO.setMediationStatus("END");
        } else {
            loginMediationRoomInfoDTO.setMediationStatus(status);
        }
        loginMediationRoomInfoDTO.setParentId(meetingRoomInfoRes.getParentId());
        return loginMediationRoomInfoDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getIsExitPhoneAndCode(String phone, String code, String appName) {
        appName = AppNameContextHolder.getAppName().toUpperCase();
        this.redisTemplate = this.redisService.getRedisTemplate();
        Boolean result = this.redisService.getRedisTemplate().hasKey((Object)("VERIFICATION_CODE_LOGIN_" + phone + "_" + code));
        log.info("VERIFICATION_CODE_LOGIN_" + phone + "_" + code + "-------------is exit -------------------" + result);
        if (!result.booleanValue()) {
            Object count1;
            String key = appName + "_peace_VERIFICATION_CODE_LOGIN_COUNT_" + phone;
            Boolean result1 = this.redisService.getRedisTemplate().hasKey((Object)key);
            if (!result1.booleanValue()) {
                this.redisService.set((RedisKey)RedisKeyEnums.VERIFICATION_CODE_LOGIN_COUNT, phone, (Object)0, 1L, TimeUnit.MINUTES);
            } else {
                count1 = (Integer)this.redisService.get((RedisKey)RedisKeyEnums.VERIFICATION_CODE_LOGIN_COUNT, phone);
                log.info("-----------------count1------------------------" + count1);
                if ((Integer)count1 >= 5) {
                    AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE_LIMIT, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf71\u5206\u949f\u540e\u91cd\u8bd5");
                }
            }
            count1 = this;
            synchronized (count1) {
                Integer value = (Integer)this.redisService.get((RedisKey)RedisKeyEnums.VERIFICATION_CODE_LOGIN_COUNT, phone);
                this.redisService.set((RedisKey)RedisKeyEnums.VERIFICATION_CODE_LOGIN_COUNT, phone, (Object)(value + 1), 1L, TimeUnit.MINUTES);
                Integer count = (Integer)this.redisService.get((RedisKey)RedisKeyEnums.VERIFICATION_CODE_LOGIN_COUNT, phone);
                log.info("-----------------count------------------------" + count);
                if (count >= 5) {
                    AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE_LIMIT, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf71\u5206\u949f\u540e\u91cd\u8bd5");
                } else {
                    AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
                }
            }
        } else {
            Integer count1;
            String key = appName + "_peace_VERIFICATION_CODE_LOGIN_COUNT_" + phone;
            Boolean result1 = this.redisService.getRedisTemplate().hasKey((Object)key);
            if (result1.booleanValue() && (count1 = (Integer)this.redisService.get((RedisKey)RedisKeyEnums.VERIFICATION_CODE_LOGIN_COUNT, phone)) >= 5) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE_LIMIT, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf71\u5206\u949f\u540e\u91cd\u8bd5");
            }
            this.redisService.delete((RedisKey)RedisKeyEnums.VERIFICATION_CODE_LOGIN_COUNT, phone);
        }
        return result;
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.redisTemplate = this.redisService.getRedisTemplate();
        this.redisService.getRedisTemplate().opsForValue().set((Object)"ACCESS_TOKRN", (Object)accessToken, 1L, TimeUnit.HOURS);
    }

    @Override
    public String getAccessToken() {
        RedisTemplate redisTemplate = this.redisService.getRedisTemplate();
        String accessToken = (String)this.redisService.getRedisTemplate().opsForValue().get((Object)"ACCESS_TOKRN");
        return accessToken;
    }
}

