/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.constants.MeetingUserTypeConst;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.domain.dto.TempUserDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyBusinessRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyBusinessResponseDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMediationRoomUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserPortraitRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.HoldCourtDateCountResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyBusinessStatisticsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.TodoStatisticsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.TypeInfoResponseDTO;
import com.beiming.odr.referee.dto.requestdto.MyBusinessReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseListMicroResponseDTO;
import com.beiming.odr.referee.dto.responsedto.HoldCourtDateCountRespDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MyBusinessStatisticsRespDTO;
import com.beiming.odr.referee.dto.responsedto.UserPortraitCaseResponseDTO;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class PersonalConvert {
    public static MyBusinessReqDTO getMyBusinessReqDTO(MyBusinessRequestDTO requestDTO) {
        MyBusinessReqDTO reqDTO = new MyBusinessReqDTO();
        String userId = JWTContextUtil.getCurrentUserId();
        reqDTO.setUserId(Long.valueOf(userId));
        reqDTO.setCaseStatus(requestDTO.getCaseStatus());
        reqDTO.setPageIndex(requestDTO.getPageIndex());
        reqDTO.setPageSize(requestDTO.getPageSize());
        reqDTO.setStartTime(requestDTO.getStartTime());
        reqDTO.setEndTime(requestDTO.getEndTime());
        reqDTO.setKeyWord(requestDTO.getKeyWord());
        return reqDTO;
    }

    public static MyBusinessReqDTO getMyBusinessReqUserPortrait(UserPortraitRequestDTO requestDTO) {
        MyBusinessReqDTO reqDTO = new MyBusinessReqDTO();
        String userId = JWTContextUtil.getCurrentUserId();
        reqDTO.setUserId(Long.valueOf(userId));
        reqDTO.setPageIndex(requestDTO.getPageIndex());
        reqDTO.setPageSize(requestDTO.getPageSize());
        return reqDTO;
    }

    public static MyBusinessResponseDTO getMyBusinessResponseDTO(CaseListMicroResponseDTO one) {
        MyBusinessResponseDTO responseDTO = new MyBusinessResponseDTO();
        if (one == null) {
            return responseDTO;
        }
        responseDTO.setBizRoomId(one.getBizRoomId());
        responseDTO.setName(one.getName());
        responseDTO.setRoomType(one.getMediationMeetingType());
        responseDTO.setRoomStatus(one.getMediationStatus());
        responseDTO.setCauseName(one.getCauseName());
        responseDTO.setCreateTime(one.getCreateTime());
        responseDTO.setCaseSource(one.getCaseSource());
        responseDTO.setRoomId(one.getRoomId());
        return responseDTO;
    }

    public static void buildParticipants(MyBusinessResponseDTO myBusinessResponseDTO, ArrayList<MediationRoomUserInfoResDTO> mediationUserInfoList) {
        if (CollectionUtils.isEmpty(mediationUserInfoList)) {
            myBusinessResponseDTO.setJoinUserNumber(Integer.valueOf(0));
            myBusinessResponseDTO.setStaff("");
            myBusinessResponseDTO.setLitigant("");
            return;
        }
        String staff = "";
        String litigant = "";
        HashSet<Long> userIdSet = new HashSet<Long>();
        for (MediationRoomUserInfoResDTO member : mediationUserInfoList) {
            if (userIdSet.contains(member.getUserId())) continue;
            userIdSet.add(member.getUserId());
            String type = member.getMeetingUserType();
            JSONObject json = new JSONObject();
            String userName = "";
            String unitName = "";
            if (member.getExpandAttribute() != null) {
                json = JSONObject.parseObject((String)member.getExpandAttribute());
                unitName = json.getString(ColumnEnums.UNIT_NAME.desc());
            }
            userName = StringUtils.isNotEmpty((CharSequence)unitName) ? unitName + "(" + MeetingUserTypeConst.getUserIdentity((String)PersonalConvert.getType(type, json)) + ")" : member.getUserName() + "(" + MeetingUserTypeConst.getUserIdentity((String)PersonalConvert.getType(type, json)) + ")";
            if ("MEDIATOR".equals(type) || "ASSISTANT_JUDGE".equals(type) || "CLERK".equals(type) || "JUROR".equals(type)) {
                staff = StringUtils.isBlank((String)staff) ? userName : staff + "," + userName;
                continue;
            }
            litigant = StringUtils.isBlank((String)litigant) ? userName : litigant + "," + userName;
        }
        myBusinessResponseDTO.setJoinUserNumber(Integer.valueOf(userIdSet.size()));
        myBusinessResponseDTO.setStaff(staff);
        myBusinessResponseDTO.setLitigant(litigant);
    }

    public static String getType(String type, JSONObject json) {
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "APPLICANT".equals(type)) {
            type = "SECOND_APPLICANT";
        }
        if (json.get((Object)ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()) != null && "RESPONDENT".equals(type)) {
            type = "SECOND_RESPONDENT";
        }
        return type;
    }

    public static MyBusinessStatisticsResponseDTO getMyBusinessStatisticsResponseDTO(MyBusinessStatisticsRespDTO dto) {
        MyBusinessStatisticsResponseDTO responseDTO = new MyBusinessStatisticsResponseDTO();
        DecimalFormat df = new DecimalFormat("#0.00");
        if (dto != null) {
            responseDTO.setScheduleCount(dto.getScheduleCount());
            responseDTO.setHoldCourtCount(dto.getHoldCourtCount());
            responseDTO.setHoldCourtDuration(Double.valueOf(df.format(dto.getHoldCourtDuration())).doubleValue());
            responseDTO.setPlatformCreationCount(dto.getPlatformCreationCount());
            responseDTO.setIntranetCreationCount(dto.getIntranetCreationCount());
        }
        return responseDTO;
    }

    public static TodoStatisticsResponseDTO getTodoStatisticsResponseDTO(MyBusinessStatisticsRespDTO dto) {
        TodoStatisticsResponseDTO responseDTO = new TodoStatisticsResponseDTO();
        if (dto != null) {
            responseDTO.setScheduleCount(dto.getScheduleCount());
            responseDTO.setHoldCourtCount(dto.getHoldCourtCount());
            HoldCourtDateCountRespDTO holdCourtDto = dto.getHoldCourtDateCount();
            HoldCourtDateCountResponseDTO holdCourtResponseDto = new HoldCourtDateCountResponseDTO();
            holdCourtResponseDto.setToday(holdCourtDto.getToday());
            holdCourtResponseDto.setTomorrow(holdCourtDto.getTomorrow());
            holdCourtResponseDto.setDayAfterTomorrow(holdCourtDto.getDayAfterTomorrow());
            holdCourtResponseDto.setFuture(holdCourtDto.getFuture());
            responseDTO.setHoldCourtDateCount(holdCourtResponseDto);
        }
        return responseDTO;
    }

    public static List<TypeInfoResponseDTO> getTypeInfoResponseDTO(PageInfo<UserPortraitCaseResponseDTO> dubbo) {
        ArrayList<TypeInfoResponseDTO> result = new ArrayList<TypeInfoResponseDTO>();
        Integer first = 0;
        Integer second = 0;
        List caseList = dubbo.getList();
        for (UserPortraitCaseResponseDTO userPortraitCaseResponse : caseList) {
            if (userPortraitCaseResponse.getExpandAttribute() == null) continue;
            JSONObject json = JSONObject.parseObject((String)userPortraitCaseResponse.getExpandAttribute());
            if (json.get((Object)"case_type") != null && (json.getString("case_type").contains("\u4e00\u5ba1") || json.getString("case_type").contains("YS"))) {
                first = first + 1;
            }
            if (json.get((Object)"case_type") == null || !json.getString("case_type").contains("\u4e8c\u5ba1") && !json.getString("case_type").contains("ES")) continue;
            second = second + 1;
        }
        TypeInfoResponseDTO typeInfoResponseFirst = new TypeInfoResponseDTO();
        typeInfoResponseFirst.setNum(first);
        typeInfoResponseFirst.setTypeName("\u4e00\u5ba1");
        TypeInfoResponseDTO typeInfoResponseSecond = new TypeInfoResponseDTO();
        typeInfoResponseSecond.setNum(second);
        typeInfoResponseSecond.setTypeName("\u4e8c\u5ba1");
        result.add(typeInfoResponseFirst);
        result.add(typeInfoResponseSecond);
        return result;
    }

    public static List<TempUserDTO> allUserList(UpdateMediationRoomUserRequestDTO dto) {
        List agentList;
        List litigantList;
        ArrayList<TempUserDTO> allUserList = new ArrayList<TempUserDTO>();
        TempUserDTO tempUserRequestDTO = null;
        List mediatorList = dto.getMediatorList();
        if (!CollectionUtils.isEmpty((Collection)mediatorList)) {
            for (LitigantInfoRequestDTO mediator : mediatorList) {
                tempUserRequestDTO = new TempUserDTO();
                tempUserRequestDTO.setMobilePhone(mediator.getMobilePhone());
                tempUserRequestDTO.setUserName(mediator.getUserName());
                tempUserRequestDTO.setUserType("MEDIATOR");
                tempUserRequestDTO.setIdCard(mediator.getIdCard());
                tempUserRequestDTO.setMeetingUserType(mediator.getMeetingUserType().name());
                tempUserRequestDTO.setUserTempId(mediator.getUserTempId());
                allUserList.add(tempUserRequestDTO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(litigantList = dto.getLitigantList()))) {
            for (LitigantInfoRequestDTO litigant : litigantList) {
                tempUserRequestDTO = new TempUserDTO();
                tempUserRequestDTO.setMobilePhone(litigant.getMobilePhone());
                tempUserRequestDTO.setUserName(litigant.getUserName());
                tempUserRequestDTO.setUserType("LITIGANT");
                tempUserRequestDTO.setCreditCode(litigant.getCreditCode());
                tempUserRequestDTO.setIdCard(litigant.getIdCard());
                tempUserRequestDTO.setIsUndertaker(litigant.getIsUndertaker());
                tempUserRequestDTO.setLitigantType(litigant.getLitigantType());
                tempUserRequestDTO.setOriginalLitigationStatus(litigant.getOriginalLitigationStatus());
                tempUserRequestDTO.setUnitName(litigant.getUnitName());
                tempUserRequestDTO.setMeetingUserType(litigant.getMeetingUserType().name());
                tempUserRequestDTO.setUserTempId(litigant.getUserTempId());
                allUserList.add(tempUserRequestDTO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(agentList = dto.getAgentList()))) {
            for (LitigantAgentInfoMicroRequestDTO agent : agentList) {
                tempUserRequestDTO = new TempUserDTO();
                tempUserRequestDTO.setMobilePhone(agent.getMobilePhone());
                tempUserRequestDTO.setUserName(agent.getUserName());
                tempUserRequestDTO.setUserType("AGENT");
                tempUserRequestDTO.setIdCard(agent.getIdCard());
                tempUserRequestDTO.setMeetingUserType(agent.getMeetingUserType().name());
                tempUserRequestDTO.setUserTempId(agent.getUserTempId());
                allUserList.add(tempUserRequestDTO);
            }
        }
        return allUserList;
    }

    public static List<TempUserDTO> checkAddParticipants(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> addUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO newUser : newUserList) {
            boolean flag = true;
            for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
                if (!newUser.getMobilePhone().equals(oldUser.getMobilePhone()) || !newUser.getUserName().equals(oldUser.getUserName()) || !oldUser.getMeetingUserType().equals(newUser.getMeetingUserType())) continue;
                flag = false;
                break;
            }
            if (newUser.getMeetingUserType().contains("AGENT")) {
                flag = true;
            }
            if (!flag) continue;
            addUserList.add(newUser);
        }
        return addUserList;
    }

    public static List<TempUserDTO> checkAddParticipantsYanCheng(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> addUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO newUser : newUserList) {
            boolean flag = true;
            for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
                if (!newUser.getMobilePhone().equals(oldUser.getMobilePhone()) || !oldUser.getMeetingUserType().equals(newUser.getMeetingUserType())) continue;
                flag = false;
                break;
            }
            if (newUser.getMeetingUserType().contains("AGENT")) {
                flag = true;
            }
            if (!flag) continue;
            addUserList.add(newUser);
        }
        return addUserList;
    }

    public static List<TempUserDTO> checkDeleteParticipants(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> deleteUserList = new ArrayList<TempUserDTO>();
        TempUserDTO tempUserRequestDTO = null;
        for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
            boolean flag = true;
            for (TempUserDTO newUser : newUserList) {
                if (!oldUser.getMobilePhone().equals(newUser.getMobilePhone()) || !oldUser.getUserName().equals(newUser.getUserName()) || !oldUser.getMeetingUserType().equals(newUser.getMeetingUserType())) continue;
                flag = false;
                break;
            }
            if (oldUser.getMeetingUserType().contains("AGENT")) {
                flag = true;
            }
            if (!flag) continue;
            tempUserRequestDTO = new TempUserDTO();
            tempUserRequestDTO.setUserName(oldUser.getUserName());
            tempUserRequestDTO.setMobilePhone(oldUser.getMobilePhone());
            String userType = oldUser.getMeetingUserType();
            if ("MEDIATOR".equals(userType) || "CLERK".equals(userType)) {
                tempUserRequestDTO.setUserType("MEDIATOR");
            } else if (userType.contains("AGENT")) {
                tempUserRequestDTO.setUserType("AGENT");
            } else {
                tempUserRequestDTO.setUserType("LITIGANT");
            }
            deleteUserList.add(tempUserRequestDTO);
        }
        return deleteUserList;
    }

    public static List<TempUserDTO> checkDeleteParticipantsYanCheng(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> deleteUserList = new ArrayList<TempUserDTO>();
        TempUserDTO tempUserRequestDTO = null;
        for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
            boolean flag = true;
            for (TempUserDTO newUser : newUserList) {
                if (!oldUser.getMobilePhone().equals(newUser.getMobilePhone()) || !oldUser.getMeetingUserType().equals(newUser.getMeetingUserType())) continue;
                flag = false;
                break;
            }
            if (oldUser.getMeetingUserType().contains("AGENT")) {
                flag = true;
            }
            if (!flag) continue;
            tempUserRequestDTO = new TempUserDTO();
            tempUserRequestDTO.setUserName(oldUser.getUserName());
            tempUserRequestDTO.setMobilePhone(oldUser.getMobilePhone());
            String userType = oldUser.getMeetingUserType();
            if ("MEDIATOR".equals(userType) || "CLERK".equals(userType)) {
                tempUserRequestDTO.setUserType("MEDIATOR");
            } else if (userType.contains("AGENT")) {
                tempUserRequestDTO.setUserType("AGENT");
            } else {
                tempUserRequestDTO.setUserType("LITIGANT");
            }
            deleteUserList.add(tempUserRequestDTO);
        }
        return deleteUserList;
    }

    public static List<TempUserDTO> checkUpdateParticipants(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> updateUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO newUser : newUserList) {
            boolean flag = false;
            for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
                if (!newUser.getMobilePhone().equals(oldUser.getMobilePhone()) || !newUser.getUserName().equals(oldUser.getUserName()) || !oldUser.getMeetingUserType().equals(newUser.getMeetingUserType())) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            updateUserList.add(newUser);
        }
        return updateUserList;
    }

    public static List<TempUserDTO> checkUpdateParticipantsYanCheng(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> updateUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO newUser : newUserList) {
            boolean flag = false;
            for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
                if (!newUser.getMobilePhone().equals(oldUser.getMobilePhone()) || !oldUser.getMeetingUserType().equals(newUser.getMeetingUserType())) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            updateUserList.add(newUser);
        }
        return updateUserList;
    }

    public static Map<String, Object> allUserMap(UpdateMediationRoomUserRequestDTO requestDTO) {
        List agentList;
        List litigantList;
        HashMap<String, Object> allUserMap = new HashMap<String, Object>();
        List mediatorList = requestDTO.getMediatorList();
        if (!CollectionUtils.isEmpty((Collection)mediatorList)) {
            for (LitigantInfoRequestDTO mediator : mediatorList) {
                allUserMap.put(mediator.getMobilePhone(), mediator);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(litigantList = requestDTO.getLitigantList()))) {
            for (LitigantInfoRequestDTO litigant : litigantList) {
                allUserMap.put(litigant.getMobilePhone(), litigant);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(agentList = requestDTO.getAgentList()))) {
            for (LitigantAgentInfoMicroRequestDTO agent : agentList) {
                allUserMap.put(agent.getMobilePhone(), agent);
            }
        }
        return allUserMap;
    }

    public static List<TempUserDTO> getTempUserListHasPhone(List<TempUserDTO> userList) {
        ArrayList<TempUserDTO> newUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO tempUser : userList) {
            if (!StringUtils.isNotBlank((CharSequence)tempUser.getMobilePhone()) || "1111".equals(tempUser.getMobilePhone())) continue;
            newUserList.add(tempUser);
        }
        return newUserList;
    }

    public static List<MediationRoomUserInfoResDTO> getMediationRoomUserListHasPhone(List<MediationRoomUserInfoResDTO> roomUserList) {
        ArrayList<MediationRoomUserInfoResDTO> newUserList = new ArrayList<MediationRoomUserInfoResDTO>();
        for (MediationRoomUserInfoResDTO mediationRoomUserInfo : roomUserList) {
            if (!StringUtils.isNotBlank((CharSequence)mediationRoomUserInfo.getMobilePhone())) continue;
            newUserList.add(mediationRoomUserInfo);
        }
        return newUserList;
    }

    public static List<TempUserDTO> getTempUserListNoPhone(List<TempUserDTO> userList) {
        ArrayList<TempUserDTO> newUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO tempUser : userList) {
            if (!StringUtils.isBlank((String)tempUser.getMobilePhone()) && !"1111".equals(tempUser.getMobilePhone())) continue;
            newUserList.add(tempUser);
        }
        return newUserList;
    }

    public static List<MediationRoomUserInfoResDTO> getMediationRoomUserListNoPhone(List<MediationRoomUserInfoResDTO> roomUserList) {
        ArrayList<MediationRoomUserInfoResDTO> newUserList = new ArrayList<MediationRoomUserInfoResDTO>();
        for (MediationRoomUserInfoResDTO mediationRoomUserInfo : roomUserList) {
            if (!StringUtils.isBlank((String)mediationRoomUserInfo.getMobilePhone())) continue;
            newUserList.add(mediationRoomUserInfo);
        }
        return newUserList;
    }

    public static List<TempUserDTO> checkAddNoPhoneParticipants(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> addUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO newUser : newUserList) {
            boolean flag = true;
            for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
                if (!newUser.getUserTempId().equals(oldUser.getRemark()) || !newUser.getMeetingUserType().equals(oldUser.getMeetingUserType())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            addUserList.add(newUser);
        }
        return addUserList;
    }

    public static List<TempUserDTO> checkDeleteNoPhoneParticipants(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> deleteUserList = new ArrayList<TempUserDTO>();
        TempUserDTO tempUserRequestDTO = null;
        for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
            boolean flag = true;
            for (TempUserDTO newUser : newUserList) {
                if (!newUser.getUserTempId().equals(oldUser.getRemark()) || !newUser.getMeetingUserType().equals(oldUser.getMeetingUserType())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            tempUserRequestDTO = new TempUserDTO();
            tempUserRequestDTO.setUserName(oldUser.getUserName());
            tempUserRequestDTO.setMeetingUserType(oldUser.getMeetingUserType());
            String userType = oldUser.getMeetingUserType();
            if ("MEDIATOR".equals(userType) || "CLERK".equals(userType)) {
                tempUserRequestDTO.setUserType("MEDIATOR");
            } else if (userType.contains("AGENT")) {
                tempUserRequestDTO.setUserType("AGENT");
            } else {
                tempUserRequestDTO.setUserType("LITIGANT");
            }
            deleteUserList.add(tempUserRequestDTO);
        }
        return deleteUserList;
    }

    public static List<TempUserDTO> checkUpdateNoPhoneParticipants(List<TempUserDTO> newUserList, List<MediationRoomUserInfoResDTO> oldUserList) {
        ArrayList<TempUserDTO> updateUserList = new ArrayList<TempUserDTO>();
        for (TempUserDTO newUser : newUserList) {
            boolean flag = false;
            for (MediationRoomUserInfoResDTO oldUser : oldUserList) {
                if (!newUser.getUserTempId().equals(oldUser.getRemark()) || !newUser.getMeetingUserType().equals(oldUser.getMeetingUserType())) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            updateUserList.add(newUser);
        }
        return updateUserList;
    }
}

