/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.Java8DateUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.SMSTypeEnums;
import com.beiming.odr.peace.common.utils.RandomUtil;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.service.PeaceSmsService;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.SMSUtil;
import com.beiming.odr.referee.dto.responsedto.VisitorSystemMsgUserResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PeaceSmsServiceImpl
implements PeaceSmsService {
    private static final Logger log = LoggerFactory.getLogger(PeaceSmsServiceImpl.class);
    @Resource
    private RedisService redisService;
    @Resource
    private SMSUtil smsUtil;
    @Resource
    private DictionaryService dictionaryService;
    private RedisTemplate redisTemplate;

    @Override
    public void regenerateVerificationCode(String mobilePhone, Long mediationRoomId, String roomId, Integer authFlag) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = null;
        String verificationCode = "";
        Boolean flag = false;
        while (!flag.booleanValue()) {
            verificationCode = RandomUtil.getNumRandom((int)5);
            RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
            redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
            redisMediationRoomInfoDTO.setMobilePhone(mobilePhone);
            redisMediationRoomInfoDTO.setRoomId(roomId);
            redisMediationRoomInfoDTO.setAuthFlag(authFlag);
            flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
            if (!flag.booleanValue()) continue;
            this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
            verificationCodes = StringUtils.isBlank(verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + mediationRoomId + "_" + mobilePhone), (Object)verificationCode, 7L, TimeUnit.DAYS);
        this.redisService.getRedisTemplate().opsForValue().set((Object)("VERIFICATION_CODE_LOGIN_" + mobilePhone + "_" + verificationCode), (Object)1, 7L, TimeUnit.DAYS);
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendMediationRoomSms(List<LitigantInfoRequestDTO> litigantList, Long mediationRoomId, String name, String roomId, String mediator, Integer authFlag) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = null;
        for (LitigantInfoRequestDTO info : litigantList) {
            if (StringUtils.isBlank((String)info.getMobilePhone()) || StringUtils.isBlank((String)info.getUserName()) || "1111".equals(info.getMobilePhone())) continue;
            String verificationCode = "";
            Boolean flag = false;
            while (!flag.booleanValue()) {
                verificationCode = RandomUtil.getNumRandom((int)5);
                RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
                redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
                redisMediationRoomInfoDTO.setMobilePhone(info.getMobilePhone());
                redisMediationRoomInfoDTO.setRoomId(roomId);
                redisMediationRoomInfoDTO.setAuthFlag(authFlag);
                flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
                if (!flag.booleanValue()) continue;
                this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
                verificationCodes = StringUtils.isBlank((String)verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
            }
            this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + mediationRoomId + "_" + info.getMobilePhone()), (Object)verificationCode, 7L, TimeUnit.DAYS);
            this.redisService.getRedisTemplate().opsForValue().set((Object)("VERIFICATION_CODE_LOGIN_" + info.getMobilePhone() + "_" + verificationCode), (Object)1, 7L, TimeUnit.DAYS);
            HashMap data = Maps.newHashMap();
            data.put("mediator", mediator);
            String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
            data.put("name", name);
            data.put("url", url);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(info.getMobilePhone(), SMSTypeEnums.SMS_MEDIATION_ROOM_LITIGANT.name() + "_" + appName.toUpperCase(), data);
        }
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendMediationRoomSmsForAgent(List<LitigantAgentInfoMicroRequestDTO> agentList, Long mediationRoomId, String roomId, String caseName, String mediator, Integer authFlag) {
        if (agentList == null) {
            return;
        }
        String appName = AppNameContextHolder.getAppName();
        String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
        String smsEnum = SMSTypeEnums.SMS_MEDIATION_ROOM_NOTICE_LITIGANT.name() + "_" + appName.toUpperCase();
        String suffix = appName;
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = null;
        for (LitigantAgentInfoMicroRequestDTO info : agentList) {
            String verificationCode = "";
            Boolean flag = false;
            while (!flag.booleanValue()) {
                verificationCode = RandomUtil.getNumRandom((int)5);
                RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
                redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
                redisMediationRoomInfoDTO.setMobilePhone(info.getMobilePhone());
                redisMediationRoomInfoDTO.setRoomId(roomId);
                redisMediationRoomInfoDTO.setAuthFlag(authFlag);
                flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
                if (!flag.booleanValue()) continue;
                this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
                verificationCodes = StringUtils.isBlank((String)verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
            }
            log.info("------------------------------------------------------");
            log.info(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode);
            log.info("------------------------------------------------------");
            this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + mediationRoomId + "_" + info.getMobilePhone()), (Object)verificationCode, 7L, TimeUnit.DAYS);
            log.info("------------------------------------------------------");
            log.info(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + mediationRoomId + "_" + info.getMobilePhone());
            log.info("------------------------------------------------------");
            this.redisService.getRedisTemplate().opsForValue().set((Object)("VERIFICATION_CODE_LOGIN_" + info.getMobilePhone() + "_" + verificationCode), (Object)1, 7L, TimeUnit.DAYS);
            HashMap data = Maps.newHashMap();
            data.put("mediator", mediator);
            data.put("url", url);
            data.put("caseName", caseName);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(info.getMobilePhone(), smsEnum, data);
        }
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendMediationMeetingSms(List<LitigantInfoRequestDTO> litigantList, Long mediationRoomId, String roomId, String mediator, Date orderTime, Integer authFlag) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = null;
        for (LitigantInfoRequestDTO info : litigantList) {
            String verificationCode = "";
            Boolean flag = false;
            while (!flag.booleanValue()) {
                verificationCode = RandomUtil.getNumRandom((int)4);
                RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
                redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
                redisMediationRoomInfoDTO.setMobilePhone(info.getMobilePhone());
                redisMediationRoomInfoDTO.setRoomId(roomId);
                redisMediationRoomInfoDTO.setAuthFlag(authFlag);
                flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
                if (!flag.booleanValue()) continue;
                this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
                verificationCodes = StringUtils.isBlank((String)verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
            }
            HashMap data = Maps.newHashMap();
            data.put("mediator", mediator);
            data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
            String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
            data.put("url", url);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(info.getMobilePhone(), SMSTypeEnums.SMS_MEDIATION_MEETING.name() + "_" + appName.toUpperCase(), data);
        }
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendMediationMeetingSmsByPhoneList(List<String> phoneList, Long mediationRoomId, String name, String roomId, String mediator, Date orderTime, Integer authFlag) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = null;
        for (String phone : phoneList) {
            String verificationCode = "";
            Boolean flag = false;
            while (!flag.booleanValue()) {
                verificationCode = RandomUtil.getNumRandom((int)4);
                RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
                redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
                redisMediationRoomInfoDTO.setMobilePhone(phone);
                redisMediationRoomInfoDTO.setRoomId(roomId);
                redisMediationRoomInfoDTO.setAuthFlag(authFlag);
                flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
                if (!flag.booleanValue()) continue;
                this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
                verificationCodes = StringUtils.isBlank((String)verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
            }
            this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + mediationRoomId + "_" + phone), (Object)verificationCode, 7L, TimeUnit.DAYS);
            this.redisService.getRedisTemplate().opsForValue().set((Object)("VERIFICATION_CODE_LOGIN_" + phone + "_" + verificationCode), (Object)1, 7L, TimeUnit.DAYS);
            HashMap data = Maps.newHashMap();
            data.put("mediator", mediator);
            data.put("name", name);
            data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
            String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
            data.put("url", url);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(phone, SMSTypeEnums.SMS_MEDIATION_MEETING_LITIGANT.name() + "_" + appName.toUpperCase(), data);
        }
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendLitigantSms(List<LitigantInfoRequestDTO> litigantList, Long mediationRoomId, String roomId, String mediator, Date orderTime, Integer authFlag, String cause) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = null;
        for (LitigantInfoRequestDTO info : litigantList) {
            MeetingUserTypeEnum userType = info.getMeetingUserType();
            if (!MeetingUserTypeEnum.APPLICANT.equals((Object)userType) && !MeetingUserTypeEnum.RESPONDENT.equals((Object)userType)) continue;
            String verificationCode = "";
            Boolean flag = false;
            while (!flag.booleanValue()) {
                verificationCode = RandomUtil.getNumRandom((int)4);
                RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
                redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
                redisMediationRoomInfoDTO.setMobilePhone(info.getMobilePhone());
                redisMediationRoomInfoDTO.setRoomId(roomId);
                redisMediationRoomInfoDTO.setAuthFlag(authFlag);
                flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
                if (!flag.booleanValue()) continue;
                this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
                verificationCodes = StringUtils.isBlank((String)verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
            }
            HashMap data = Maps.newHashMap();
            String litigantNames = litigantList.stream().filter(o -> !o.getUserId().equals(info.getUserId())).map(LitigantInfoRequestDTO::getUserName).collect(Collectors.joining("\u3001"));
            data.put("litigant", litigantNames);
            data.put("cause", cause);
            data.put("mediator", mediator);
            String smsEmun = SMSTypeEnums.SMS_MEDIATION_ROOM_NOTICE_COMMON.name();
            if (orderTime != null) {
                data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
                smsEmun = SMSTypeEnums.SMS_MEDIATION_MEETING_COMMON.name();
            }
            String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
            data.put("url", url);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(info.getMobilePhone(), smsEmun + "_" + appName.toUpperCase(), data);
        }
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendThirdSms(List<String> phoneList, Long mediationRoomId, String roomId, String mediator, Date orderTime, Integer authFlag, String cause, String applicantNames, String respondentNames) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = null;
        for (String phone : phoneList) {
            String verificationCode = "";
            Boolean flag = false;
            while (!flag.booleanValue()) {
                verificationCode = RandomUtil.getNumRandom((int)4);
                RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
                redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
                redisMediationRoomInfoDTO.setMobilePhone(phone);
                redisMediationRoomInfoDTO.setRoomId(roomId);
                redisMediationRoomInfoDTO.setAuthFlag(authFlag);
                flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
                if (!flag.booleanValue()) continue;
                this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
                verificationCodes = StringUtils.isBlank((String)verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
            }
            HashMap data = Maps.newHashMap();
            data.put("applicant", applicantNames);
            data.put("respondent", respondentNames);
            data.put("cause", cause);
            data.put("mediator", mediator);
            String smsEmun = SMSTypeEnums.SMS_MEDIATION_ROOM_NOTICE_THIRD.name();
            if (orderTime != null) {
                data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
                smsEmun = SMSTypeEnums.SMS_MEDIATION_MEETING_THIRD.name();
            }
            String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
            data.put("url", url);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(phone, smsEmun + "_" + appName.toUpperCase(), data);
        }
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendStaffSms(List<LitigantInfoRequestDTO> mediationList, Date orderTime, String caseName) {
        String appName;
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        for (LitigantInfoRequestDTO info : mediationList) {
            HashMap data = Maps.newHashMap();
            data.put("mediator", info.getUserName());
            data.put("caseName", caseName);
            String smsEmun = SMSTypeEnums.SMS_MEDIATION_ROOM_NOTICE_STAFF.name();
            if (orderTime != null) {
                data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
                smsEmun = SMSTypeEnums.SMS_MEDIATION_MEETING_STAFF.name();
            }
            this.smsUtil.sendSms(info.getMobilePhone(), smsEmun + "_" + appName.toUpperCase(), data);
        }
    }

    @Override
    public void sendVisitorSystemSms(List<VisitorSystemMsgUserResDTO> list, String orderTime, String userVisitingBusiness, String address) {
        String appName;
        log.info("\u8bbf\u5ba2\u7cfb\u7edf\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5165\u53c2{},\u8bbf\u95ee\u65f6\u95f4{}, \u4e1a\u52a1{}, \u6cd5\u9662\u5730\u5740{}", new Object[]{list, orderTime, userVisitingBusiness, address});
        String suffix = appName = AppNameContextHolder.getAppName();
        if (address.contains("donghufangkeyuyue")) {
            suffix = "donghufangkeyuyue";
        }
        suffix = suffix + "_";
        for (VisitorSystemMsgUserResDTO info : list) {
            HashMap<String, String> data = new HashMap<String, String>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String formatter = "";
            try {
                Date date = simpleDateFormat.parse(orderTime);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd HH:mm");
                formatter = sdf.format(date);
            }
            catch (Exception e) {
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5931\u8d25{}", (Throwable)e);
            }
            data.put("mediator", formatter);
            data.put("caseName", userVisitingBusiness);
            data.put("orderTime", address);
            String smsEmun = SMSTypeEnums.SMS_VISITOR.name();
            log.info("\u77ed\u4fe1\u53d1\u9001\u5165\u53c2{}, \u6a21\u677fid{}", data, (Object)(smsEmun + "_" + appName.toUpperCase()));
            this.smsUtil.sendSms(info.getUserMobilePhone(), smsEmun + "_" + appName.toUpperCase(), data);
        }
    }
}

