/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.Java8DateUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.SMSTypeEnums;
import com.beiming.odr.peace.domain.dto.requestdto.SendSMAgainRequestDTO;
import com.beiming.odr.peace.service.SMSHubeiService;
import com.beiming.odr.peace.service.SMSHubeiZzService;
import com.beiming.odr.peace.service.SendSMAgainService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.SMSUtil;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingRoomInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SendSMAgainServiceImpl
implements SendSMAgainService {
    private static final Logger log = LoggerFactory.getLogger(SendSMAgainServiceImpl.class);
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private RedisService redisService;
    @Resource
    private SMSUtil smsUtil;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private SMSHubeiService smsHubeiService;
    @Resource
    private SMSHubeiZzService smsHubeiZzService;
    @Resource
    private UserService userService;
    private RedisTemplate redisTemplate;

    @Override
    public String sendMediationRoomSMS(SendSMAgainRequestDTO dto) {
        String verificationCode;
        String appName;
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        String checkSign = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.SMS_AGAIN_COUNT.name() + dto.getBizRoomId() + "_" + dto.getMobilePhone()));
        AssertUtils.assertNull((Object)checkSign, (ResultCode)ErrorCode.SMS_SEND_AGAIN, (String)ErrorCode.SMS_SEND_AGAIN.desc());
        DubboResult mediationRoomDubbo = this.mediationRoomApi.selectCaseMeetingInfo(dto.getBizRoomId());
        CaseMeetingRoomInfoResDTO roomInfo = (CaseMeetingRoomInfoResDTO)mediationRoomDubbo.getData();
        AssertUtils.assertNotNull((Object)roomInfo, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
        if (SMSTypeEnums.SMS_LITIGANT_AGAIN.toString().equals(dto.getSmsType())) {
            verificationCode = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + dto.getBizRoomId() + "_" + dto.getMobilePhone()));
            AssertUtils.assertNotNull((Object)verificationCode, (ResultCode)ErrorCode.SMS_CODE_IS_NULL, (String)ErrorCode.SMS_CODE_IS_NULL.desc());
            HashMap data = Maps.newHashMap();
            data.put("mediator", roomInfo.getCreateUser());
            data.put("name", roomInfo.getName());
            if (!"weitingshenhubeizz".equals(appName)) {
                data.put("url", url);
            }
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(dto.getMobilePhone(), SMSTypeEnums.SMS_MEDIATION_ROOM_LITIGANT.name() + "_" + appName.toUpperCase(), data);
        } else if (SMSTypeEnums.SMS_AGENT_AGAIN.toString().equals(dto.getSmsType())) {
            verificationCode = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + dto.getBizRoomId() + "_" + dto.getMobilePhone()));
            AssertUtils.assertNotNull((Object)verificationCode, (ResultCode)ErrorCode.SMS_CODE_IS_NULL, (String)ErrorCode.SMS_CODE_IS_NULL.desc());
            HashMap data = Maps.newHashMap();
            data.put("mediator", roomInfo.getCreateUser());
            if (!"weitingshenhubeizz".equals(appName)) {
                data.put("url", url);
            }
            data.put("caseName", roomInfo.getName());
            data.put("verificationCode", verificationCode);
            String smsEnum = SMSTypeEnums.SMS_MEDIATION_ROOM_NOTICE_LITIGANT.name() + "_" + appName.toUpperCase();
            this.smsUtil.sendSms(dto.getMobilePhone(), smsEnum, data);
        } else if (SMSTypeEnums.SMS_STAFF_AGAIN.toString().equals(dto.getSmsType())) {
            HashMap data = Maps.newHashMap();
            data.put("mediator", roomInfo.getCreateUser());
            data.put("caseName", roomInfo.getName());
            String smsEmun = SMSTypeEnums.SMS_MEDIATION_ROOM_NOTICE_STAFF.name();
            this.smsUtil.sendSms(dto.getMobilePhone(), smsEmun + "_" + appName.toUpperCase(), data);
        }
        String sign = "OK";
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.SMS_AGAIN_COUNT.name() + dto.getBizRoomId() + "_" + dto.getMobilePhone()), (Object)sign, 3L, TimeUnit.MINUTES);
        return null;
    }

    @Override
    public String sendMediationMeetingSmS(SendSMAgainRequestDTO dto) {
        String appName;
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        String checkSign = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.SMS_AGAIN_COUNT.name() + dto.getBizRoomId() + "_" + dto.getMobilePhone()));
        AssertUtils.assertNull((Object)checkSign, (ResultCode)ErrorCode.SMS_SEND_AGAIN, (String)ErrorCode.SMS_SEND_AGAIN.desc());
        DubboResult mediationRoomDubbo = this.mediationRoomApi.selectCaseMeetingInfo(dto.getBizRoomId());
        CaseMeetingRoomInfoResDTO roomInfo = (CaseMeetingRoomInfoResDTO)mediationRoomDubbo.getData();
        AssertUtils.assertNotNull((Object)roomInfo, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date orderTime = null;
        if (roomInfo.getOrderTime() != null) {
            try {
                orderTime = sdf.parse(roomInfo.getOrderTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (SMSTypeEnums.SMS_LITIGANT_AGAIN.toString().equals(dto.getSmsType()) || SMSTypeEnums.SMS_AGENT_AGAIN.toString().equals(dto.getSmsType())) {
            String verificationCode = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + dto.getBizRoomId() + "_" + dto.getMobilePhone()));
            AssertUtils.assertNotNull((Object)verificationCode, (ResultCode)ErrorCode.SMS_CODE_IS_NULL, (String)ErrorCode.SMS_CODE_IS_NULL.desc());
            if (!("weitingshenhubei".equals(appName) || "weitingshenhainan".equals(appName) || "weitingshenhubeizz".equals(appName))) {
                HashMap data = Maps.newHashMap();
                data.put("mediator", roomInfo.getCreateUser());
                data.put("name", roomInfo.getName());
                data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
                data.put("url", url);
                data.put("verificationCode", verificationCode);
                this.smsUtil.sendSms(dto.getMobilePhone(), SMSTypeEnums.SMS_MEDIATION_MEETING_LITIGANT.name() + "_" + appName.toUpperCase(), data);
            } else if ("weitingshenhubeizz".equals(appName)) {
                LoginInfoResDTO userInfo = this.userService.userLoginTwo(dto.getMobilePhone());
                this.smsHubeiZzService.sendMediationMeetingSmSAgain(dto.getMobilePhone(), userInfo.getUserInfo().getUserId(), verificationCode, dto.getBizRoomId(), roomInfo.getName(), roomInfo.getCreateUser(), orderTime);
            } else {
                LoginInfoResDTO userInfo = this.userService.userLoginTwo(dto.getMobilePhone());
                this.smsHubeiService.sendMediationMeetingSmSAgain(dto.getMobilePhone(), userInfo.getUserInfo().getUserId(), verificationCode, dto.getBizRoomId(), roomInfo.getName(), roomInfo.getCreateUser(), orderTime);
            }
        } else if (SMSTypeEnums.SMS_STAFF_AGAIN.toString().equals(dto.getSmsType())) {
            HashMap data = Maps.newHashMap();
            data.put("mediator", roomInfo.getCreateUser());
            data.put("caseName", roomInfo.getName());
            data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
            String smsEmun = SMSTypeEnums.SMS_MEDIATION_MEETING_STAFF.name();
            this.smsUtil.sendSms(dto.getMobilePhone(), smsEmun + "_" + appName.toUpperCase(), data);
        }
        String sign = "OK";
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.SMS_AGAIN_COUNT.name() + dto.getBizRoomId() + "_" + dto.getMobilePhone()), (Object)sign, 3L, TimeUnit.MINUTES);
        return null;
    }
}

