/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RSAUtil {
    private static final String PUBLICKEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmudfd0ZXk2R2P8Lj7z/dDu/8nNqIYm1e\r\noa+09TcXBzfC67xOMRu/1KSpAU7stfBxvVkqANOyHX7fKWXycIbQ06SqKRn8mnHTo4Ni+nkWTWpF\r\nyIFYKLnGTcm1wk9gvNKeeFY8k3qe7m4LruuDF2i07HgsGWXiBRYeZHHLpc1CMEm6d/IQXpmldz70\r\nfY5PemGWe4F4JTT/3kPx9TV9wMhUPLg+4ntRX3XWPjAiLKIN5WJmyG4FOZxdQ9D7N7P81t8m7mjm\r\nPRHvZ9KtPKr7WGfIe2Hwl96c0vbQ4RMrIGGvQy4KieZzYUuTMWp680i639Gs51Dlw/TuwAI8nrrl\r\nfphp4wIDAQAB";
    private static final String PRIVATEKEY = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCa5193RleTZHY/wuPvP90O7/yc\r\n2ohibV6hr7T1NxcHN8LrvE4xG7/UpKkBTuy18HG9WSoA07Idft8pZfJwhtDTpKopGfyacdOjg2L6\r\neRZNakXIgVgoucZNybXCT2C80p54VjyTep7ubguu64MXaLTseCwZZeIFFh5kcculzUIwSbp38hBe\r\nmaV3PvR9jk96YZZ7gXglNP/eQ/H1NX3AyFQ8uD7ie1FfddY+MCIsog3lYmbIbgU5nF1D0Ps3s/zW\r\n3ybuaOY9Ee9n0q08qvtYZ8h7YfCX3pzS9tDhEysgYa9DLgqJ5nNhS5MxanrzSLrf0aznUOXD9O7A\r\nAjyeuuV+mGnjAgMBAAECggEAc6f1G3UlxiLoN0soLGYegxykG+j+k57dXRN3pO7w/q6flqsOJpR1\r\ncitPFG79Rgq0oY+FUQC+qE8mCB7aGTJPkPYNJosEk7wRLLDYofLut/Z1C/OnAyFR8pp8XwwtSk5n\r\ni6m3qNWQ/KylhIDLbBr9muFO69eqHeoZ3x0n1C+hD7ONOXbkWFl22YvW5iT+11gJO6+lwaiYVVVS\r\n+RxyY8FhbYxFr/OS6l0J/tDmeT9m/lTuFA6No0JkbDQ5UR4oEWPb23cjVfz8+Rcss4F3FfOzGEls\r\nOjMqjMVnhy06bJ1WYgczidjFFjtSCl0GW3f2bJ3yMYY7N/yVKAI4M1XrQU9LAQKBgQD0J1oX1NmR\r\nzEX5yPuMe7l1uNcSmZvtdhmOvWpjC+G3aaYrghxnHdr87MoUgrnJSiAK0fNEmTmzMtnvmp3Z1acq\r\nh13F6oNcnIae6ulBS5A8LW/ljauDevPPvLZA1z/DZX0NproT2HraF/i7OLQ8VCMv8sZlBLahUzwQ\r\nORnRXqnqYQKBgQCia3E/FkQBPIF72z83SMk7QWUZjXK5JKV6hJPcEjHRa25jgTg0vwqjmV9UPT6X\r\nMj94Gr4g5vN7F63gacwR44tqVejVSxWUNM9tICX+0cAgEfHvkI3bAKmlBLJJ+acrNyAEsAwL6lVA\r\nl8kYL0ceBvtGhuGePhU82P2rtW8HUkoiwwKBgD/amuFotY5AEn0FZ2SSZyq2sOkYa4NrQ7vlJhHJ\r\nZbsGUoNGgA8n68ICW8eJePWAAWlTB4CFYmXPgtf7ZBU4n4Or64Z7kueBuGOPpHmDPbG/YGh06Mp2\r\nOZW3ESNcKDz+KfqMBFZ0Y4zugArXBaxRhPJhWCnLVchTcH39sRbk3yOBAoGAQJTuS8KDueYgKmqM\r\nYWQst8YR+C4ZPusGbYgH7wrBCl9oXmKEQdzw0wpqMGnF2ILfX9dqYFTU3c4VklUfEsHirp6IXT9k\r\nzjCNhfuxf/hRJ69a/wIAleNWkUojxmxhfzqFHbgOojJEQdHY4SfzZEosYefCEJTpBu/VNhCHnGap\r\nGdcCgYBJmygmEhEjp482WY/LCdnR2xudg6NzM9XRYv7vR+Vn5tweAgdr5e1P3EZ0FoOPYNg4bAnG\r\n7s82uywjPU4Hq/d65B714CL0R/MD5fPa/QENYLnqA4VEN5K3RkZfHlZbHxiZT27dYgLy/27gKRw7\r\nHV/tnDtIZ3blAn6jn8kh11rpLQ==";

    public static KeyPair getKeyPair() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static String getPublicKey(KeyPair keyPair) {
        PublicKey publicKey = keyPair.getPublic();
        byte[] bytes = publicKey.getEncoded();
        return RSAUtil.byte2Base64(bytes);
    }

    public static String getPrivateKey(KeyPair keyPair) {
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] bytes = privateKey.getEncoded();
        return RSAUtil.byte2Base64(bytes);
    }

    public static PublicKey string2PublicKey(String pubStr) throws Exception {
        byte[] keyBytes = RSAUtil.base642Byte(pubStr);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey string2PrivateKey(String priStr) throws Exception {
        byte[] keyBytes = RSAUtil.base642Byte(priStr);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static byte[] publicEncrypt(byte[] content, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        byte[] bytes = cipher.doFinal(content);
        return bytes;
    }

    public static byte[] encrypt(byte[] content) throws Exception {
        PublicKey publicKey = RSAUtil.string2PublicKey(PUBLICKEY);
        return RSAUtil.publicEncrypt(content, publicKey);
    }

    public static String encrypt(String content) throws Exception {
        byte[] encrypt = RSAUtil.encrypt(content.getBytes(StandardCharsets.UTF_8));
        return RSAUtil.byte2Base64(encrypt);
    }

    public static byte[] privateDecrypt(byte[] content, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] bytes = cipher.doFinal(content);
        return bytes;
    }

    public static String byte2Base64(byte[] bytes) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(bytes);
    }

    public static byte[] base642Byte(String base64Key) throws IOException {
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(base64Key);
    }

    public static void main(String[] args) throws Exception {
        KeyPair keyPair = RSAUtil.getKeyPair();
        System.out.println(RSAUtil.getPrivateKey(keyPair));
        System.out.println("--------------------");
        System.out.println(RSAUtil.getPublicKey(keyPair));
    }

    public static String generateAes() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(128);
            SecretKey sk = kg.generateKey();
            byte[] b = sk.getEncoded();
            String s = RSAUtil.byteToHexString(b);
            return s;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String byteToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String strHex = Integer.toHexString(bytes[i]);
            if (strHex.length() > 3) {
                sb.append(strHex.substring(6));
                continue;
            }
            if (strHex.length() < 2) {
                sb.append("0" + strHex);
                continue;
            }
            sb.append(strHex);
        }
        return sb.toString();
    }

    public static byte[] decrypt(byte[] content) throws Exception {
        PrivateKey privateKey = RSAUtil.string2PrivateKey(PRIVATEKEY);
        return RSAUtil.privateDecrypt(content, privateKey);
    }

    public static String decrypt(String content) throws Exception {
        byte[] decrypt = RSAUtil.decrypt(RSAUtil.base642Byte(content));
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    public static String aesDncode(String encodeRules, String content) {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(encodeRules.getBytes());
            keygen.init(128, secureRandom);
            SecretKey originalKey = keygen.generateKey();
            byte[] raw = originalKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] byteContent = new BASE64Decoder().decodeBuffer(content);
            byte[] byteeDcode = cipher.doFinal(byteContent);
            return new String(byteeDcode, "utf-8");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

