/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.GetMobilePhoneByCodeRequestDTO;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.AesUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WechatBindingUtil {
    private static final Logger log = LoggerFactory.getLogger(WechatBindingUtil.class);
    @Value(value="${wechat.url}")
    private String serverUrl;
    @Value(value="${wechat.appId}")
    private String appId;
    @Value(value="${wechat.appSecret}")
    private String appSecret;
    @Resource
    private RedisService redisService;
    @Resource
    private DictionaryService dictionaryService;

    public String getOpenIdByCode(String code, String appName) {
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)code), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u83b7\u53d6openId\uff0ccode\u5fc5\u586b");
        String appIdCode = appName + ".appId";
        String appSecretCode = appName + ".appSecret";
        log.info("appName: {} , {}, {}", new Object[]{appName, appIdCode, appSecretCode});
        this.appId = this.dictionaryService.getDictionaryValue(appIdCode);
        this.appSecret = this.dictionaryService.getDictionaryValue(appSecretCode);
        try {
            String url = this.serverUrl + "?appid=" + this.appId + "&secret=" + this.appSecret + "&js_code=" + code + "&grant_type=authorization_code";
            log.info("url:{}", (Object)url);
            String jsonStr = MyHttpClientUtils.sendHttpsGet((String)url);
            JSONObject json = JSONObject.parseObject((String)jsonStr);
            if (json.containsKey((Object)"openid")) {
                this.redisService.set((RedisKey)RedisKeyEnums.USER_OPEN_ID, code, (Object)json.getString("openid"), 4L, TimeUnit.HOURS);
                this.redisService.set((RedisKey)RedisKeyEnums.USER_SESSION_KEY, code, (Object)json.getString("session_key"), 4L, TimeUnit.HOURS);
                HashMap map = new HashMap();
                return json.getString("openid");
            }
            log.info("url\u5730\u5740 = " + url);
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)("\u83b7\u53d6openId\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9\u4e3a\uff1a" + jsonStr));
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6openId\u5f02\u5e38 ,code={}", (Object)code, (Object)e);
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UNEXCEPTED, (String)"\u83b7\u53d6openId\u5f02\u5e38");
        }
        return null;
    }

    public String getOpenIdByCode(GetMobilePhoneByCodeRequestDTO req) {
        String sessionKey = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_SESSION_KEY, req.getCode());
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)sessionKey), (ResultCode)ErrorCode.UNEXCEPTED, (String)"\u83b7\u53d6sessionKey\u4e0d\u5b58\u5728");
        try {
            String str = AesUtil.decryptPeaceWechat(req.getEncrypData(), sessionKey, req.getVi());
            JSONObject jsonObj = JSONObject.parseObject((String)str);
            return jsonObj.getString("purePhoneNumber");
        }
        catch (Exception e) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.UNEXCEPTED, (String)e.toString());
            return null;
        }
    }
}

