/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.RoomApi;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.basic.chat.api.dto.request.EditEvidencePermissionDTO;
import com.beiming.basic.chat.api.dto.request.InductionEvidenceReqDTO;
import com.beiming.basic.chat.api.dto.request.RevokeMsgDto;
import com.beiming.basic.chat.api.dto.request.RoomAttributeInfoResDTO;
import com.beiming.basic.chat.api.dto.response.EvidencePermissionResDTO;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.basic.chat.api.dto.response.MemberRoomsNewResDTO;
import com.beiming.basic.chat.api.dto.response.MemberRoomsResDTO;
import com.beiming.basic.chat.api.dto.response.RoomResDTO;
import com.beiming.basic.chat.api.enums.CallStatusEnums;
import com.beiming.basic.chat.api.enums.MessageResourceEnums;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.api.DocumentApi;
import com.beiming.odr.document.dto.responsedto.DocumentResDTO;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.MemberRoleTypeEnums;
import com.beiming.odr.peace.domain.dto.IntoRoomMediationDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ChatMsgRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CheckFileDataPermissionRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.EditEvidencePermissionRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.EvidencePermissionRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.InductionEvidenceRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.IntoMediationRoomUserRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.EvidenceProviderResDTO;
import com.beiming.odr.peace.domain.dto.responsedto.EvidenceReviewPermissionResDTO;
import com.beiming.odr.peace.domain.dto.responsedto.GroupChatMsgResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntoRoomMediationResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MessageResponseDTO;
import com.beiming.odr.peace.im.api.UnreadMessageApi;
import com.beiming.odr.peace.im.api.dto.response.UnreadMessageListResponseDTO;
import com.beiming.odr.peace.service.ChatService;
import com.beiming.odr.peace.service.backend.user.UserDubboService;
import com.beiming.odr.peace.service.convert.ChatConvertUtils;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MediationMeetingTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ChatServiceImpl
implements ChatService {
    private static final Logger log = LoggerFactory.getLogger(ChatServiceImpl.class);
    @Resource
    private RoomApi roomApi;
    @Resource
    private UnreadMessageApi unreadMessageApi;
    @Resource
    private UserDubboService userDubboService;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private DocumentApi documentApi;
    @Value(value="${obligationNotice.userId}")
    private Long firstMsgSenderId;

    @Override
    public PageInfo<MessageResponseDTO> oneToOneMessageList(ChatMsgRequestDTO dto) {
        DubboResult result = this.roomApi.listMessage(ChatConvertUtils.toListMessageReqDTO(dto));
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)result.getMessage());
        PageInfo pageInfo = (PageInfo)result.getData();
        List<MessageResponseDTO> list = ChatConvertUtils.toChatResDTO(((PageInfo)result.getData()).getList());
        return new PageInfo(list, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }

    @Override
    public PageInfo<MessageResponseDTO> listAllMessage(final ChatMsgRequestDTO dto) {
        String currentUserId;
        final String appName = AppNameContextHolder.getAppName();
        log.info("listAllMessage appName is :{}", (Object)appName);
        if (StringUtils.isNotBlank((CharSequence)dto.getSender())) {
            currentUserId = dto.getSender();
            dto.setSender(null);
        } else {
            currentUserId = JWTContextUtil.getCurrentUserId();
        }
        DubboResult roomInfoRes = this.roomApi.getRoom(dto.getRoomId());
        AssertUtils.assertFalse((roomInfoRes == null || roomInfoRes.getData() == null ? 1 : 0) != 0, (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u623f\u95f4id\u6709\u8bef");
        final List members = ((RoomResDTO)roomInfoRes.getData()).getMembers();
        DubboResult dubboResult = this.roomApi.listMessage(ChatConvertUtils.toListMessageReqDTO(dto));
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        PageInfo pageInfo = (PageInfo)dubboResult.getData();
        List<MessageResponseDTO> list = ChatConvertUtils.toChatResDTO(((PageInfo)dubboResult.getData()).getList());
        list = this.handlerDocumentData(list, dto);
        List<Long> userIds = list.stream().map(MessageResponseDTO::getSender).filter(sender -> Objects.nonNull(sender)).map(MemberResDTO::getMemberId).map(id -> Long.parseLong(id)).distinct().collect(Collectors.toList());
        final Map<Long, UserInfoDTO> userInfoMap = this.userDubboService.getUserInfoMap(userIds);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        final CountDownLatch cdl = new CountDownLatch(list.size());
        log.info("====== \u7ebf\u7a0b\u5f00\u59cb =====");
        for (final MessageResponseDTO res : list) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String threadAppName = AppNameContextHolder.getAppName();
                        log.info("threadAppName is :{}", (Object)threadAppName);
                        AppNameContextHolder.setAppName((String)appName);
                        String userIdsStr = StringUtils.isNotBlank((CharSequence)res.getUserIds()) ? res.getUserIds() : "";
                        List readUserIds = Arrays.stream(StringUtils.split((String)userIdsStr, (String)",")).distinct().collect(Collectors.toList());
                        if (!readUserIds.contains(currentUserId)) {
                            log.info("\u6dfb\u52a0\u5df2\u8bfb\u4eba\u5458id\uff1a{}", (Object)currentUserId);
                            readUserIds.add(currentUserId);
                            String joinUserIds = String.join((CharSequence)",", readUserIds);
                            ChatServiceImpl.this.roomApi.addUserId(res.getId(), joinUserIds);
                            res.setUserIds(joinUserIds);
                        }
                        if (res.getMessageContent().equals("\u5bf9\u65b9\u65e0\u5e94\u7b54") && MessageResourceEnums.VOICE_CALL.name().equals(res.getMessageResource()) && res.getSender() != null && !res.getSender().getMemberId().equals(currentUserId)) {
                            res.setMessageContent("\u672a\u5e94\u7b54");
                        }
                        if (res.getMessageContent().equals("\u5df2\u53d6\u6d88") && MessageResourceEnums.VOICE_CALL.name().equals(res.getMessageResource()) && res.getSender() != null && !res.getSender().getMemberId().equals(currentUserId)) {
                            res.setMessageContent("\u5bf9\u65b9\u5df2\u53d6\u6d88");
                        }
                        if (res.getMessageContent().equals("\u5df2\u62d2\u7edd") && MessageResourceEnums.VOICE_CALL.name().equals(res.getMessageResource()) && res.getSender() != null && res.getSender().getMemberId().equals(currentUserId)) {
                            res.setMessageContent("\u5bf9\u65b9\u5df2\u62d2\u7edd");
                        }
                        if (dto.getIsAllRead().booleanValue() && res.getSender() != null) {
                            ChatServiceImpl.getReadStatus(readUserIds, members, res);
                        } else {
                            log.info("listAllMessage @currentUserId:{}", (Object)currentUserId);
                            if (res.getSender() != null && res.getSender().getMemberId().equals(currentUserId)) {
                                ChatServiceImpl.getReadStatus(readUserIds, members, res);
                            }
                        }
                        MemberResDTO sender = res.getSender();
                        if (Objects.nonNull(sender)) {
                            sender.setRoomId(null);
                            res.setSenderHeadUrl(((UserInfoDTO)userInfoMap.get(Long.parseLong(sender.getMemberId()))).getHeadPortraitUrl());
                        } else {
                            Map<Long, UserInfoDTO> user = ChatServiceImpl.this.userDubboService.getUserInfoMap(Arrays.asList(ChatServiceImpl.this.firstMsgSenderId));
                            res.setSenderHeadUrl(StringUtils.trimToEmpty((String)user.get(ChatServiceImpl.this.firstMsgSenderId).getHeadPortraitUrl()));
                        }
                    }
                    catch (Exception e) {
                        log.info("thread error \u67e5\u8be2\u804a\u5929\u8bb0\u5f55\u591a\u7ebf\u7a0b\u9519\u8bef:", (Throwable)e);
                    }
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        executor.shutdown();
        log.info("====== \u7ebf\u7a0b\u7ed3\u675f =====");
        List resultList = list.stream().filter(x -> !MessageResourceEnums.VOICE_CALL.name().equals(x.getMessageResource()) || !CallStatusEnums.INTERRUPT.getMsg().equals(x.getMessageContent()) || x.getSender() == null || currentUserId.equals(x.getSender().getMemberId())).collect(Collectors.toList());
        return new PageInfo(resultList, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }

    private static void getReadStatus(List<String> readUserIds, List<MemberResDTO> members, MessageResponseDTO res) {
        if (readUserIds.size() == members.size()) {
            res.setAllRead(Boolean.valueOf(true));
        } else {
            List unReadUsers = members.stream().filter(x -> !readUserIds.contains(x.getMemberId())).collect(Collectors.toList());
            res.setUnReadNum(Integer.valueOf(unReadUsers.size()));
            res.setUnReadUsers(unReadUsers);
            List readUsers = members.stream().filter(x -> readUserIds.contains(x.getMemberId()) && !res.getSender().getMemberId().equals(x.getMemberId())).collect(Collectors.toList());
            res.setReadNum(Integer.valueOf(members.size() - unReadUsers.size() - 1));
            res.setReadUsers(readUsers);
        }
    }

    private List<MessageResponseDTO> handlerDocumentData(List<MessageResponseDTO> list, ChatMsgRequestDTO dto) {
        List docIdList = list.stream().filter(messageResponseDTO -> "DOCUMENT".equals(messageResponseDTO.getCategoryBig())).map(MessageResponseDTO::getFileId).collect(Collectors.toList());
        if ("DOCUMENT".equals(dto.getCategoryBig())) {
            ArrayList data = new ArrayList();
            if (CollectionUtils.isNotEmpty(docIdList)) {
                DubboResult docDubboResult = this.documentApi.queryDocumentByIds(docIdList);
                AssertUtils.assertTrue((boolean)docDubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)docDubboResult.getMessage());
                data = (ArrayList)docDubboResult.getData();
            }
            ArrayList docIds = CollectionUtils.isNotEmpty(data) ? data.stream().map(DocumentResDTO::getId).collect(Collectors.toList()) : new ArrayList();
            list = list.stream().filter(messageResponseDTO -> "DOCUMENT".equals(messageResponseDTO.getCategoryBig()) && CollectionUtils.isNotEmpty((Collection)docIds) && docIds.contains(Long.valueOf(messageResponseDTO.getFileId()))).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public IntoRoomMediationResponseDTO intoMediationRoom(IntoMediationRoomUserRequestDTO reqDTO) {
        Map<String, String> allRoomUserInfoMap;
        IntoRoomMediationResponseDTO responseDTO = new IntoRoomMediationResponseDTO();
        ArrayList intoRoomMediationDTOList = Lists.newArrayList();
        String groupRoomId = reqDTO.getRoomId();
        DubboResult allRoomInfoDubbo = this.roomApi.queryAllNewRoomInfo(reqDTO.getBizRoomId(), reqDTO.getMemberId());
        AssertUtils.assertTrue((boolean)allRoomInfoDubbo.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)allRoomInfoDubbo.getMessage());
        ArrayList memberRooms = (ArrayList)allRoomInfoDubbo.getData();
        log.info("\u67e5\u8be2allRoomInfoDubbo: " + JSONObject.toJSONString((Object)memberRooms));
        boolean isInRoom = memberRooms.stream().anyMatch(m -> StringUtils.equals((CharSequence)m.getMemberId(), (CharSequence)reqDTO.getMemberId()));
        AssertUtils.assertTrue((boolean)isInRoom, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e\u8be5\u8c03\u89e3\u5ba4!");
        AssertUtils.assertHasText((String)groupRoomId, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u7fa4\u804a\u623f\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        List allRoomUserInfoList = memberRooms.stream().filter(m -> "PRIVATE_CHAT".equals(m.getSubjectType())).collect(Collectors.toList());
        log.info("\u67e5\u8be2allRoomUserInfoList: " + JSONObject.toJSONString(allRoomUserInfoList));
        Optional<String> optionalAttr = memberRooms.stream().filter(m -> "GROUP_CHAT".equals(m.getSubjectType())).map(MemberRoomsResDTO::getBizAttrJson).findFirst();
        String bizAttrJson = optionalAttr.get();
        JSONObject json = (JSONObject)JSONObject.parse((String)bizAttrJson);
        responseDTO.setBizRoomName(json.getString("roomName"));
        DubboResult dubboResult = this.roomApi.getRoom(groupRoomId);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        RoomResDTO roomResDTO = (RoomResDTO)dubboResult.getData();
        List<MemberResDTO> memberList = ((RoomResDTO)dubboResult.getData()).getMembers();
        log.info("\u67e5\u8be2memberList: " + JSONObject.toJSONString((Object)memberList));
        log.info("\u67e5\u8be2\u8c03\u89e3\u5ba4\u623f\u95f4\u4fe1\u606f: " + JSONObject.toJSONString((Object)roomResDTO));
        responseDTO.setRoomId(groupRoomId);
        responseDTO.setBizRoomId(reqDTO.getBizRoomId());
        responseDTO.setMemberCount(Integer.valueOf(memberList.size()));
        responseDTO.setRoomStatus(roomResDTO.getRoomStatus());
        if (reqDTO.getMaster().booleanValue()) {
            memberList = memberList.stream().filter(m -> !m.isMaster()).collect(Collectors.toList());
            allRoomUserInfoMap = allRoomUserInfoList.stream().filter(r -> MemberRoleTypeEnums.NORMAL.name().equals(r.getMemberRoleType())).collect(Collectors.toMap(MemberRoomsResDTO::getMemberId, MemberRoomsNewResDTO::getId));
        } else {
            memberList = memberList.stream().filter(MemberResDTO::isMaster).collect(Collectors.toList());
            allRoomUserInfoMap = allRoomUserInfoList.stream().filter(r -> MemberRoleTypeEnums.MASTER.name().equals(r.getMemberRoleType())).collect(Collectors.toMap(MemberRoomsResDTO::getMemberId, MemberRoomsNewResDTO::getId));
        }
        DubboResult dubboRs = this.unreadMessageApi.getUnreadMessageListByUserIdAndSubjectId(reqDTO.getMemberId(), reqDTO.getBizRoomId());
        AssertUtils.assertTrue((boolean)dubboRs.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboRs.getMessage());
        List unreadMessageList = (List)((Object)dubboRs.getData());
        if (CollectionUtils.isEmpty((Collection)unreadMessageList)) {
            unreadMessageList = Lists.newArrayList();
        }
        DubboResult booleanDubboResult = this.mediationRoomApi.getAuthFlagByMediationRoomId(Long.valueOf(Long.parseLong(reqDTO.getBizRoomId())));
        AssertUtils.assertTrue((boolean)booleanDubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)booleanDubboResult.getMessage());
        responseDTO.setIsVerify((Boolean)booleanDubboResult.getData());
        log.info("\u67e5\u8be2\u67d0\u8c03\u89e3\u5ba4\u4e0b\u7684\u672a\u8bfb\u6d88\u606f: " + JSONObject.toJSONString((Object)unreadMessageList));
        Map<String, UnreadMessageListResponseDTO> unreadMsgOneToOneMap = unreadMessageList.stream().filter(dto -> !reqDTO.getRoomId().equals(dto.getRoomId())).collect(Collectors.toMap(UnreadMessageListResponseDTO::getRoomId, Function.identity()));
        UnreadMessageListResponseDTO groupChatNoReadMsg = unreadMessageList.stream().filter(dto -> reqDTO.getRoomId().equals(dto.getRoomId())).findFirst().orElse(new UnreadMessageListResponseDTO());
        groupChatNoReadMsg.setRoomId(reqDTO.getRoomId());
        GroupChatMsgResponseDTO msgResponseDTO = ChatConvertUtils.toGroupChatMsgResponseDTO(groupChatNoReadMsg);
        Integer unReadGroupCount = msgResponseDTO.getUnreadMessageCount();
        if (Objects.isNull(unReadGroupCount) || unReadGroupCount == 0) {
            MessageResponseDTO lastMsg = this.getLastMessage(reqDTO.getRoomId(), reqDTO.getMemberId());
            if (Objects.nonNull(lastMsg.getSender())) {
                msgResponseDTO.setUserRoleType(lastMsg.getSender().getMemberType());
                msgResponseDTO.setMemberName(lastMsg.getSender().getMemberName());
            }
            msgResponseDTO.setCategoryBig(lastMsg.getCategoryBig());
            msgResponseDTO.setLastMessageTime(lastMsg.getCreateTime());
            msgResponseDTO.setLastMessageContent(lastMsg.getMessageContent());
            msgResponseDTO.setMessageResource(lastMsg.getMessageResource());
        }
        responseDTO.setGroupChatMsg(msgResponseDTO);
        responseDTO.setMembers(this.getUserInfoList(reqDTO, intoRoomMediationDTOList, memberList, allRoomUserInfoMap, unreadMsgOneToOneMap, Long.parseLong(reqDTO.getBizRoomId())));
        DubboResult meetingInfo = this.mediationRoomApi.selectCaseMeetingInfo(Long.valueOf(Long.parseLong(reqDTO.getBizRoomId())));
        CaseMeetingRoomInfoResDTO caseMeetingRoomInfo = (CaseMeetingRoomInfoResDTO)meetingInfo.getData();
        if (caseMeetingRoomInfo.getExpandAttribute() != null) {
            JSONObject meetingJson = JSONObject.parseObject((String)caseMeetingRoomInfo.getExpandAttribute());
            responseDTO.setCaseType(meetingJson.getString(ColumnEnums.CASE_TYPE.desc()));
        }
        log.info("\u8fdb\u5165\u8c03\u89e3\u5ba4\u8fd4\u56de\u53c2: " + responseDTO);
        return responseDTO;
    }

    private List<IntoRoomMediationDTO> getUserInfoList(IntoMediationRoomUserRequestDTO reqDTO, List<IntoRoomMediationDTO> intoRoomMediationDTOList, List<MemberResDTO> memberList, Map<String, String> allRoomUserInfoMap, Map<String, UnreadMessageListResponseDTO> unreadMsgOneToOneMap, Long bizRoomId) {
        List<Long> userIds = memberList.stream().map(m -> Long.parseLong(m.getMemberId())).distinct().collect(Collectors.toList());
        Map<Long, UserInfoDTO> userInfoMap = this.userDubboService.getUserInfoMap(userIds);
        for (MemberResDTO m2 : memberList) {
            DubboResult result;
            UserInfoDTO userInfoDTO = userInfoMap.getOrDefault(Long.parseLong(m2.getMemberId()), new UserInfoDTO());
            UnreadMessageListResponseDTO unreadOneToOneMsg = unreadMsgOneToOneMap.getOrDefault(m2.getRoomId(), new UnreadMessageListResponseDTO());
            Integer unReadCount = unreadOneToOneMsg.getUnreadCount();
            unReadCount = Objects.isNull(unReadCount) ? 0 : unReadCount;
            IntoRoomMediationDTO roomInfo = new IntoRoomMediationDTO();
            String roomId = allRoomUserInfoMap.get(m2.getMemberId());
            AssertUtils.assertHasText((String)roomId, (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)"\u623f\u95f4\u4eba\u5458\u6570\u636e\u6709\u8bef");
            roomInfo.setRoomId(roomId);
            roomInfo.setMemberId(m2.getMemberId());
            roomInfo.setHeadUrl(userInfoDTO.getHeadPortraitUrl());
            roomInfo.setMemberName(m2.getMemberName());
            roomInfo.setIsFacialVerify(userInfoDTO.getIsFacialVerify());
            roomInfo.setUnreadMessageCount(unReadCount);
            roomInfo.setLastMessageTime(unreadOneToOneMsg.getLastUpdateTime());
            roomInfo.setLastMessageContent(unreadOneToOneMsg.getMessageContent());
            roomInfo.setCategoryBig(unreadOneToOneMsg.getMessageType());
            roomInfo.setMessageResource(unreadOneToOneMsg.getMessageResource());
            roomInfo.setMeetingUserType(m2.getMemberType());
            roomInfo.setMobilePhone(userInfoDTO.getMobilePhone());
            if (unReadCount == 0) {
                log.info("\u8fdb\u5165getLastMessage: " + roomInfo);
                MessageResponseDTO lastMsg = this.getLastMessage(roomInfo.getRoomId(), m2.getMemberId());
                roomInfo.setCategoryBig(lastMsg.getCategoryBig());
                roomInfo.setLastMessageTime(lastMsg.getCreateTime());
                roomInfo.setLastMessageContent(lastMsg.getMessageContent());
                roomInfo.setMessageResource(Objects.toString(lastMsg.getMessageResource(), null));
            }
            if ((result = this.mediationRoomApi.getMediationRoomUserInfoList(Long.valueOf(Long.parseLong(m2.getMemberId())), bizRoomId)).getData() != null && ((ArrayList)result.getData()).size() > 0) {
                MediationRoomUserInfoResDTO meetingUser = (MediationRoomUserInfoResDTO)((ArrayList)result.getData()).get(0);
                if (meetingUser.getExpandAttribute() != null) {
                    JSONObject json = JSONObject.parseObject((String)meetingUser.getExpandAttribute());
                    roomInfo.setLitigantType(json.getInteger(ColumnEnums.LITIGANT_TYPE.desc()));
                    roomInfo.setCreditCode(json.getString(ColumnEnums.CREDIT_CODE.desc()));
                    roomInfo.setOriginalLitigationStatus(json.getInteger(ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc()));
                    roomInfo.setUnitName(json.getString(ColumnEnums.UNIT_NAME.desc()));
                    roomInfo.setIsUndertaker(json.getInteger(ColumnEnums.IS_UNDERTAKER.desc()));
                    roomInfo.setLitigationStatus(json.getInteger(ColumnEnums.LITIGATION_STATUS.desc()));
                }
                roomInfo.setUserTempId(meetingUser.getRemark());
            }
            intoRoomMediationDTOList.add(roomInfo);
        }
        return intoRoomMediationDTOList;
    }

    private MessageResponseDTO getLastMessage(String roomId, String memberId) {
        ChatMsgRequestDTO requestDTO = new ChatMsgRequestDTO();
        requestDTO.setRoomId(roomId);
        requestDTO.setReceiverId(memberId);
        requestDTO.setPageIndex(Integer.valueOf(1));
        requestDTO.setPageSize(Integer.valueOf(1));
        PageInfo<MessageResponseDTO> msg = this.listAllMessage(requestDTO);
        return CollectionUtils.isEmpty((Collection)msg.getList()) ? new MessageResponseDTO() : (MessageResponseDTO)msg.getList().get(0);
    }

    @Override
    public PageInfo<MessageResponseDTO> inductionEvidence(InductionEvidenceRequestDTO dto) {
        List<Object> ids = new ArrayList<String>();
        ids.add(dto.getRoomId());
        DubboResult caseMeetingDubbo = this.mediationRoomApi.mediationRoomById(dto.getBizRoomId());
        AssertUtils.assertNotNull((Object)caseMeetingDubbo.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        CaseMeetingInfoResDTO caseMeeting = (CaseMeetingInfoResDTO)caseMeetingDubbo.getData();
        if (MediationMeetingTypeEnum.MEDIATION_ROOM.name().equals(caseMeeting.getMediationMeetingType())) {
            DubboResult caseMeetingsDubbo;
            log.info("roomIds:{}", (Object)caseMeeting.getRoomIds());
            if (!StringUtils.isBlank((String)caseMeeting.getRoomIds())) {
                String[] roomIds = caseMeeting.getRoomIds().split(",");
                for (String roomId : roomIds) {
                    ids.add(roomId);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)(caseMeetingsDubbo = this.mediationRoomApi.mediationRoomByParentId(caseMeeting.getId())).getData())))) {
                for (CaseMeetingInfoResDTO one : (ArrayList)caseMeetingsDubbo.getData()) {
                    ids.add(one.getRoomId());
                }
            }
        } else if (MediationMeetingTypeEnum.MEDIATION_MEETING.name().equals(caseMeeting.getMediationMeetingType()) && caseMeeting.getParentId() != null) {
            DubboResult caseMeetingsDubbo;
            DubboResult caseRoomDubbo = this.mediationRoomApi.mediationRoomById(caseMeeting.getParentId());
            if (caseRoomDubbo.getData() != null) {
                ids.add(((CaseMeetingInfoResDTO)caseRoomDubbo.getData()).getRoomId());
            }
            if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)(caseMeetingsDubbo = this.mediationRoomApi.mediationRoomByParentId(caseMeeting.getParentId())).getData())))) {
                for (CaseMeetingInfoResDTO one : (ArrayList)caseMeetingsDubbo.getData()) {
                    ids.add(one.getRoomId());
                }
            }
        }
        String dataPermission = this.getDataPermission(dto.getBizRoomId());
        InductionEvidenceReqDTO reqDTO = new InductionEvidenceReqDTO();
        ids = ids.stream().distinct().collect(Collectors.toList());
        reqDTO.setRoomIds(ids);
        reqDTO.setPageIndex(dto.getPageIndex());
        reqDTO.setPageSize(dto.getPageSize());
        reqDTO.setDataPermission(dataPermission);
        reqDTO.setSenderId(dto.getSenderId());
        DubboResult dubboResult = this.roomApi.inductionEvidence(reqDTO);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        PageInfo pageInfo = (PageInfo)dubboResult.getData();
        List<MessageResponseDTO> list = ChatConvertUtils.toChatResDTO(((PageInfo)dubboResult.getData()).getList());
        List<Long> userIds = list.stream().map(MessageResponseDTO::getSender).map(MemberResDTO::getMemberId).map(id -> Long.parseLong(id)).distinct().collect(Collectors.toList());
        Map<Long, UserInfoDTO> userInfoMap = this.userDubboService.getUserInfoMap(userIds);
        list.forEach(res -> {
            DubboResult roomInfo;
            MemberResDTO sender = res.getSender();
            if (Objects.nonNull(sender)) {
                sender.setRoomId(null);
                res.setSenderHeadUrl(((UserInfoDTO)userInfoMap.get(Long.parseLong(sender.getMemberId()))).getHeadPortraitUrl());
            }
            if ((roomInfo = this.roomMediationApi.getRoomByRoomId(res.getRoomId())).getData() != null) {
                if ("CHAT".equals(((RoomAttributeInfoResDTO)roomInfo.getData()).getBizRoomType())) {
                    res.setEvidenceResource("\u6848\u4ef6\u7a7a\u95f4");
                    String subjectType = ((RoomAttributeInfoResDTO)roomInfo.getData()).getSubjectType();
                    List<String> memberNames = this.setMemeberName(subjectType, res.getRoomId());
                    res.setMemberName(memberNames);
                    DubboResult meetingInfo = this.mediationRoomApi.mediationRoomById(Long.valueOf(((RoomAttributeInfoResDTO)roomInfo.getData()).getBizRoomId()));
                    res.setCaseNumber(((CaseMeetingInfoResDTO)meetingInfo.getData()).getName());
                } else if ("VIDEO".equals(((RoomAttributeInfoResDTO)roomInfo.getData()).getBizRoomType())) {
                    res.setEvidenceResource("\u5728\u7ebf\u5ead\u5ba1");
                    DubboResult meetingInfo = this.mediationRoomApi.mediationRoomById(Long.valueOf(((RoomAttributeInfoResDTO)roomInfo.getData()).getBizRoomId()));
                    res.setCaseNumber(((CaseMeetingInfoResDTO)meetingInfo.getData()).getName());
                }
            }
            res.setRoomId(null);
        });
        return new PageInfo(list, pageInfo.getTotalRows(), pageInfo.getPageIndex(), pageInfo.getPageSize());
    }

    @Override
    public int revokeMsg(RevokeMsgDto dto) {
        DubboResult dubboResult = this.roomApi.revokeMsg(dto);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        return (Integer)dubboResult.getData();
    }

    @Override
    public Boolean checkDataPermission(CheckFileDataPermissionRequestDTO dto) {
        Long bizRoomId = dto.getBizRoomId();
        String dataPermission = this.getDataPermission(bizRoomId);
        if (StringUtils.isBlank((String)dataPermission)) {
            return false;
        }
        DubboResult dubboResult = this.roomApi.getChatInfoPermissionByChatId(dto.getId());
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        EvidencePermissionResDTO data = (EvidencePermissionResDTO)dubboResult.getData();
        if (null == data) {
            return false;
        }
        String permission = data.getDataPermission();
        if ("ALL".equals(permission) || permission.equals(dataPermission) || "MEDIATOR".equals(dataPermission)) {
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<EvidenceReviewPermissionResDTO> evidenceReviewPermissions(EvidencePermissionRequestDTO dto) {
        ArrayList<EvidenceReviewPermissionResDTO> resultList = new ArrayList<EvidenceReviewPermissionResDTO>();
        EvidenceReviewPermissionResDTO allPermission = new EvidenceReviewPermissionResDTO();
        allPermission.setKey("\u5168\u90e8\u53ef\u89c1");
        allPermission.setValue("ALL");
        resultList.add(allPermission);
        Long bizRoomId = dto.getBizRoomId();
        DubboResult dubboResult = this.mediationRoomApi.getMediationRoomAllUserInfoList(bizRoomId);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        ArrayList data = (ArrayList)dubboResult.getData();
        List commonList = data.stream().filter(x -> !"MEDIATOR".equals(x.getMeetingUserType()) && !"CLERK".equals(x.getMeetingUserType()) && !"ASSISTANT_JUDGE".equals(x.getMeetingUserType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(commonList)) {
            for (MediationRoomUserInfoResDTO datum : commonList) {
                String meetingUserType = datum.getMeetingUserType();
                String meetingUserTypeName = datum.getMeetingUserTypeName();
                EvidenceReviewPermissionResDTO temp = new EvidenceReviewPermissionResDTO();
                temp.setKey(meetingUserTypeName + "\u53ef\u89c1");
                temp.setValue(meetingUserType);
                resultList.add(temp);
            }
        }
        EvidenceReviewPermissionResDTO mediatorPermission = new EvidenceReviewPermissionResDTO();
        mediatorPermission.setKey("\u6cd5\u9662\u53ef\u89c1");
        mediatorPermission.setValue("MEDIATOR");
        resultList.add(mediatorPermission);
        EvidenceReviewPermissionResDTO invisiblePermission = new EvidenceReviewPermissionResDTO();
        invisiblePermission.setKey("\u5168\u90e8\u4e0d\u53ef\u89c1");
        invisiblePermission.setValue("INVISIBLE");
        resultList.add(invisiblePermission);
        return resultList;
    }

    @Override
    public ArrayList<EvidenceProviderResDTO> evidenceProviders(EvidencePermissionRequestDTO dto) {
        ArrayList<EvidenceProviderResDTO> resultList = new ArrayList<EvidenceProviderResDTO>();
        Long bizRoomId = dto.getBizRoomId();
        DubboResult dubboResult = this.mediationRoomApi.getMediationRoomAllUserInfoList(bizRoomId);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        ArrayList data = (ArrayList)dubboResult.getData();
        List commonList = data.stream().filter(x -> !"MEDIATOR".equals(x.getMeetingUserType()) && !"CLERK".equals(x.getMeetingUserType()) && !"ASSISTANT_JUDGE".equals(x.getMeetingUserType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(commonList)) {
            Map<String, List<MediationRoomUserInfoResDTO>> groupMap = commonList.stream().collect(Collectors.groupingBy(MediationRoomUserInfoResDTO::getMeetingUserType));
            groupMap.forEach((key, values) -> {
                if (values.size() == 1) {
                    EvidenceProviderResDTO evidenceProviderResDTO = new EvidenceProviderResDTO();
                    evidenceProviderResDTO.setSenderId(Arrays.asList(((MediationRoomUserInfoResDTO)values.get(0)).getUserId()));
                    evidenceProviderResDTO.setKey(((MediationRoomUserInfoResDTO)values.get(0)).getMeetingUserTypeName() + "\uff1a" + ((MediationRoomUserInfoResDTO)values.get(0)).getUserName());
                    resultList.add(evidenceProviderResDTO);
                } else {
                    for (int i = 0; i < values.size(); ++i) {
                        Long userId = ((MediationRoomUserInfoResDTO)values.get(i)).getUserId();
                        String userName = ((MediationRoomUserInfoResDTO)values.get(i)).getUserName();
                        String meetingUserTypeName = ((MediationRoomUserInfoResDTO)values.get(i)).getMeetingUserTypeName();
                        EvidenceProviderResDTO evidenceProviderResDTO = new EvidenceProviderResDTO();
                        evidenceProviderResDTO.setSenderId(Arrays.asList(userId));
                        evidenceProviderResDTO.setKey(meetingUserTypeName + (i + 1) + "\uff1a" + userName);
                        resultList.add(evidenceProviderResDTO);
                    }
                }
            });
        }
        EvidenceProviderResDTO evidenceProviderResDTO = new EvidenceProviderResDTO();
        List mediatorIds = data.stream().filter(x -> "MEDIATOR".equals(x.getMeetingUserType()) || "CLERK".equals(x.getMeetingUserType()) || "ASSISTANT_JUDGE".equals(x.getMeetingUserType())).map(MediationRoomUserInfoResDTO::getUserId).collect(Collectors.toList());
        evidenceProviderResDTO.setSenderId(mediatorIds);
        evidenceProviderResDTO.setKey("\u6cd5\u9662");
        resultList.add(evidenceProviderResDTO);
        return resultList;
    }

    @Override
    public Boolean editEvidencePermission(EditEvidencePermissionRequestDTO dto) {
        Long bizRoomId = dto.getBizRoomId();
        String currentUserId = JWTContextUtil.getCurrentUserId();
        DubboResult dubboResult = this.mediationRoomApi.getMediationRoomAllUserInfoList(bizRoomId);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        ArrayList data = (ArrayList)dubboResult.getData();
        Optional<MediationRoomUserInfoResDTO> first = data.stream().filter(x -> currentUserId.equals(String.valueOf(x.getUserId()))).findFirst();
        MediationRoomUserInfoResDTO mediationRoomUserInfoResDTO = first.get();
        AssertUtils.assertTrue(("MEDIATOR".equals(mediationRoomUserInfoResDTO.getMeetingUserType()) || "CLERK".equals(mediationRoomUserInfoResDTO.getMeetingUserType()) || "ASSISTANT_JUDGE".equals(mediationRoomUserInfoResDTO.getMeetingUserType()) ? 1 : 0) != 0, (ResultCode)ErrorCode.EDIT_EVIDENCE_PERMISSION_NO, (String)ErrorCode.EDIT_EVIDENCE_PERMISSION_NO.desc());
        EditEvidencePermissionDTO editEvidencePermissionDTO = new EditEvidencePermissionDTO();
        editEvidencePermissionDTO.setChatInfoId(dto.getChatInfoId());
        editEvidencePermissionDTO.setDataPermission(dto.getDataPermission());
        DubboResult flag = this.roomApi.editEvidencePermission(editEvidencePermissionDTO);
        AssertUtils.assertTrue((boolean)flag.isSuccess(), (ResultCode)APIResultCodeEnums.FAIL_DATABASE, (String)dubboResult.getMessage());
        return (Boolean)flag.getData();
    }

    public List<String> setMemeberName(String subjectType, String roomId) {
        DubboResult memberRes;
        ArrayList<String> memeberNames = new ArrayList<String>();
        if ("PRIVATE_CHAT".equals(subjectType) && !CollectionUtils.isEmpty((Collection)((Collection)((Object)(memberRes = this.roomMediationApi.getRoomMembers(roomId)).getData())))) {
            for (MemberResDTO memberRe : (ArrayList)memberRes.getData()) {
                memeberNames.add(memberRe.getMemberName());
            }
        }
        return memeberNames;
    }

    private String getDataPermission(Long bizRoomId) {
        String currentUserId = JWTContextUtil.getCurrentUserId();
        DubboResult mediationRoomAllUserInfoList = this.mediationRoomApi.getMediationRoomAllUserInfoList(bizRoomId);
        AssertUtils.assertNotNull((Object)mediationRoomAllUserInfoList.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ArrayList mediationRoomAllUserList = (ArrayList)mediationRoomAllUserInfoList.getData();
        Optional<MediationRoomUserInfoResDTO> currentUserInfoOptional = mediationRoomAllUserList.stream().filter(x -> currentUserId.equals(String.valueOf(x.getUserId()))).findFirst();
        MediationRoomUserInfoResDTO currentUserInfo = null;
        if (!currentUserInfoOptional.isPresent()) {
            return "";
        }
        currentUserInfo = currentUserInfoOptional.get();
        String meetingUserType = currentUserInfo.getMeetingUserType();
        String dataPermission = "MEDIATOR".equals(meetingUserType) || "CLERK".equals(meetingUserType) || "ASSISTANT_JUDGE".equals(meetingUserType) ? "MEDIATOR" : meetingUserType;
        return dataPermission;
    }
}

