/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.api.AttachmentApi;
import com.beiming.odr.document.dto.requestdto.ObjectReqDTO;
import com.beiming.odr.peace.api.PeaceIntranetApi;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.TempUserDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMediationMeetingUserRequestMicroDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddMeetingIntranetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.InductionEvidenceRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SendRtmpRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMediationRoomUserRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UpdateMeetingYanChengRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MessageResponseDTO;
import com.beiming.odr.peace.im.api.IntranetPeaceImApi;
import com.beiming.odr.peace.im.api.dto.request.InvitationVideoSendTextRequestDTO;
import com.beiming.odr.peace.service.ChatService;
import com.beiming.odr.peace.service.IntranetYanChengService;
import com.beiming.odr.peace.service.UserService;
import com.beiming.odr.peace.service.convert.PersonalConvert;
import com.beiming.odr.peace.service.util.DateUtil;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.IntranetApi;
import com.beiming.odr.referee.api.MediationMeetingApi;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.MeetingInfoRequestDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MeetingVideoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.BackstageUserMicroServiceApi;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntranetYanChengServiceImpl
implements IntranetYanChengService {
    private static final Logger log = LoggerFactory.getLogger(IntranetYanChengServiceImpl.class);
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private UserService userService;
    @Resource
    private IntranetPeaceImApi intranetPeaceImApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private PeaceIntranetApi peaceIntranetApi;
    @Resource
    private BackstageUserMicroServiceApi backstageUserMicroServiceApi;
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private IntranetApi intranetApi;
    @Resource
    private ChatService chatService;
    @Resource
    private AttachmentApi attachmentApi;
    @Resource
    private MediationMeetingApi mediationMeetingApi;

    @Override
    public ArrayList<MeetingVideoResDTO> getCourtVideotape(SendRtmpRequestDTO dto) {
        MeetingInfoRequestDTO meetingInfoRequest = new MeetingInfoRequestDTO();
        meetingInfoRequest.setCaseNumberCode(dto.getCaseNumberCode());
        meetingInfoRequest.setCaseOrder(dto.getCaseOrder());
        meetingInfoRequest.setCourtCode(dto.getCourtCode());
        meetingInfoRequest.setRemark("YAN_CHENG");
        DubboResult dubboResult = this.caseRoomMicroApi.getMeetingRoomInfoByNameAndCaseOrder(meetingInfoRequest);
        AssertUtils.assertNotNull((Object)dubboResult.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        MediationMeetingRoomInfoResDTO mediationMeetingRoomInfo = (MediationMeetingRoomInfoResDTO)dubboResult.getData();
        DubboResult result = this.mediationMeetingRoomApi.getVideoList(mediationMeetingRoomInfo.getId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (ArrayList)result.getData();
    }

    @Override
    public void sendMsg(SendRtmpRequestDTO dto) {
        MeetingInfoRequestDTO meetingInfoRequest = new MeetingInfoRequestDTO();
        meetingInfoRequest.setCaseNumberCode(dto.getCaseNumberCode());
        meetingInfoRequest.setCaseOrder(dto.getCaseOrder());
        meetingInfoRequest.setCourtCode(dto.getCourtCode());
        meetingInfoRequest.setRemark("YAN_CHENG");
        DubboResult dubboResult = this.caseRoomMicroApi.getMeetingRoomInfoByNameAndCaseOrder(meetingInfoRequest);
        AssertUtils.assertNotNull((Object)dubboResult.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        MediationMeetingRoomInfoResDTO mediationMeetingRoomInfo = (MediationMeetingRoomInfoResDTO)dubboResult.getData();
        DubboResult userResult = this.mediationMeetingRoomApi.getMediationRoomUserInfoList(mediationMeetingRoomInfo.getId());
        AssertUtils.assertTrue((boolean)userResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)userResult.getMessage());
        MediationMeetingRoomUserInfoResDTO mediationMeetingRoomInfoRes = (MediationMeetingRoomUserInfoResDTO)userResult.getData();
        List list = mediationMeetingRoomInfoRes.getList();
        ArrayList<String> userList = new ArrayList<String>();
        for (MediationRoomUserInfoResDTO mediationRoomUserInfoRes : list) {
            if (mediationRoomUserInfoRes.getUserId() == null) continue;
            userList.add(mediationRoomUserInfoRes.getUserId().toString());
        }
        String receivers = StringUtils.join(userList, (String)",");
        InvitationVideoSendTextRequestDTO intranetSendText = new InvitationVideoSendTextRequestDTO();
        intranetSendText.setBizRoomId(mediationMeetingRoomInfo.getId().toString());
        intranetSendText.setContent(dto.getContent());
        intranetSendText.setMemberId(dto.getUserId());
        intranetSendText.setReceivers(receivers);
        intranetSendText.setRoomId(mediationMeetingRoomInfo.getRoomId());
        this.intranetPeaceImApi.sendTextYancheng(intranetSendText);
    }

    @Override
    public APIResult updateMediationMeeting(UpdateMeetingYanChengRequestDTO updateRequest) {
        MeetingInfoRequestDTO meetingInfoRequest = new MeetingInfoRequestDTO();
        meetingInfoRequest.setCaseNumberCode(updateRequest.getCaseNumberCode());
        meetingInfoRequest.setCaseOrder(updateRequest.getCaseOrder());
        meetingInfoRequest.setCourtCode(updateRequest.getCourtCode());
        meetingInfoRequest.setRemark("YAN_CHENG");
        DubboResult dubboResult = this.caseRoomMicroApi.getMeetingRoomInfoByNameAndCaseOrder(meetingInfoRequest);
        AssertUtils.assertNotNull((Object)dubboResult.getData(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        MediationMeetingRoomInfoResDTO meetingInfo = (MediationMeetingRoomInfoResDTO)dubboResult.getData();
        if (DateUtil.getMinuteDiff(new Date(), meetingInfo.getOrderTime()) < 0L) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u5df2\u5f00\u5ead,\u4e0d\u53ef\u4fee\u6539\u5ead\u5ba1\u4fe1\u606f");
        }
        ArrayList<LitigantInfoRequestDTO> mediatorList = new ArrayList<LitigantInfoRequestDTO>();
        LitigantInfoRequestDTO mediator = new LitigantInfoRequestDTO();
        mediator.setUserName(updateRequest.getStaffName());
        mediator.setMobilePhone(updateRequest.getMobilePhone());
        mediator.setMeetingUserType(MeetingUserTypeEnum.MEDIATOR);
        mediatorList.add(mediator);
        UpdateMediationRoomUserRequestDTO dto = new UpdateMediationRoomUserRequestDTO();
        dto.setAgentList(updateRequest.getAgentList());
        dto.setLitigantList(updateRequest.getLitigantList());
        dto.setMediationMeetingId(meetingInfo.getId());
        dto.setMediatorList(mediatorList);
        List<TempUserDTO> newUserList = PersonalConvert.allUserList(dto);
        InductionEvidenceRequestDTO evidenceRequest = new InductionEvidenceRequestDTO();
        evidenceRequest.setBizRoomId(meetingInfo.getId());
        List<String> roomIds = Arrays.asList(meetingInfo.getRoomId().split(","));
        evidenceRequest.setRoomId(roomIds.get(0));
        evidenceRequest.setPageIndex(Integer.valueOf(1));
        evidenceRequest.setPageSize(Integer.valueOf(1000));
        PageInfo<MessageResponseDTO> evidenceDubbo = this.chatService.inductionEvidence(evidenceRequest);
        if (evidenceDubbo.getTotalRows() > 0) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u5ead\u5ba1\u5df2\u6709\u4e0a\u4f20\u8bc1\u636e\uff0c\u4e0d\u53ef\u4fee\u6539\u5ead\u5ba1\u4fe1\u606f");
        }
        ObjectReqDTO objectReqDTO = new ObjectReqDTO();
        objectReqDTO.setObjectId(meetingInfo.getId());
        DubboResult result = this.attachmentApi.queryAttachmentNum(objectReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        Integer responseLstDTO = (Integer)result.getData();
        if (responseLstDTO > 0) {
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u5ead\u5ba1\u5df2\u6709\u4e0a\u4f20\u6587\u4e66\uff0c\u4e0d\u53ef\u4fee\u6539\u5ead\u5ba1\u4fe1\u606f");
        }
        DubboResult oldUserListDubbo = this.mediationRoomApi.getMediationRoomAllUserInfoList(meetingInfo.getId());
        if (oldUserListDubbo == null || CollectionUtils.isEmpty((Collection)((Collection)((Object)oldUserListDubbo.getData())))) {
            log.error("\u83b7\u53d6\u5ead\u5ba1\u53c2\u4e0e\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return APIResult.failed((APIResultCodeEnums)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u83b7\u53d6\u5ead\u5ba1\u53c2\u4e0e\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        Map<String, Object> allUserMap = PersonalConvert.allUserMap(dto);
        List<MediationRoomUserInfoResDTO> oldUserList = (List<MediationRoomUserInfoResDTO>)((Object)oldUserListDubbo.getData());
        List<MediationRoomUserInfoResDTO> oldNoPhoneList = PersonalConvert.getMediationRoomUserListNoPhone(oldUserList);
        List<TempUserDTO> newNoPhoneList = PersonalConvert.getTempUserListNoPhone(newUserList);
        List<TempUserDTO> addNoPhoneUserList = PersonalConvert.checkAddNoPhoneParticipants(newNoPhoneList, oldNoPhoneList);
        List<TempUserDTO> deleteNoPhoneUserList = PersonalConvert.checkDeleteNoPhoneParticipants(newNoPhoneList, oldNoPhoneList);
        List<TempUserDTO> updateNoPhoneUserList = PersonalConvert.checkUpdateNoPhoneParticipants(newNoPhoneList, oldNoPhoneList);
        oldUserList = PersonalConvert.getMediationRoomUserListHasPhone(oldUserList);
        newUserList = PersonalConvert.getTempUserListHasPhone(newUserList);
        List<TempUserDTO> addUserList = PersonalConvert.checkAddParticipantsYanCheng(newUserList, oldUserList);
        List<TempUserDTO> deleteUserList = PersonalConvert.checkDeleteParticipantsYanCheng(newUserList, oldUserList);
        List<TempUserDTO> updateUserList = PersonalConvert.checkUpdateParticipantsYanCheng(newUserList, oldUserList);
        this.handleUserIsDelete(meetingInfo.getId(), meetingInfo.getRoomId(), oldUserList, deleteUserList);
        this.handleUserIsAdd(meetingInfo.getId(), allUserMap, addUserList, mediatorList);
        this.handleUserNeedUpdate(meetingInfo.getId(), updateUserList);
        this.handleUserIsDeleteNoPhone(meetingInfo.getId(), meetingInfo.getRoomId(), oldNoPhoneList, deleteNoPhoneUserList);
        this.handleUserIsAddNoPhone(meetingInfo.getId(), allUserMap, addNoPhoneUserList, mediatorList);
        this.handleUserNeedUpdateNoPhone(meetingInfo.getId(), updateNoPhoneUserList);
        this.updateMeetingOrderTimeCauseName(updateRequest, meetingInfo.getId());
        return APIResult.success();
    }

    private void handleUserIsAdd(Long meetingId, Map<String, Object> allUserMap, List<TempUserDTO> addUserList, List<LitigantInfoRequestDTO> mediatorList) {
        if (CollectionUtils.isEmpty(addUserList)) {
            return;
        }
        log.info("\u6709{}\u4e2a\u53c2\u4e0e\u4eba\u9700\u8981\u65b0\u589e", (Object)addUserList.size());
        LitigantInfoRequestDTO createMediator = mediatorList.get(0);
        for (TempUserDTO addUser : addUserList) {
            AddMediationMeetingUserRequestMicroDTO reqDTO;
            String mobilePhone = addUser.getMobilePhone();
            String userType = addUser.getUserType();
            if ("AGENT".equals(userType)) {
                LitigantAgentInfoMicroRequestDTO agent = (LitigantAgentInfoMicroRequestDTO)allUserMap.get(mobilePhone);
                log.info("\u4ee3\u7406\u4eba\u6570\u636e\uff1a{}", (Object)agent.toString());
                reqDTO = new AddMediationMeetingUserRequestMicroDTO();
                reqDTO.setMediationRoomId(meetingId);
                reqDTO.setMediatorName(createMediator.getUserName());
                ArrayList<LitigantAgentInfoMicroRequestDTO> agentList = new ArrayList<LitigantAgentInfoMicroRequestDTO>();
                agentList.add(agent);
                reqDTO.setAgentList(agentList);
                this.invokingAddMethod(reqDTO);
                continue;
            }
            if ("MEDIATOR".equals(userType)) {
                LitigantInfoRequestDTO mediator = (LitigantInfoRequestDTO)allUserMap.get(mobilePhone);
                reqDTO = new AddMediationMeetingUserRequestMicroDTO();
                reqDTO.setMediationRoomId(meetingId);
                ArrayList<LitigantInfoRequestDTO> mediatorLists = new ArrayList<LitigantInfoRequestDTO>();
                mediatorLists.add(mediator);
                reqDTO.setLitigantList(mediatorLists);
                this.invokingAddMethod(reqDTO);
                DubboResult createDubbo = this.peaceIntranetApi.updateMeetingCreateUser(meetingId, mediator);
                if (createDubbo == null) {
                    log.error("duboo\u4fee\u6539\u5ead\u5ba1\u521b\u5efa\u4eba\u5931\u8d25");
                    return;
                }
                if (createDubbo.isSuccess()) continue;
                log.error(createDubbo.getMessage());
                continue;
            }
            if (!"LITIGANT".equals(userType)) continue;
            LitigantInfoRequestDTO litigant = (LitigantInfoRequestDTO)allUserMap.get(mobilePhone);
            reqDTO = new AddMediationMeetingUserRequestMicroDTO();
            reqDTO.setMediationRoomId(meetingId);
            reqDTO.setMediatorName(createMediator.getUserName());
            ArrayList<LitigantInfoRequestDTO> litigantList = new ArrayList<LitigantInfoRequestDTO>();
            litigantList.add(litigant);
            reqDTO.setLitigantList(litigantList);
            this.invokingAddMethod(reqDTO);
        }
    }

    private void handleUserIsDelete(Long meetingId, String roomId, List<MediationRoomUserInfoResDTO> oldUserList, List<TempUserDTO> deleteUserList) {
        if (CollectionUtils.isEmpty(deleteUserList)) {
            return;
        }
        log.info("\u6709{}\u4e2a\u53c2\u4e0e\u4eba\u9700\u8981\u5220\u9664", (Object)deleteUserList.size());
        for (TempUserDTO deleteUser : deleteUserList) {
            String mobilePhone = deleteUser.getMobilePhone();
            String userType = deleteUser.getUserType();
            if ("AGENT".equals(userType)) {
                for (MediationRoomUserInfoResDTO mediationRoomUserInfoRes : oldUserList) {
                    if (!mobilePhone.equals(mediationRoomUserInfoRes.getMobilePhone())) continue;
                    LitigantAgentInfoMicroRequestDTO agent = new LitigantAgentInfoMicroRequestDTO();
                    agent.setUserName(mediationRoomUserInfoRes.getUserName());
                    agent.setMobilePhone(mediationRoomUserInfoRes.getMobilePhone());
                    this.deleteMeetingAgent(meetingId, roomId, agent);
                }
                continue;
            }
            if ("MEDIATOR".equals(userType)) {
                for (MediationRoomUserInfoResDTO mediationRoomUserInfoRes : oldUserList) {
                    if (!mobilePhone.equals(mediationRoomUserInfoRes.getMobilePhone())) continue;
                    LitigantInfoRequestDTO mediator = new LitigantInfoRequestDTO();
                    mediator.setUserName(mediationRoomUserInfoRes.getUserName());
                    mediator.setMobilePhone(mediationRoomUserInfoRes.getMobilePhone());
                    this.deleteMeetingMediator(meetingId, roomId, mediator);
                }
                continue;
            }
            if (!"LITIGANT".equals(userType)) continue;
            for (MediationRoomUserInfoResDTO mediationRoomUserInfoRes : oldUserList) {
                if (!mobilePhone.equals(mediationRoomUserInfoRes.getMobilePhone())) continue;
                LitigantInfoRequestDTO litigant = new LitigantInfoRequestDTO();
                litigant.setUserName(mediationRoomUserInfoRes.getUserName());
                litigant.setMobilePhone(mediationRoomUserInfoRes.getMobilePhone());
                this.deleteMeetingLitigant(meetingId, roomId, litigant);
            }
        }
    }

    private void handleUserNeedUpdate(Long meetingId, List<TempUserDTO> updateUserList) {
        if (CollectionUtils.isEmpty(updateUserList)) {
            return;
        }
        for (TempUserDTO addUser : updateUserList) {
            MediationMeetingUserInfoReqDTO meetingUserInfoReq = new MediationMeetingUserInfoReqDTO();
            meetingUserInfoReq.setMediationMeetingId(meetingId);
            meetingUserInfoReq.setIdCard(addUser.getIdCard());
            meetingUserInfoReq.setMobilePhone(addUser.getMobilePhone());
            meetingUserInfoReq.setUserName(addUser.getUserName());
            JSONObject json = new JSONObject();
            if (addUser.getCreditCode() != null) {
                json.put("credit_code", (Object)addUser.getCreditCode());
            }
            if (addUser.getIsUndertaker() != null) {
                json.put("is_undertaker", (Object)addUser.getIsUndertaker());
            }
            if (addUser.getLitigantType() != null) {
                json.put("litigant_type", (Object)addUser.getLitigantType());
            }
            if (addUser.getOriginalLitigationStatus() != null) {
                json.put("original_litigation_status", (Object)addUser.getOriginalLitigationStatus());
            }
            if (addUser.getUnitName() != null) {
                json.put("unit_name", (Object)addUser.getUnitName());
            }
            meetingUserInfoReq.setExpandAttribute((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
            this.mediationMeetingApi.updateMeetingUser(meetingUserInfoReq);
        }
    }

    private void invokingAddMethod(AddMediationMeetingUserRequestMicroDTO reqDTO) {
        DubboResult dubboResult = this.peaceIntranetApi.addMediationMeetingUser(reqDTO);
        if (dubboResult == null) {
            log.error("duboo\u6dfb\u52a0\u53c2\u4e0e\u4eba\u8c03\u7528\u5931\u8d25");
            return;
        }
        if (!dubboResult.isSuccess()) {
            log.error(dubboResult.getMessage());
        }
    }

    public void deleteMeetingAgent(Long meetingId, String roomId, LitigantAgentInfoMicroRequestDTO agentDTO) {
        DubboResult userInfoDubbo = this.backstageUserMicroServiceApi.getUserInfo(agentDTO.getMobilePhone(), agentDTO.getUserName(), "COMMON");
        if (userInfoDubbo == null || userInfoDubbo.getCode() != 200) {
            log.error("\u67e5\u8be2\u7684\u4ee3\u7406\u4eba\u7528\u6237\u4e3a\u7a7a");
            return;
        }
        UserInfoDTO userInfoDTO = (UserInfoDTO)userInfoDubbo.getData();
        Long userId = userInfoDTO.getUserId();
        String mobilePhone = userInfoDTO.getMobilePhone();
        this.changeMemberInfoStatus(roomId, userId);
        this.changeMediationMeetingUserStatus(meetingId, userId);
        DubboResult deleteVerificationCode = this.peaceIntranetApi.deleteVerificationCode(meetingId, userId, mobilePhone);
        if (deleteVerificationCode != null && deleteVerificationCode.getCode() != 200) {
            log.info("\u5220\u9664\u9a8c\u8bc1\u7801\u6210\u529f");
        }
    }

    public void deleteMeetingLitigant(Long meetingId, String roomId, LitigantInfoRequestDTO litigant) {
        DubboResult userInfoDubbo = this.backstageUserMicroServiceApi.getUserInfo(litigant.getMobilePhone(), litigant.getUserName(), "COMMON");
        if (userInfoDubbo == null || userInfoDubbo.getCode() != 200) {
            log.error("\u67e5\u8be2\u7684\u5f53\u4e8b\u4eba\u7528\u6237\u4e3a\u7a7a");
            return;
        }
        UserInfoDTO userInfoDTO = (UserInfoDTO)userInfoDubbo.getData();
        Long userId = userInfoDTO.getUserId();
        String mobilePhone = userInfoDTO.getMobilePhone();
        this.changeMemberInfoStatus(roomId, userId);
        this.changeMediationMeetingUserStatus(meetingId, userId);
        DubboResult deleteVerificationCode = this.peaceIntranetApi.deleteVerificationCode(meetingId, userId, mobilePhone);
        if (deleteVerificationCode != null && deleteVerificationCode.getCode() != 200) {
            log.info("\u5220\u9664\u9a8c\u8bc1\u7801\u6210\u529f");
        }
    }

    public void deleteMeetingMediator(Long meetingId, String roomId, LitigantInfoRequestDTO mediator) {
        DubboResult userInfoDubbo = this.backstageUserMicroServiceApi.getUserInfo(mediator.getMobilePhone(), mediator.getUserName(), "STAFF");
        if (userInfoDubbo == null || userInfoDubbo.getCode() != 200) {
            log.error("\u67e5\u8be2\u7684\u5de5\u4f5c\u4eba\u5458\u7528\u6237\u4e3a\u7a7a");
            return;
        }
        UserInfoDTO userInfoDTO = (UserInfoDTO)userInfoDubbo.getData();
        Long userId = userInfoDTO.getUserId();
        this.changeMemberInfoStatus(roomId, userId);
        this.changeMediationMeetingUserStatus(meetingId, userId);
    }

    private void changeMemberInfoStatus(String roomId, Long userId) {
        DubboResult changeDubbo = this.roomMediationApi.changeMemberStatus(roomId, userId);
        if (changeDubbo != null && changeDubbo.getData() != null) {
            log.info("\u4fee\u6539\u4e86member_info\u8868-{}\u4e2a\u53c2\u4e0e\u4eba", (Object)changeDubbo.getData());
        }
    }

    private void changeMediationMeetingUserStatus(Long meetingId, Long userId) {
        DubboResult changeDubbo = this.intranetApi.updateMeetingUserStatus(meetingId, userId);
        if (changeDubbo != null && changeDubbo.getData() != null) {
            log.info("\u4fee\u6539\u4e86mediation_meeting_user\u8868{}\u4e2a\u53c2\u4e0e\u4eba", (Object)changeDubbo.getData());
        }
    }

    private void handleUserIsAddNoPhone(Long meetingId, Map<String, Object> allUserMap, List<TempUserDTO> addUserList, List<LitigantInfoRequestDTO> mediatorList) {
        if (CollectionUtils.isEmpty(addUserList)) {
            return;
        }
        log.info("\u6709{}\u4e2a\u53c2\u4e0e\u4eba\u9700\u8981\u65b0\u589e", (Object)addUserList.size());
        LitigantInfoRequestDTO createMediator = mediatorList.get(0);
        for (TempUserDTO addUser : addUserList) {
            String userType = addUser.getUserType();
            if (!"LITIGANT".equals(userType)) continue;
            LitigantInfoRequestDTO litigant = new LitigantInfoRequestDTO();
            litigant.setIdCard(addUser.getIdCard());
            litigant.setUserName(addUser.getUserName());
            litigant.setMeetingUserType(MeetingUserTypeEnum.valueOf((String)addUser.getMeetingUserType()));
            litigant.setCreditCode(addUser.getCreditCode());
            litigant.setIsUndertaker(addUser.getIsUndertaker());
            litigant.setLitigantType(addUser.getLitigantType());
            litigant.setOriginalLitigationStatus(addUser.getOriginalLitigationStatus());
            litigant.setUnitName(addUser.getUnitName());
            litigant.setMobilePhone(addUser.getMobilePhone());
            AddMediationMeetingUserRequestMicroDTO reqDTO = new AddMediationMeetingUserRequestMicroDTO();
            reqDTO.setMediationRoomId(meetingId);
            reqDTO.setMediatorName(createMediator.getUserName());
            ArrayList<LitigantInfoRequestDTO> litigantList = new ArrayList<LitigantInfoRequestDTO>();
            litigantList.add(litigant);
            reqDTO.setLitigantList(litigantList);
            this.invokingAddMethod(reqDTO);
        }
    }

    private void handleUserIsDeleteNoPhone(Long meetingId, String roomId, List<MediationRoomUserInfoResDTO> oldUserList, List<TempUserDTO> deleteUserList) {
        if (CollectionUtils.isEmpty(deleteUserList)) {
            return;
        }
        log.info("\u6709{}\u4e2a\u53c2\u4e0e\u4eba\u9700\u8981\u5220\u9664", (Object)deleteUserList.size());
        for (TempUserDTO deleteUser : deleteUserList) {
            String userType = deleteUser.getUserType();
            if (!"LITIGANT".equals(userType)) continue;
            for (MediationRoomUserInfoResDTO mediationRoomUserInfoRes : oldUserList) {
                if (!mediationRoomUserInfoRes.getUserName().equals(deleteUser.getUserName()) || !mediationRoomUserInfoRes.getMeetingUserType().equals(deleteUser.getMeetingUserType())) continue;
                this.deleteNoPhoneMeetingUser(meetingId, mediationRoomUserInfoRes);
            }
        }
    }

    public void deleteNoPhoneMeetingUser(Long meetingId, MediationRoomUserInfoResDTO mediationRoomUserInfoRes) {
        DubboResult changeDubbo = this.intranetApi.updateNoPhoneMeetingUserStatus(meetingId, mediationRoomUserInfoRes.getRemark());
        if (changeDubbo != null && changeDubbo.getData() != null) {
            log.info("\u4fee\u6539\u4e86mediation_meeting_user\u8868{}\u4e2a\u53c2\u4e0e\u4eba", (Object)changeDubbo.getData());
        }
    }

    private void handleUserNeedUpdateNoPhone(Long meetingId, List<TempUserDTO> updateUserList) {
        if (CollectionUtils.isEmpty(updateUserList)) {
            return;
        }
        for (TempUserDTO addUser : updateUserList) {
            MediationMeetingUserInfoReqDTO meetingUserInfoReq = new MediationMeetingUserInfoReqDTO();
            meetingUserInfoReq.setMediationMeetingId(meetingId);
            meetingUserInfoReq.setIdCard(addUser.getIdCard());
            meetingUserInfoReq.setMeetingUserType(addUser.getMeetingUserType());
            meetingUserInfoReq.setUserName(addUser.getUserName());
            meetingUserInfoReq.setRemark(addUser.getUserTempId());
            if (StringUtils.isNotBlank((CharSequence)addUser.getMobilePhone()) && !"1111".equals(addUser.getMobilePhone())) {
                meetingUserInfoReq.setMobilePhone(addUser.getMobilePhone());
            }
            JSONObject json = new JSONObject();
            if (addUser.getCreditCode() != null) {
                json.put("credit_code", (Object)addUser.getCreditCode());
            }
            if (addUser.getIsUndertaker() != null) {
                json.put("is_undertaker", (Object)addUser.getIsUndertaker());
            }
            if (addUser.getLitigantType() != null) {
                json.put("litigant_type", (Object)addUser.getLitigantType());
            }
            if (addUser.getOriginalLitigationStatus() != null) {
                json.put("original_litigation_status", (Object)addUser.getOriginalLitigationStatus());
            }
            if (addUser.getUnitName() != null) {
                json.put("unit_name", (Object)addUser.getUnitName());
            }
            meetingUserInfoReq.setExpandAttribute((String)JSON.parseObject((String)JSON.toJSONString((Object)json), String.class));
            this.mediationMeetingApi.updateNoPhoneMeetingUser(meetingUserInfoReq);
        }
    }

    public DubboResult<String> updateMeetingOrderTimeCauseName(UpdateMeetingYanChengRequestDTO dto, Long meetingId) {
        AddMediationMeetingRoomMicroReqDTO reqDTO = new AddMediationMeetingRoomMicroReqDTO();
        reqDTO.setMeetingId(meetingId);
        reqDTO.setCauseName(dto.getCauseName());
        reqDTO.setOrderTime(dto.getOrderTime());
        DubboResult result = this.mediationMeetingApi.updateMeetingOrderTimeCauseName(reqDTO);
        return result;
    }

    @Override
    public void checkHasCreateMeeting(AddMeetingIntranetRequestDTO dto) {
        MeetingInfoRequestDTO meetingInfoRequest = new MeetingInfoRequestDTO();
        meetingInfoRequest.setCaseNumberCode(dto.getCaseNumberCode());
        meetingInfoRequest.setCaseOrder(dto.getCaseOrder());
        meetingInfoRequest.setCourtCode(dto.getCourtCode());
        meetingInfoRequest.setRemark("YAN_CHENG");
        DubboResult dubboResult = this.caseRoomMicroApi.getMeetingRoomInfoByNameAndCaseOrder(meetingInfoRequest);
        AssertUtils.assertNull((Object)dubboResult.getData(), (ResultCode)ErrorCode.NAME_IS_REPEAT, (String)ErrorCode.NAME_IS_REPEAT.desc());
    }

    @Override
    public void checkHasCreateIntranetMeeting(AddMeetingIntranetRequestDTO dto) {
        MeetingInfoRequestDTO meetingInfoRequest = new MeetingInfoRequestDTO();
        meetingInfoRequest.setCaseNumberCode(dto.getCaseNumberCode());
        meetingInfoRequest.setCaseOrder(dto.getCaseOrder());
        meetingInfoRequest.setCourtCode(dto.getCourtCode());
        DubboResult dubboResult = this.caseRoomMicroApi.getMeetingRoomInfoByNameAndCaseOrder(meetingInfoRequest);
        AssertUtils.assertNull((Object)dubboResult.getData(), (ResultCode)ErrorCode.NAME_IS_REPEAT, (String)ErrorCode.NAME_IS_REPEAT.desc());
    }
}

