/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.AttachmentApi;
import com.beiming.odr.document.dto.requestdto.ObjectReqDTO;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.GetCaseInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.InductionEvidenceRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyBusinessRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyBusinessResponseDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MyBusinessStatisticsRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.UserPortraitRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MessageResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyBusinessStatisticsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.SevenDaysCreationCaseRespDTO;
import com.beiming.odr.peace.domain.dto.responsedto.SevenDaysNumRespDTO;
import com.beiming.odr.peace.domain.dto.responsedto.TodayCourtListResDTO;
import com.beiming.odr.peace.domain.dto.responsedto.TodoStatisticsResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.TypeInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.UserPortraitCaseResDTO;
import com.beiming.odr.peace.domain.dto.responsedto.UserPortraitInfoResponseDTO;
import com.beiming.odr.peace.service.ChatService;
import com.beiming.odr.peace.service.MyBusinessService;
import com.beiming.odr.peace.service.convert.PersonalConvert;
import com.beiming.odr.peace.service.util.DateUtil;
import com.beiming.odr.peace.service.util.TokenGeneratorParse;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.DataStatisticsServiceApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.requestdto.MyBusinessReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseListMicroResponseDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MyBusinessStatisticsRespDTO;
import com.beiming.odr.referee.dto.responsedto.UserPortraitCaseResponseDTO;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MyBusinessServiceImpl
implements MyBusinessService {
    private static final Logger log = LoggerFactory.getLogger(MyBusinessServiceImpl.class);
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private AttachmentApi attachmentApi;
    @Resource
    private DataStatisticsServiceApi dataStatisticsServiceApi;
    @Resource
    private ChatService chatService;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    TokenGeneratorParse tokenGeneratorParse;
    public static final String DATE_FORMAT = "yyyy-MM-dd 00:00:00";
    public static final String DATE_FORMAT_ALL = "yyyy-MM-dd HH:mm:ss";

    @Override
    public PageInfo<MyBusinessResponseDTO> myBusinessTodoList(MyBusinessRequestDTO requestDTO) {
        MyBusinessReqDTO reqDTO = PersonalConvert.getMyBusinessReqDTO(requestDTO);
        DubboResult dubboResult = this.caseRoomMicroApi.myBusinessTodoList(reqDTO);
        PageInfo pageInfoResult = (PageInfo)dubboResult.getData();
        AssertUtils.assertNotNull((Object)pageInfoResult, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        List resultList = pageInfoResult.getList();
        ArrayList<MyBusinessResponseDTO> myBusinessResponseList = new ArrayList<MyBusinessResponseDTO>();
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            for (CaseListMicroResponseDTO one : resultList) {
                MyBusinessResponseDTO myBusinessResponseDTO = PersonalConvert.getMyBusinessResponseDTO(one);
                DubboResult mediationUserInfoRes = this.mediationRoomApi.getMediationRoomUserInfoAllList(one.getBizRoomId());
                ArrayList mediationUserInfoList = (ArrayList)mediationUserInfoRes.getData();
                PersonalConvert.buildParticipants(myBusinessResponseDTO, mediationUserInfoList);
                myBusinessResponseList.add(myBusinessResponseDTO);
            }
        }
        return new PageInfo(myBusinessResponseList, pageInfoResult.getTotalRows(), pageInfoResult.getPageIndex(), pageInfoResult.getPageSize());
    }

    @Override
    public PageInfo<MyBusinessResponseDTO> myBusinessDoneList(MyBusinessRequestDTO requestDTO) {
        MyBusinessReqDTO reqDTO = PersonalConvert.getMyBusinessReqDTO(requestDTO);
        DubboResult dubboResult = this.caseRoomMicroApi.myBusinessDoneList(reqDTO);
        PageInfo pageInfoResult = (PageInfo)dubboResult.getData();
        AssertUtils.assertNotNull((Object)pageInfoResult, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        List resultList = pageInfoResult.getList();
        ArrayList<MyBusinessResponseDTO> myBusinessResponseList = new ArrayList<MyBusinessResponseDTO>();
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            for (CaseListMicroResponseDTO one : resultList) {
                MyBusinessResponseDTO myBusinessResponseDTO = PersonalConvert.getMyBusinessResponseDTO(one);
                DubboResult mediationUserInfoRes = this.mediationRoomApi.getMediationRoomUserInfoAllList(one.getBizRoomId());
                ArrayList mediationUserInfoList = (ArrayList)mediationUserInfoRes.getData();
                PersonalConvert.buildParticipants(myBusinessResponseDTO, mediationUserInfoList);
                myBusinessResponseList.add(myBusinessResponseDTO);
            }
        }
        return new PageInfo(myBusinessResponseList, pageInfoResult.getTotalRows(), pageInfoResult.getPageIndex(), pageInfoResult.getPageSize());
    }

    @Override
    public MyBusinessStatisticsResponseDTO doneStatistics(MyBusinessStatisticsRequestDTO requestDTO) {
        String userId = JWTContextUtil.getCurrentUserId();
        Date now = new Date();
        String nowTime = DateUtil.getFormatDate(DATE_FORMAT_ALL, DateUtil.getDateEndTime());
        String beforeTime = DateUtil.getMinusDate(DATE_FORMAT, now, requestDTO.getDays());
        MyBusinessReqDTO reqDTO = new MyBusinessReqDTO();
        reqDTO.setUserId(Long.valueOf(userId));
        reqDTO.setStartTime(beforeTime);
        reqDTO.setEndTime(nowTime);
        log.info("\u6253\u5370\u8d77\u59cb\u548c\u7ed3\u675f\u65f6\u95f4.beforeTime:{}||nowTime:{}", (Object)beforeTime, (Object)nowTime);
        DubboResult dubboResult = this.dataStatisticsServiceApi.doneStatistics(reqDTO);
        AssertUtils.assertNotNull((Object)dubboResult, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        MyBusinessStatisticsRespDTO myBusinessStatisticsRespDTO = (MyBusinessStatisticsRespDTO)dubboResult.getData();
        return PersonalConvert.getMyBusinessStatisticsResponseDTO(myBusinessStatisticsRespDTO);
    }

    @Override
    public TodoStatisticsResponseDTO todoStatistics(MyBusinessStatisticsRequestDTO requestDTO) {
        String userId = JWTContextUtil.getCurrentUserId();
        Date now = new Date();
        String endTime = DateUtil.getFormatDate(DATE_FORMAT_ALL, DateUtil.getDateEndTime());
        String beforeTime = DateUtil.getMinusDate(DATE_FORMAT, now, requestDTO.getDays());
        MyBusinessReqDTO reqDTO = new MyBusinessReqDTO();
        reqDTO.setUserId(Long.valueOf(userId));
        reqDTO.setStartTime(beforeTime);
        reqDTO.setEndTime(endTime);
        log.info("\u6253\u5370\u8d77\u59cb\u548c\u7ed3\u675f\u65f6\u95f4.beforeTime:{}||nowTime:{}", (Object)beforeTime, (Object)endTime);
        DubboResult dubboResult = this.dataStatisticsServiceApi.todoStatistics(reqDTO);
        AssertUtils.assertNotNull((Object)dubboResult, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        MyBusinessStatisticsRespDTO myBusinessStatisticsRespDTO = (MyBusinessStatisticsRespDTO)dubboResult.getData();
        return PersonalConvert.getTodoStatisticsResponseDTO(myBusinessStatisticsRespDTO);
    }

    @Override
    public SevenDaysCreationCaseRespDTO sevenDaysCreationCase() {
        String userId = JWTContextUtil.getCurrentUserId();
        Date now = new Date();
        String endTime = DateUtil.getFormatDate(DATE_FORMAT_ALL, DateUtil.getDateEndTime());
        String beforeTime = DateUtil.getMinusDate(DATE_FORMAT, now, 7L);
        MyBusinessReqDTO reqDTO = new MyBusinessReqDTO();
        reqDTO.setUserId(Long.valueOf(userId));
        reqDTO.setStartTime(beforeTime);
        reqDTO.setEndTime(endTime);
        log.info("\u6253\u5370\u8d77\u59cb\u548c\u7ed3\u675f\u65f6\u95f4.beforeTime:{}||nowTime:{}", (Object)beforeTime, (Object)endTime);
        reqDTO.setType(Integer.valueOf(1));
        DubboResult platformCreationResult = this.dataStatisticsServiceApi.getMediationRoomList(reqDTO);
        reqDTO.setType(Integer.valueOf(2));
        DubboResult intranetCreationResult = this.dataStatisticsServiceApi.getMediationRoomList(reqDTO);
        SevenDaysCreationCaseRespDTO respDTO = new SevenDaysCreationCaseRespDTO();
        respDTO.setPlatformCreation(this.getCalendarCaseData(beforeTime, endTime, (DubboResult<ArrayList<CaseListMicroResponseDTO>>)platformCreationResult));
        respDTO.setIntranetCreation(this.getCalendarCaseData(beforeTime, endTime, (DubboResult<ArrayList<CaseListMicroResponseDTO>>)intranetCreationResult));
        return respDTO;
    }

    private List<SevenDaysNumRespDTO> getCalendarCaseData(String startTime, String endTime, DubboResult<ArrayList<CaseListMicroResponseDTO>> dubboResult) {
        ArrayList<SevenDaysNumRespDTO> list = new ArrayList<SevenDaysNumRespDTO>();
        for (long i = 0L; i < 7L; ++i) {
            String date = DateUtil.getPlusDateByStr(DATE_FORMAT, startTime, i);
            SevenDaysNumRespDTO data = new SevenDaysNumRespDTO();
            data.setTime(date);
            data.setNum(Integer.valueOf(0));
            list.add(data);
        }
        log.info("\u751f\u6210\u7684\u65f6\u95f4\u65e5\u5386map\uff1a{}", (Object)JSONObject.toJSONString(list));
        if (dubboResult == null || CollectionUtils.isEmpty((Collection)((Collection)((Object)dubboResult.getData())))) {
            return list;
        }
        ArrayList caseList = (ArrayList)dubboResult.getData();
        for (CaseListMicroResponseDTO one : caseList) {
            Date createTime = one.getCreateTime();
            if (createTime == null) continue;
            String date = DateUtil.getFormatDate("MM\u6708dd\u65e5", createTime);
            log.info("createTime\uff1a{}||\uff0cdate\uff1a{}", (Object)createTime, (Object)date);
            Integer caseCount = 0;
            for (SevenDaysNumRespDTO sevenDaysNumResp : list) {
                if (!date.equals(sevenDaysNumResp.getTime())) continue;
                caseCount = sevenDaysNumResp.getNum();
                sevenDaysNumResp.setNum(Integer.valueOf(caseCount + 1));
            }
        }
        return list;
    }

    @Override
    public TodayCourtListResDTO todayCourtList() {
        String startTime = DateUtil.getFormatDate(DATE_FORMAT_ALL, DateUtil.getDateStartTime());
        String endTime = DateUtil.getFormatDate(DATE_FORMAT_ALL, DateUtil.getDateEndTime());
        String userId = JWTContextUtil.getCurrentUserId();
        MyBusinessReqDTO reqDTO = new MyBusinessReqDTO();
        reqDTO.setUserId(Long.valueOf(userId));
        reqDTO.setStartTime(startTime);
        reqDTO.setEndTime(endTime);
        log.info("\u6253\u5370\u8d77\u59cb\u548c\u7ed3\u675f\u65f6\u95f4.beforeTime:{}||nowTime:{}", (Object)startTime, (Object)endTime);
        DubboResult dubboResult = this.dataStatisticsServiceApi.todayCourtList(reqDTO);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ArrayList todayCourtList = (ArrayList)dubboResult.getData();
        TodayCourtListResDTO todayCourtListRes = new TodayCourtListResDTO();
        todayCourtListRes.setTodayCourtList((List)todayCourtList);
        todayCourtListRes.setTotal(Integer.valueOf(todayCourtList.size()));
        return todayCourtListRes;
    }

    @Override
    public UserPortraitInfoResponseDTO userPortraitInfo(UserPortraitRequestDTO dto, HttpServletRequest request) throws Exception {
        dto.setUserId(this.tokenGeneratorParse.getUserIdByJWTToken(request.getHeader("Jwttoken")));
        log.info("----------------dto-----------------" + JSON.toJSONString((Object)dto));
        DubboResult userDubbo = this.dataStatisticsServiceApi.userPortraitInfo(dto.getMediationMeetingId(), dto.getUserId());
        log.info("----------------userDubbo-----------------" + JSON.toJSONString((Object)userDubbo));
        AssertUtils.assertTrue((boolean)userDubbo.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        MediationRoomUserInfoResDTO mediationRoomUserInfoRes = (MediationRoomUserInfoResDTO)userDubbo.getData();
        CommonIdReqDTO commonIdReq = new CommonIdReqDTO();
        commonIdReq.setId(dto.getUserId());
        DubboResult userBasicDubbo = this.userServiceApi.searchCommonUser(commonIdReq);
        AssertUtils.assertTrue((boolean)userBasicDubbo.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        CommonUserSearchResDTO commonUserSearchRes = (CommonUserSearchResDTO)userBasicDubbo.getData();
        UserPortraitInfoResponseDTO userPortraitInfoResponse = new UserPortraitInfoResponseDTO();
        log.info("----------------***-----------------" + String.valueOf(StringUtils.isNotEmpty((String)commonUserSearchRes.getIdCard()) && !commonUserSearchRes.getIdCard().contains("*")));
        if (StringUtils.isNotEmpty((String)commonUserSearchRes.getIdCard()) && !commonUserSearchRes.getIdCard().contains("*")) {
            userPortraitInfoResponse.setBirth(MyBusinessServiceImpl.extractYearMonthDayOfIdCard(commonUserSearchRes.getIdCard()));
            userPortraitInfoResponse.setAge(MyBusinessServiceImpl.extractAgeOfIdCard(commonUserSearchRes.getIdCard()));
            userPortraitInfoResponse.setSex(MyBusinessServiceImpl.getCarInfo(commonUserSearchRes.getIdCard()));
        }
        MyBusinessReqDTO reqDTO = PersonalConvert.getMyBusinessReqUserPortrait(dto);
        reqDTO.setPageIndex(Integer.valueOf(1));
        reqDTO.setPageSize(Integer.valueOf(1000));
        DubboResult dubboResult = this.caseRoomMicroApi.userPortraitCaseList(reqDTO);
        List<TypeInfoResponseDTO> caseTypeNum = PersonalConvert.getTypeInfoResponseDTO((PageInfo<UserPortraitCaseResponseDTO>)((PageInfo)dubboResult.getData()));
        userPortraitInfoResponse.setCaseTypeNum(caseTypeNum);
        ObjectReqDTO objectReqDTO = new ObjectReqDTO();
        objectReqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
        objectReqDTO.setUserId(dto.getUserId());
        DubboResult result = this.attachmentApi.queryAttachmentNum(objectReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        userPortraitInfoResponse.setDocumentNum((Integer)result.getData());
        userPortraitInfoResponse.setIdCard(mediationRoomUserInfoRes.getIdCard());
        userPortraitInfoResponse.setMobilePhone(mediationRoomUserInfoRes.getMobilePhone());
        userPortraitInfoResponse.setUserName(mediationRoomUserInfoRes.getUserName());
        return userPortraitInfoResponse;
    }

    @Override
    public PageInfo<UserPortraitCaseResDTO> userPortraitCaseList(MyBusinessRequestDTO dto) {
        MyBusinessReqDTO reqDTO = PersonalConvert.getMyBusinessReqDTO(dto);
        reqDTO.setUserId(dto.getUserId());
        log.info("\u8bf7\u6c42\u53c2\u6570\uff1a{},{},{}", new Object[]{reqDTO.toString(), reqDTO.getPageIndex(), reqDTO.getPageSize()});
        DubboResult dubboResult = this.caseRoomMicroApi.userPortraitCaseList(reqDTO);
        PageInfo pageInfoResult = (PageInfo)dubboResult.getData();
        AssertUtils.assertNotNull((Object)pageInfoResult, (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        List resultList = pageInfoResult.getList();
        ArrayList<UserPortraitCaseResDTO> userPortraitCaseResList = new ArrayList<UserPortraitCaseResDTO>();
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            for (UserPortraitCaseResponseDTO one : resultList) {
                UserPortraitCaseResDTO userPortraitCaseRes = new UserPortraitCaseResDTO();
                BeanUtils.copyProperties((Object)one, (Object)userPortraitCaseRes);
                ObjectReqDTO objectReqDTO = new ObjectReqDTO();
                objectReqDTO.setObjectId(one.getMeetingId());
                objectReqDTO.setObjectType(ObjectTypeEnum.MEDIATION.name());
                DubboResult result = this.attachmentApi.queryAttachmentList(objectReqDTO);
                AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
                ArrayList responseLstDTO = (ArrayList)result.getData();
                userPortraitCaseRes.setDocAttachList(responseLstDTO);
                ObjectReqDTO judgmentReqDTO = new ObjectReqDTO();
                judgmentReqDTO.setObjectId(one.getMeetingId());
                judgmentReqDTO.setFlag("1");
                judgmentReqDTO.setObjectType(ObjectTypeEnum.JUDICIAL_DOCUMENT.name());
                DubboResult intranetAttachments = this.attachmentApi.queryAttachmentList(judgmentReqDTO);
                AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
                log.info("judgmentReqDTO is {}, intranetAttachments is {}", (Object)JSONObject.toJSONString((Object)judgmentReqDTO), (Object)JSONObject.toJSONString((Object)intranetAttachments));
                ArrayList data = (ArrayList)intranetAttachments.getData();
                if (CollectionUtil.isNotEmpty((Collection)data) && data.size() > 0) {
                    List judgmentList = data.stream().filter(docAttachmentResDTO -> "JUDICIAL_DOCUMENT".equals(docAttachmentResDTO.getObjectType())).collect(Collectors.toList());
                    userPortraitCaseRes.setJudgmentDocument(judgmentList);
                }
                InductionEvidenceRequestDTO evidenceRequest = new InductionEvidenceRequestDTO();
                evidenceRequest.setBizRoomId(one.getMeetingId());
                List<String> roomIds = Arrays.asList(one.getRoomId().split(","));
                evidenceRequest.setRoomId(roomIds.get(0));
                evidenceRequest.setPageIndex(Integer.valueOf(1));
                evidenceRequest.setPageSize(Integer.valueOf(1000));
                PageInfo<MessageResponseDTO> evidenceDubbo = this.chatService.inductionEvidence(evidenceRequest);
                userPortraitCaseRes.setEvidenceList(evidenceDubbo.getList());
                userPortraitCaseResList.add(userPortraitCaseRes);
            }
        }
        return new PageInfo(userPortraitCaseResList, pageInfoResult.getTotalRows(), pageInfoResult.getPageIndex(), pageInfoResult.getPageSize());
    }

    public static String extractYearMonthDayOfIdCard(String id) {
        String year = null;
        String month = null;
        String day = null;
        if (!id.matches("^\\d{15}|\\d{17}[\\dxX]$")) {
            System.out.println("\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u5339\u914d\uff01");
            return null;
        }
        year = id.substring(6, 10);
        month = id.substring(10, 12);
        day = id.substring(12, 14);
        return year + "-" + month + "-" + day;
    }

    public static String extractAgeOfIdCard(String sfzjh) {
        if (sfzjh == null || "".equals(sfzjh)) {
            return "\u8eab\u4efd\u8bc1\u4ef6\u53f7\u6709\u8bef,\u65e0\u6cd5\u8ba1\u7b97\u5e74\u9f84";
        }
        if (sfzjh.length() != 15 && sfzjh.length() != 18) {
            return "\u8eab\u4efd\u8bc1\u4ef6\u53f7\u6709\u8bef,\u65e0\u6cd5\u8ba1\u7b97\u5e74\u9f84";
        }
        String age = "\u8eab\u4efd\u8bc1\u4ef6\u53f7\u6709\u8bef,\u65e0\u6cd5\u8ba1\u7b97\u5e74\u9f84";
        Calendar cal = Calendar.getInstance();
        int yearNow = cal.get(1);
        int monthNow = cal.get(2) + 1;
        int dayNow = cal.get(5);
        int year = Integer.valueOf(sfzjh.substring(6, 10));
        int month = Integer.valueOf(sfzjh.substring(10, 12));
        int day = Integer.valueOf(sfzjh.substring(12, 14));
        age = month < monthNow || month == monthNow && day <= dayNow ? String.valueOf(yearNow - year) : String.valueOf(yearNow - year - 1);
        return age;
    }

    public static String getCarInfo(String cardCode) throws Exception {
        String sex = Integer.parseInt(cardCode.substring(16).substring(0, 1)) % 2 == 0 ? "\u5973" : "\u7537";
        return sex;
    }

    @Override
    public ArrayList<CaseListMicroResponseDTO> mediationMeetingList(GetCaseInfoRequestDTO dto) {
        DubboResult dubboResult = this.caseRoomMicroApi.getMediationMeetingList(dto.getBizRoomId());
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ArrayList meetingList = (ArrayList)dubboResult.getData();
        return meetingList;
    }
}

