/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.constants.PeaceConst;
import com.beiming.odr.peace.domain.dto.PreviewUserDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationRoomUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import com.beiming.odr.referee.enums.UserTypeEnum;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PreviewConvert {
    public static MediationMeetingUserInfoReqDTO covertCommonUser(CommonUserSearchResDTO user) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setUserId(user.getUserId());
        String idCard = user.getIdCard();
        reqDTO.setUserName(user.getUserName());
        reqDTO.setMobilePhone(user.getMobilePhone());
        reqDTO.setIdCard(idCard);
        if (user.getIsRealName().booleanValue()) {
            reqDTO.setAuthStatus(PeaceConst.AUTH_YES);
        }
        reqDTO.setUserOrder(PeaceConst.INT_ONE);
        return reqDTO;
    }

    public static MediationMeetingUserInfoReqDTO convertMediator(PreviewUserDTO previewUserDTO) {
        MediationMeetingUserInfoReqDTO mediator = new MediationMeetingUserInfoReqDTO();
        mediator.setUserId(previewUserDTO.getUserId());
        mediator.setUserName(previewUserDTO.getUserName());
        mediator.setMobilePhone(previewUserDTO.getMobilePhone());
        mediator.setIdCard(previewUserDTO.getIdCard());
        mediator.setAuthStatus(previewUserDTO.getAuthStatus());
        mediator.setMeetingUserType(MeetingUserTypeEnum.MEDIATOR.name());
        mediator.setUserOrder(PeaceConst.INT_ONE);
        return mediator;
    }

    public static AddMediationRoomUserReqDTO covertAddMediationRoomUserReqDTO(Long meetingId, Long userId, String nickname, List<MediationRoomUserInfoResDTO> meetingUserList, CommonUserSearchResDTO userInfo) {
        AddMediationRoomUserReqDTO reqDTO = new AddMediationRoomUserReqDTO();
        reqDTO.setMediationRoomId(meetingId);
        ArrayList list = Lists.newArrayList();
        MediationMeetingUserInfoReqDTO userInfoReqDTO = new MediationMeetingUserInfoReqDTO();
        List applicantList = meetingUserList.stream().filter(e -> MeetingUserTypeEnum.APPLICANT.name().equals(e.getMeetingUserType())).collect(Collectors.toList());
        List respondentList = meetingUserList.stream().filter(e -> MeetingUserTypeEnum.RESPONDENT.name().equals(e.getMeetingUserType())).collect(Collectors.toList());
        if (applicantList.size() == respondentList.size()) {
            userInfoReqDTO.setMeetingUserType(MeetingUserTypeEnum.APPLICANT.name());
            userInfoReqDTO.setUserOrder(Integer.valueOf(applicantList.size() + 1));
        } else {
            userInfoReqDTO.setMeetingUserType(MeetingUserTypeEnum.RESPONDENT.name());
            userInfoReqDTO.setUserOrder(Integer.valueOf(respondentList.size() + 1));
        }
        userInfoReqDTO.setUserId(userId);
        userInfoReqDTO.setUserName(nickname);
        userInfoReqDTO.setMobilePhone(userInfo.getMobilePhone());
        userInfoReqDTO.setIdCard(userInfo.getIdCard());
        userInfoReqDTO.setAuthStatus(PeaceConst.AUTH_YES);
        userInfoReqDTO.setUserType(UserTypeEnum.NATURAL_PERSON.name());
        if (StringUtils.isNotBlank((CharSequence)userInfo.getIdCard())) {
            String str = userInfo.getIdCard().substring(16, 17);
            Integer num = Integer.valueOf(str);
            if (num % 2 == 0) {
                userInfoReqDTO.setUserSex(UserSexEnum.FEMALE.name());
            } else {
                userInfoReqDTO.setUserSex(UserSexEnum.MALE.name());
            }
        }
        list.add(userInfoReqDTO);
        reqDTO.setList((List)list);
        reqDTO.setCurrentUserId(String.valueOf(userId));
        reqDTO.setCreateUser(nickname);
        return reqDTO;
    }
}

