/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.processor;

import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.referee.dto.requestdto.PeaceDeleteVerificationCodeReqDTO;
import com.beiming.pigeons.api.consumer.rocketmq.RocketMsgProcessor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class DeleteVerificationCodeProcessor
implements RocketMsgProcessor<PeaceDeleteVerificationCodeReqDTO> {
    private static final Logger log = LoggerFactory.getLogger(DeleteVerificationCodeProcessor.class);
    @Resource
    private RedisService redisService;
    private RedisTemplate redisTemplate;

    public String process(PeaceDeleteVerificationCodeReqDTO requestDTO) {
        String[] verificationCodeList;
        log.info("\u81ea\u52a8\u7ed3\u675f\u89c6\u9891\u5220\u9664redis\u91cc\u9762\u7684\u9a8c\u8bc1\u7801\u6d88\u8d39\u5f00\u59cb........mediationRoomId\u4e3a\u3010" + requestDTO.getMediationRoomId() + "\u3011");
        String appName = requestDTO.getAppName();
        if (StringUtils.isBlank((String)appName)) {
            return null;
        }
        String suffix = appName;
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        log.info("mq\u6d88\u8d39\u83b7\u53d6appName=" + appName);
        this.redisTemplate = this.redisService.getRedisTemplate();
        String verificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + requestDTO.getMediationRoomId()));
        if (StringUtils.isBlank((String)verificationCodes)) {
            log.info("\u81ea\u52a8\u7ed3\u675f\u89c6\u9891\u5220\u9664redis\u91cc\u9762\u7684\u9a8c\u8bc1\u7801\u6d88\u8d39\u7ed3\u675f........\uff0cverificationCodes\u4e3a\u7a7a\uff0cmediationRoomId\u4e3a\u3010" + requestDTO.getMediationRoomId() + "\u3011");
            return null;
        }
        log.info("\u81ea\u52a8\u7ed3\u675f\u89c6\u9891\u5220\u9664redis\u91cc\u9762\u7684\u9a8c\u8bc1\u7801\u6d88\u8d39\uff0c\u83b7\u53d6\u4f1a\u8bae\u6240\u6709\u9a8c\u8bc1\u7801\u4e3a\u3010" + verificationCodes + "\u3011\uff0cmediationRoomId\u4e3a\u3010" + requestDTO.getMediationRoomId() + "\u3011");
        for (String verificationCode : verificationCodeList = verificationCodes.split(",")) {
            this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode));
            log.info("\u9a8c\u8bc1\u7801\u5df2\u5220\u9664\uff0c\u9a8c\u8bc1\u7801\u4e3a\u3010" + verificationCode + "\u3011");
        }
        this.redisTemplate.delete((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + requestDTO.getMediationRoomId()));
        log.info("\u81ea\u52a8\u7ed3\u675f\u89c6\u9891\u5220\u9664redis\u91cc\u9762\u7684\u9a8c\u8bc1\u7801\u6d88\u8d39\u7ed3\u675f........");
        return null;
    }
}

