/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.user.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.DictionaryRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.DictionaryResponseDTO;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.user.api.DictionaryServiceApi;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DictionaryServiceImpl
implements DictionaryService {
    private static final Logger log = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    @Resource
    private DictionaryServiceApi dictionaryServiceApi;
    @Resource
    private RedisService redisService;

    @Override
    public List<DictionaryInfoDTO> searchDictionaryInfo(String parentCode, String code) {
        List result = null;
        DictionaryReqDTO reqDTO = new DictionaryReqDTO(parentCode, code);
        DubboResult resDTO = this.dictionaryServiceApi.searchDictionaryInfo(reqDTO);
        if (resDTO.isSuccess()) {
            DictionaryResDTO dictionaryResDTO = (DictionaryResDTO)resDTO.getData();
            result = dictionaryResDTO.getData();
        }
        if (result == null) {
            log.error("\u67e5\u8be2\u5b57\u5178\u4e3a\u7a7a\uff1aparentCode = " + parentCode + "--------code = " + code);
            AssertUtils.assertNotNull((Object)result, (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)"\u672a\u83b7\u53d6\u5230\u5b57\u5178\u6570\u636e");
        }
        return result;
    }

    @Override
    public DictionaryInfoDTO getDictionary(String code) {
        List<DictionaryInfoDTO> searchDictionaryInfo = this.searchDictionaryInfo(null, code);
        return searchDictionaryInfo.get(0);
    }

    @Override
    public String getDictionaryValue(String code) {
        String result = this.getDictionary(code).getValue();
        return result;
    }

    @Override
    public List<DictionaryResponseDTO> searchDictionaryInfo(DictionaryRequestDTO requestDTO) {
        AssertUtils.assertTrue((StringUtils.isNotBlank((CharSequence)requestDTO.getCode()) || StringUtils.isNotBlank((CharSequence)requestDTO.getParentCode()) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"code\u548cparentCode\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a");
        DictionaryReqDTO dictionaryReqDTO = new DictionaryReqDTO(requestDTO.getParentCode(), requestDTO.getCode());
        if (StringUtils.isNotBlank((CharSequence)requestDTO.getRelationCode())) {
            dictionaryReqDTO.setRemark(requestDTO.getRelationCode());
        }
        DubboResult dictionaryResult = this.dictionaryServiceApi.searchDictionaryInfo(dictionaryReqDTO);
        AssertUtils.assertTrue((boolean)dictionaryResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dictionaryResult.getMessage());
        ArrayList<DictionaryResponseDTO> result = new ArrayList<DictionaryResponseDTO>();
        List list = ((DictionaryResDTO)dictionaryResult.getData()).getData();
        if (list != null && list.size() > 0) {
            for (DictionaryInfoDTO dictionaryInfoDTO : list) {
                result.add(new DictionaryResponseDTO(dictionaryInfoDTO));
            }
        }
        return result;
    }

    @Override
    public List<DictionaryResponseDTO> searchOperationVideo(DictionaryRequestDTO requestDTO) {
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)requestDTO.getParentCode()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"code\u548cparentCode\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a");
        DictionaryReqDTO dictionaryReqDTO = new DictionaryReqDTO(requestDTO.getParentCode(), requestDTO.getCode());
        if (StringUtils.isNotBlank((CharSequence)requestDTO.getRelationCode())) {
            dictionaryReqDTO.setRemark(requestDTO.getRelationCode());
        }
        DubboResult dictionaryResult = this.dictionaryServiceApi.searchDictionaryInfo(dictionaryReqDTO);
        AssertUtils.assertTrue((boolean)dictionaryResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dictionaryResult.getMessage());
        ArrayList<DictionaryResponseDTO> result = new ArrayList<DictionaryResponseDTO>();
        List list = ((DictionaryResDTO)dictionaryResult.getData()).getData();
        if (list != null && list.size() > 0) {
            for (DictionaryInfoDTO dictionaryInfoDTO : list) {
                result.add(new DictionaryResponseDTO(dictionaryInfoDTO));
            }
        }
        return result;
    }
}

