/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.exception.APIBusinessException;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.odr.document.dto.requestdto.SignatureBizInfoReqDTO;
import com.beiming.odr.document.dto.requestdto.SignatureInfoReqDTO;
import com.beiming.odr.document.dto.responsedto.DocWholeConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.SignatureInfoResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.utils.ImgTools;
import com.beiming.odr.peace.common.utils.JavaFileUtil;
import com.beiming.odr.peace.domain.dto.requestdto.ClientClerkConfirmRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkConfirmResponseDTO;
import com.beiming.odr.peace.service.backend.document.SignatureDubboService;
import com.beiming.odr.peace.service.backend.storage.StorageDubboService;
import com.beiming.odr.peace.service.client.ClientClerkOpinionService;
import com.beiming.odr.peace.service.util.Base64Utils;
import com.beiming.odr.referee.api.IntranetApi;
import com.beiming.odr.referee.dto.responsedto.IntranetMeetingCaseInfoResDTO;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ClientClerkOpinionServiceImpl
implements ClientClerkOpinionService {
    private static final Logger log = LoggerFactory.getLogger(ClientClerkOpinionServiceImpl.class);
    @Resource
    private SignatureDubboService signatureDubboService;
    @Resource
    private StorageDubboService storageDubboServiceImpl;
    @Resource
    UserServiceSecondApi userServiceSecondApi;
    @Resource
    IntranetApi intranetApi;
    @Resource
    private RedisService redisService;
    private RedisTemplate redisTemplate;

    @Override
    public ClerkConfirmResponseDTO confirmSignature(ClientClerkConfirmRequestDTO reqDTO) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        Long userId = reqDTO.getUserId();
        Integer degree = reqDTO.getDegree();
        String documentIds = reqDTO.getDocumentIds();
        ArrayList signBizInfo = Lists.newArrayList();
        for (String docId : documentIds.split(",")) {
            AssertUtils.assertTrue((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{docId}) && pattern.matcher(docId).matches() ? 1 : 0) != 0, (ResultCode)ErrorCode.CLERK_SIGNATURE_FAIL, (String)"{signature.document.ids.error}");
            SignatureBizInfoReqDTO bizInfo = new SignatureBizInfoReqDTO(Long.valueOf(docId), null, null, null, null, null);
            signBizInfo.add(bizInfo);
        }
        String imgId = this.processImage(reqDTO);
        SignatureInfoReqDTO signatureInfoReqDTO = new SignatureInfoReqDTO(userId, imgId, degree, (List)signBizInfo);
        SignatureInfoResDTO resDTO = this.signatureDubboService.confirmSignature(signatureInfoReqDTO);
        ClerkConfirmResponseDTO responseDTO = new ClerkConfirmResponseDTO(resDTO.getErrorMsg());
        this.sendRecordSignPic(reqDTO);
        return responseDTO;
    }

    private String processImage(ClientClerkConfirmRequestDTO reqDTO) {
        Integer degree = reqDTO.getDegree();
        String fileName = reqDTO.getFileName();
        String fileCode = reqDTO.getFileCode();
        AssertUtils.assertTrue((boolean)JavaFileUtil.isPictureExt((String)fileName), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"{signature.image.not.exit}");
        byte[] signFileByteArr = null;
        try {
            signFileByteArr = Base64Utils.decodeBase64Bytes(fileCode);
            if (null != degree && !degree.equals(0)) {
                signFileByteArr = JavaFileUtil.rotateImg((byte[])signFileByteArr, (int)degree, null);
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
            throw new APIBusinessException((APIResultCode)APIResultCodeEnums.RESULT_EMPTY, "{signature.image.rotate.error}");
        }
        DubboResult<SaveFileResponseDTO> saveFileRes = this.storageDubboServiceImpl.save(fileName, signFileByteArr);
        AssertUtils.assertNotNull(saveFileRes, (ResultCode)ErrorCode.CLERK_SIGNATURE_IMG_SAVE_FAILE, (String)"{signature.image.save.fail}");
        SaveFileResponseDTO saveFileresDTO = (SaveFileResponseDTO)saveFileRes.getData();
        String imgId = saveFileresDTO.getFileId();
        AssertUtils.assertHasText((String)imgId, (ResultCode)ErrorCode.CLERK_SIGNATURE_IMG_ID_NOT_EXIT, (String)"{signature.image.id.is.null}");
        log.info("\u5ba2\u6237\u7aef\u7b7e\u5b57\u56fe\u7247id{}", (Object)imgId);
        return imgId;
    }

    private void sendRecordSignPic(ClientClerkConfirmRequestDTO requestDTO) {
        String appName;
        DocWholeConfirmResDTO eholeConfirmResDTO = this.signatureDubboService.queryState(Long.valueOf(requestDTO.getDocumentIds()));
        if (eholeConfirmResDTO == null || eholeConfirmResDTO.getObjectId() == null) {
            log.error("sendRecordSignPic \u83b7\u53d6\u7b14\u5f55\u4fe1\u606f\u5931\u8d25");
            return;
        }
        Long userId = requestDTO.getUserId();
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        String reverseUrlSuffix = suffix + "_NTRANET_REVERSE_URL_PREFIX_" + eholeConfirmResDTO.getObjectId();
        String reverseUrl = (String)this.redisTemplate.opsForValue().get((Object)reverseUrlSuffix);
        if (reverseUrl == null) {
            return;
        }
        log.info("\u7528\u6237{}\u83b7\u53d6\u5230\u7684\u53cd\u9988URL\u524d\u7f00\u4e3a{}", (Object)userId, (Object)reverseUrlSuffix);
        DubboResult userDubbo = this.userServiceSecondApi.getUserInfoByUserId(userId);
        if (userDubbo == null || userDubbo.getData() == null) {
            log.error("\u901a\u8fc7userId\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return;
        }
        UserInfoDTO userInfo = (UserInfoDTO)userDubbo.getData();
        DubboResult meetingCaseInfoDubbo = this.intranetApi.getIntranetMeetingCaseInfo(eholeConfirmResDTO.getObjectId());
        if (meetingCaseInfoDubbo == null || meetingCaseInfoDubbo.getData() == null) {
            log.error("\u83b7\u53d6\u6848\u4ef6\u4fe1\u606f\u5931\u8d25");
            return;
        }
        IntranetMeetingCaseInfoResDTO meetingCaseInfo = (IntranetMeetingCaseInfoResDTO)meetingCaseInfoDubbo.getData();
        JSONObject json = new JSONObject();
        json.put("courtCode", (Object)meetingCaseInfo.getOrgId());
        json.put("caseNumberCode", (Object)meetingCaseInfo.getName());
        json.put("caseOrder", (Object)meetingCaseInfo.getScheduleId());
        json.put("userName", (Object)userInfo.getUserName());
        json.put("mobilePhone", (Object)userInfo.getMobilePhone());
        byte[] signFileByteArr = null;
        try {
            signFileByteArr = Base64Utils.decodeBase64Bytes(requestDTO.getFileCode());
            if (null != requestDTO.getDegree() && !requestDTO.getDegree().equals(0)) {
                signFileByteArr = JavaFileUtil.rotateImg((byte[])signFileByteArr, (int)requestDTO.getDegree(), null);
            }
            signFileByteArr = ImgTools.compress((byte[])signFileByteArr, (double)0.3);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        json.put("signPic", (Object)Base64Utils.encodeBase64String(signFileByteArr));
        String url = reverseUrl + "/bm/uploadRecordSignPic";
        log.info("\u53d1\u9001\u7b7e\u540d\u56fe\u7247\u63a5\u53e3URL\uff1a{}", (Object)url);
        try {
            String res = MyHttpClientUtils.sendHttpPost((String)url, (String)json.toJSONString());
            log.info("\u8c03\u7528\u53d1\u9001\u7b7e\u540d\u56fe\u7247\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)res);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

