/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.DocMediationSchemeApi;
import com.beiming.odr.document.dto.requestdto.DocPersonReqDTO;
import com.beiming.odr.document.dto.requestdto.SaveMediationSchemeReqDTO;
import com.beiming.odr.document.dto.responsedto.MediationSchemeResDTO;
import com.beiming.odr.document.dto.responsedto.MediatorMediationSchemeResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.peace.service.backend.document.DocMediationSchemeDubboService;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.convert.DocumentConvert;
import com.beiming.odr.referee.dto.responsedto.MediationRoomPersonResDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DocMediationSchemeDubboServiceImpl
implements DocMediationSchemeDubboService {
    @Resource
    private DocMediationSchemeApi docMediationSchemeApi;
    @Resource
    private MediationRoomDubboService mediationRoomDubboService;

    @Override
    public MediatorMediationSchemeResDTO getMediationSchemeByMediator(Long mediationRoomId) {
        DubboResult result = this.docMediationSchemeApi.getMediationSchemeByMediator(mediationRoomId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        MediatorMediationSchemeResDTO mediationScheme = (MediatorMediationSchemeResDTO)result.getData();
        return mediationScheme;
    }

    @Override
    public ProtocolBookResponseDTO getMediationSchemeByUser(Long mediationRoomId) {
        DubboResult result = this.docMediationSchemeApi.getMediationSchemeByUser(mediationRoomId);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        MediationSchemeResDTO resDTO = (MediationSchemeResDTO)result.getData();
        ProtocolBookResponseDTO mediationScheme = DocumentConvert.convertMediationSchemeResDTO(resDTO);
        return mediationScheme;
    }

    @Override
    public Long saveMediationScheme(SaveProtocolBookRequestDTO dto) {
        SaveMediationSchemeReqDTO reqDTO = DocumentConvert.convertSaveMediationSchemeReqDTO(dto);
        MediationRoomPersonResDTO mediator = this.mediationRoomDubboService.getMediationRoomMediator(dto.getMediationRoomId());
        DocPersonReqDTO proPerson = DocumentConvert.getDocPersonReqDTO(mediator);
        reqDTO.getMediationSchemePersonList().add(proPerson);
        DubboResult result = this.docMediationSchemeApi.saveMediationScheme(reqDTO);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Long)result.getData();
    }
}

