/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.areas.api.AreaServiceApi;
import com.beiming.odr.areas.api.dto.AreasInfoDTO;
import com.beiming.odr.areas.api.dto.requestdto.AreaReqDTO;
import com.beiming.odr.areas.api.dto.responsedto.AreasResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.AreaRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.AreasResponseDTO;
import com.beiming.odr.peace.service.AreaService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AreaServiceImpl
implements AreaService {
    @Resource
    private AreaServiceApi areaServiceApi;
    @Resource
    private RedisService redisService;

    @Override
    public List<AreasResponseDTO> searchAreasInfo(AreaRequestDTO areaRequestDTO) {
        AreaReqDTO areaReqDTO = new AreaReqDTO();
        areaReqDTO.setCode(areaRequestDTO.getCode());
        areaReqDTO.setLevel(areaRequestDTO.getLevel());
        areaReqDTO.setParentCode(areaRequestDTO.getParentCode());
        DubboResult areasResult = this.areaServiceApi.searchAreasInfo(areaReqDTO);
        AssertUtils.assertTrue((boolean)areasResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)areasResult.getMessage());
        List list = ((AreasResDTO)areasResult.getData()).getData();
        ArrayList<AreasResponseDTO> result = new ArrayList<AreasResponseDTO>();
        if (list != null && list.size() > 0) {
            for (AreasInfoDTO areasInfoDTO : list) {
                result.add(new AreasResponseDTO(areasInfoDTO));
            }
        }
        return result;
    }
}

