/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.RandomValue;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LoginErrorCountUtil {
    private static final Logger log = LoggerFactory.getLogger(LoginErrorCountUtil.class);
    public static long timeout = 10L;
    public static TimeUnit unit = TimeUnit.MINUTES;
    @Resource
    private RedisService redisService;

    public void saveUserLoginErrorCount(String mobile, String loginType) {
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        if (StringUtils.isEmpty((Object)mobileBak)) {
            this.redisService.delete((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        }
        int count = this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType) == null ? 0 : (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        ++count;
        if (StringUtils.isEmpty((Object)mobileBak)) {
            this.redisService.set((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType, (Object)mobile, 12L, TimeUnit.HOURS);
        }
        this.redisService.set((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType, (Object)count, 12L, TimeUnit.HOURS);
        if (count >= 5) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.POPUP_FIRST_ERROR_CODE, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf712\u5c0f\u65f6\u540e\u91cd\u8bd5");
        }
    }

    public void deleteUserLoginErrorCount(String mobile, String loginType) {
        this.redisService.delete((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        this.redisService.delete((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
    }

    public String getImgCode(String deviceId) {
        String imgCode = RandomValue.getRandomCharAndNumr((Integer)4);
        this.redisService.set((RedisKey)RedisKeyEnums.IMG_CODE, deviceId, (Object)imgCode, 120L, unit);
        return imgCode;
    }

    public void checkImgCode(String mobile, String imgCode, String deviceId, String loginType) {
        String oldImgCode;
        String mobileBak = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_LOGIN_ERROR, mobile + loginType);
        if (StringUtils.isEmpty((Object)mobileBak)) {
            return;
        }
        int count = (Integer)this.redisService.get((RedisKey)RedisKeyEnums.USER_LOGIN_ERROR_COUNT, mobile + loginType);
        if (count <= 4) {
            return;
        }
        String deviceIdExists = (String)this.redisService.get((RedisKey)RedisKeyEnums.USER_FIRST_POPUP_LOGIN_ERROR, deviceId);
        if (StringUtils.isEmpty((Object)deviceIdExists)) {
            return;
        }
        if (StringUtils.isEmpty((Object)imgCode)) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.PLEASE_INPUT_CODE, (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
        }
        if (StringUtils.isEmpty((Object)(oldImgCode = (String)this.redisService.get((RedisKey)RedisKeyEnums.IMG_CODE, deviceId)))) {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.PLEASE_INPUT_CODE, (String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        if (imgCode.equalsIgnoreCase(oldImgCode)) {
            this.redisService.delete((RedisKey)RedisKeyEnums.IMG_CODE, deviceId);
        } else {
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.PLEASE_INPUT_CODE, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }
}

