/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.alibaba.fastjson.JSON;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.DocRecordApi;
import com.beiming.odr.document.api.DocRecordMicroApi;
import com.beiming.odr.document.dto.requestdto.DocRecordGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocRecordSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.document.dto.responsedto.DocRecordGetResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.service.backend.document.DocRecordDubboService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocRecordDubboServiceImpl
implements DocRecordDubboService {
    private static final Logger log = LoggerFactory.getLogger(DocRecordDubboServiceImpl.class);
    @Resource
    private DocRecordApi docRecordApi;
    @Resource
    private DocRecordMicroApi docRecordMicroApi;

    @Override
    public DocRecordGetResDTO viewClerkRecordForMediator(DocRecordGetReqDTO req) {
        DubboResult dubboRes = this.docRecordMicroApi.getDocRecordMicro(req, Boolean.valueOf(true));
        DocRecordGetResDTO resDTO = (DocRecordGetResDTO)dubboRes.getData();
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        return resDTO;
    }

    @Override
    public DocRecordGetResDTO viewClerkRecordForClient(DocRecordGetReqDTO reqDTO) {
        DubboResult dubboRes = this.docRecordMicroApi.getDocRecordMicro(reqDTO, Boolean.valueOf(false));
        DocRecordGetResDTO resDTO = (DocRecordGetResDTO)dubboRes.getData();
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        return resDTO;
    }

    @Override
    public DocIdResDTO saveClerkRecord(DocRecordSaveReqDTO reqDTO) {
        DubboResult dubboRes = this.docRecordApi.saveDocRecord(reqDTO);
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        DocIdResDTO resDTO = (DocIdResDTO)dubboRes.getData();
        return resDTO;
    }

    @Override
    public DocIdResDTO saveClerkRecordMicro(DocRecordSaveReqDTO reqDTO) {
        DubboResult dubboRes = this.docRecordMicroApi.saveDocRecordMicro(reqDTO);
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        DocIdResDTO resDTO = (DocIdResDTO)dubboRes.getData();
        return resDTO;
    }

    @Override
    public DocIdResDTO sendClerkRecordMicro(DocRecordSaveReqDTO reqDTO) {
        DubboResult dubboRes = this.docRecordMicroApi.sendDocRecordMicro(reqDTO);
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        DocIdResDTO resDTO = (DocIdResDTO)dubboRes.getData();
        return resDTO;
    }

    @Override
    public DocIdResDTO sendSuspectReportRecordMicro(DocRecordSaveReqDTO reqDTO) {
        DubboResult dubboRes = this.docRecordMicroApi.sendDocSuspectRecordMicro(reqDTO);
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        DocIdResDTO resDTO = (DocIdResDTO)dubboRes.getData();
        return resDTO;
    }

    @Override
    public DocIdResDTO sendElectronicReportRecordMicro(DocRecordSaveReqDTO reqDTO) {
        DubboResult dubboRes = this.docRecordMicroApi.sendDocElectronicRecordMicro(reqDTO);
        log.info("[sendElectronicReportRecordMicro] @dubboRes:{}", (Object)JSON.toJSONString((Object)dubboRes));
        AssertUtils.assertTrue((boolean)dubboRes.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        return (DocIdResDTO)dubboRes.getData();
    }

    @Override
    public DocIdResDTO sendClerkRecord(DocRecordSaveReqDTO reqDTO) {
        DubboResult dubboRes = this.docRecordApi.sendDocRecord(reqDTO);
        AssertUtils.assertTrue((dubboRes != null && dubboRes.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboRes.getMessage());
        DocIdResDTO resDTO = (DocIdResDTO)dubboRes.getData();
        return resDTO;
    }
}

