/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.demonstration;

import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.utils.RandomUtil;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MyVideoMeetingPageListResponseDTO;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DemonstrationUtil {
    @Resource
    private RedisService redisService;

    public static void setMeetingPageListResponse(List<MediationRoomUserInfoResDTO> userInfoList, MyVideoMeetingPageListResponseDTO response) {
        String joinUserId = "";
        String joinUserName = "";
        for (MediationRoomUserInfoResDTO userInfo : userInfoList) {
            joinUserId = (StringUtils.isBlank((String)joinUserId) ? "" : joinUserId + ",") + userInfo.getUserId();
            joinUserName = (StringUtils.isBlank((String)joinUserName) ? "" : joinUserName + ",") + userInfo.getUserName();
        }
        response.setJoinUserId(joinUserId);
        response.setJoinUserName(joinUserName);
        response.setJoinUserNumber(Integer.valueOf(userInfoList.size()));
    }

    public String createVerificationCode(Long mediationRoomId, String roomId, String mobilePhone, Long userId) {
        String verificationCode = "";
        Boolean flag = false;
        while (!flag.booleanValue()) {
            verificationCode = RandomUtil.getNumRandom((int)4);
            RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
            redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
            redisMediationRoomInfoDTO.setMobilePhone(mobilePhone);
            redisMediationRoomInfoDTO.setRoomId(roomId);
            redisMediationRoomInfoDTO.setUserId(userId);
            flag = this.redisService.setIfAbsent((RedisKey)RedisKeyEnums.VERIFICATION_CODE, verificationCode, (Object)redisMediationRoomInfoDTO, 365L, TimeUnit.DAYS);
        }
        return verificationCode;
    }

    public static String filterEmoji(String str) {
        if (str.trim().isEmpty()) {
            return str;
        }
        String pattern = "[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]";
        String reStr = "";
        Pattern emoji = Pattern.compile(pattern);
        Matcher emojiMatcher = emoji.matcher(str);
        str = emojiMatcher.replaceAll(reStr);
        return str;
    }
}

