/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.basic.storage.api.FileStorageApi;
import com.beiming.basic.storage.api.dto.response.FilePreviewResponseDTO;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.ClerkConfirmApi;
import com.beiming.odr.document.api.DocListApi;
import com.beiming.odr.document.dto.requestdto.DocSignListReqDTO;
import com.beiming.odr.document.dto.requestdto.SignatureConfirmInfoReqDTO;
import com.beiming.odr.document.dto.responsedto.DocPersonConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.DocSignListResDTO;
import com.beiming.odr.document.dto.responsedto.SignatureConfirmInfoResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkConfirmInfoResponseDTO;
import com.beiming.odr.peace.service.backend.document.ClerkConfirmDubboService;
import com.beiming.odr.peace.service.convert.ClerkConfirmConvert;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ClerkConfirmDubboServiceImpl
implements ClerkConfirmDubboService {
    private static final Logger log = LoggerFactory.getLogger(ClerkConfirmDubboServiceImpl.class);
    @Resource
    private ClerkConfirmApi clerkConfirmApi;
    @Resource
    private DocListApi docListApi;
    @Resource
    private FileStorageApi fileStorageApi;
    @Value(value="${file.server}")
    private String fileServer;

    @Override
    public List<ClerkConfirmInfoResponseDTO> getAllMediationClerkConfirm(Long docId) {
        DubboResult result = this.clerkConfirmApi.getAllMediationClerkConfirm(docId);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ArrayList<ClerkConfirmInfoResponseDTO> clerkConfirmRespDto = new ArrayList<ClerkConfirmInfoResponseDTO>();
        String userType = JWTContextUtil.getPersonType();
        String userId = JWTContextUtil.getCurrentUserId();
        log.info("\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606fuserType:{},userId:{}", (Object)userType, (Object)userId);
        for (DocPersonConfirmResDTO one : (ArrayList)result.getData()) {
            DubboResult filePreview;
            ClerkConfirmInfoResponseDTO clerkConfirm = ClerkConfirmConvert.convertDocPersonConfirmResDTO(one);
            if (one.getSignatureUrl() == null) {
                clerkConfirmRespDto.add(clerkConfirm);
                continue;
            }
            String signatureUrl = "";
            if (("STAFF".equals(userType) || userId.equals(one.getUserId().toString())) && (filePreview = this.fileStorageApi.filePreview(one.getSignatureUrl())).getData() != null && ((FilePreviewResponseDTO)filePreview.getData()).getFilePath() != null) {
                String filePath = ((FilePreviewResponseDTO)filePreview.getData()).getFilePath();
                signatureUrl = this.fileServer + filePath.replaceAll("weitingshen", "");
            }
            clerkConfirm.setSignatureUrl(signatureUrl);
            clerkConfirmRespDto.add(clerkConfirm);
        }
        return clerkConfirmRespDto;
    }

    @Override
    public ArrayList<SignatureConfirmInfoResDTO> signatureConfirmInfo(List<Long> documentIds) {
        SignatureConfirmInfoReqDTO reqDTO = new SignatureConfirmInfoReqDTO();
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setDocumentIds(documentIds);
        DubboResult result = this.clerkConfirmApi.signatureConfirmInfo(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        return (ArrayList)result.getData();
    }

    @Override
    public List<DocSignListResDTO> getSignDocList(DocSignListReqDTO reqDTO) {
        DubboResult resDTO = this.docListApi.signDocList(reqDTO);
        AssertUtils.assertTrue((boolean)resDTO.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        return (List)((Object)resDTO.getData());
    }
}

