/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.Java8DateUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.SMSTypeEnums;
import com.beiming.odr.peace.common.utils.RandomUtil;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.service.SMSHubeiService;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.SMSUtil;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SMSHubeiServiceImpl
implements SMSHubeiService {
    private static final Logger log = LoggerFactory.getLogger(SMSHubeiServiceImpl.class);
    @Value(value="${wechatHubei.accessTokenUrl}")
    private String accessTokenUrl;
    @Value(value="${wechatHubei.schemeUrl}")
    private String schemeUrl;
    @Value(value="${wechatHubei.appId}")
    private String appId;
    @Value(value="${wechatHubei.secret}")
    private String secret;
    @Value(value="${domainName.url}")
    private String domainUrl;
    @Resource
    RedisService redisService;
    @Resource
    private SMSUtil smsUtil;
    @Resource
    private DictionaryService dictionaryService;
    private RedisTemplate redisTemplate;

    private String callGetAccessToken() {
        String url = this.accessTokenUrl + "&appid=" + this.appId + "&secret=" + this.secret;
        String accessToken = "";
        try {
            String response = MyHttpClientUtils.sendHttpGet((String)url);
            log.info("\u83b7\u53d6access_token \u7ed3\u679c\uff1a{}", (Object)response);
            JSONObject responseJson = JSONObject.parseObject((String)response);
            if (responseJson != null && StringUtils.isNotBlank((CharSequence)responseJson.getString("access_token"))) {
                accessToken = responseJson.getString("access_token");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5c0f\u7a0b\u5e8faccess_token\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            e.printStackTrace();
        }
        return accessToken;
    }

    @Override
    public String getAccessToken() {
        this.redisTemplate = this.redisService.getRedisTemplate();
        String appName = AppNameContextHolder.getAppName();
        String accessTokenKey = appName + "_WX_ACCESS_TOKEN";
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)accessTokenKey);
        if (StringUtils.isBlank((String)accessToken)) {
            String callResult = this.callGetAccessToken();
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)callResult), (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u83b7\u53d6\u4ee4\u724c\u5931\u8d25");
            accessToken = callResult;
            this.redisTemplate.opsForValue().set((Object)accessTokenKey, (Object)accessToken, 30L, TimeUnit.MINUTES);
        }
        return accessToken;
    }

    @Override
    public String getSchemeKey(String path, String query) {
        String accessToken = this.getAccessToken();
        this.redisTemplate = this.redisService.getRedisTemplate();
        String appName = AppNameContextHolder.getAppName();
        String url = this.schemeUrl + "?access_token=" + accessToken;
        JSONObject requestJson = new JSONObject();
        JSONObject jumpWxaJson = new JSONObject();
        jumpWxaJson.put("path", (Object)path);
        jumpWxaJson.put("query", (Object)query);
        requestJson.put("jump_wxa", (Object)jumpWxaJson);
        requestJson.put("is_expire", (Object)true);
        requestJson.put("expire_type", (Object)1);
        requestJson.put("expire_interval", (Object)45);
        String scheme = "";
        String schemeKey = RandomStringUtils.randomAlphanumeric((int)6);
        try {
            log.info("\u83b7\u53d6scheme \u8bf7\u6c42\u5730\u5740\uff1a{}||\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)url, (Object)requestJson.toJSONString());
            String response = MyHttpClientUtils.sendHttpPost((String)url, (String)requestJson.toJSONString());
            log.info("\u83b7\u53d6scheme \u54cd\u5e94\u53c2\u6570\uff1a{}", (Object)response);
            JSONObject responseJson = JSONObject.parseObject((String)response);
            scheme = responseJson.getString("openlink").replaceAll("\\\\", "");
            AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)scheme), (ResultCode)ErrorCode.RESULT_EMPTY, (String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            schemeKey = this.getNotRepeatSchemeKey(schemeKey, appName);
            this.redisTemplate.opsForValue().set((Object)(appName + "_SCHEME_" + schemeKey), (Object)scheme, 45L, TimeUnit.DAYS);
            String schemeCode = (String)this.redisTemplate.opsForValue().get((Object)(appName + "_SCHEME_" + schemeKey));
            if (StringUtils.isEmpty((String)schemeCode)) {
                log.error("schemeCode \u5b58\u50a8\u5931\u8d25");
            } else if (scheme.equals(schemeCode)) {
                log.info("schemeCode: {} , \u4e0escheme: {} \u4e0d\u4e00\u81f4", (Object)schemeCode, (Object)scheme);
            } else {
                log.info("schemeCode: {}", (Object)schemeCode);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u83b7\u53d6 scheme \u5931\u8d25");
            e.printStackTrace();
        }
        return scheme;
    }

    private String getNotRepeatSchemeKey(String schemeKey, String appName) {
        this.redisTemplate = this.redisService.getRedisTemplate();
        String repeat = (String)this.redisTemplate.opsForValue().get((Object)(appName + "_SCHEME_" + schemeKey));
        if (repeat != null) {
            log.error("schemeKey\u91cd\u590d\uff0c\u9700\u91cd\u65b0\u751f\u6210||{}", (Object)schemeKey);
            schemeKey = RandomStringUtils.randomAlphanumeric((int)6);
            this.getNotRepeatSchemeKey(schemeKey, appName);
        }
        return schemeKey;
    }

    @Override
    public String getSchemeCode(String key) {
        this.redisTemplate = this.redisService.getRedisTemplate();
        String appName = AppNameContextHolder.getAppName();
        String schemeCode = (String)this.redisTemplate.opsForValue().get((Object)(appName + "_SCHEME_" + key));
        log.info("getSchemeCodeByKey: {}, is: {}", (Object)key, (Object)schemeCode);
        return schemeCode;
    }

    @Override
    public void sendMediationMeetingSmsByDTO(List<MediationMeetingUserInfoReqDTO> userList, Long mediationRoomId, String name, String roomId, String mediator, Date orderTime, Integer authFlag) {
        String appName;
        log.info("userList{}", userList);
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_";
        this.redisTemplate = this.redisService.getRedisTemplate();
        HashSet<String> phoneList = new HashSet<String>();
        String verificationCodes = null;
        for (MediationMeetingUserInfoReqDTO user : userList) {
            String phone = user.getMobilePhone();
            if (StringUtils.isBlank((String)phone) || phoneList.contains(phone)) continue;
            phoneList.add(phone);
            String verificationCode = "";
            Boolean flag = false;
            while (!flag.booleanValue()) {
                verificationCode = RandomUtil.getNumRandom((int)4);
                RedisMediationRoomInfoDTO redisMediationRoomInfoDTO = new RedisMediationRoomInfoDTO();
                redisMediationRoomInfoDTO.setMediationRoomId(mediationRoomId);
                redisMediationRoomInfoDTO.setMobilePhone(phone);
                redisMediationRoomInfoDTO.setRoomId(roomId);
                redisMediationRoomInfoDTO.setAuthFlag(authFlag);
                flag = this.redisTemplate.opsForValue().setIfAbsent((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), (Object)redisMediationRoomInfoDTO);
                if (!flag.booleanValue()) continue;
                this.redisTemplate.expire((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE.name() + verificationCode), 7L, TimeUnit.DAYS);
                verificationCodes = StringUtils.isBlank((String)verificationCodes) ? verificationCode : verificationCodes + "," + verificationCode;
            }
            this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_RELATION.name() + mediationRoomId + "_" + phone), (Object)verificationCode, 7L, TimeUnit.DAYS);
            this.redisTemplate.opsForValue().set((Object)("VERIFICATION_CODE_LOGIN_" + phone + "_" + verificationCode), (Object)1, 7L, TimeUnit.DAYS);
            HashMap data = Maps.newHashMap();
            data.put("mediator", mediator);
            data.put("name", name);
            data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
            String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
            data.put("url", url);
            data.put("verificationCode", verificationCode);
            this.smsUtil.sendSms(phone, SMSTypeEnums.SMS_MEDIATION_MEETING_LITIGANT_SIGN_IN.name() + "_" + appName.toUpperCase(), data);
        }
        String oldVerificationCodes = (String)this.redisTemplate.opsForValue().get((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId));
        if (StringUtils.isNotBlank((CharSequence)oldVerificationCodes)) {
            verificationCodes = oldVerificationCodes + "," + verificationCodes;
        }
        this.redisTemplate.opsForValue().set((Object)(suffix + RedisKeyEnums.VERIFICATION_CODE_BIZ_ID.name() + mediationRoomId), (Object)verificationCodes, 14L, TimeUnit.DAYS);
    }

    @Override
    public void sendMediationMeetingSmSAgain(String mobilePhone, Long userId, String verificationCode, Long mediationRoomId, String name, String mediator, Date orderTime) {
        String appName = AppNameContextHolder.getAppName();
        HashMap data = Maps.newHashMap();
        data.put("mediator", mediator);
        data.put("name", name);
        data.put("orderTime", Java8DateUtils.formatter((Date)orderTime, (String)"yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206"));
        String url = this.dictionaryService.getDictionaryValue("PEACE_SMALL_PROGRAM_URL_" + appName.toUpperCase());
        data.put("url", url);
        data.put("verificationCode", verificationCode);
        this.smsUtil.sendSms(mobilePhone, SMSTypeEnums.SMS_MEDIATION_MEETING_LITIGANT_SIGN_IN.name() + "_" + appName.toUpperCase(), data);
    }

    @Override
    public void sendMediationMeetingDiscipline(List<String> phoneList) {
        if (CollectionUtils.isEmpty(phoneList)) {
            return;
        }
        log.info("\u8fdb\u5165\u53d1\u9001\u5ead\u5ba1\u7eaa\u5f8b\u903b\u8f91");
        String appName = AppNameContextHolder.getAppName();
        for (String mobilePhone : phoneList) {
            this.smsUtil.sendSms(mobilePhone, SMSTypeEnums.SMS_MEDIATION_MEETING_DISCIPLINE.name() + "_" + appName.toUpperCase(), Maps.newHashMap());
        }
    }
}

