/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.producer.impl;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.domain.dto.CreateDocMqDTO;
import com.beiming.odr.peace.service.producer.CreateProducer;
import com.beiming.pigeons.api.producer.rocketmq.RocketMessageDto;
import com.beiming.pigeons.api.producer.rocketmq.RocketProducerClient;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CreateProducerImpl
implements CreateProducer {
    private static final Logger log = LoggerFactory.getLogger(CreateProducerImpl.class);
    @Resource
    private RocketProducerClient rocketProducerClient;

    @Override
    public void createDoc(CreateDocMqDTO msgDTO) {
        AssertUtils.assertTrue((boolean)Objects.nonNull(msgDTO), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)"\u4e1a\u52a1\u5904\u7406\u6d88\u606f\u4e3a\u7a7a");
        AssertUtils.assertTrue((boolean)Objects.nonNull(msgDTO.getObjectId()), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)"\u4e1a\u52a1\u5904\u7406\u6848\u53f7\u4e3a\u7a7a");
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
            String dateStr = sdf.format(msgDTO.getCreateTime());
            String bizKeyPre = "CREATE_DOCX_PROCESS";
            String bizKey = bizKeyPre + "." + dateStr + "." + String.valueOf(msgDTO.getObjectId()) + "." + Instant.now().toEpochMilli();
            msgDTO.setBizKey(bizKey);
            msgDTO.setAppName(AppNameContextHolder.getAppName());
            log.info("[DockingProducerImpl.DockingDocMqDTO] SendMQ PREPARE @AppName {} @DockingDocMqDTO {}", (Object)msgDTO.getAppName(), (Object)msgDTO);
            String topic = "createDocxProcessTopic";
            RocketMessageDto rocketMessageDTO = new RocketMessageDto(topic, bizKey, (Object)msgDTO);
            DubboResult res = this.rocketProducerClient.sendMessage(rocketMessageDTO);
            log.info("[DockingProducerImpl.DockingDocMqDTO] SendMQ END @DockingDocMqDTO {}, @SendResult {}", (Object)msgDTO, (Object)res);
        }
        catch (Exception e) {
            log.error("[DockingProducerImpl.DockingDocMqDTO] Exception @DockingDocMqDTO {}, @Exception {}", (Object)msgDTO, (Object)e);
            throw e;
        }
    }
}

