/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.peace.service.util.RSACoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RSACoderUtil {
    private static final Logger log = LoggerFactory.getLogger(RSACoderUtil.class);
    @Resource
    private RedisService redisService;

    public String decryptByPrivateKey(String data, String publicKey) {
        AssertUtils.assertTrue((StringUtils.isNotBlank((CharSequence)data) && StringUtils.isNotBlank((CharSequence)publicKey) ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u901a\u8fc7\u79c1\u94a5\u89e3\u5bc6,\u5f85\u89e3\u5bc6\u53c2\u6570\u548c\u516c\u94a5\u53c2\u6570\u5fc5\u987b\u5b58\u5728");
        String endata = "";
        String privateKey = (String)this.redisService.getRedisTemplate().opsForHash().get((Object)RedisKeyEnums.RSA_PUBLIC_KEY_AND_PRIVATE_KEY.toString(), (Object)publicKey);
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)privateKey), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u901a\u8fc7\u79c1\u94a5\u89e3\u5bc6,\u516c\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762");
        try {
            endata = RSACoder.decryptByPrivateKey(data, privateKey);
        }
        catch (Exception e) {
            log.error("\u901a\u8fc7\u79c1\u94a5\u89e3\u5bc6\u5f02\u5e38:" + e.toString());
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u901a\u8fc7\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25");
        }
        return endata;
    }

    public void initRSAKey(int size) {
        this.redisService.getRedisTemplate().delete((Object)RedisKeyEnums.RSA_PUBLIC_KEY_AND_PRIVATE_KEY.toString());
        this.redisService.getRedisTemplate().delete((Object)RedisKeyEnums.RSA_PUBLIC_KEY.toString());
        log.info("\u751f\u6210RSA\u7684key===\u5f00\u59cb===");
        Map<String, String> rsaKey = null;
        try {
            rsaKey = RSACoder.initKeyMap(size);
        }
        catch (Exception e) {
            log.error("\u751f\u6210RSA\u5bc6\u94a5\u96c6\u5408\u5f02\u5e38:" + e.toString());
            AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u751f\u6210RSA\u5bc6\u94a5\u96c6\u5408\u5f02\u5e38");
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : rsaKey.keySet()) {
            keyList.add(key);
            this.redisService.getRedisTemplate().opsForHash().put((Object)RedisKeyEnums.RSA_PUBLIC_KEY_AND_PRIVATE_KEY.toString(), (Object)key, (Object)rsaKey.get(key));
        }
        this.redisService.getRedisTemplate().opsForSet().add((Object)RedisKeyEnums.RSA_PUBLIC_KEY.toString(), (Object[])keyList.toArray(new String[keyList.size()]));
        log.info("\u751f\u6210RSA\u7684key===\u7ed3\u675f===");
    }

    public String getRandomPublicKey() {
        String publicKey = (String)this.redisService.getRedisTemplate().opsForSet().randomMember((Object)RedisKeyEnums.RSA_PUBLIC_KEY.toString());
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)publicKey), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5f02\u5e38");
        return publicKey;
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat fordate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("\u5f00\u59cb\u65f6\u95f4\n" + fordate.format(new Date()));
        new RSACoderUtil().initRSAKey(100);
        System.out.println("\u7ed3\u675f\u65f6\u95f4\n" + fordate.format(new Date()));
    }
}

