/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.beiming.odr.document.dto.responsedto.DocAttachmentResDTO;
import com.beiming.odr.peace.common.enums.AttachmentEnum;
import com.beiming.odr.peace.domain.dto.responsedto.DocumentResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.IntranetDocumentResponseDTO;
import com.beiming.odr.referee.dto.responsedto.IntranetAttchmentResDTO;

public class AttachmentConvert {
    public static DocumentResponseDTO convertDocAttachmentResDTO(DocAttachmentResDTO resDTO) {
        DocumentResponseDTO responseDTO = new DocumentResponseDTO();
        responseDTO.setId(resDTO.getId());
        responseDTO.setUserId(resDTO.getCaseUserId());
        responseDTO.setSign(resDTO.getSign());
        responseDTO.setDocFileId(resDTO.getFileId());
        responseDTO.setDocType(resDTO.getCategoryMiddle());
        responseDTO.setDocName(resDTO.getFileName());
        responseDTO.setDocUser(resDTO.getCreateUser());
        responseDTO.setDocClass(resDTO.getCategoryBig());
        return responseDTO;
    }

    public static DocumentResponseDTO getDocumentListResponseDTO(DocAttachmentResDTO resDTO) {
        DocumentResponseDTO responseDTO = new DocumentResponseDTO();
        responseDTO.setDocClass(resDTO.getCategoryBig());
        responseDTO.setUserId(resDTO.getPersonnelId());
        responseDTO.setSign(resDTO.getSign());
        responseDTO.setId(resDTO.getId());
        responseDTO.setDocUser(resDTO.getCreateUser());
        responseDTO.setDocType(resDTO.getCategoryMiddle());
        responseDTO.setDocName(resDTO.getFileName());
        responseDTO.setDocFileId(resDTO.getFileId());
        responseDTO.setRoomId(resDTO.getRoomId());
        responseDTO.setDocId(resDTO.getDocId());
        return responseDTO;
    }

    public static IntranetDocumentResponseDTO getIntranetDocumentListResponseDTO(DocAttachmentResDTO resDTO) {
        IntranetDocumentResponseDTO responseDTO = new IntranetDocumentResponseDTO();
        responseDTO.setDocClass(resDTO.getCategoryBig());
        String wslb = "JUDICIAL_DOCUMENT".equals(resDTO.getObjectType()) ? "\u6587\u4e66\u7b14\u5f55" : ("INTRANET_MATERIALS".equals(resDTO.getObjectType()) ? "\u5176\u4ed6\u6587\u4e66" : "\u5176\u4ed6\u6750\u6599");
        responseDTO.setUserId(resDTO.getPersonnelId());
        responseDTO.setSign(resDTO.getSign());
        responseDTO.setId(resDTO.getId());
        responseDTO.setDocUser(resDTO.getCreateUser());
        responseDTO.setDocType(wslb);
        String fileName = resDTO.getFileName();
        if (fileName.endsWith("doc") || fileName.endsWith("docx")) {
            String pdfName = !fileName.split("\\.")[1].contains("pdf") ? fileName.split("\\.")[0].concat(".pdf") : fileName;
            responseDTO.setDocName(pdfName);
        } else {
            responseDTO.setDocName(fileName);
        }
        responseDTO.setDocFileId(resDTO.getFileId());
        responseDTO.setRoomId(resDTO.getRoomId());
        responseDTO.setDocId(resDTO.getDocId());
        responseDTO.setCreateTime(resDTO.getCreateTime());
        responseDTO.setFlag(AttachmentEnum.INTERNET.name());
        responseDTO.setExamineFlag(resDTO.getExamineFlag());
        return responseDTO;
    }

    public static IntranetDocumentResponseDTO getInternetDocumentListResponseDTO(IntranetAttchmentResDTO resDTO) {
        IntranetDocumentResponseDTO responseDTO = new IntranetDocumentResponseDTO();
        responseDTO.setId(resDTO.getId());
        responseDTO.setDocClass(resDTO.getWslb());
        responseDTO.setDocUser(resDTO.getMl2());
        responseDTO.setDocType(resDTO.getWslb());
        responseDTO.setDocName(resDTO.getMc());
        responseDTO.setCreateTime(resDTO.getCreateTime());
        responseDTO.setFlag(AttachmentEnum.INTRANET.name());
        responseDTO.setExamineFlag(resDTO.getExamineFlag());
        return responseDTO;
    }
}

