/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.alibaba.fastjson.JSONObject;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.domain.dto.requestdto.AddMeetingIntranetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.referee.dto.requestdto.AddMediationMeetingRoomMicroReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IntranetMediationMeetingConvert {
    public static AddMediationMeetingRoomMicroReqDTO getAddMediationMeetingRoomMicroReqDTO(AddMeetingIntranetRequestDTO dto) {
        AddMediationMeetingRoomMicroReqDTO addDto = new AddMediationMeetingRoomMicroReqDTO();
        addDto.setMediationMeetingRoomName(dto.getCaseNumberCode());
        addDto.setAuthFlag(Integer.valueOf(1));
        addDto.setCallFlag(Integer.valueOf(0));
        addDto.setOrderTime(dto.getOrderTime());
        addDto.setCauseName(dto.getCauseName());
        addDto.setScheduleId(dto.getCaseOrder());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(ColumnEnums.CASE_TYPE.desc(), (Object)dto.getCaseType());
        if (!StringUtils.isEmpty((CharSequence)dto.getAhdm())) {
            jsonObject.put("ahdm", (Object)dto.getAhdm());
        }
        addDto.setExpandAttribute(jsonObject.toJSONString());
        ArrayList litigantList = Lists.newArrayList();
        ArrayList mediationList = Lists.newArrayList();
        List list = dto.getLitigantList();
        list = list == null ? Lists.newArrayList() : list;
        for (int i = 0; i < list.size(); ++i) {
            LitigantInfoRequestDTO userDto = (LitigantInfoRequestDTO)list.get(i);
            MediationMeetingUserInfoReqDTO userInfoReqDTO = IntranetMediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(userDto);
            userInfoReqDTO.setExpandAttribute(IntranetMediationMeetingConvert.buildLitigantJsonInfo(userDto));
            litigantList.add(userInfoReqDTO);
        }
        List agentList = dto.getAgentList();
        agentList = agentList == null ? Lists.newArrayList() : agentList;
        ArrayList agentListAdd = Lists.newArrayList();
        for (LitigantAgentInfoMicroRequestDTO agentInfoMicroReq : agentList) {
            String agentParentUserUserTempIdStr = agentInfoMicroReq.getAgentParentUserTempIdList();
            List<Object> agentParentUserTempIdList = Lists.newArrayList();
            if (!StringUtils.isBlank((CharSequence)agentParentUserUserTempIdStr)) {
                String[] split = agentParentUserUserTempIdStr.split(",");
                agentParentUserTempIdList = Arrays.asList(split);
            }
            List<MediationMeetingUserInfoReqDTO> agentListTemp = IntranetMediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(agentInfoMicroReq, agentParentUserTempIdList);
            agentListAdd.addAll(agentListTemp);
        }
        addDto.setAgentList((List)agentListAdd);
        addDto.setLitigantList((List)litigantList);
        List mediatorList = dto.getMediatorList();
        for (LitigantInfoRequestDTO litigantInfoRequestDTO : mediatorList) {
            MediationMeetingUserInfoReqDTO userInfoReqDTO = IntranetMediationMeetingConvert.getMediationMeetingUserInfoMicroReqDTO(litigantInfoRequestDTO);
            userInfoReqDTO.setExpandAttribute(IntranetMediationMeetingConvert.buildMediatorJsonInfo(litigantInfoRequestDTO));
            mediationList.add(userInfoReqDTO);
        }
        addDto.setMediatorList((List)mediationList);
        if (dto.getRemark() != null) {
            addDto.setRemark(dto.getRemark());
        }
        return addDto;
    }

    public static MediationMeetingUserInfoReqDTO getMediationMeetingUserInfoMicroReqDTO(LitigantInfoRequestDTO dto) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType().name());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setRemark(dto.getUserTempId());
        reqDTO.setExpandAttribute(IntranetMediationMeetingConvert.buildLitigantJsonInfo(dto));
        return reqDTO;
    }

    public static List<MediationMeetingUserInfoReqDTO> getMediationMeetingUserInfoMicroReqDTO(LitigantAgentInfoMicroRequestDTO dto, List<String> agentParentUserTempIdList) {
        ArrayList list = Lists.newArrayList();
        for (String userTempId : agentParentUserTempIdList) {
            MediationMeetingUserInfoReqDTO reqDTO = IntranetMediationMeetingConvert.createAgentReqObject(dto, userTempId);
            list.add(reqDTO);
        }
        if (list.size() == 0) {
            MediationMeetingUserInfoReqDTO reqDTO = IntranetMediationMeetingConvert.createAgentReqObject(dto, null);
            list.add(reqDTO);
        }
        return list;
    }

    private static MediationMeetingUserInfoReqDTO createAgentReqObject(LitigantAgentInfoMicroRequestDTO dto, String userTempId) {
        MediationMeetingUserInfoReqDTO reqDTO = new MediationMeetingUserInfoReqDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType().name());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setAgentUserTempId(userTempId);
        reqDTO.setAgentType(dto.getAgentType() == null ? "" : dto.getAgentType().name());
        reqDTO.setUserOrder(dto.getUserOrder());
        reqDTO.setRemark(dto.getUserTempId());
        return reqDTO;
    }

    public static String buildLitigantJsonInfo(LitigantInfoRequestDTO dto) {
        if (dto.getLitigantType() == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(ColumnEnums.ORIGINAL_LITIGATION_STATUS.desc(), (Object)dto.getOriginalLitigationStatus());
        json.put(ColumnEnums.LITIGANT_TYPE.desc(), (Object)dto.getLitigantType());
        if (dto.getLitigantType() != 1) {
            json.put(ColumnEnums.UNIT_NAME.desc(), (Object)dto.getUnitName());
            json.put(ColumnEnums.CREDIT_CODE.desc(), (Object)dto.getCreditCode());
        }
        return json.toJSONString();
    }

    public static String buildMediatorJsonInfo(LitigantInfoRequestDTO dto) {
        if (dto.getIsUndertaker() == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(ColumnEnums.IS_UNDERTAKER.desc(), (Object)dto.getIsUndertaker());
        return json.toJSONString();
    }

    public static LitigantAgentInfoMicroRequestDTO getLitigantAgentInfo(LitigantAgentInfoRequestDTO dto, String userTempId) {
        LitigantAgentInfoMicroRequestDTO reqDTO = new LitigantAgentInfoMicroRequestDTO();
        reqDTO.setMeetingUserType(dto.getMeetingUserType());
        reqDTO.setUserId(dto.getUserId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setAuthStatus(dto.getAuthStatus());
        reqDTO.setUserTempId(dto.getUserTempId());
        reqDTO.setAgentType(dto.getAgentType());
        reqDTO.setUserOrder(dto.getUserOrder());
        reqDTO.setAgentParentUserTempIdList(userTempId);
        return reqDTO;
    }

    public static LitigantInfoRequestDTO buildLitigantInfo(UserInfoDTO userInfo) {
        LitigantInfoRequestDTO mediator = new LitigantInfoRequestDTO();
        mediator.setUserId(userInfo.getUserId());
        mediator.setUserName(userInfo.getUserName());
        mediator.setMobilePhone(userInfo.getMobilePhone());
        mediator.setMeetingUserType(MeetingUserTypeEnum.MEDIATOR);
        mediator.setIsUndertaker(Integer.valueOf(3));
        return mediator;
    }
}

