/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.CheckCaseInfoRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.GetCaseInfoRequestDTO;
import com.beiming.odr.peace.service.MediationMeetingSecondService;
import com.beiming.odr.referee.api.CaseRoomMicroApi;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.responsedto.CaseListMicroResponseDTO;
import com.beiming.odr.referee.enums.MediationMeetingTypeEnum;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MediationMeetingSecondServiceImpl
implements MediationMeetingSecondService {
    private static final Logger log = LoggerFactory.getLogger(MediationMeetingSecondServiceImpl.class);
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Resource
    private CaseRoomMicroApi caseRoomMicroApi;

    @Override
    public void checkNameAndScheduleId(CheckCaseInfoRequestDTO dto) {
        String userId = JWTContextUtil.getCurrentUserId();
        String type = MediationMeetingTypeEnum.MEDIATION_MEETING.name();
        DubboResult numResult = this.mediationRoomApi.checkNameAndScheduleId(dto.getName(), type, dto.getScheduleId(), userId);
        if (numResult == null || numResult.getData() == null) {
            return;
        }
        Integer caseNum = (Integer)numResult.getData();
        AssertUtils.assertTrue((caseNum < 1 ? 1 : 0) != 0, (ResultCode)ErrorCode.NAME_IS_REPEAT, (String)ErrorCode.NAME_IS_REPEAT.desc());
    }

    @Override
    public ArrayList<CaseListMicroResponseDTO> mediationMeetingList(GetCaseInfoRequestDTO dto) {
        DubboResult dubboResult = this.caseRoomMicroApi.getMediationMeetingList(dto.getBizRoomId());
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.RESULT_EMPTY, (String)ErrorCode.RESULT_EMPTY.desc());
        ArrayList meetingList = (ArrayList)dubboResult.getData();
        return meetingList;
    }
}

