/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.sender;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ClientEventEnums;
import com.beiming.odr.peace.common.enums.SendToPeaceEventEnums;
import com.beiming.odr.peace.domain.dto.entity.PeaceImEventMqEntity;
import com.beiming.odr.peace.domain.dto.imres.WebSocketResponseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SenderService {
    private static final Logger log = LoggerFactory.getLogger(SenderService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${server.peaceIm.channel.chat:peaceIm_chat}")
    private String channel;
    @Value(value="${server.peaceIm.channel.sendToPeace:sendToPeace}")
    private String sendToPeaceChannel;

    public void sendMessage(PeaceImEventMqEntity sendDTO) {
        AssertUtils.assertNotNull((Object)sendDTO, (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)"\u53d1\u9001\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        String[] receiverIds = sendDTO.getReceiverIds();
        if (receiverIds == null || receiverIds.length < 1) {
            log.info("\u63a5\u6536\u8005\u6570\u91cf\u4e3a:{}", (Object)(receiverIds == null ? null : Integer.valueOf(0)));
            return;
        }
        String appName = AppNameContextHolder.getAppName();
        sendDTO.setAppName(appName);
        String message = JSON.toJSONString((Object)sendDTO);
        String receiverIdsStr = JSON.toJSONString((Object)receiverIds);
        this.stringRedisTemplate.convertAndSend(this.channel, (Object)message);
        log.info("sendMessageToRedis:{},{},{},{}", new Object[]{appName, sendDTO.getSender(), receiverIdsStr, sendDTO.getEvent(), appName});
    }

    public void sendMessage(String roomId, String sender, String[] receiverIds, ClientEventEnums event, WebSocketResponseDTO response) {
        if (receiverIds == null || receiverIds.length < 1) {
            return;
        }
        PeaceImEventMqEntity sendDTO = new PeaceImEventMqEntity(roomId, sender, receiverIds, event, response);
        this.sendMessage(sendDTO);
    }

    public void leaveVideoNotice(String memberId, String roomId, String appName) {
        JSONObject jobj = new JSONObject();
        jobj.put("roomId", (Object)roomId);
        jobj.put("memberId", (Object)memberId);
        this.sendToPeace(jobj, appName, SendToPeaceEventEnums.LEAVE_VIDEO_ROOM);
    }

    public void sendToPeace(JSONObject data, String appName, SendToPeaceEventEnums event) {
        AssertUtils.assertNotNull((Object)data, (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)"\u53d1\u9001\u6d88\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.assertNotNull((Object)event, (ResultCode)APIResultCodeEnums.UNEXCEPTED, (String)"\u53d1\u9001\u6d88\u606f\u7684\u4e8b\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        JSONObject post = new JSONObject();
        post.put("data", (Object)data);
        post.put("event", (Object)event.name());
        post.put("appName", (Object)appName);
        String message = post.toString();
        this.stringRedisTemplate.convertAndSend(this.sendToPeaceChannel, (Object)message);
        log.info("sendToPeaceChannel:{}", (Object)message);
    }
}

