/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.message.api.MessageServiceApi;
import com.beiming.basic.message.dto.request.SendSmsRequestDTO;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.SMSTypeEnums;
import com.beiming.odr.peace.service.enums.RedisKeyEnums;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SMSUtil {
    private static final Logger log = LoggerFactory.getLogger(SMSUtil.class);
    @Value(value="${SMS.send.flag}")
    private Boolean smsSendFlag;
    @Value(value="${SMS.send.fixedCodeFlag}")
    private Boolean smsSendFixedCodeFlag;
    @Resource
    private MessageServiceApi messageServiceApi;
    @Resource
    private RedisService redisService;
    private static final String SMSTEMPLE = "SMS_USER_MOBILE_PHONE";

    public String sendSms(String mobile, SMSTypeEnums smsType, PersonTypeEnum personType) {
        String msgCode = "";
        String validateKey = mobile + "_validate";
        String obj = (String)this.redisService.get((RedisKey)RedisKeyEnums.SMS_CODE, validateKey);
        AssertUtils.assertTrue((boolean)StringUtils.isBlank((String)obj), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u4e00\u5206\u949f\u4e4b\u540e\u624d\u80fd\u53d1\u9001\u77ed\u4fe1");
        if (!this.smsSendFixedCodeFlag.booleanValue()) {
            Random r = new Random();
            for (int i = 0; i < 6; ++i) {
                msgCode = msgCode + r.nextInt(10);
            }
        } else {
            msgCode = "666666";
        }
        if (this.smsSendFlag.booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("smsUserMobilePhone", (Object)msgCode);
            SendSmsRequestDTO req = new SendSmsRequestDTO(mobile, SMSTEMPLE, json);
            DubboResult result = this.messageServiceApi.sendSMS(req);
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        }
        this.redisService.set((RedisKey)RedisKeyEnums.SMS_CODE, mobile + smsType.toString() + personType.toString(), (Object)msgCode, 5L, TimeUnit.MINUTES);
        this.redisService.set((RedisKey)RedisKeyEnums.SMS_CODE, validateKey, (Object)validateKey, 1L, TimeUnit.MINUTES);
        log.info("\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801=====mobile=" + mobile + ",code=" + msgCode);
        return msgCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean checkMobilePhoneCode(String mobile, String smsCode, SMSTypeEnums smsType, Boolean bol, PersonTypeEnum personType) {
        Boolean hasKey = this.redisService.getRedisTemplate().hasKey((Object)("PASSWORD_RESET_COUNT_" + mobile));
        if (hasKey.booleanValue()) {
            Integer count1 = (Integer)this.redisService.getRedisTemplate().opsForValue().get((Object)("PASSWORD_RESET_COUNT_" + mobile));
            if (count1 >= 5) {
                AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE_LIMIT, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf712\u5c0f\u65f6\u540e\u91cd\u8bd5");
            }
            SMSUtil sMSUtil = this;
            synchronized (sMSUtil) {
                Integer value = (Integer)this.redisService.getRedisTemplate().opsForValue().get((Object)("PASSWORD_RESET_COUNT_" + mobile));
                this.redisService.getRedisTemplate().opsForValue().set((Object)("PASSWORD_RESET_COUNT_" + mobile), (Object)(value + 1), 12L, TimeUnit.HOURS);
                Integer count = (Integer)this.redisService.getRedisTemplate().opsForValue().get((Object)("PASSWORD_RESET_COUNT_" + mobile));
                if (count >= 5) {
                    AssertUtils.assertTrue((boolean)false, (ResultCode)ErrorCode.ERROR_CODE_LIMIT, (String)"\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u8bf712\u5c0f\u65f6\u540e\u91cd\u8bd5");
                }
            }
        } else {
            this.redisService.getRedisTemplate().opsForValue().set((Object)("PASSWORD_RESET_COUNT_" + mobile), (Object)0, 12L, TimeUnit.HOURS);
        }
        String code = (String)this.redisService.get((RedisKey)RedisKeyEnums.SMS_CODE, mobile + smsType.toString() + personType.toString());
        if (smsCode.equals(code)) {
            if (bol.booleanValue()) {
                this.redisService.delete((RedisKey)RedisKeyEnums.SMS_CODE, mobile + smsType.toString() + personType.toString());
                this.redisService.getRedisTemplate().delete((Object)("PASSWORD_RESET_COUNT_" + mobile));
            }
            return true;
        }
        return false;
    }

    public void sendSms(String mobilePhone, String smsEnum, Map<String, String> data) {
        if (StringUtils.isBlank((String)mobilePhone) || null == smsEnum) {
            log.error("mobilePhone is {},smsEnum {},data {}", new Object[]{mobilePhone, smsEnum, data});
            return;
        }
        SendSmsRequestDTO smsRequestDTO = new SendSmsRequestDTO();
        try {
            smsRequestDTO.setParams(JSONObject.parseObject((String)JSON.toJSONString(data)));
            smsRequestDTO.setPhone(mobilePhone);
            smsRequestDTO.setTemplateId(smsEnum);
            DubboResult result = this.messageServiceApi.sendSMS(smsRequestDTO);
            log.info("sendSms requestDto {},result {}", (Object)smsRequestDTO, (Object)result);
            if (!result.isSuccess()) {
                log.error("sendSms error requestDto {},result {}", (Object)smsRequestDTO, (Object)result);
            }
        }
        catch (Exception e) {
            log.error("sendSms reqDto {} error {}", (Object)smsRequestDTO, (Object)e);
        }
    }
}

