/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.DocPromiseApi;
import com.beiming.odr.document.dto.requestdto.ObjectReqDTO;
import com.beiming.odr.document.dto.requestdto.SavePromiseBookReqDTO;
import com.beiming.odr.document.dto.requestdto.UserInfoReqDTO;
import com.beiming.odr.document.dto.responsedto.MediationPromiseGetResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.SavePromiseBookRequestDTO;
import com.beiming.odr.peace.service.backend.document.DocPromiseDubboService;
import com.beiming.odr.peace.service.backend.user.UserDubboService;
import com.beiming.odr.peace.service.convert.DocumentConvert;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DocPromiseDubboServiceImpl
implements DocPromiseDubboService {
    @Resource
    private DocPromiseApi docPromiseApi;
    @Resource
    private UserDubboService userDubboService;

    @Override
    public void savePromiseBook(SavePromiseBookRequestDTO dto, ArrayList<MediationRoomUserInfoResDTO> list) {
        SavePromiseBookReqDTO reqDTO = DocumentConvert.convertSavePromiseBookReqDTO(dto, list);
        DubboResult result = this.docPromiseApi.savePromiseBook(reqDTO);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    @Override
    public MediationPromiseGetResDTO getMediationPromise(Long objectId, String objectType) {
        UserInfoReqDTO user = new UserInfoReqDTO(Long.valueOf(JWTContextUtil.getCurrentUserId()), this.userDubboService.getUserNameByJWT());
        ObjectReqDTO objDTO = new ObjectReqDTO(objectId, objectType);
        DubboResult result = this.docPromiseApi.getMediationPromise(user, objDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (MediationPromiseGetResDTO)result.getData();
    }
}

