/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.RoomMediationApi;
import com.beiming.basic.chat.api.dto.response.MemberResDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.ShortUrlUtils;
import com.beiming.odr.document.dto.requestdto.DocRecordGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocRecordSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocIdResDTO;
import com.beiming.odr.document.dto.responsedto.DocRecordGetResDTO;
import com.beiming.odr.document.dto.responsedto.ElectronicDeliveryResDTO;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import com.beiming.odr.peace.common.constants.MeetingUserTypeConst;
import com.beiming.odr.peace.common.enums.ColumnEnums;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.PeaceRedisKeyEnums;
import com.beiming.odr.peace.common.utils.DocXmlUtil;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordGetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordSaveRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.CommonIdRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SuspectReportRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordSaveResponseDTO;
import com.beiming.odr.peace.service.MediationMeetingService;
import com.beiming.odr.peace.service.backend.document.DocRecordDubboService;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.backend.user.UserBackendService;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import com.beiming.odr.peace.service.convert.DocPersonalConvert;
import com.beiming.odr.peace.service.convert.DocRecordConvert;
import com.beiming.odr.peace.service.util.TokenGeneratorParse;
import com.beiming.odr.referee.api.MediationRoomApi;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClerkRecordServiceImpl
implements ClerkRecordService {
    private static final Logger log = LoggerFactory.getLogger(ClerkRecordServiceImpl.class);
    @Resource
    private RedisService redisService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private DocRecordDubboService docRecordDubboService;
    @Resource
    private MediationRoomDubboService mediationRoomDubboService;
    @Resource
    private MediationMeetingService mediationMeetingService;
    @Resource
    private UserBackendService userBackendService;
    @Resource
    private RoomMediationApi roomMediationApi;
    @Resource
    private MediationRoomApi mediationRoomApi;
    @Value(value="${peace.qrCodeUrlPrefix}")
    private String qrCodeUrlPrefix;
    @Value(value="${peace.accessSignUrlPrefix}")
    private String accessSignUrlPrefix;
    @Value(value="${peace.accessSignUrlSuffix}")
    private String accessSignUrlSuffix;
    @Resource
    TokenGeneratorParse tokenGeneratorParse;

    @Override
    public ClerkRecordGetResponseDTO viewClerkRecord(ClerkRecordGetRequestDTO requestDTO) {
        DocRecordGetReqDTO reqDTO = this.buildDocRecordGetReqDTO(requestDTO);
        if (reqDTO == null) {
            return null;
        }
        DocRecordGetResDTO resDTO = new DocRecordGetResDTO();
        Long bizId = requestDTO.getBizId();
        if (this.mediationRoomDubboService.checkIsWorker(bizId).booleanValue()) {
            resDTO = this.docRecordDubboService.viewClerkRecordForMediator(reqDTO);
            if (AppNameContextHolder.getAppName().contains("weitingshen") && null == requestDTO.getDocId()) {
                SearchServicePersonResDTO servicePerson = this.userBackendService.searchServicePerson(Long.valueOf(JWTContextUtil.getCurrentUserId()));
                List userRoleRelationList = servicePerson.getUserRoleRelationList();
                UserRoleInfoDTO userRoleInfoDTO = (UserRoleInfoDTO)userRoleRelationList.get(0);
                resDTO.setOrgId(userRoleInfoDTO.getOrganizationId());
                resDTO.setOrgName(userRoleInfoDTO.getOrganizationName());
            }
        } else {
            resDTO = this.docRecordDubboService.viewClerkRecordForClient(reqDTO);
        }
        if (AppNameContextHolder.getAppName().contains("weitingshen") && Objects.isNull(resDTO.getDocId())) {
            MediationMeetingRoomInfoResDTO roomInfo = this.mediationRoomDubboService.getMediationMeetingRoomInfo(bizId);
            resDTO.setDisputeType(roomInfo.getCauseName());
            resDTO.setBizNo(roomInfo.getName());
        }
        ClerkRecordGetResponseDTO result = DocRecordConvert.convertClerkRecordGetResponseDTO(resDTO);
        String caseType = "MSYS";
        DubboResult meetingInfo = this.mediationRoomApi.selectCaseMeetingInfo(bizId);
        if (meetingInfo != null && meetingInfo.getData() != null && ((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getExpandAttribute() != null) {
            JSONObject json = JSONObject.parseObject((String)((CaseMeetingRoomInfoResDTO)meetingInfo.getData()).getExpandAttribute());
            caseType = (String)json.get((Object)ColumnEnums.CASE_TYPE.desc());
            log.info("\u7b14\u5f55\u63a5\u53e3\u83b7\u53d6\u7684\u6848\u4ef6\u7c7b\u578b\u4e3a\uff1a{}", (Object)caseType);
        }
        result.setCaseType(caseType);
        return result;
    }

    @Override
    public ClerkRecordSaveResponseDTO saveClerkRecord(ClerkRecordSaveRequestDTO requestDTO) {
        DocRecordSaveReqDTO reqDTO = this.buildDocRecordSaveReqDTO(requestDTO);
        DocIdResDTO resDTO = this.docRecordDubboService.saveClerkRecord(reqDTO);
        return DocRecordConvert.convertClerkRecordSaveResponseDTO(resDTO);
    }

    @Override
    public ClerkRecordSaveResponseDTO saveClerkRecordMicro(ClerkRecordSaveRequestDTO requestDTO) {
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)requestDTO.getUserInfo()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"{common.parameterIsNull}");
        DocRecordSaveReqDTO reqDTO = this.buildDocRecordSaveReqDTO(requestDTO);
        DocIdResDTO resDTO = this.docRecordDubboService.saveClerkRecordMicro(reqDTO);
        return DocRecordConvert.convertClerkRecordSaveResponseDTO(resDTO);
    }

    @Override
    public ClerkRecordSaveResponseDTO sendClerkRecord(ClerkRecordSaveRequestDTO requestDTO) {
        DocRecordSaveReqDTO reqDTO = this.buildDocRecordSaveReqDTO(requestDTO);
        DocIdResDTO resDTO = this.docRecordDubboService.sendClerkRecord(reqDTO);
        ClerkRecordSaveResponseDTO responseDTO = DocRecordConvert.convertClerkRecordSaveResponseDTO(resDTO);
        responseDTO.setLaunchSign(this.buildLaunchSign(resDTO.getDocId()));
        return responseDTO;
    }

    @Override
    public ClerkRecordSaveResponseDTO createSuspectReport(SuspectReportRequestDTO requestDTO, String jwttoken) {
        DocRecordSaveReqDTO reqDTO = this.buildDocSuspectRecordSaveReqDTO(requestDTO);
        reqDTO.setCreateUserId(this.tokenGeneratorParse.getUserIdByJWTToken(jwttoken));
        reqDTO.setCreateUser(this.tokenGeneratorParse.getUserNameByJWTToken(jwttoken));
        DocIdResDTO resDTO = this.docRecordDubboService.sendSuspectReportRecordMicro(reqDTO);
        ClerkRecordSaveResponseDTO responseDTO = DocRecordConvert.convertClerkRecordSaveResponseDTO(resDTO);
        responseDTO.setLaunchSign(this.buildLaunchSign(resDTO.getDocId()));
        return responseDTO;
    }

    @Override
    public DocIdResDTO createElectronicReport(SuspectReportRequestDTO requestDTO) {
        DocRecordSaveReqDTO reqDTO = this.buildDocElectronicRecordSaveReqDTO(requestDTO);
        log.info("createElectronicReport.reqDTO is:{}", (Object)reqDTO);
        return this.docRecordDubboService.sendElectronicReportRecordMicro(reqDTO);
    }

    @Override
    public void electronicLaunchSign(ElectronicDeliveryResDTO resDTO) {
        resDTO.setLaunchSign(this.buildElectronicLaunchSign(resDTO.getDocId()));
    }

    @Override
    public ClerkRecordSaveResponseDTO sendClerkRecordMicro(ClerkRecordSaveRequestDTO requestDTO) {
        requestDTO.setContent(DocXmlUtil.checkUnicodeString((String)requestDTO.getContent()));
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)requestDTO.getUserInfo()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"{common.parameterIsNull}");
        DocRecordSaveReqDTO reqDTO = this.buildDocRecordSaveReqDTO(requestDTO);
        DocIdResDTO resDTO = this.docRecordDubboService.sendClerkRecordMicro(reqDTO);
        ClerkRecordSaveResponseDTO responseDTO = DocRecordConvert.convertClerkRecordSaveResponseDTO(resDTO);
        responseDTO.setLaunchSign(this.buildLaunchSign(resDTO.getDocId()));
        return responseDTO;
    }

    private String buildLaunchSign(Long docId) {
        String apiUrl = this.dictionaryService.getDictionaryValue("PEACE_API_URL");
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        String shortQrCodeUrl = ShortUrlUtils.encode((long)docId) + ShortUrlUtils.encode((long)userId);
        String shortUrl = apiUrl + this.qrCodeUrlPrefix.concat(shortQrCodeUrl);
        String appName = AppNameContextHolder.getAppName();
        log.info("buildLaunchSign appName is {}", (Object)appName);
        String longUrl = apiUrl.concat(this.accessSignUrlPrefix).concat(appName).concat("/").concat(this.accessSignUrlSuffix).concat(docId.toString()) + "&userId=" + userId;
        this.redisService.hSet((RedisKey)PeaceRedisKeyEnums.SHORT_URL, shortQrCodeUrl, (Object)longUrl);
        return shortUrl;
    }

    private String buildElectronicLaunchSign(Long docId) {
        String apiUrl = this.dictionaryService.getDictionaryValue("PEACE_API_URL");
        Long userId = Long.valueOf(JWTContextUtil.getCurrentUserId());
        String shortQrCodeUrl = ShortUrlUtils.encode((long)docId) + ShortUrlUtils.encode((long)userId);
        String shortUrl = apiUrl + this.qrCodeUrlPrefix.concat(shortQrCodeUrl);
        String appName = AppNameContextHolder.getAppName();
        log.info("buildLaunchSign appName is {}", (Object)appName);
        String longUrl = apiUrl.concat(this.accessSignUrlPrefix).concat(appName).concat("/").concat(this.accessSignUrlSuffix).concat(docId.toString()) + "&userId=" + userId + "&source=ELECTRONIC_DOC";
        this.redisService.hSet((RedisKey)PeaceRedisKeyEnums.SHORT_URL, shortQrCodeUrl, (Object)longUrl);
        return shortUrl;
    }

    private DocRecordGetReqDTO buildDocRecordGetReqDTO(ClerkRecordGetRequestDTO requestDTO) {
        String meetingVideoId;
        DocRecordGetReqDTO reqDTO = DocRecordConvert.convertDocRecordGetReqDTO(requestDTO);
        Long bizId = requestDTO.getBizId();
        MediationMeetingRoomUserInfoResDTO roomUserInfo = this.mediationMeetingService.getMediationRoomUserInfoList(new CommonIdRequestDTO(bizId));
        if (roomUserInfo == null) {
            return null;
        }
        String bizType = roomUserInfo.getMediationMeetingType();
        String meetingOrderType = roomUserInfo.getMediationMeetingType();
        List userInfoLst = roomUserInfo.getList();
        String meetingOrderAddress = null;
        String disputeType = null;
        String roomId = roomUserInfo.getRoomId();
        String string = meetingVideoId = StringUtils.isNotBlank((CharSequence)roomId) ? roomId.split(",")[0] : roomId;
        if (requestDTO.getRoomId() != null) {
            reqDTO.setRoomId(requestDTO.getRoomId());
            DubboResult pirvateMemberDubbo = this.roomMediationApi.getRoomMembers(requestDTO.getRoomId());
            if (!CollectionUtils.isEmpty((Collection)((Collection)((Object)pirvateMemberDubbo.getData())))) {
                ArrayList pirvateMembers = (ArrayList)pirvateMemberDubbo.getData();
                List userIds = pirvateMembers.stream().map(MemberResDTO::getMemberId).collect(Collectors.toList());
                List docPersonalLst = userInfoLst.stream().map(DocPersonalConvert::convertDocPersonalReqDTO).filter(s -> s.getUserId() != null && userIds.contains(s.getUserId().toString())).collect(Collectors.toList());
                reqDTO.setMeetingJoinUserIds(String.join((CharSequence)",", userIds));
                reqDTO.setDocPersonalLst(docPersonalLst);
            }
        } else {
            List userIds = userInfoLst.stream().map(MediationRoomUserInfoResDTO::getUserId).map(s -> String.valueOf(s)).collect(Collectors.toList());
            List docPersonalLst = userInfoLst.stream().map(DocPersonalConvert::convertDocPersonalReqDTO).collect(Collectors.toList());
            reqDTO.setMeetingJoinUserIds(String.join((CharSequence)",", userIds));
            reqDTO.setDocPersonalLst(docPersonalLst);
        }
        bizType = ObjectTypeEnum.MEDIATION.name();
        reqDTO.setBizType(bizType);
        reqDTO.setMeetingOrderType(meetingOrderType);
        reqDTO.setMeetingOrderAddress(meetingOrderAddress);
        reqDTO.setDisputeType(disputeType);
        reqDTO.setMeetingVideoId(meetingVideoId);
        return reqDTO;
    }

    private DocRecordSaveReqDTO buildDocRecordSaveReqDTO(ClerkRecordSaveRequestDTO requestDTO) {
        DocRecordSaveReqDTO reqDTO = DocRecordConvert.convertDocRecordSaveReqDTO(requestDTO);
        Long bizId = requestDTO.getBizId();
        MediationMeetingRoomUserInfoResDTO roomUserInfo = this.mediationMeetingService.getMediationRoomUserInfoList(new CommonIdRequestDTO(bizId));
        List userInfoLst = roomUserInfo.getList();
        String meetingOrderType = roomUserInfo.getMediationMeetingType();
        List userIds = userInfoLst.stream().map(MediationRoomUserInfoResDTO::getUserId).map(s -> String.valueOf(s)).collect(Collectors.toList());
        List docPersonalLst = userInfoLst.stream().map(DocPersonalConvert::convertDocPersonalReqDTO).collect(Collectors.toList());
        String bizType = roomUserInfo.getMediationMeetingType();
        bizType = ObjectTypeEnum.MEDIATION.name();
        reqDTO.setBizType(bizType);
        if (requestDTO.getMeetId() != null) {
            reqDTO.setMeetingId(requestDTO.getMeetId());
        } else {
            reqDTO.setMeetingId(bizId);
        }
        System.out.println(meetingOrderType);
        reqDTO.setMeetingOrderType(meetingOrderType);
        reqDTO.setMeetingJoinUserIds(String.join((CharSequence)",", userIds));
        reqDTO.setMeetingOrder(Integer.valueOf(0));
        reqDTO.setDocPersonalLst(docPersonalLst);
        reqDTO.setRoomId(requestDTO.getRoomId());
        System.out.println("-------" + requestDTO.getRoomId());
        if (!StringUtils.isEmpty((CharSequence)requestDTO.getRoomId())) {
            reqDTO.setFileName(this.buildDocRecordName(requestDTO.getRoomId()));
        }
        return reqDTO;
    }

    private DocRecordSaveReqDTO buildDocSuspectRecordSaveReqDTO(SuspectReportRequestDTO requestDTO) {
        DocRecordSaveReqDTO reqDTO = DocRecordConvert.convertDocSuspectRecordSaveReqDTO(requestDTO);
        log.info("requestDTO: " + JSONObject.toJSONString((Object)requestDTO));
        Long bizId = requestDTO.getBizId();
        MediationMeetingRoomUserInfoResDTO roomUserInfo = this.mediationMeetingService.getMediationRoomUserInfoList(new CommonIdRequestDTO(bizId));
        List userInfoLst = roomUserInfo.getList();
        String meetingOrderType = roomUserInfo.getMediationMeetingType();
        List userIds = userInfoLst.stream().map(MediationRoomUserInfoResDTO::getUserId).map(s -> String.valueOf(s)).collect(Collectors.toList());
        List docPersonalLst = userInfoLst.stream().map(DocPersonalConvert::convertDocPersonalReqDTO).collect(Collectors.toList());
        String bizType = roomUserInfo.getMediationMeetingType();
        bizType = ObjectTypeEnum.SEND_SUSPECTREPORT.name();
        reqDTO.setBizType(bizType);
        if (requestDTO.getMeetId() != null) {
            reqDTO.setMeetingId(requestDTO.getMeetId());
        } else {
            reqDTO.setMeetingId(bizId);
        }
        System.out.println(meetingOrderType);
        reqDTO.setMeetingOrderType(meetingOrderType);
        reqDTO.setMeetingJoinUserIds(String.join((CharSequence)",", userIds));
        reqDTO.setMeetingOrder(Integer.valueOf(0));
        reqDTO.setDocPersonalLst(docPersonalLst);
        return reqDTO;
    }

    private DocRecordSaveReqDTO buildDocElectronicRecordSaveReqDTO(SuspectReportRequestDTO requestDTO) {
        DocRecordSaveReqDTO reqDTO = new DocRecordSaveReqDTO();
        reqDTO.setMeetingId(requestDTO.getMeetId());
        reqDTO.setBizType(ObjectTypeEnum.SEND_ELECTRONIC_RECEIPT.name());
        reqDTO.setMeetingId(requestDTO.getMeetId());
        reqDTO.setAddUser(requestDTO.isAddUser());
        return reqDTO;
    }

    private String buildDocRecordName(String roomId) {
        DubboResult pirvateMemberDubbo = this.roomMediationApi.getRoomMembers(roomId);
        if (CollectionUtils.isEmpty((Collection)((Collection)((Object)pirvateMemberDubbo.getData())))) {
            return "";
        }
        ArrayList memberList = (ArrayList)pirvateMemberDubbo.getData();
        String mediatorName = "";
        String litigant = "";
        for (MemberResDTO member : memberList) {
            if (MeetingUserTypeConst.getUserTypeIsStaff((String)member.getMemberType())) {
                mediatorName = MeetingUserTypeConst.getUserIdentity((String)member.getMemberType()) + member.getMemberName();
                continue;
            }
            litigant = MeetingUserTypeConst.getUserIdentity((String)member.getMemberType()) + member.getMemberName();
        }
        return mediatorName + "\u4e0e" + litigant + "\u7684\u79c1\u804a\u7b14\u5f55";
    }
}

