/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.APIResult;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.AddVisitSystemAppointmentRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AddVisitSystemJudgeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointDetailReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointManagementListReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointOrgJudgeReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.AppointRefusedReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.RealNameAuthenticationRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemCancelAppointmentReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemJudgeStatusReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemJudgeUserReqDTO;
import com.beiming.odr.peace.domain.dto.requestdto.VisitSystemMyAppointmentReqDTO;
import com.beiming.odr.peace.service.BackstageUserService;
import com.beiming.odr.peace.service.PeaceSmsService;
import com.beiming.odr.peace.service.PersonalService;
import com.beiming.odr.peace.service.VisitorSystemService;
import com.beiming.odr.peace.service.convert.DTOCheckFieldConvert;
import com.beiming.odr.peace.service.convert.MediationMeetingConvert;
import com.beiming.odr.peace.service.convert.VisitSystemCaseUserConvert;
import com.beiming.odr.peace.service.util.PasswordHandleUtil;
import com.beiming.odr.referee.api.VisitorSystemCaseApi;
import com.beiming.odr.referee.dto.requestdto.AddVisitSystemUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.AppointDetailsReqDTO;
import com.beiming.odr.referee.dto.requestdto.AppointManagementReqDTO;
import com.beiming.odr.referee.dto.requestdto.AppointRefusedReasonReqDTO;
import com.beiming.odr.referee.dto.requestdto.VisitSystemUserReqDTO;
import com.beiming.odr.referee.dto.requestdto.VisitorSystemCancelAppointmentReqDTO;
import com.beiming.odr.referee.dto.requestdto.VisitorSystemCaseInfoReqDTO;
import com.beiming.odr.referee.dto.requestdto.VisitorSystemMyAppointReqDTO;
import com.beiming.odr.referee.dto.responsedto.AddVisitorSystemCaseUserResDTO;
import com.beiming.odr.referee.dto.responsedto.AddVisitorSystemResDTO;
import com.beiming.odr.referee.dto.responsedto.AppointDetailApplicantResDTO;
import com.beiming.odr.referee.dto.responsedto.AppointDetailResDTO;
import com.beiming.odr.referee.dto.responsedto.VisitSystemAppointManagementResDTO;
import com.beiming.odr.referee.dto.responsedto.VisitSystemCaseInfoDTO;
import com.beiming.odr.referee.dto.responsedto.VisitSystemCaseInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.VisitSystemCaseMediationResDTO;
import com.beiming.odr.referee.dto.responsedto.VisitSystemCaseScheduleResDTO;
import com.beiming.odr.referee.dto.responsedto.VisitSystemMyAppointmentResDTO;
import com.beiming.odr.referee.dto.responsedto.VisitorSystemMsgResDTO;
import com.beiming.odr.referee.dto.responsedto.VisitorSystemStatusResDTO;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.common.enums.PasswordFormatTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.AppointUserAuthStatusDTO;
import com.beiming.odr.user.api.dto.PeaceRealNameAuthenticationTopicDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.AddVisitSystemJudgeReqDTO;
import com.beiming.odr.user.api.dto.requestdto.AppointJudgeUserReqDTO;
import com.beiming.odr.user.api.dto.requestdto.JudgeUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.JudgeUserStatusReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.responsedto.AppointJudgeResDTO;
import com.beiming.odr.user.api.dto.responsedto.AppointJudgeUserResDTO;
import com.beiming.odr.user.api.dto.responsedto.JudgeUserDetailResDTO;
import com.beiming.odr.user.api.dto.responsedto.JudgeUserManageResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.pigeons.api.producer.rocketmq.RocketMessageDto;
import com.beiming.pigeons.api.producer.rocketmq.RocketProducerClient;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class VisitorSystemServiceImpl
implements VisitorSystemService {
    private static final Logger log = LoggerFactory.getLogger(VisitorSystemServiceImpl.class);
    @Resource
    private VisitorSystemCaseApi visitorSystemCaseApi;
    @Resource
    private BackstageUserService backstageUserService;
    @Resource
    private PersonalService personalService;
    @Resource
    private PeaceSmsService peaceSmsService;
    @Resource
    private UserServiceSecondApi userServiceSecondApi;
    @Resource
    private RocketProducerClient rocketProducerClient;
    @Resource
    private PasswordHandleUtil passwordHandleUtil;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private RedisTemplate redisTemplate;
    private static final String SENDMSGTIME = "visitor_system_send_msg_time";
    private static final String UPDATESTATUS = "visitor_system_update_status";

    @Override
    public AddVisitorSystemCaseUserResDTO addVisitorSystemCase(AddVisitSystemAppointmentRequestDTO dto) {
        if (dto.getList() != null && dto.getList().size() > 0) {
            DTOCheckFieldConvert.checkVisitDsrInfoRequestDTO(dto.getList());
        }
        log.info("VisitorSystemServiceImpl.addVisitorSystemCase @AddVisitSystemAppointmentRequestDTO {}", (Object)dto);
        APIResult apiResult = MediationMeetingConvert.getAllPersontListCountIgnorePhoneNoIs1111(dto.getList());
        AssertUtils.assertTrue((apiResult.getCode() == 1000 ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)apiResult.getMessage());
        this.registerVisitSystem(dto.getList());
        log.info("\u6821\u9a8c\u540e\u7684\u53c2\u6570{}", (Object)dto);
        AddVisitSystemUserReqDTO reqDTO = VisitSystemCaseUserConvert.getAddVisitSystemUserReqDTO(dto);
        log.info("\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf \u62fc\u63a5\u7533\u8bf7\u53c2\u6570{}", (Object)reqDTO);
        DubboResult result = this.visitorSystemCaseApi.addVisitorSystemCaseUser(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AddVisitorSystemResDTO resDTO1 = (AddVisitorSystemResDTO)result.getData();
        VisitorSystemMsgResDTO msgResDTO = resDTO1.getMsgResDTO();
        this.addRedisAppointmentKey(msgResDTO);
        AddVisitorSystemCaseUserResDTO resDTO = VisitSystemCaseUserConvert.getAddVisitorSystemCaseUserResDTO(resDTO1);
        return resDTO;
    }

    @Override
    public UserInfoDTO setRealNameAndFacialVerify(RealNameAuthenticationRequestDTO req) {
        log.info("\u8eab\u4efd\u8ba4\u8bc1\u5165\u53c2\u4e3a{}", (Object)req);
        RealNameAuthenticationReqDTO requestDTO = new RealNameAuthenticationReqDTO();
        requestDTO.setIdCard(req.getIdCard());
        requestDTO.setUserName(req.getUserName());
        DubboResult result = this.userServiceSecondApi.setVisitSystemRealNameAndFacialVerify(null, requestDTO);
        log.info("userservice\u8ba4\u8bc1\u63a5\u53e3\u8fd4\u56de\u6570\u636e{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        PeaceRealNameAuthenticationTopicDTO obj = new PeaceRealNameAuthenticationTopicDTO(((UserInfoDTO)result.getData()).getUserId(), req.getUserName(), req.getIdCard());
        RocketMessageDto rocketMessageDto = new RocketMessageDto("peaceRealNameAuthenticationTopic", ((UserInfoDTO)result.getData()).getUserId() + "", (Object)obj);
        this.rocketProducerClient.sendMessage(rocketMessageDto);
        return (UserInfoDTO)result.getData();
    }

    @Override
    public Boolean verifyExpiration(Long userId, RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        AssertUtils.assertNotNull((Object)userId, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u672a\u767b\u5f55");
        RealNameAuthenticationReqDTO requestDTO = new RealNameAuthenticationReqDTO();
        requestDTO.setIdCard(realNameAuthenticationRequestDTO.getIdCard());
        requestDTO.setUserName(realNameAuthenticationRequestDTO.getUserName());
        DubboResult result = this.userServiceSecondApi.verifyExpiration(userId, requestDTO);
        log.info("\u786e\u8ba4\u8ba4\u8bc1\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Boolean)result.getData();
    }

    @Override
    public List<VisitSystemCaseInfoDTO> caseList(RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        VisitorSystemCaseInfoReqDTO reqDTO = new VisitorSystemCaseInfoReqDTO();
        reqDTO.setUserName(realNameAuthenticationRequestDTO.getUserName());
        reqDTO.setUserCard(realNameAuthenticationRequestDTO.getIdCard());
        DubboResult result = this.visitorSystemCaseApi.caseList(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        ArrayList data = (ArrayList)result.getData();
        return data;
    }

    @Override
    public PageInfo<VisitSystemCaseScheduleResDTO> caseScheduleList(RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        VisitorSystemCaseInfoReqDTO reqDTO = new VisitorSystemCaseInfoReqDTO();
        reqDTO.setUserName(realNameAuthenticationRequestDTO.getUserName());
        reqDTO.setUserCard(realNameAuthenticationRequestDTO.getIdCard());
        reqDTO.setPageNum(Integer.valueOf(realNameAuthenticationRequestDTO.getPageNum() == null ? 1 : realNameAuthenticationRequestDTO.getPageNum()));
        reqDTO.setPageSize(Integer.valueOf(realNameAuthenticationRequestDTO.getPageSize() == null ? 10 : realNameAuthenticationRequestDTO.getPageSize()));
        DubboResult list = this.visitorSystemCaseApi.casScheduleList(reqDTO);
        AssertUtils.assertTrue((boolean)list.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)list.getMessage());
        return (PageInfo)list.getData();
    }

    @Override
    public PageInfo<VisitSystemCaseMediationResDTO> caseMediationList(RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        VisitorSystemCaseInfoReqDTO reqDTO = new VisitorSystemCaseInfoReqDTO();
        reqDTO.setUserName(realNameAuthenticationRequestDTO.getUserName());
        reqDTO.setUserCard(realNameAuthenticationRequestDTO.getIdCard());
        reqDTO.setPageNum(Integer.valueOf(realNameAuthenticationRequestDTO.getPageNum() == null ? 1 : realNameAuthenticationRequestDTO.getPageNum()));
        reqDTO.setPageSize(Integer.valueOf(realNameAuthenticationRequestDTO.getPageSize() == null ? 10 : realNameAuthenticationRequestDTO.getPageSize()));
        DubboResult list = this.visitorSystemCaseApi.caseMediationList(reqDTO);
        AssertUtils.assertTrue((boolean)list.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)list.getMessage());
        return (PageInfo)list.getData();
    }

    @Override
    public PageInfo<VisitSystemCaseInfoResDTO> caseInfoList(RealNameAuthenticationRequestDTO realNameAuthenticationRequestDTO) {
        VisitorSystemCaseInfoReqDTO reqDTO = new VisitorSystemCaseInfoReqDTO();
        reqDTO.setUserName(realNameAuthenticationRequestDTO.getUserName());
        reqDTO.setUserCard(realNameAuthenticationRequestDTO.getIdCard());
        reqDTO.setPageNum(Integer.valueOf(realNameAuthenticationRequestDTO.getPageNum() == null ? 1 : realNameAuthenticationRequestDTO.getPageNum()));
        reqDTO.setPageSize(Integer.valueOf(realNameAuthenticationRequestDTO.getPageSize() == null ? 10 : realNameAuthenticationRequestDTO.getPageSize()));
        DubboResult list = this.visitorSystemCaseApi.caseInfoList(reqDTO);
        log.info("list{}", (Object)list);
        AssertUtils.assertTrue((boolean)list.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)list.getMessage());
        return (PageInfo)list.getData();
    }

    @Override
    public PageInfo<VisitSystemMyAppointmentResDTO> myAppointList(String userId, VisitSystemMyAppointmentReqDTO reqDTO) {
        log.info("\u5f53\u524d\u7528\u6237id{}", (Object)userId);
        AssertUtils.assertNotNull((Object)userId, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u672a\u767b\u5f55");
        VisitorSystemMyAppointReqDTO dto = new VisitorSystemMyAppointReqDTO();
        dto.setQueryType(reqDTO.getQueryType());
        dto.setVisitingBusiness(reqDTO.getVisitingBusiness().toString());
        dto.setUserId(userId);
        dto.setPageNum(Integer.valueOf(reqDTO.getPageNum() == null ? 1 : reqDTO.getPageNum()));
        dto.setPageSize(Integer.valueOf(reqDTO.getPageSize() == null ? 10 : reqDTO.getPageSize()));
        DubboResult list = this.visitorSystemCaseApi.myAppointList(dto);
        AssertUtils.assertTrue((boolean)list.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)list.getMessage());
        return (PageInfo)list.getData();
    }

    @Override
    public Boolean cancelAppointment(String userId, VisitSystemCancelAppointmentReqDTO reqDTO) {
        AssertUtils.assertNotNull((Object)userId, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u7528\u6237\u672a\u767b\u5f55");
        VisitorSystemCancelAppointmentReqDTO dto = new VisitorSystemCancelAppointmentReqDTO();
        dto.setUserId(userId);
        dto.setCaseUserId(reqDTO.getCaseUserId());
        DubboResult result = this.visitorSystemCaseApi.cancelAppointment(dto);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        VisitorSystemStatusResDTO data = (VisitorSystemStatusResDTO)result.getData();
        this.delRedisAppointmentKey(data.getList());
        return ((VisitorSystemStatusResDTO)result.getData()).getFlag();
    }

    @Override
    public PageInfo<VisitSystemAppointManagementResDTO> appointManagementList(AppointManagementListReqDTO reqDTO) {
        AppointManagementReqDTO dto = new AppointManagementReqDTO();
        dto.setPageNum(Integer.valueOf(reqDTO.getPageNum() == null ? 1 : reqDTO.getPageNum()));
        dto.setPageSize(Integer.valueOf(reqDTO.getPageSize() == null ? 10 : reqDTO.getPageSize()));
        dto.setUserVisitBusiness(reqDTO.getUserVisitBusiness());
        dto.setUserName(reqDTO.getUserName());
        dto.setStatus(reqDTO.getStatus());
        dto.setVisitStartTime(reqDTO.getVisitStartTime());
        dto.setVisitEndTime(reqDTO.getVisitEndTime());
        DubboResult pageInfo = this.visitorSystemCaseApi.appointManagementList(dto);
        AssertUtils.assertTrue((boolean)pageInfo.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)pageInfo.getMessage());
        return (PageInfo)pageInfo.getData();
    }

    @Override
    public AppointDetailResDTO appointDetail(AppointDetailReqDTO reqDTO) {
        AppointDetailsReqDTO dto = new AppointDetailsReqDTO();
        dto.setCaseUserId(reqDTO.getCaseUserId());
        dto.setUserName(reqDTO.getUserName());
        dto.setUserCard(reqDTO.getUserCard());
        DubboResult result = this.visitorSystemCaseApi.appointDetails(dto);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AppointDetailResDTO data = (AppointDetailResDTO)result.getData();
        if (data != null) {
            List list = data.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                for (AppointDetailApplicantResDTO resDTO : list) {
                    Integer userId = resDTO.getUserId();
                    userIds.add(userId);
                }
                log.info("\u83b7\u53d6\u591a\u7528\u6237\u8ba4\u8bc1\u5165\u53c2{}", userIds);
                DubboResult authStatusResult = this.userServiceSecondApi.setAuthStatus(userIds);
                log.info("authStatusResult{}", (Object)authStatusResult);
                AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.SELECT_PERSON_NULL, (String)result.getMessage());
                ArrayList data1 = (ArrayList)authStatusResult.getData();
                for (AppointUserAuthStatusDTO statusDTO : data1) {
                    Integer id = statusDTO.getId();
                    String isRealName = statusDTO.getIsRealName();
                    String isFacialVerify = statusDTO.getIsFacialVerify();
                    String cardRealTime = statusDTO.getCardRealTime();
                    String facialVerifyTime = statusDTO.getFacialVerifyTime();
                    String authStatus = "\u672a\u8ba4\u8bc1";
                    String authentication = "";
                    if ("1".equals(isRealName) && "1".equals(isFacialVerify) && StringUtils.isNotBlank((CharSequence)cardRealTime) && StringUtils.isNotBlank((CharSequence)facialVerifyTime)) {
                        authStatus = "\u5df2\u8ba4\u8bc1";
                        authentication = "\u8eab\u4efd\u8ba4\u8bc1";
                    }
                    for (AppointDetailApplicantResDTO resDTO : list) {
                        if (id != resDTO.getUserId()) continue;
                        resDTO.setAuthStatus(authStatus);
                        resDTO.setAuthentication(authentication);
                        resDTO.setAuthTime(cardRealTime);
                    }
                }
            }
            data.setList(list);
        }
        return data;
    }

    @Override
    public Boolean confirmedAppoint(AppointDetailReqDTO reqDTO) {
        AppointDetailsReqDTO dto = new AppointDetailsReqDTO();
        dto.setCaseUserId(reqDTO.getCaseUserId());
        dto.setUserName(reqDTO.getUserName());
        dto.setUserCard(reqDTO.getUserCard());
        DubboResult result = this.visitorSystemCaseApi.confirmedAppoint(dto);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        VisitorSystemStatusResDTO data = (VisitorSystemStatusResDTO)result.getData();
        this.addRedisAppointmentKey(data.getList());
        return ((VisitorSystemStatusResDTO)result.getData()).getFlag();
    }

    @Override
    public Boolean refusedAppoint(AppointRefusedReqDTO reqDTO) {
        AppointRefusedReasonReqDTO dto = new AppointRefusedReasonReqDTO();
        dto.setCaseUserId(reqDTO.getCaseUserId());
        dto.setUserName(reqDTO.getUserName());
        dto.setUserCard(reqDTO.getUserCard());
        dto.setRefusedReason(reqDTO.getRefuseReason());
        DubboResult result = this.visitorSystemCaseApi.refusedAppoint(dto);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        VisitorSystemStatusResDTO data = (VisitorSystemStatusResDTO)result.getData();
        this.delRedisAppointmentKey(data.getList());
        return ((VisitorSystemStatusResDTO)result.getData()).getFlag();
    }

    @Override
    public List<AppointJudgeResDTO> departmentList() {
        DubboResult result = this.userServiceSecondApi.departmentList();
        log.info("\u8fd4\u56de\u6570\u636e{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (List)((Object)result.getData());
    }

    @Override
    public List<AppointJudgeUserResDTO> judgeList(AppointOrgJudgeReqDTO dto) {
        AppointJudgeUserReqDTO reqDTO = new AppointJudgeUserReqDTO();
        reqDTO.setCode(dto.getCode());
        DubboResult result = this.userServiceSecondApi.judgeList(reqDTO);
        log.info("\u8fd4\u56de\u6570\u636e{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (List)((Object)result.getData());
    }

    @Override
    public LoginInfoResDTO judgeLogin(String mobile, String loginName, String password, UserLoginTypeEnum loginType, String publicKey, String deviceId) {
        loginType = loginType == null ? UserLoginTypeEnum.COMMON_USER_LOGIN_TYPE : loginType;
        password = this.passwordHandleUtil.decryptPassword(PasswordFormatTypeEnum.USER_LOGIN, publicKey, password, "\u5bc6\u7801\u683c\u5f0f\u9519\u8bef");
        DubboResult result = this.userServiceApi.userLoginTest(mobile, password, loginName, loginType);
        log.info("result{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (LoginInfoResDTO)result.getData();
    }

    @Override
    public Boolean addJudgeUser(AddVisitSystemJudgeRequestDTO dto) {
        AddVisitSystemJudgeReqDTO reqDTO = new AddVisitSystemJudgeReqDTO();
        reqDTO.setOrgName(dto.getOrgName());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setPhone(dto.getMobilePhone());
        reqDTO.setSex(dto.getSex());
        reqDTO.setIsValid(dto.getStatus());
        DubboResult result = this.userServiceApi.addJudgeUser(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Boolean)result.getData();
    }

    @Override
    public PageInfo<JudgeUserManageResDTO> judgeUserList(VisitSystemJudgeUserReqDTO dto) {
        int pageNum = dto.getPageNum() == null ? 1 : dto.getPageNum();
        int pageSize = dto.getPageSize() == null ? 10 : dto.getPageSize();
        JudgeUserListReqDTO reqDTO = new JudgeUserListReqDTO();
        reqDTO.setName(dto.getName());
        reqDTO.setStatus(dto.getStatus());
        reqDTO.setPageNum(Integer.valueOf(pageNum));
        reqDTO.setPageSize(Integer.valueOf(pageSize));
        DubboResult result = this.userServiceApi.judgeUserList(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (PageInfo)result.getData();
    }

    @Override
    public Boolean updateJudgeUser(VisitSystemJudgeStatusReqDTO dto) {
        AssertUtils.assertNotNull((Object)dto, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        JudgeUserStatusReqDTO reqDTO = new JudgeUserStatusReqDTO();
        reqDTO.setId(dto.getId());
        reqDTO.setName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setStatus(dto.getStatus());
        DubboResult result = this.userServiceApi.updateJudgeUserStatus(reqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (Boolean)result.getData();
    }

    @Override
    public JudgeUserDetailResDTO judgeUserDetail(VisitSystemJudgeStatusReqDTO dto) {
        AssertUtils.assertNotNull((Object)dto, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        JudgeUserStatusReqDTO reqDTO = new JudgeUserStatusReqDTO();
        reqDTO.setId(dto.getId());
        reqDTO.setName(dto.getUserName());
        reqDTO.setMobilePhone(dto.getMobilePhone());
        reqDTO.setStatus(dto.getStatus());
        DubboResult result = this.userServiceApi.getJudgeUserDetails(reqDTO);
        log.info("result{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        return (JudgeUserDetailResDTO)result.getData();
    }

    private void registerVisitSystem(List<VisitSystemUserReqDTO> list) {
        for (VisitSystemUserReqDTO dto : list) {
            if ("1111".equals(dto.getUserMobilePhone()) || !StringUtils.isNotBlank((CharSequence)dto.getUserMobilePhone())) continue;
            this.registerVisitSytemUserInfo(dto);
        }
    }

    private void registerVisitSytemUserInfo(VisitSystemUserReqDTO info) {
        log.info("\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf \u8ba4\u8bc1\u7528\u6237\u63a5\u53e3\u5165\u53c2\u4e3a{}", (Object)info);
        String userType = info.getUserType();
        String phone = info.getUserMobilePhone();
        if (StringUtils.isBlank((CharSequence)info.getUserName()) || StringUtils.isBlank((CharSequence)info.getUserMobilePhone())) {
            return;
        }
        DubboResult result = this.userServiceSecondApi.searchAndRegisterByMobileofVisitSystem(phone, info.getUserName(), info.getUserCard());
        log.info("\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf \u8ba4\u8bc1\u7528\u6237\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u4e3a{}", (Object)result);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        UserInfoDTO userInfo = (UserInfoDTO)result.getData();
        if (userInfo == null) {
            return;
        }
        info.setUserId(userInfo.getUserId());
        String errorMsg = "\u8bbf\u5ba2\u9884\u7ea6\u7cfb\u7edf\u624b\u673a\u53f7" + info.getUserMobilePhone() + "\u5df2\u5b9e\u540d\uff0c\u5b9e\u540d\u59d3\u540d\u4e0e\u8f93\u5165\u59d3\u540d\u4e0d\u7b26\u3002";
        AssertUtils.assertTrue((boolean)info.getUserName().equals(userInfo.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)errorMsg);
        info.setUserName(userInfo.getUserName() == null ? info.getUserName() : userInfo.getUserName());
        info.setUserCard(userInfo.getIdCard());
    }

    public void addRedisAppointmentKey(VisitorSystemMsgResDTO list) {
        log.info("list is {}", (Object)list);
        Long l = 0L;
        String sendKey = "";
        if (list == null) {
            return;
        }
        try {
            Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(list.getSendMsgTime());
            l = parse.toInstant().atZone(ZoneId.systemDefault()).toEpochSecond();
            sendKey = String.valueOf(l);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u65f6\u95f4\u8f6c\u6362\u5931\u8d25{}", (Throwable)e);
        }
        JSONArray dataList = new JSONArray();
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)list);
        log.info("sendKey is {} dto to JSONObject{}", (Object)sendKey, (Object)jsonObject);
        dataList.add((Object)jsonObject);
        JSONObject temp = new JSONObject();
        temp.put(sendKey, (Object)dataList);
        Object o = this.redisTemplate.opsForValue().get((Object)SENDMSGTIME);
        log.info("SENDMSGTIME data is {}", o);
        if (o != null) {
            JSONObject jsonObject1 = JSONObject.parseObject((String)String.valueOf(o));
            if (jsonObject1.containsKey((Object)sendKey)) {
                JSONArray jsonObject2 = (JSONArray)jsonObject1.get((Object)sendKey);
                jsonObject2.addAll((Collection)dataList);
                jsonObject2 = this.distinct(jsonObject2);
                jsonObject1.put(sendKey, (Object)jsonObject2);
            } else {
                jsonObject1.put(sendKey, (Object)dataList);
            }
            log.info("jsonObject{}", (Object)jsonObject1);
            this.redisTemplate.opsForValue().set((Object)SENDMSGTIME, (Object)JSONObject.toJSONString((Object)jsonObject1));
        } else {
            this.redisTemplate.opsForValue().set((Object)SENDMSGTIME, (Object)JSONObject.toJSONString((Object)temp));
        }
        log.info("redis key is {} data is {}", (Object)SENDMSGTIME, this.redisTemplate.opsForValue().get((Object)SENDMSGTIME));
        String caseUserId = list.getCaseUserId();
        String visitTime = list.getVisitTime();
        Long l1 = 0L;
        String updateKey = "";
        try {
            Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(visitTime);
            l1 = parse.toInstant().atZone(ZoneId.systemDefault()).toEpochSecond();
            updateKey = String.valueOf(l1);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u65f6\u95f4\u8f6c\u6362\u5931\u8d25{}", (Throwable)e);
        }
        JSONObject update = new JSONObject();
        ArrayList<String> caseIds = new ArrayList<String>();
        caseIds.add(caseUserId);
        update.put(updateKey, caseIds);
        Object updateData = this.redisTemplate.opsForValue().get((Object)UPDATESTATUS);
        if (updateData != null) {
            JSONObject updateJson = JSONObject.parseObject((String)String.valueOf(updateData));
            if (updateJson.containsKey((Object)updateKey)) {
                List o1 = (List)updateJson.get((Object)updateKey);
                o1.addAll(caseIds);
                o1 = o1.stream().distinct().collect(Collectors.toList());
                updateJson.put(updateKey, o1);
            } else {
                updateJson.put(updateKey, caseIds);
            }
            this.redisTemplate.opsForValue().set((Object)UPDATESTATUS, (Object)JSONObject.toJSONString((Object)updateJson));
        } else {
            this.redisTemplate.opsForValue().set((Object)UPDATESTATUS, (Object)JSONObject.toJSONString((Object)update));
        }
    }

    public void delRedisAppointmentKey(VisitorSystemMsgResDTO list) {
        log.info("list is {}", (Object)list);
        Long l = 0L;
        String sendKey = "";
        if (list == null) {
            return;
        }
        try {
            Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(list.getSendMsgTime());
            l = parse.toInstant().atZone(ZoneId.systemDefault()).toEpochSecond();
            sendKey = String.valueOf(l);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u65f6\u95f4\u8f6c\u6362\u5931\u8d25{}", (Throwable)e);
        }
        JSONArray dataList = new JSONArray();
        JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)list);
        log.info("sendKey is {} dto to JSONObject{}", (Object)sendKey, (Object)jsonObject);
        dataList.add((Object)jsonObject);
        JSONObject temp = new JSONObject();
        temp.put(sendKey, (Object)dataList);
        Object o = this.redisTemplate.opsForValue().get((Object)SENDMSGTIME);
        log.info("SENDMSGTIME data is {}", o);
        if (o != null) {
            JSONObject jsonObject1 = JSONObject.parseObject((String)String.valueOf(o));
            if (jsonObject1.containsKey((Object)sendKey)) {
                JSONArray jsonObject2 = (JSONArray)jsonObject1.get((Object)sendKey);
                log.info("jsonObject2 is {}", (Object)jsonObject2);
                for (int i = 0; i < jsonObject2.size(); ++i) {
                    log.info("del o1 is {}", jsonObject2.get(i));
                    VisitorSystemMsgResDTO msgResDTO = (VisitorSystemMsgResDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject2.get(i)), VisitorSystemMsgResDTO.class);
                    String caseUserId = msgResDTO.getCaseUserId();
                    if (!list.getCaseUserId().equals(caseUserId)) continue;
                    jsonObject2.remove(i);
                }
                log.info("jsonObject2 changed is {}", (Object)jsonObject2);
                jsonObject1.put(sendKey, (Object)jsonObject2);
            }
            log.info("jsonObject{}", (Object)jsonObject1);
            this.redisTemplate.opsForValue().set((Object)SENDMSGTIME, (Object)JSONObject.toJSONString((Object)jsonObject1));
        }
        log.info("redis key is {} data is {}", (Object)SENDMSGTIME, this.redisTemplate.opsForValue().get((Object)SENDMSGTIME));
        String caseUserId = list.getCaseUserId();
        String visitTime = list.getVisitTime();
        Long l1 = 0L;
        String updateKey = "";
        try {
            Date parse = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(visitTime);
            l1 = parse.toInstant().atZone(ZoneId.systemDefault()).toEpochSecond();
            updateKey = String.valueOf(l1);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u65f6\u95f4\u8f6c\u6362\u5931\u8d25{}", (Throwable)e);
        }
        log.info("l1 data is {}", (Object)l1);
        Object updateData = this.redisTemplate.opsForValue().get((Object)UPDATESTATUS);
        log.info("updateData is {}", updateData);
        if (updateData != null) {
            JSONObject updateJson = JSONObject.parseObject((String)String.valueOf(updateData));
            if (updateJson.containsKey((Object)updateKey)) {
                List o1 = (List)updateJson.get((Object)updateKey);
                o1.remove(caseUserId);
                o1 = o1.stream().distinct().collect(Collectors.toList());
                updateJson.put(updateKey, o1);
            }
            log.info("updateJson is {}", (Object)updateJson);
            this.redisTemplate.opsForValue().set((Object)UPDATESTATUS, (Object)JSONObject.toJSONString((Object)updateJson));
        }
    }

    public JSONArray distinct(JSONArray jsonArray) {
        ArrayList fieldsNames = new ArrayList();
        JSONArray distinctArr = new JSONArray();
        jsonArray.stream().map(e -> (JSONObject)e).forEach(e -> {
            String fileName = (String)e.getObject("caseUserId", String.class);
            if (!fieldsNames.contains(fileName)) {
                fieldsNames.add(fileName);
                distinctArr.add(e);
            }
        });
        return distinctArr;
    }
}

