/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import com.beiming.framework.enums.CTypeEnums;
import com.beiming.framework.enums.JWTTokenTypeEnums;
import com.beiming.framework.security.JWTUtils;
import com.beiming.framework.util.RandomValue;
import com.beiming.odr.peace.domain.dto.RedisMediationRoomInfoDTO;
import com.beiming.odr.peace.domain.dto.responsedto.LoginTokenResponseDTO;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import io.jsonwebtoken.Claims;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TokenGeneratorParse {
    private static final Logger log = LoggerFactory.getLogger(TokenGeneratorParse.class);
    @Value(value="${jwt.auth.secret}")
    private String authJwtSecret;
    @Value(value="${jwt.refresh.secret}")
    private String refreshJwtSecret;
    @Value(value="${jwt.expireMinutes.authToken}")
    private int authTokenExpireMinutes;
    @Value(value="${jwt.expireMinutes.refreshToken}")
    private int refreshTokenExpireMinutes;
    @Value(value="${jwt.expireMinutes.visitorSystemAuthToken}")
    private int visitorSystemAuthTokenExpireMinutes;
    @Value(value="${jwt.expireMinutes.visitorSystemRefreshToken}")
    private int visitorSystemRefreshTokenExpireMinutes;
    @Resource
    private JWTUtils jwtUtils;

    public Long getUserIdByJWTToken(String jwtToken) {
        if (StringUtils.isBlank((CharSequence)jwtToken)) {
            return null;
        }
        Claims claims = null;
        try {
            claims = this.jwtUtils.parseJWTToken(jwtToken, this.authJwtSecret);
        }
        catch (Exception e) {
            log.info("parseJWTToken error {}", (Object)e.getMessage());
        }
        if (claims == null) {
            return null;
        }
        Long userId = claims.get((Object)"userId") == null ? null : Long.valueOf(claims.get((Object)"userId").toString());
        return userId;
    }

    public String getUserNameByJWTToken(String jwtToken) {
        if (StringUtils.isBlank((CharSequence)jwtToken)) {
            return null;
        }
        Claims claims = null;
        try {
            claims = this.jwtUtils.parseJWTToken(jwtToken, this.authJwtSecret);
        }
        catch (Exception e) {
            log.info("parseJWTToken error {}", (Object)e.getMessage());
        }
        if (claims == null) {
            return null;
        }
        String userName = claims.get((Object)"userName") == null ? null : claims.get((Object)"userName").toString();
        return userName;
    }

    public LoginTokenResponseDTO generateLoginToken(LoginInfoResDTO loginInfo, String ctype, RedisMediationRoomInfoDTO mediationInfo) {
        Date authTokenExpireTime = Java8DateUtil.getDate((LocalDateTime)LocalDateTime.now().plusMinutes(this.authTokenExpireMinutes));
        Date refreshTokenExpireTime = Java8DateUtil.getDate((LocalDateTime)LocalDateTime.now().plusMinutes(this.refreshTokenExpireMinutes));
        UserInfoDTO userInfo = loginInfo.getUserInfo();
        ArrayList<String> roles = new ArrayList<String>();
        if (loginInfo.getUserRoles() != null) {
            for (UserRoleInfoDTO userRoleInfoDTO : loginInfo.getUserRoles()) {
                roles.add(userRoleInfoDTO.getRoleType());
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (CTypeEnums.ANDROID.toString().equalsIgnoreCase(ctype) || CTypeEnums.IOS.toString().equalsIgnoreCase(ctype)) {
            ctype = "APP";
        } else if (CTypeEnums.PC.toString().equalsIgnoreCase(ctype)) {
            ctype = RandomValue.getRandomCharAndNumr((Integer)10);
        }
        map.put("cType", ctype);
        String authToken = this.jwtUtils.generateJWTToken(authTokenExpireTime, userInfo.getUserId() + "", userInfo.getUserName(), userInfo.getPersonType(), roles, map, this.authJwtSecret, Long.valueOf(Long.parseLong(this.authTokenExpireMinutes + "")), TimeUnit.MINUTES, JWTTokenTypeEnums.TOKEN);
        String refreshToken = this.jwtUtils.generateJWTToken(refreshTokenExpireTime, userInfo.getUserId() + "", userInfo.getUserName(), userInfo.getPersonType(), roles, map, this.refreshJwtSecret, Long.valueOf(Long.parseLong(this.refreshTokenExpireMinutes + "")), TimeUnit.MINUTES, JWTTokenTypeEnums.REFRESH_TOKEN);
        LoginTokenResponseDTO token = new LoginTokenResponseDTO();
        token.setLoginInfo(loginInfo);
        token.setAuthToken(authToken);
        token.setRefreshToken(refreshToken);
        token.setMediationInfoDTO(mediationInfo);
        return token;
    }
}

