/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.document.api.DocDissentApi;
import com.beiming.odr.document.dto.requestdto.DocDissentGetReqDTO;
import com.beiming.odr.document.dto.requestdto.DocDissentSaveReqDTO;
import com.beiming.odr.document.dto.responsedto.DocDissentGetResDTO;
import com.beiming.odr.document.dto.responsedto.DocDissentSaveResDTO;
import com.beiming.odr.document.enums.ObjectTypeEnum;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.DissentBookGetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DissentBookSaveRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.DissentBookGetResponseDTO;
import com.beiming.odr.peace.service.backend.document.DocDissentDubboService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DocDissentDubboServiceImpl
implements DocDissentDubboService {
    @Resource
    private DocDissentApi docDissentApi;

    @Override
    public DissentBookGetResponseDTO getDissentBook(DissentBookGetRequestDTO dto) {
        DissentBookGetResponseDTO response = new DissentBookGetResponseDTO();
        DocDissentGetReqDTO reqDTO = new DocDissentGetReqDTO();
        reqDTO.setBizId(dto.getMediationRoomId());
        reqDTO.setBizType(ObjectTypeEnum.MEDIATION.name());
        reqDTO.setMediationSchemeId(dto.getMediationSchemeId());
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        DubboResult result = this.docDissentApi.getDocDissent(reqDTO);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        DocDissentGetResDTO data = (DocDissentGetResDTO)result.getData();
        response.setMediationRoomId(data.getBizId());
        response.setDocumentId(data.getDocId());
        response.setUserId(data.getUserId());
        response.setUserName(data.getUserName());
        response.setSex(data.getSex());
        response.setUserType(data.getUserType());
        response.setMeetingUserType(data.getCaseUserType());
        response.setPhone(data.getPhone());
        response.setIdCard(data.getIdCard());
        response.setProvCode(data.getProvCode());
        response.setCityCode(data.getCityCode());
        response.setAreaCode(data.getAreaCode());
        response.setStreetCode(data.getStreetCode());
        response.setProvName(data.getProvName());
        response.setCityName(data.getCityName());
        response.setAreaName(data.getAreaName());
        response.setStreetName(data.getStreetName());
        response.setAddress(data.getAddress());
        response.setContent(data.getContent());
        return response;
    }

    @Override
    public Long saveDissentBook(DissentBookSaveRequestDTO dto) {
        DocDissentSaveReqDTO reqDTO = new DocDissentSaveReqDTO();
        reqDTO.setBizId(dto.getMediationRoomId());
        reqDTO.setBizType(ObjectTypeEnum.MEDIATION.name());
        reqDTO.setUserId(Long.valueOf(JWTContextUtil.getCurrentUserId()));
        reqDTO.setMediationSchemeId(dto.getMediationSchemeId());
        reqDTO.setUserType(dto.getUserType());
        reqDTO.setDocId(dto.getDocumentId());
        reqDTO.setUserName(dto.getUserName());
        reqDTO.setCaseUserType(dto.getCaseUserType());
        reqDTO.setSex(dto.getSex());
        reqDTO.setPhone(dto.getPhone());
        reqDTO.setIdCard(dto.getIdCard());
        reqDTO.setProvCode(dto.getProvCode());
        reqDTO.setCityCode(dto.getCityCode());
        reqDTO.setAreaCode(dto.getAreaCode());
        reqDTO.setStreetCode(dto.getStreetCode());
        reqDTO.setProvName(dto.getProvName());
        reqDTO.setCityName(dto.getCityName());
        reqDTO.setAreaName(dto.getAreaName());
        reqDTO.setStreetName(dto.getStreetName());
        reqDTO.setAddress(dto.getAddress());
        reqDTO.setContent(dto.getContent());
        DubboResult result = this.docDissentApi.saveDocDissent(reqDTO);
        AssertUtils.assertTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        DocDissentSaveResDTO data = (DocDissentSaveResDTO)result.getData();
        return data.getDocId();
    }
}

