/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.convert;

import com.beiming.basic.chat.api.dto.request.InductionEvidenceReqDTO;
import com.beiming.basic.chat.api.dto.request.ListMessageReqDTO;
import com.beiming.basic.chat.api.dto.response.MessageResDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ChatMsgRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.InductionEvidenceRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.GroupChatMsgResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MessageResponseDTO;
import com.beiming.odr.peace.im.api.dto.response.UnreadMessageListResponseDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ChatConvertUtils {
    public static ListMessageReqDTO toListMessageReqDTO(ChatMsgRequestDTO dto) {
        String sender;
        ListMessageReqDTO reqDTO = new ListMessageReqDTO();
        reqDTO.setRoomId(dto.getRoomId());
        reqDTO.setReceiverId(dto.getReceiverId());
        reqDTO.setPageIndex(dto.getPageIndex());
        reqDTO.setPageSize(dto.getPageSize());
        reqDTO.setCategoryBig(dto.getCategoryBig());
        reqDTO.setMsgStartTime(dto.getMsgStartTime());
        reqDTO.setMsgEndTime(dto.getMsgEndTime());
        if (dto.getEvidenceType() != null) {
            reqDTO.setEvidenceType(dto.getEvidenceType());
        }
        if (dto.getKindParam() != null) {
            reqDTO.setKindParam(dto.getKindParam());
        }
        if (dto.getSearchContent() != null) {
            reqDTO.setSearchContent(dto.getSearchContent());
        }
        if (StringUtils.isNotBlank((CharSequence)(sender = dto.getSender()))) {
            reqDTO.setSenderId(sender);
        }
        return reqDTO;
    }

    public static List<MessageResponseDTO> toChatResDTO(List<MessageResDTO> list) {
        ArrayList rsList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(dto -> rsList.add(new MessageResponseDTO(dto)));
        }
        return rsList;
    }

    public static GroupChatMsgResponseDTO toGroupChatMsgResponseDTO(UnreadMessageListResponseDTO msg) {
        GroupChatMsgResponseDTO responseDTO = new GroupChatMsgResponseDTO();
        responseDTO.setRoomId(msg.getRoomId());
        responseDTO.setUserRoleType(msg.getUserRoleType());
        responseDTO.setCategoryBig(msg.getMessageType());
        responseDTO.setMemberName(msg.getUserName());
        responseDTO.setLastMessageContent(msg.getMessageContent());
        responseDTO.setLastMessageTime(msg.getLastUpdateTime());
        responseDTO.setUnreadMessageCount(msg.getUnreadCount());
        responseDTO.setMessageResource(msg.getMessageResource());
        return responseDTO;
    }

    public static InductionEvidenceReqDTO toInductionEvidence(InductionEvidenceRequestDTO dto) {
        InductionEvidenceReqDTO reqDTO = new InductionEvidenceReqDTO();
        reqDTO.setPageIndex(dto.getPageIndex());
        reqDTO.setPageSize(dto.getPageSize());
        return reqDTO;
    }
}

