/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.page.PageInfo;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.domain.dto.requestdto.BackstageUserAddRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.BackstageUserListRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.BackstageUserSearchRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.BackstageUserUpdateIdCardReqPDTO;
import com.beiming.odr.peace.domain.dto.requestdto.BackstageUserUpdateStatusRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DepartmentsRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.BackstageUserInfoResponseDTO;
import com.beiming.odr.peace.service.BackstageUserService;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.BackstageUserServiceApi;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserUpdateIdCardReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserUpdateStatusReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DepartReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageUserInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.DepartmentsResponseDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BackstageUserServiceImpl
implements BackstageUserService {
    @Resource
    private BackstageUserServiceApi backstageUserServiceApi;

    @Override
    public void insertBackstageUser(BackstageUserAddRequestDTO backstageuserAddRequestDTO) {
        BackstageUserAddReqDTO param = new BackstageUserAddReqDTO();
        this.setValueBackstageUserAddReqDTO(param, backstageuserAddRequestDTO);
        DubboResult result = this.backstageUserServiceApi.insertBackstageUser(param);
        if (!StringUtils.isBlank((String)backstageuserAddRequestDTO.getIdCard())) {
            BackstageUserUpdateIdCardReqPDTO backstageUserUpdateIdCardReqPDTO = new BackstageUserUpdateIdCardReqPDTO();
            backstageUserUpdateIdCardReqPDTO.setIdCard(backstageuserAddRequestDTO.getIdCard());
            backstageUserUpdateIdCardReqPDTO.setMobilePhone(backstageuserAddRequestDTO.getMobilePhone());
            this.updateBackstageUserIdCard(backstageUserUpdateIdCardReqPDTO);
        }
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    @Override
    public void updateBackstageUser(BackstageUserAddRequestDTO backstageuserAddRequestDTO) {
        BackstageUserAddReqDTO param = new BackstageUserAddReqDTO();
        this.setValueBackstageUserAddReqDTO(param, backstageuserAddRequestDTO);
        DubboResult result = this.backstageUserServiceApi.updateBackstageUser(param);
        if (!StringUtils.isBlank((String)backstageuserAddRequestDTO.getIdCard())) {
            BackstageUserUpdateIdCardReqPDTO backstageUserUpdateIdCardReqPDTO = new BackstageUserUpdateIdCardReqPDTO();
            backstageUserUpdateIdCardReqPDTO.setIdCard(backstageuserAddRequestDTO.getIdCard());
            backstageUserUpdateIdCardReqPDTO.setMobilePhone(backstageuserAddRequestDTO.getMobilePhone());
            this.updateBackstageUserIdCard(backstageUserUpdateIdCardReqPDTO);
        }
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    @Override
    public BackstageUserInfoResponseDTO searchBackstageUser(BackstageUserSearchRequestDTO backstageSearchUpdateRequestDTO) {
        BackstageUserSearchReqDTO backstageUserSearchReqDTO = new BackstageUserSearchReqDTO();
        backstageUserSearchReqDTO.setUserId(backstageSearchUpdateRequestDTO.getUserId());
        DubboResult result = this.backstageUserServiceApi.searchBackstageUser(backstageUserSearchReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        AssertUtils.assertNotNull((Object)result.getData(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u6682\u65e0\u6570\u636e");
        BackstageUserInfoResDTO resultObj = (BackstageUserInfoResDTO)result.getData();
        return new BackstageUserInfoResponseDTO(resultObj);
    }

    @Override
    public void updateBackstageUserStatus(BackstageUserUpdateStatusRequestDTO req) {
        BackstageUserUpdateStatusReqDTO res = new BackstageUserUpdateStatusReqDTO();
        res.setUserId(req.getUserId());
        res.setStatus(req.getStatus());
        DubboResult result = this.backstageUserServiceApi.updateBackstageUserStatus(res);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    @Override
    public PageInfo<BackstageUserInfoResponseDTO> listBackstageUser(BackstageUserListRequestDTO backstageUserListRequestDTO) {
        BackstageUserListReqDTO backstageUserListReqDTO = new BackstageUserListReqDTO();
        backstageUserListReqDTO.setPageIndex(backstageUserListRequestDTO.getPageIndex());
        backstageUserListReqDTO.setPageSize(backstageUserListRequestDTO.getPageSize());
        backstageUserListReqDTO.setUserName(backstageUserListRequestDTO.getUserName());
        backstageUserListReqDTO.setMobilePhone(backstageUserListRequestDTO.getMobilePhone());
        backstageUserListReqDTO.setKeyword(backstageUserListRequestDTO.getKeyword());
        if (StringUtils.isNotBlank((CharSequence)backstageUserListRequestDTO.getRoleType())) {
            if (MeetingUserTypeEnum.JUROR.name().equalsIgnoreCase(backstageUserListRequestDTO.getRoleType())) {
                backstageUserListReqDTO.setRoleCode(backstageUserListRequestDTO.getRoleType());
            } else {
                backstageUserListReqDTO.setRoleType(MeetingUserTypeEnum.MEDIATOR.name());
            }
        }
        backstageUserListReqDTO.setOrganizationId(backstageUserListRequestDTO.getOrgId());
        DubboResult result = this.backstageUserServiceApi.listBackstageUser(backstageUserListReqDTO);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        PageInfo resultPageInfo = (PageInfo)result.getData();
        List resultList = resultPageInfo.getList();
        if (resultList == null || resultList.size() == 0) {
            return new PageInfo(new ArrayList(), 0, resultPageInfo.getPageIndex());
        }
        ArrayList<BackstageUserInfoResponseDTO> list = new ArrayList<BackstageUserInfoResponseDTO>();
        for (BackstageUserInfoResDTO back : resultList) {
            BackstageUserInfoResponseDTO obj = new BackstageUserInfoResponseDTO(back);
            list.add(obj);
        }
        PageInfo pageInfo = new PageInfo(list, resultPageInfo.getTotalRows(), resultPageInfo.getPageIndex());
        return pageInfo;
    }

    private void setValueBackstageUserAddReqDTO(BackstageUserAddReqDTO param, BackstageUserAddRequestDTO backstageuserAddRequestDTO) {
        param.setUserId(backstageuserAddRequestDTO.getUserId());
        param.setUserName(backstageuserAddRequestDTO.getUserName());
        param.setMobilePhone(backstageuserAddRequestDTO.getMobilePhone());
        param.setAbility(backstageuserAddRequestDTO.getAbility());
        param.setUserRoleRelation(backstageuserAddRequestDTO.getUserRoleRelation());
        param.setSex(backstageuserAddRequestDTO.getSex());
        param.setHeadPortraitUrl(backstageuserAddRequestDTO.getHeadPortraitUrl());
        param.setPersonalSchedules(backstageuserAddRequestDTO.getPersonalSchedules());
        param.setPeopleManagement(backstageuserAddRequestDTO.getPeopleManagement());
        param.setStatistics(backstageuserAddRequestDTO.getStatistics());
        param.setCourtSchedules(backstageuserAddRequestDTO.getCourtSchedules());
        param.setGatewayStatus(backstageuserAddRequestDTO.getGatewayStatus());
        param.setDepartId(backstageuserAddRequestDTO.getDepartId());
        param.setDepartName(backstageuserAddRequestDTO.getDepartName());
    }

    @Override
    public UserRoleInfoDTO searchBackstageUserOrgId(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            return null;
        }
        BackstageUserInfoResponseDTO creator = this.searchBackstageUser(new BackstageUserSearchRequestDTO(Long.valueOf(userId)));
        List userRole = creator.getUserRole();
        if (CollectionUtils.isEmpty((Collection)userRole)) {
            return null;
        }
        UserRoleInfoDTO roleInfo = (UserRoleInfoDTO)userRole.get(0);
        return roleInfo;
    }

    @Override
    public void updateBackstageUserIdCard(@Valid BackstageUserUpdateIdCardReqPDTO backstageUserUpdateIdCardReqPDTO) {
        BackstageUserUpdateIdCardReqDTO res = new BackstageUserUpdateIdCardReqDTO();
        res.setMobilePhone(backstageUserUpdateIdCardReqPDTO.getMobilePhone());
        res.setIdCard(backstageUserUpdateIdCardReqPDTO.getIdCard());
        res.setOldmobilePhone(backstageUserUpdateIdCardReqPDTO.getOldmobilePhone());
        DubboResult result = this.backstageUserServiceApi.updateBackstageUserIdCard(res);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
    }

    @Override
    public List<DepartmentsResponseDTO> listDepartments(DepartmentsRequestDTO dto) {
        AssertUtils.assertTrue((null != dto.getOrgId() ? 1 : 0) != 0, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<DepartmentsResponseDTO> list = new ArrayList();
        DepartReqDTO reqDTO = new DepartReqDTO();
        reqDTO.setOrgId(dto.getOrgId());
        DubboResult dubboResult = this.backstageUserServiceApi.listDepartment(reqDTO);
        AssertUtils.assertTrue((boolean)dubboResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)dubboResult.getMessage());
        list = (List)((Object)dubboResult.getData());
        return list;
    }
}

