/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.impl;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.redis.key.RedisKey;
import com.beiming.framework.security.JWTContextUtil;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.ShortUrlUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.document.dto.requestdto.DeliveryRequestDTO;
import com.beiming.odr.document.dto.responsedto.DossierAttachment;
import com.beiming.odr.document.dto.responsedto.ElectronicConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.ElectronicDeliveryResDTO;
import com.beiming.odr.document.dto.responsedto.MediationPromiseGetResDTO;
import com.beiming.odr.document.dto.responsedto.MediationSchemeResDTO;
import com.beiming.odr.document.dto.responsedto.MediatorMediationSchemeResDTO;
import com.beiming.odr.document.enums.DocumentTypeEnum;
import com.beiming.odr.document.enums.UserTypeEnum;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.PeaceRedisKeyEnums;
import com.beiming.odr.peace.domain.dto.requestdto.AreaRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DossierDeleteRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DossierRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.MediationSchemeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ObjectTypeRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SavePromiseBookRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SaveProtocolBookRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.AgentInfoResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.AreasResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ElectronicDeliveryGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationPromiseGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.MediationSchemeResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.PromiseResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolBookResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ProtocolPersonResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.SendProtocolBookResponseDTO;
import com.beiming.odr.peace.service.DocumentService;
import com.beiming.odr.peace.service.backend.document.DocDossierDubboService;
import com.beiming.odr.peace.service.backend.document.DocMediationBookDubboService;
import com.beiming.odr.peace.service.backend.document.DocMediationSchemeDubboService;
import com.beiming.odr.peace.service.backend.document.DocPromiseDubboService;
import com.beiming.odr.peace.service.backend.document.DocUndisputedFactDubboService;
import com.beiming.odr.peace.service.backend.referee.MediationRoomDubboService;
import com.beiming.odr.peace.service.backend.user.DictionaryService;
import com.beiming.odr.peace.service.convert.DocPromiseConvert;
import com.beiming.odr.peace.service.convert.DocumentConvert;
import com.beiming.odr.peace.service.util.DocumentUtil;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.UserServiceApi;
import com.beiming.odr.user.api.dto.requestdto.UserAreaReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserAreasResDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger log = LoggerFactory.getLogger(DocumentServiceImpl.class);
    @Resource
    private MediationRoomDubboService mediationRoomDubboService;
    @Resource
    private DocMediationBookDubboService docMediationBookDubboService;
    @Resource
    private DocUndisputedFactDubboService docUndisputedFactDubboService;
    @Resource
    private DocMediationSchemeDubboService docMediationSchemeDubboService;
    @Resource
    private DocPromiseDubboService docPromiseDubboService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private DocDossierDubboService docDossierDubboService;
    @Resource
    private RedisService redisService;
    @Value(value="${peace.qrCodeUrlPrefix}")
    private String qrCodeUrlPrefix;
    @Value(value="${peace.accessSignUrlPrefix}")
    private String accessSignUrlPrefix;
    @Value(value="${peace.accessSignUrlSuffix}")
    private String accessSignUrlSuffix;

    @Override
    public ProtocolBookResponseDTO getProtocolBook(ProtocolBookRequestDTO dto) {
        ProtocolBookResponseDTO result = new ProtocolBookResponseDTO();
        Boolean mediatorFlag = this.mediationRoomDubboService.checkIsMediator(dto.getId());
        if (mediatorFlag.booleanValue()) {
            switch (dto.getDocumentType()) {
                case MEDIATION_BOOK: {
                    result = this.docMediationBookDubboService.getMediationBookByMediator(dto.getId());
                    break;
                }
                case UNDISPUTED_FACT: {
                    result = this.docUndisputedFactDubboService.getUndisputedFactByMediator(dto.getId());
                    break;
                }
            }
            if (result.getProtocolId() == null) {
                this.getMediationRoomUser(dto.getId(), dto.getDocumentType(), result);
            }
        } else {
            switch (dto.getDocumentType()) {
                case MEDIATION_BOOK: {
                    result = this.docMediationBookDubboService.getMediationBookByUser(dto.getId());
                    break;
                }
                case NO_DISSENT_MEDIATION_SCHEME: {
                    result = this.docMediationSchemeDubboService.getMediationSchemeByUser(dto.getId());
                    break;
                }
                case UNDISPUTED_FACT: {
                    result = this.docUndisputedFactDubboService.getUndisputedFactByUser(dto.getId());
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public MediationSchemeResponseDTO getMediationSchemeByMediator(MediationSchemeRequestDTO dto) {
        MediationSchemeResponseDTO result = new MediationSchemeResponseDTO();
        MediatorMediationSchemeResDTO dubboScheme = this.docMediationSchemeDubboService.getMediationSchemeByMediator(dto.getId());
        PromiseResponseDTO promise = null;
        if (!dubboScheme.getPromiseSaveFlag().booleanValue()) {
            promise = new PromiseResponseDTO();
            ArrayList<MediationRoomUserInfoResDTO> list = this.mediationRoomDubboService.getMediationRoomUserInfoList(dto.getId());
            promise.setApplicantName(DocumentUtil.getAppNames(list));
            promise.setRespondentName(DocumentUtil.getResNames(list));
        }
        result.setPromise(promise);
        ProtocolBookResponseDTO mediationScheme = new ProtocolBookResponseDTO();
        MediationSchemeResDTO resDTO = dubboScheme.getMediationScheme();
        if (resDTO.getMediationSchemeId() == null) {
            mediationScheme.setCaseNo(resDTO.getCaseNo());
            this.getMediationRoomUser(dto.getId(), DocumentTypeEnum.NO_DISSENT_MEDIATION_SCHEME, mediationScheme);
        } else {
            mediationScheme = DocumentConvert.convertMediationSchemeResDTO(resDTO);
        }
        result.setMediationScheme(mediationScheme);
        return result;
    }

    @Override
    public Long saveProtocolBook(SaveProtocolBookRequestDTO dto) {
        Long protocolBookId = null;
        switch (dto.getDocumentType()) {
            case MEDIATION_BOOK: {
                protocolBookId = this.docMediationBookDubboService.saveMediationBook(dto);
                break;
            }
            case NO_DISSENT_MEDIATION_SCHEME: {
                protocolBookId = this.docMediationSchemeDubboService.saveMediationScheme(dto);
                break;
            }
            case UNDISPUTED_FACT: {
                protocolBookId = this.docUndisputedFactDubboService.saveUndisputedFact(dto);
                break;
            }
        }
        return protocolBookId;
    }

    @Override
    public SendProtocolBookResponseDTO sendProtocolBook(SaveProtocolBookRequestDTO dto) {
        SendProtocolBookResponseDTO result = new SendProtocolBookResponseDTO();
        Long protocolBookId = this.saveProtocolBook(dto);
        result.setProtocolId(protocolBookId);
        String userId = JWTContextUtil.getCurrentUserId();
        String shortUrl = this.launchSign(protocolBookId, userId);
        result.setLaunchSign(shortUrl);
        return result;
    }

    @Override
    public void savePromiseBook(SavePromiseBookRequestDTO dto) {
        ArrayList<MediationRoomUserInfoResDTO> list = this.mediationRoomDubboService.getMediationRoomUserInfoList(dto.getMediationRoomId());
        this.docPromiseDubboService.savePromiseBook(dto, list);
    }

    @Override
    public MediationPromiseGetResponseDTO viewMediationPromise(ObjectTypeRequestDTO reqDTO) {
        MediationPromiseGetResDTO result = this.docPromiseDubboService.getMediationPromise(reqDTO.getId(), reqDTO.getType());
        return DocPromiseConvert.getMediationPromiseGetResponseDTO(result);
    }

    @Override
    public String launchSign(Long documentId, String currentUserId) {
        String apiUrl = this.dictionaryService.getDictionaryValue("PEACE_API_URL");
        String shortQrCodeUrl = ShortUrlUtils.encode((long)documentId) + ShortUrlUtils.encode((long)Long.valueOf(currentUserId));
        String shortUrl = apiUrl + this.qrCodeUrlPrefix.concat(shortQrCodeUrl);
        String longUrl = apiUrl.concat(this.accessSignUrlPrefix).concat(AppNameContextHolder.getAppName()).concat("/").concat(this.accessSignUrlSuffix).concat(documentId.toString()) + "&userId=" + currentUserId;
        log.info("launchSign appName is {}", (Object)AppNameContextHolder.getAppName());
        this.redisService.hSet((RedisKey)PeaceRedisKeyEnums.SHORT_URL, shortQrCodeUrl, (Object)longUrl);
        return shortUrl;
    }

    private void getMediationRoomUser(Long mediationRoomId, DocumentTypeEnum documentType, ProtocolBookResponseDTO result) {
        result.setMediationRoomId(mediationRoomId);
        result.setDocumentType(documentType.name());
        ArrayList<MediationRoomUserInfoResDTO> list = this.mediationRoomDubboService.getMediationRoomUserInfoList(mediationRoomId);
        ArrayList applicantList = Lists.newArrayList();
        ArrayList respondentList = Lists.newArrayList();
        List<MediationRoomUserInfoResDTO> agentList = list.stream().filter(s -> MeetingUserTypeEnum.APPLICANT_AGENT.name().equals(s.getMeetingUserType()) || MeetingUserTypeEnum.RESPONDENT_AGENT.name().equals(s.getMeetingUserType())).collect(Collectors.toList());
        for (MediationRoomUserInfoResDTO resDTO : list) {
            ProtocolPersonResponseDTO protocolPerson = new ProtocolPersonResponseDTO();
            protocolPerson.setUserId(resDTO.getUserId());
            protocolPerson.setUserType(resDTO.getUserType());
            protocolPerson.setMeetingUserType(resDTO.getMeetingUserType());
            if (UserTypeEnum.NATURAL_PERSON.name().equals(resDTO.getUserType())) {
                protocolPerson.setUserName(resDTO.getUserName());
            } else {
                protocolPerson.setCorporation(resDTO.getUserName());
            }
            protocolPerson.setPhone(resDTO.getMobilePhone());
            protocolPerson.setIdCard(resDTO.getIdCard());
            protocolPerson.setUserOrder(resDTO.getUserOrder());
            if (!CollectionUtils.isEmpty(agentList)) {
                AgentInfoResponseDTO agent = this.getAgentInfoResponseDTO(resDTO.getPersonId(), agentList);
                protocolPerson.setAgent(agent);
            }
            if (MeetingUserTypeEnum.APPLICANT.name().equals(resDTO.getMeetingUserType())) {
                applicantList.add(protocolPerson);
            }
            if (!MeetingUserTypeEnum.RESPONDENT.name().equals(resDTO.getMeetingUserType())) continue;
            respondentList.add(protocolPerson);
        }
        result.setApplicantList((List)applicantList);
        result.setRespondentList((List)respondentList);
    }

    private AgentInfoResponseDTO getAgentInfoResponseDTO(Long personId, List<MediationRoomUserInfoResDTO> agentList) {
        AgentInfoResponseDTO agent = null;
        for (MediationRoomUserInfoResDTO agentRes : agentList) {
            if (!personId.equals(agentRes.getAgentParentId())) continue;
            agent = new AgentInfoResponseDTO();
            agent.setAgentId(agentRes.getUserId());
            agent.setAgentName(agentRes.getUserName());
            agent.setAgentSex(agentRes.getUserSex());
            agent.setAgentPhone(agentRes.getMobilePhone());
            agent.setAgentIdCard(agentRes.getIdCard());
            break;
        }
        return agent;
    }

    @Override
    public String launchSignMicro(Long documentId, String currentUserId, Boolean isResign) {
        String apiUrl = this.dictionaryService.getDictionaryValue("PEACE_API_URL");
        String shortQrCodeUrl = ShortUrlUtils.encode((long)documentId) + ShortUrlUtils.encode((long)Long.valueOf(currentUserId)) + isResign;
        String shortUrl = apiUrl + this.qrCodeUrlPrefix.concat(shortQrCodeUrl);
        String longUrl = apiUrl.concat(this.accessSignUrlPrefix).concat(AppNameContextHolder.getAppName()).concat("/").concat(this.accessSignUrlSuffix).concat(documentId.toString()) + "&userId=" + currentUserId + "&isResign=" + isResign;
        log.info("launchSign appName is {}", (Object)AppNameContextHolder.getAppName());
        this.redisService.hSet((RedisKey)PeaceRedisKeyEnums.SHORT_URL, shortQrCodeUrl, (Object)longUrl);
        return shortUrl;
    }

    @Override
    public void uploadDossier(DossierDeleteRequestDTO dto) {
        for (DossierRequestDTO reqDto : dto.getDossierList()) {
            this.docDossierDubboService.saveDossier(reqDto);
        }
    }

    @Override
    public List<Map<String, Object>> dossierCatalogue(DossierRequestDTO dto) {
        List<DossierAttachment> list = this.docDossierDubboService.selectDossierCatalogue(dto);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Map<String, List<DossierAttachment>> map = list.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getCategoryMiddle())).collect(Collectors.groupingBy(DossierAttachment::getCategoryMiddle));
        map.forEach((x, y) -> {
            List sortList = y.stream().sorted(Comparator.comparing(DossierAttachment::getDocSort)).collect(Collectors.toList());
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            newMap.put("fileName", x);
            newMap.put("children", sortList);
            resultList.add(newMap);
        });
        return resultList;
    }

    @Override
    public void deleteDossier(DossierDeleteRequestDTO dto) {
        this.docDossierDubboService.deleteDossier(dto);
    }

    @Override
    public void updateDossierSort(DossierDeleteRequestDTO dto) {
        this.docDossierDubboService.updateDossierSort(dto);
    }

    @Override
    public ArrayList<ElectronicDeliveryGetResponseDTO> signatureStatus(DeliveryRequestDTO dto) {
        return this.mediationRoomDubboService.signatureStatus(dto);
    }

    @Override
    public ElectronicDeliveryResDTO electronicDocInfo(DeliveryRequestDTO dto) {
        return this.mediationRoomDubboService.electronicDocInfo(dto);
    }

    @Override
    public ElectronicConfirmResDTO confirmDocInfo(ElectronicDeliveryResDTO dto) {
        return this.mediationRoomDubboService.confirmDocInfo(dto);
    }

    @Override
    public ArrayList<AreasResponseDTO> searchAreasInfo(AreaRequestDTO areaRequestDTO) {
        UserAreaReqDTO areaReqDTO = new UserAreaReqDTO();
        areaReqDTO.setCode(areaRequestDTO.getCode());
        areaReqDTO.setLevel(areaRequestDTO.getLevel());
        areaReqDTO.setParentCode(areaRequestDTO.getParentCode());
        DubboResult areasResult = this.userServiceApi.searchAreasInfo(areaReqDTO);
        AssertUtils.assertTrue((boolean)areasResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)areasResult.getMessage());
        ArrayList list = (ArrayList)areasResult.getData();
        log.info("UserAreas list.size() is :{}", (Object)list.size());
        ArrayList<AreasResponseDTO> result = new ArrayList<AreasResponseDTO>();
        if (list.size() > 0) {
            for (UserAreasResDTO areasInfoDTO : list) {
                result.add(new AreasResponseDTO(areasInfoDTO));
            }
        }
        log.info("result list.size() is :{}", (Object)result.size());
        return result;
    }

    @Override
    public Map<String, Object> signatureConfirmInfo(ElectronicDeliveryResDTO dto) {
        return this.mediationRoomDubboService.signatureConfirmInfo(dto);
    }
}

