/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.document.impl;

import com.alibaba.fastjson.JSON;
import com.beiming.odr.document.api.DocDossierApi;
import com.beiming.odr.document.dto.responsedto.DossierAttachment;
import com.beiming.odr.peace.domain.dto.requestdto.DossierDeleteRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.DossierRequestDTO;
import com.beiming.odr.peace.service.backend.document.DocDossierDubboService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocDossierDubboServiceImpl
implements DocDossierDubboService {
    private static final Logger log = LoggerFactory.getLogger(DocDossierDubboServiceImpl.class);
    @Resource
    private DocDossierApi docDossierApi;

    @Override
    public void saveDossier(DossierRequestDTO dto) {
        DossierAttachment dossierAttachment = new DossierAttachment();
        BeanUtils.copyProperties((Object)dto, (Object)dossierAttachment);
        dossierAttachment.setStatus(Integer.valueOf(0));
        log.info("DossierRequestDTO is :{}", (Object)JSON.toJSONString((Object)dossierAttachment));
        this.docDossierApi.saveDossier(dossierAttachment);
    }

    @Override
    public void deleteDossier(DossierDeleteRequestDTO dto) {
        List dossierList = dto.getDossierList();
        for (DossierRequestDTO delDto : dossierList) {
            DossierAttachment dossierAttachment = new DossierAttachment();
            dossierAttachment.setId(delDto.getId());
            dossierAttachment.setUpdateUser(dto.getUserName());
            dossierAttachment.setStatus(Integer.valueOf(1));
            dossierAttachment.setUpdateTime(new Date());
            this.docDossierApi.deleteDossier(dossierAttachment);
        }
    }

    @Override
    @Transactional
    public void updateDossierSort(DossierDeleteRequestDTO dto) {
        List dossierList = dto.getDossierList();
        int ztDoc = 0;
        int qsDoc = 0;
        int zjDoc = 0;
        for (DossierRequestDTO updateDto : dossierList) {
            DossierAttachment dossierAttachment = new DossierAttachment();
            dossierAttachment.setId(updateDto.getId());
            dossierAttachment.setUpdateUser(dto.getUserName());
            dossierAttachment.setCategoryMiddle(updateDto.getCategoryMiddle());
            dossierAttachment.setUpdateTime(new Date());
            if ("\u4e3b\u4f53\u6750\u6599".equals(updateDto.getCategoryMiddle())) {
                dossierAttachment.setDocSort(Integer.valueOf(ztDoc++));
            } else if ("\u8d77\u8bc9\u72b6".equals(updateDto.getCategoryMiddle())) {
                dossierAttachment.setDocSort(Integer.valueOf(qsDoc++));
            } else if ("\u8bc1\u636e\u6750\u6599".equals(updateDto.getCategoryMiddle())) {
                dossierAttachment.setDocSort(Integer.valueOf(zjDoc++));
            }
            this.docDossierApi.updateDossierSort(dossierAttachment);
        }
    }

    @Override
    public List<DossierAttachment> selectDossierCatalogue(DossierRequestDTO dto) {
        return this.docDossierApi.selectDossierCatalogue(dto.getMeetingId());
    }
}

