/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.APIResultCode;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.exception.APIBusinessException;
import com.beiming.framework.redis.RedisService;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.MyHttpClientUtils;
import com.beiming.odr.document.api.DocumentApi;
import com.beiming.odr.document.api.PdfAttachMentApi;
import com.beiming.odr.document.dto.requestdto.SignatureBizInfoReqDTO;
import com.beiming.odr.document.dto.requestdto.SignatureInfoReqDTO;
import com.beiming.odr.document.dto.responsedto.DocWholeConfirmResDTO;
import com.beiming.odr.document.dto.responsedto.DocumentResDTO;
import com.beiming.odr.document.dto.responsedto.SignatureInfoResDTO;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.enums.ThirdPartyEnum;
import com.beiming.odr.peace.common.utils.ImgTools;
import com.beiming.odr.peace.common.utils.JavaFileUtil;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkConfirmAgainRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkConfirmRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordGetRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.ClerkRecordSaveRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.SignCallBackRequestDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkConfirmResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordGetResponseDTO;
import com.beiming.odr.peace.domain.dto.responsedto.ClerkRecordSaveResponseDTO;
import com.beiming.odr.peace.service.backend.document.SignatureDubboService;
import com.beiming.odr.peace.service.backend.storage.StorageDubboService;
import com.beiming.odr.peace.service.client.ClerkOpinionService;
import com.beiming.odr.peace.service.client.ClerkRecordService;
import com.beiming.odr.peace.service.client.YanChengMeetingService;
import com.beiming.odr.peace.service.util.Base64Utils;
import com.beiming.odr.referee.api.IntranetApi;
import com.beiming.odr.referee.api.MediationMeetingRoomApi;
import com.beiming.odr.referee.dto.responsedto.IntranetMeetingCaseInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationMeetingRoomUserInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRoomUserInfoResDTO;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ClerkOpinionServiceImpl
implements ClerkOpinionService {
    private static final Logger log = LoggerFactory.getLogger(ClerkOpinionServiceImpl.class);
    @Resource
    private SignatureDubboService signatureDubboService;
    @Resource
    private StorageDubboService storageDubboServiceImpl;
    @Resource
    private ClerkRecordService clerkRecordServiceImpl;
    @Resource
    UserServiceSecondApi userServiceSecondApi;
    @Resource
    IntranetApi intranetApi;
    @Resource
    private YanChengMeetingService yanChengMeetingService;
    @Resource
    private RedisService redisService;
    private RedisTemplate redisTemplate;
    @Resource
    private DocumentApi documentApi;
    @Resource
    private MediationMeetingRoomApi mediationMeetingRoomApi;
    @Resource
    private PdfAttachMentApi pdfAttachMentApi;

    @Override
    public ClerkConfirmResponseDTO confirmSignature(ClerkConfirmRequestDTO requestDTO, MultipartFile signFile) {
        String string;
        log.info("\u8bf7\u6c42\u53c2\u6570{}", (Object)requestDTO);
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        Long userId = requestDTO.getUserId();
        Integer degree = requestDTO.getDegree();
        String documentIds = requestDTO.getDocumentIds();
        ArrayList signBizInfo = Lists.newArrayList();
        for (String docId : documentIds.split(",")) {
            AssertUtils.assertTrue((StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{docId}) && pattern.matcher(docId).matches() ? 1 : 0) != 0, (ResultCode)ErrorCode.CLERK_SIGNATURE_FAIL, (String)"{signature.document.ids.error}");
            SignatureBizInfoReqDTO bizInfo = new SignatureBizInfoReqDTO(Long.valueOf(docId), null, null, null, null, null);
            signBizInfo.add(bizInfo);
        }
        SaveFileResponseDTO saveFileresDTO = this.processImage(signFile, degree);
        log.info("\u7b7e\u540d\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)saveFileresDTO.toString());
        SignatureInfoReqDTO reqDTO = new SignatureInfoReqDTO(userId, saveFileresDTO.getFileId(), degree, (List)signBizInfo);
        if ("ELECTRONIC_DOC".equals(requestDTO.getSource())) {
            SignatureInfoResDTO infoResDTO = this.signElectronicDoc(reqDTO);
            return new ClerkConfirmResponseDTO(infoResDTO.getErrorMsg());
        }
        SignatureInfoResDTO resDTO = this.signatureDubboService.confirmSignature(reqDTO);
        log.info("SignatureInfoReqDTO errorMsg:{}", (Object)resDTO);
        ClerkConfirmResponseDTO responseDTO = new ClerkConfirmResponseDTO(resDTO.getErrorMsg());
        this.sendRecordSignPic(requestDTO, signFile);
        DubboResult docDubbo = this.documentApi.queryDocumentByDocId(Long.valueOf(documentIds));
        DocumentResDTO documentRes = (DocumentResDTO)docDubbo.getData();
        DubboResult result = this.mediationMeetingRoomApi.getMediationRoomUserInfoList(documentRes.getObjectId());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        MediationMeetingRoomUserInfoResDTO mediationMeetingRoomInfoRes = (MediationMeetingRoomUserInfoResDTO)result.getData();
        if (StringUtils.isNotBlank((CharSequence)mediationMeetingRoomInfoRes.getRemark()) && mediationMeetingRoomInfoRes.getRemark().equals("YAN_CHENG")) {
            List list = mediationMeetingRoomInfoRes.getList();
            String string2 = this.getImageBase64(signFile, degree);
            SignCallBackRequestDTO requestDto = new SignCallBackRequestDTO();
            requestDto.setCaseNumberCode(mediationMeetingRoomInfoRes.getName());
            requestDto.setCaseOrder(mediationMeetingRoomInfoRes.getScheduleId());
            requestDto.setCourtCode(mediationMeetingRoomInfoRes.getOrgId().toString());
            requestDto.setFile(string2);
            for (MediationRoomUserInfoResDTO mediationRoomUserInfoRes : list) {
                if (!mediationRoomUserInfoRes.getUserId().toString().equals(requestDTO.getUserId().toString())) continue;
                requestDto.setLitigantMobilePhone(mediationRoomUserInfoRes.getMobilePhone());
            }
            this.yanChengMeetingService.signCallback(requestDto);
        }
        String appName = AppNameContextHolder.getAppName();
        for (String docId : documentIds.split(",")) {
            DubboResult document = this.documentApi.queryDocumentByDocId(Long.valueOf(docId));
            Long objectId = ((DocumentResDTO)document.getData()).getObjectId();
            DubboResult result1 = this.mediationMeetingRoomApi.getCauseCode(objectId);
            String causeCode = (String)((Object)result1.getData());
            if (causeCode.length() != 15 || !"weitingshen".equals(appName)) continue;
            String url = "http://222.190.111.146:15000/channel/jeM4bGixgK/sfjdjkfw/api/dzzz/wtsgz.do";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fydm", (Object)"320000");
            jsonObject.put("yydm", (Object)"BMZB");
            jsonObject.put("ahdm", (Object)causeCode);
            jsonObject.put("wjmc", (Object)"\u7b14\u5f55");
            jsonObject.put("wjgs", (Object)"pdf");
            StringBuilder urlFileInfo = new StringBuilder("https://internetcourt.odrcloud.cn/peace/file/downloadAttachment?");
            urlFileInfo.append("id=").append(objectId);
            urlFileInfo.append("&sign=").append(ThirdPartyEnum.TDHYAOHAO.getCode());
            String s = Base64.getEncoder().encodeToString(urlFileInfo.toString().getBytes());
            jsonObject.put("gzwsDownloadPath", (Object)s);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            String resultData = MyHttpClientUtils.sendHttpPost((String)url, (String)jsonObject.toJSONString(), header);
            log.info("-----------------\u901a\u8fbe\u6d77\u53c2\u6570\uff1a{}, fileid:{}, \u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{jsonObject.toJSONString(), docId, resultData});
        }
        log.info("\u7b7e\u540d\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u4e3a{}", (Object)responseDTO);
        if (StringUtils.isNotBlank((CharSequence)responseDTO.getMessage()) && (string = responseDTO.getMessage()).contains("BusinessMessage:")) {
            responseDTO.setMessage(string.split("BusinessMessage:")[1]);
        }
        return responseDTO;
    }

    private SignatureInfoResDTO signElectronicDoc(SignatureInfoReqDTO reqDTO) {
        return this.signatureDubboService.signElectronicDoc(reqDTO);
    }

    private SaveFileResponseDTO processImage(MultipartFile signFile, Integer degree) {
        AssertUtils.assertNotNull((Object)signFile, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"{signature.image.not.exit}");
        String fileName = signFile.getOriginalFilename();
        AssertUtils.assertTrue((boolean)JavaFileUtil.isPictureExt((String)fileName), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"{signature.image.not.exit}");
        byte[] signFileByteArr = null;
        try {
            signFileByteArr = signFile.getBytes();
            if (null != degree && !degree.equals(0)) {
                signFileByteArr = JavaFileUtil.rotateImg((byte[])signFile.getBytes(), (int)degree, null);
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
            throw new APIBusinessException((APIResultCode)APIResultCodeEnums.RESULT_EMPTY, "{signature.image.rotate.error}");
        }
        DubboResult<SaveFileResponseDTO> saveFileRes = this.storageDubboServiceImpl.save(fileName, signFileByteArr);
        AssertUtils.assertNotNull(saveFileRes, (ResultCode)ErrorCode.CLERK_SIGNATURE_IMG_SAVE_FAILE, (String)"{signature.image.save.fail}");
        SaveFileResponseDTO saveFileresDTO = (SaveFileResponseDTO)saveFileRes.getData();
        String imgId = saveFileresDTO.getFileId();
        AssertUtils.assertHasText((String)imgId, (ResultCode)ErrorCode.CLERK_SIGNATURE_IMG_ID_NOT_EXIT, (String)"{signature.image.id.is.null}");
        return saveFileresDTO;
    }

    private String getImageBase64(MultipartFile signFile, Integer degree) {
        AssertUtils.assertNotNull((Object)signFile, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"{signature.image.not.exit}");
        String fileName = signFile.getOriginalFilename();
        AssertUtils.assertTrue((boolean)JavaFileUtil.isPictureExt((String)fileName), (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"{signature.image.not.exit}");
        byte[] signFileByteArr = null;
        try {
            signFileByteArr = signFile.getBytes();
            if (null != degree && !degree.equals(0)) {
                signFileByteArr = JavaFileUtil.rotateImg((byte[])signFile.getBytes(), (int)degree, null);
            }
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
            throw new APIBusinessException((APIResultCode)APIResultCodeEnums.RESULT_EMPTY, "{signature.image.rotate.error}");
        }
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])signFileByteArr);
    }

    @Override
    @Transactional
    public Object againClerkConfirm(ClerkConfirmAgainRequestDTO clerkConfirmAgainRequestDTO, String userName) {
        String appName;
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        suffix = suffix + "_DOCID_" + clerkConfirmAgainRequestDTO.getDocId();
        String checkSign = (String)this.redisTemplate.opsForValue().get((Object)suffix);
        if (checkSign != null) {
            int type = 1;
            return type;
        }
        this.redisTemplate.opsForValue().set((Object)suffix, (Object)clerkConfirmAgainRequestDTO.getDocId().toString(), 1L, TimeUnit.MINUTES);
        ClerkRecordGetRequestDTO reqDTO = new ClerkRecordGetRequestDTO();
        reqDTO.setMeetId(clerkConfirmAgainRequestDTO.getMeetId());
        reqDTO.setRoomId(clerkConfirmAgainRequestDTO.getRoomId());
        reqDTO.setBizId(reqDTO.getMeetId());
        DocWholeConfirmResDTO eholeConfirmResDTO = this.signatureDubboService.queryState(clerkConfirmAgainRequestDTO.getDocId());
        if (eholeConfirmResDTO.getStatus().equals(1)) {
            int type = 1;
            return type;
        }
        ClerkRecordGetResponseDTO clerkRecordGetResponseDTO = this.clerkRecordServiceImpl.viewClerkRecord(reqDTO);
        ClerkRecordSaveRequestDTO clerkRecordSaveRequestDTO = new ClerkRecordSaveRequestDTO();
        clerkRecordSaveRequestDTO.setBizId(clerkRecordGetResponseDTO.getBizId());
        clerkRecordSaveRequestDTO.setBizNo(clerkRecordGetResponseDTO.getBizNo());
        clerkRecordSaveRequestDTO.setContent(clerkRecordGetResponseDTO.getContent());
        clerkRecordSaveRequestDTO.setDisputeType(clerkRecordGetResponseDTO.getDisputeType());
        clerkRecordSaveRequestDTO.setDocId(clerkRecordGetResponseDTO.getDocId());
        clerkRecordSaveRequestDTO.setLocation(clerkRecordGetResponseDTO.getLocation());
        clerkRecordSaveRequestDTO.setMediatorName(userName);
        clerkRecordSaveRequestDTO.setMeetId(reqDTO.getMeetId());
        clerkRecordSaveRequestDTO.setOrgId(clerkRecordGetResponseDTO.getOrgId());
        clerkRecordSaveRequestDTO.setOrgName(clerkRecordGetResponseDTO.getOrgName());
        clerkRecordSaveRequestDTO.setRemark(clerkRecordGetResponseDTO.getRemark());
        clerkRecordSaveRequestDTO.setRoomId(clerkConfirmAgainRequestDTO.getRoomId());
        clerkRecordSaveRequestDTO.setSelectPersonIds(clerkRecordGetResponseDTO.getSelectPersonIds());
        clerkRecordSaveRequestDTO.setTime(clerkRecordGetResponseDTO.getTime());
        clerkRecordSaveRequestDTO.setUserInfo(clerkRecordGetResponseDTO.getUserInfo());
        ClerkRecordSaveResponseDTO clerkRecordSaveResponseDTO = this.clerkRecordServiceImpl.sendClerkRecordMicro(clerkRecordSaveRequestDTO);
        Thread.sleep(1000L);
        List<DocWholeConfirmResDTO> list = this.signatureDubboService.queryBilu(clerkConfirmAgainRequestDTO.getMeetId(), clerkConfirmAgainRequestDTO.getUserId(), clerkConfirmAgainRequestDTO.getDocId());
        if (!CollectionUtils.isEmpty(list)) {
            for (DocWholeConfirmResDTO ss : list) {
                if (ss.getConfirm() != null && ss.getConfirm() != "" && !ss.getConfirm().equals("SIGN_YES")) {
                    DocWholeConfirmResDTO docWholeConfirmResDTO = this.signatureDubboService.queryR(ss);
                    ss.setId(docWholeConfirmResDTO.getId());
                    this.signatureDubboService.updateConfirm(ss);
                    continue;
                }
                if (ss.getConfirm() == null || ss.getConfirm() == "") continue;
                ArrayList<SignatureBizInfoReqDTO> signBizInfo = new ArrayList<SignatureBizInfoReqDTO>();
                SignatureBizInfoReqDTO bizInfo = new SignatureBizInfoReqDTO(clerkRecordSaveResponseDTO.getDocumentId(), null, null, null, null, null);
                signBizInfo.add(bizInfo);
                SignatureInfoReqDTO reqDTOs = new SignatureInfoReqDTO(ss.getConfirmUserId(), ss.getSignatureUrl(), clerkConfirmAgainRequestDTO.getDegree(), signBizInfo);
                SignatureInfoResDTO resDTO = this.signatureDubboService.confirmSignatures(reqDTOs);
                Thread.sleep(2000L);
            }
        }
        this.redisTemplate.delete((Object)suffix);
        DubboResult document = this.documentApi.queryDocumentByDocId(clerkConfirmAgainRequestDTO.getDocId());
        Long objectId = ((DocumentResDTO)document.getData()).getObjectId();
        DubboResult result1 = this.mediationMeetingRoomApi.getCauseCode(objectId);
        String causeCode = (String)((Object)result1.getData());
        if (causeCode.length() == 15 && "weitingshen".equals(appName)) {
            String url = "http://222.190.111.146:15000/channel/Si4y7XRoaR/sfjdjkfw/sfjd/api/dzzz/wtsgz.do";
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fydm", (Object)"320000");
            jsonObject.put("yydm", (Object)"BMZB");
            jsonObject.put("ahdm", (Object)causeCode);
            jsonObject.put("wjmc", (Object)"\u7b14\u5f55");
            jsonObject.put("wjgs", (Object)"docx");
            StringBuilder urlFileInfo = new StringBuilder("https://internetcourt.odrcloud.cn/peace/file/downloadAttachment?");
            urlFileInfo.append("id=").append(objectId);
            urlFileInfo.append("&sign=").append(ThirdPartyEnum.TDHYAOHAO.getCode());
            String s = Base64.getEncoder().encodeToString(urlFileInfo.toString().getBytes());
            jsonObject.put("gzwsDownloadPath", (Object)s);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "application/json");
            String resultData = MyHttpClientUtils.sendHttpPost((String)url, (String)jsonObject.toJSONString(), header);
            log.info("-----------------\u901a\u8fbe\u6d77\u53c2\u6570\uff1a{},\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)jsonObject.toJSONString(), (Object)resultData);
        }
        return clerkRecordSaveResponseDTO.getDocumentId();
    }

    private void sendRecordSignPic(ClerkConfirmRequestDTO requestDTO, MultipartFile signFile) {
        String appName;
        DocWholeConfirmResDTO eholeConfirmResDTO = this.signatureDubboService.queryState(Long.valueOf(requestDTO.getDocumentIds()));
        if (eholeConfirmResDTO == null || eholeConfirmResDTO.getObjectId() == null) {
            log.error("sendRecordSignPic \u83b7\u53d6\u7b14\u5f55\u4fe1\u606f\u5931\u8d25");
            return;
        }
        Long userId = requestDTO.getUserId();
        this.redisTemplate = this.redisService.getRedisTemplate();
        String suffix = appName = AppNameContextHolder.getAppName();
        if (appName.contains("weitingshen")) {
            suffix = "weitingshen";
        }
        String reverseUrlSuffix = suffix + "_NTRANET_REVERSE_URL_PREFIX_" + eholeConfirmResDTO.getObjectId();
        String reverseUrl = (String)this.redisTemplate.opsForValue().get((Object)reverseUrlSuffix);
        if (reverseUrl == null) {
            return;
        }
        log.info("\u7528\u6237{}\u83b7\u53d6\u5230\u7684\u53cd\u9988URL\u524d\u7f00\u4e3a{}", (Object)userId, (Object)reverseUrlSuffix);
        DubboResult userDubbo = this.userServiceSecondApi.getUserInfoByUserId(userId);
        if (userDubbo == null || userDubbo.getData() == null) {
            log.error("\u901a\u8fc7userId\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            return;
        }
        UserInfoDTO userInfo = (UserInfoDTO)userDubbo.getData();
        DubboResult meetingCaseInfoDubbo = this.intranetApi.getIntranetMeetingCaseInfo(eholeConfirmResDTO.getObjectId());
        if (meetingCaseInfoDubbo == null || meetingCaseInfoDubbo.getData() == null) {
            log.error("\u83b7\u53d6\u6848\u4ef6\u4fe1\u606f\u5931\u8d25");
            return;
        }
        IntranetMeetingCaseInfoResDTO meetingCaseInfo = (IntranetMeetingCaseInfoResDTO)meetingCaseInfoDubbo.getData();
        JSONObject json = new JSONObject();
        json.put("courtCode", (Object)meetingCaseInfo.getOrgId());
        json.put("caseNumberCode", (Object)meetingCaseInfo.getName());
        json.put("caseOrder", (Object)meetingCaseInfo.getScheduleId());
        json.put("userName", (Object)userInfo.getUserName());
        json.put("mobilePhone", (Object)userInfo.getMobilePhone());
        byte[] signFileByteArr = null;
        try {
            signFileByteArr = signFile.getBytes();
            if (null != requestDTO.getDegree() && !requestDTO.getDegree().equals(0)) {
                signFileByteArr = JavaFileUtil.rotateImg((byte[])signFile.getBytes(), (int)requestDTO.getDegree(), null);
            }
            signFileByteArr = ImgTools.compress((byte[])signFileByteArr, (double)0.3);
        }
        catch (Exception e) {
            log.error("error {}", (Throwable)e);
        }
        json.put("signPic", (Object)Base64Utils.encodeBase64String(signFileByteArr));
        String url = reverseUrl + "/bm/uploadRecordSignPic";
        log.info("\u53d1\u9001\u7b7e\u540d\u56fe\u7247\u63a5\u53e3URL\uff1a{}", (Object)url);
        try {
            String res = MyHttpClientUtils.sendHttpPost((String)url, (String)json.toJSONString());
            log.info("\u8c03\u7528\u53d1\u9001\u7b7e\u540d\u56fe\u7247\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)res);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

