/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.util;

import cn.hutool.core.io.IoUtil;
import com.aspose.words.Document;
import com.aspose.words.License;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(ConvertUtil.class);

    public static boolean getLicense() {
        boolean result = false;
        try {
            InputStream is = ConvertUtil.class.getResourceAsStream("/license-18.xml");
            License aposeLic = new License();
            aposeLic.setLicense(is);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void doc2pdf(String inPath, String outPath) {
        if (!ConvertUtil.getLicense()) {
            return;
        }
        try {
            File file = new File(outPath);
            FileOutputStream os = new FileOutputStream(file);
            Document doc = new Document(inPath);
            doc.save((OutputStream)os, 40);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8def\u5f84->\u8def\u5f84\uff0cdoc\u8f6cpdf\u62a5\u9519{}", (Object)e.getMessage());
        }
    }

    public static InputStream doc2pdf(InputStream docInputStream) {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        if (!ConvertUtil.getLicense()) {
            throw new RuntimeException("docx\u8f6cpdf\u9a8c\u8bc1\u5931\u8d25");
        }
        try {
            os = new ByteArrayOutputStream();
            Document doc = new Document(docInputStream);
            doc.save((OutputStream)os, 40);
            ByteArrayInputStream byteArrayInputStream = is = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("inputStream -> inputStream doc\u8f6cpdf\u62a5\u9519{}", (Object)e.getMessage());
            throw new RuntimeException("inputStream -> inputStream docx\u8f6cpdf\u62a5\u9519");
        }
        finally {
            if (os != null) {
                ConvertUtil.close(os);
            }
            if (docInputStream != null) {
                ConvertUtil.close(docInputStream);
            }
        }
    }

    public static void close(ByteArrayOutputStream os) {
        try {
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("os\u6d41\u5173\u95ed\u5931\u8d25{}", (Object)e.getMessage());
        }
    }

    public static void close(InputStream docInputStream) {
        try {
            docInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("docxInputStream\u6d41\u5173\u95ed\u5931\u8d25{}", (Object)e.getMessage());
        }
    }

    public static byte[] doc2pdfByte(InputStream docInputStream) {
        InputStream inputStream = ConvertUtil.doc2pdf(docInputStream);
        return ConvertUtil.toByteArray(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is) {
        try {
            int nRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((nRead = is.read(bytes)) != -1) {
                os.write(bytes, 0, nRead);
            }
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("inputStream -> byte[] \u5931\u8d25{}", (Object)e.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IoUtil.close((Closeable)is);
        }
    }

    public static InputStream byteToInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }
}

