/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.storage.impl;

import com.beiming.basic.storage.api.FileStorageApi;
import com.beiming.basic.storage.api.dto.request.FileInfoRequestDTO;
import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.peace.common.utils.JavaFileUtil;
import com.beiming.odr.peace.service.backend.storage.StorageDubboService;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StorageDubboServiceImpl
implements StorageDubboService {
    private static final Logger log = LoggerFactory.getLogger(StorageDubboServiceImpl.class);
    @Resource
    FileStorageApi fileStorageApiImpl;

    @Override
    public DubboResult<SaveFileResponseDTO> save(String fileName, byte[] fileByte) {
        log.info("{} core request reqDTO fileName {}, length {}", new Object[]{JavaFileUtil.getMethodName(), fileName, fileByte.length});
        FileInfoRequestDTO fileReqDTO = new FileInfoRequestDTO(fileName, fileByte);
        DubboResult saveFileRes = this.fileStorageApiImpl.save(fileReqDTO);
        log.info("dubbo result saveFileRes =============={}", (Object)saveFileRes);
        if (saveFileRes.isSuccess()) {
            return saveFileRes;
        }
        return null;
    }

    @Override
    public FileInfoResponseDTO getFileInfo(@Valid String fileId) {
        DubboResult fileRes = this.fileStorageApiImpl.getFileInfo(fileId);
        FileInfoResponseDTO fileInfoResponseDTO = (FileInfoResponseDTO)fileRes.getData();
        return fileInfoResponseDTO;
    }
}

