/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.service.backend.user.impl;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.util.AssertUtils;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.peace.common.constants.PeaceConst;
import com.beiming.odr.peace.common.enums.ErrorCode;
import com.beiming.odr.peace.common.utils.WeitingshenUtil;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantAgentInfoMicroRequestDTO;
import com.beiming.odr.peace.domain.dto.requestdto.LitigantInfoRequestDTO;
import com.beiming.odr.peace.service.backend.user.UserBackendService;
import com.beiming.odr.peace.service.convert.MediationRoomConvert;
import com.beiming.odr.referee.dto.requestdto.MediationMeetingUserInfoReqDTO;
import com.beiming.odr.referee.enums.MeetingUserTypeEnum;
import com.beiming.odr.user.api.ServicePersonServiceApi;
import com.beiming.odr.user.api.UserServiceSecondApi;
import com.beiming.odr.user.api.UserServiceThirdApi;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import java.util.List;
import javax.annotation.Resource;
import org.mortbay.log.Log;
import org.springframework.stereotype.Service;

@Service
public class UserBackendServiceImpl
implements UserBackendService {
    @Resource
    private ServicePersonServiceApi servicePersonServiceApi;
    @Resource
    private UserServiceSecondApi userServiceSecondApi;
    @Resource
    private UserServiceThirdApi userServiceThirdApi;

    @Override
    public List<LitigantInfoRequestDTO> registerLitigant(List<LitigantInfoRequestDTO> litigantList) {
        if (litigantList == null) {
            return null;
        }
        for (LitigantInfoRequestDTO info : litigantList) {
            MeetingUserTypeEnum userType = info.getMeetingUserType();
            String phone = info.getMobilePhone();
            if (WeitingshenUtil.getLitigatSet().contains(userType) && "1111".equals(phone) || StringUtils.isEmpty((String)phone)) continue;
            String userName = info.getUserName();
            DubboResult result = null;
            if (!"1111".equals(info.getMobilePhone()) && !StringUtils.isBlank((String)info.getMobilePhone())) {
                this.registerLitigantInfo(info);
                continue;
            }
            if ("MEDIATOR".equals(info.getMeetingUserType().name()) || "CLERK".equals(info.getMeetingUserType().name())) {
                Log.info((String)"\u6cd5\u5b98");
                result = this.userServiceThirdApi.searchAndRegisterByMobileStaff(phone, userName);
                AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
            } else {
                Log.info((String)"\u666e\u901a\u7528\u6237");
                result = this.userServiceSecondApi.searchAndRegisterByMobileCommon(phone, userName);
                AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
            }
            UserInfoDTO userInfo = (UserInfoDTO)result.getData();
            if (userInfo == null) continue;
            info.setUserId(userInfo.getUserId());
            info.setUserName(userInfo.getUserName() == null ? info.getUserName() : userInfo.getUserName());
            String errorMsg = "\u624b\u673a\u53f7:" + phone + "\u5df2\u5b9e\u540d,\u5b9e\u540d\u59d3\u540d\u4e0e\u8f93\u5165\u59d3\u540d\u4e0d\u7b26\u3002";
            AssertUtils.assertTrue((boolean)userName.equals(userInfo.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)errorMsg);
            info.setIdCard(userInfo.getIdCard());
            if (userInfo.getIsRealName().booleanValue() && userInfo.getIsFacialVerify().booleanValue()) {
                info.setAuthStatus(PeaceConst.AUTH_YES);
                continue;
            }
            info.setAuthStatus(PeaceConst.AUTH_NO);
        }
        return litigantList;
    }

    @Override
    public UserInfoDTO searchLitigant(String mobilePhone) {
        DubboResult result = this.userServiceSecondApi.searchAndRegisterByMobileCommon(mobilePhone, mobilePhone);
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        UserInfoDTO userInfo = (UserInfoDTO)result.getData();
        return userInfo;
    }

    @Override
    public void registerAgentLitigant(List<LitigantAgentInfoMicroRequestDTO> litigantList) {
        if (litigantList == null) {
            return;
        }
        for (LitigantAgentInfoMicroRequestDTO info : litigantList) {
            DubboResult result = this.userServiceSecondApi.searchAndRegisterByMobileCommon(info.getMobilePhone(), info.getUserName());
            AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
            UserInfoDTO userInfo = (UserInfoDTO)result.getData();
            if (userInfo == null) {
                return;
            }
            info.setUserId(userInfo.getUserId());
            String errorMsg = "\u624b\u673a\u53f7:" + info.getMobilePhone() + "\u5df2\u5b9e\u540d,\u5b9e\u540d\u59d3\u540d\u4e0e\u8f93\u5165\u59d3\u540d\u4e0d\u7b26\u3002";
            AssertUtils.assertTrue((boolean)info.getUserName().equals(userInfo.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)errorMsg);
            info.setUserName(userInfo.getUserName());
            info.setIdCard(userInfo.getIdCard());
            if (userInfo.getIsRealName().booleanValue() && userInfo.getIsFacialVerify().booleanValue()) {
                info.setAuthStatus(PeaceConst.AUTH_YES);
                continue;
            }
            info.setAuthStatus(PeaceConst.AUTH_NO);
        }
    }

    @Override
    public MediationMeetingUserInfoReqDTO getMediatorInfo(Long userId) {
        SearchServicePersonResDTO person = this.searchServicePerson(userId);
        MediationMeetingUserInfoReqDTO mediator = MediationRoomConvert.getMediationMeetingUserInfoReqDTO(person);
        return mediator;
    }

    @Override
    public SearchServicePersonResDTO searchServicePerson(Long userId) {
        SearchServicePersonReqDTO personReqDTO = new SearchServicePersonReqDTO();
        personReqDTO.setSearchUserId(userId);
        DubboResult mediatorResult = this.servicePersonServiceApi.searchServicePerson(personReqDTO);
        AssertUtils.assertTrue((boolean)mediatorResult.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)mediatorResult.getMessage());
        SearchServicePersonResDTO person = (SearchServicePersonResDTO)mediatorResult.getData();
        AssertUtils.assertNotNull((Object)person, (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)"{common.parameterIsError}");
        return person;
    }

    private void registerLitigantInfo(LitigantInfoRequestDTO info) {
        MeetingUserTypeEnum userType = info.getMeetingUserType();
        String phone = info.getMobilePhone();
        if (WeitingshenUtil.getLitigatSet().contains(userType) && "1111".equals(phone)) {
            return;
        }
        if (StringUtils.isBlank((String)info.getUserName()) || StringUtils.isBlank((String)info.getMobilePhone())) {
            return;
        }
        DubboResult result = this.userServiceSecondApi.searchAndRegisterByMobileCommon(info.getMobilePhone(), info.getUserName());
        AssertUtils.assertTrue((boolean)result.isSuccess(), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)result.getMessage());
        UserInfoDTO userInfo = (UserInfoDTO)result.getData();
        if (userInfo == null) {
            return;
        }
        info.setUserId(userInfo.getUserId());
        String errorMsg = "\u624b\u673a\u53f7:" + info.getMobilePhone() + "\u5df2\u5b9e\u540d,\u5b9e\u540d\u59d3\u540d\u4e0e\u8f93\u5165\u59d3\u540d\u4e0d\u7b26\u3002";
        AssertUtils.assertTrue((boolean)info.getUserName().equals(userInfo.getUserName()), (ResultCode)ErrorCode.ILLEGAL_PARAMETER, (String)errorMsg);
        info.setUserName(userInfo.getUserName() == null ? info.getUserName() : userInfo.getUserName());
        info.setIdCard(userInfo.getIdCard());
        if (userInfo.getIsRealName().booleanValue() && userInfo.getIsFacialVerify().booleanValue()) {
            info.setAuthStatus(PeaceConst.AUTH_YES);
        } else {
            info.setAuthStatus(PeaceConst.AUTH_NO);
        }
    }
}

